/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractIndexedIterator;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.UnmodifiableListIterator;
import org.python.google.common.primitives.Ints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Lists {
    private Lists() {
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(E ... EArray) {
        Preconditions.checkNotNull(EArray);
        int n = Lists.computeArrayListCapacity(EArray.length);
        ArrayList arrayList = new ArrayList(n);
        Collections.addAll(arrayList, EArray);
        return arrayList;
    }

    @VisibleForTesting
    static int computeArrayListCapacity(int n) {
        Preconditions.checkArgument(n >= 0);
        return Ints.saturatedCast(5L + (long)n + (long)(n / 10));
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? new ArrayList<E>(Collections2.cast(iterable)) : Lists.newArrayList(iterable.iterator());
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> iterator) {
        Preconditions.checkNotNull(iterator);
        ArrayList<E> arrayList = Lists.newArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithCapacity(int n) {
        return new ArrayList(n);
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithExpectedSize(int n) {
        return new ArrayList(Lists.computeArrayListCapacity(n));
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> iterable) {
        LinkedList<E> linkedList = Lists.newLinkedList();
        for (E e : iterable) {
            linkedList.add(e);
        }
        return linkedList;
    }

    public static <E> List<E> asList(@Nullable E e, E[] EArray) {
        return new OnePlusArrayList<E>(e, EArray);
    }

    public static <E> List<E> asList(@Nullable E e, @Nullable E e2, E[] EArray) {
        return new TwoPlusArrayList<E>(e, e2, EArray);
    }

    public static <F, T> List<T> transform(List<F> list, Function<? super F, ? extends T> function) {
        return list instanceof RandomAccess ? new TransformingRandomAccessList<F, T>(list, function) : new TransformingSequentialList<F, T>(list, function);
    }

    public static <T> List<List<T>> partition(List<T> list, int n) {
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument(n > 0);
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, n) : new Partition<T>(list, n);
    }

    @Beta
    public static ImmutableList<Character> charactersOf(String string) {
        return new StringAsImmutableList(Preconditions.checkNotNull(string));
    }

    @Beta
    public static List<Character> charactersOf(CharSequence charSequence) {
        return new CharSequenceAsList(Preconditions.checkNotNull(charSequence));
    }

    @Beta
    public static <T> List<T> reverse(List<T> list) {
        if (list instanceof ReverseList) {
            return ((ReverseList)list).getForwardList();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list);
        }
        return new ReverseList<T>(list);
    }

    static int hashCodeImpl(List<?> list) {
        int n = 1;
        for (Object obj : list) {
            n = 31 * n + (obj == null ? 0 : obj.hashCode());
        }
        return n;
    }

    static boolean equalsImpl(List<?> list, @Nullable Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list2 = (List)object;
        return list.size() == list2.size() && Iterators.elementsEqual(list.iterator(), list2.iterator());
    }

    static <E> boolean addAllImpl(List<E> list, int n, Iterable<? extends E> iterable) {
        boolean bl = false;
        ListIterator<E> listIterator = list.listIterator(n);
        for (E e : iterable) {
            listIterator.add(e);
            bl = true;
        }
        return bl;
    }

    static int indexOfImpl(List<?> list, @Nullable Object object) {
        ListIterator<?> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(object, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list, @Nullable Object object) {
        ListIterator<?> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(object, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    static <E> ListIterator<E> listIteratorImpl(List<E> list, int n) {
        return new AbstractListWrapper<E>(list).listIterator(n);
    }

    static <E> List<E> subListImpl(List<E> list, int n, int n2) {
        AbstractListWrapper abstractListWrapper = list instanceof RandomAccess ? new RandomAccessListWrapper<E>((List)list){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int n) {
                return this.backingList.listIterator(n);
            }
        } : new AbstractListWrapper<E>((List)list){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int n) {
                return this.backingList.listIterator(n);
            }
        };
        return abstractListWrapper.subList(n, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractListWrapper<E>
    extends AbstractList<E> {
        final List<E> backingList;

        AbstractListWrapper(List<E> list) {
            this.backingList = Preconditions.checkNotNull(list);
        }

        @Override
        public void add(int n, E e) {
            this.backingList.add(n, e);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            return this.backingList.addAll(n, collection);
        }

        @Override
        public E get(int n) {
            return this.backingList.get(n);
        }

        @Override
        public E remove(int n) {
            return this.backingList.remove(n);
        }

        @Override
        public E set(int n, E e) {
            return this.backingList.set(n, e);
        }

        @Override
        public boolean contains(Object object) {
            return this.backingList.contains(object);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharSequenceAsList
    extends AbstractList<Character> {
        private final CharSequence sequence;

        CharSequenceAsList(CharSequence charSequence) {
            this.sequence = charSequence;
        }

        @Override
        public Character get(int n) {
            return Character.valueOf(this.sequence.charAt(n));
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(@Nullable Object object) {
            if (object instanceof Character) {
                char c = ((Character)object).charValue();
                for (int i = 0; i < this.sequence.length(); ++i) {
                    if (this.sequence.charAt(i) != c) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            if (object instanceof Character) {
                char c = ((Character)object).charValue();
                for (int i = this.sequence.length() - 1; i >= 0; --i) {
                    if (this.sequence.charAt(i) != c) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int size() {
            return this.sequence.length();
        }

        @Override
        public List<Character> subList(int n, int n2) {
            return Lists.charactersOf(this.sequence.subSequence(n, n2));
        }

        @Override
        public int hashCode() {
            int n = 1;
            for (int i = 0; i < this.sequence.length(); ++i) {
                n = n * 31 + this.sequence.charAt(i);
            }
            return n;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            int n = this.sequence.length();
            if (n != list.size()) {
                return false;
            }
            Iterator iterator = list.iterator();
            for (int i = 0; i < n; ++i) {
                Object e = iterator.next();
                if (e instanceof Character && ((Character)e).charValue() == this.sequence.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OnePlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        OnePlusArrayList(@Nullable E e, E[] EArray) {
            this.first = e;
            this.rest = Preconditions.checkNotNull(EArray);
        }

        @Override
        public int size() {
            return this.rest.length + 1;
        }

        @Override
        public E get(int n) {
            Preconditions.checkElementIndex(n, this.size());
            return n == 0 ? this.first : this.rest[n - 1];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        Partition(List<T> list, int n) {
            this.list = list;
            this.size = n;
        }

        @Override
        public List<T> get(int n) {
            int n2 = this.size();
            Preconditions.checkElementIndex(n, n2);
            int n3 = n * this.size;
            int n4 = Math.min(n3 + this.size, this.list.size());
            return this.list.subList(n3, n4);
        }

        @Override
        public int size() {
            return (this.list.size() + this.size - 1) / this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RandomAccessListWrapper<E>
    extends AbstractListWrapper<E>
    implements RandomAccess {
        RandomAccessListWrapper(List<E> list) {
            super(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list, int n) {
            super(list, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        RandomAccessReverseList(List<T> list) {
            super(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        ReverseList(List<T> list) {
            this.forwardList = Preconditions.checkNotNull(list);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        private int reverseIndex(int n) {
            int n2 = this.size();
            Preconditions.checkElementIndex(n, n2);
            return n2 - 1 - n;
        }

        private int reversePosition(int n) {
            int n2 = this.size();
            Preconditions.checkPositionIndex(n, n2);
            return n2 - n;
        }

        @Override
        public void add(int n, @Nullable T t) {
            this.forwardList.add(this.reversePosition(n), t);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T remove(int n) {
            return this.forwardList.remove(this.reverseIndex(n));
        }

        @Override
        protected void removeRange(int n, int n2) {
            this.subList(n, n2).clear();
        }

        @Override
        public T set(int n, @Nullable T t) {
            return this.forwardList.set(this.reverseIndex(n), t);
        }

        @Override
        public T get(int n) {
            return this.forwardList.get(this.reverseIndex(n));
        }

        @Override
        public boolean isEmpty() {
            return this.forwardList.isEmpty();
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.forwardList.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.forwardList.containsAll(collection);
        }

        @Override
        public List<T> subList(int n, int n2) {
            Preconditions.checkPositionIndexes(n, n2, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition(n2), this.reversePosition(n)));
        }

        @Override
        public int indexOf(@Nullable Object object) {
            int n = this.forwardList.lastIndexOf(object);
            return n >= 0 ? this.reverseIndex(n) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            int n = this.forwardList.indexOf(object);
            return n >= 0 ? this.reverseIndex(n) : -1;
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int n) {
            int n2 = this.reversePosition(n);
            final ListIterator<T> listIterator = this.forwardList.listIterator(n2);
            return new ListIterator<T>(){
                boolean canRemove;
                boolean canSet;

                @Override
                public void add(T t) {
                    listIterator.add(t);
                    listIterator.previous();
                    this.canRemove = false;
                    this.canSet = false;
                }

                @Override
                public boolean hasNext() {
                    return listIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return listIterator.hasNext();
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return listIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return ReverseList.this.reversePosition(listIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return listIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.canRemove);
                    listIterator.remove();
                    this.canSet = false;
                    this.canRemove = false;
                }

                @Override
                public void set(T t) {
                    Preconditions.checkState(this.canSet);
                    listIterator.set(t);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringAsImmutableList
    extends ImmutableList<Character> {
        private final String string;
        int hash = 0;

        StringAsImmutableList(String string) {
            this.string = string;
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(@Nullable Object object) {
            return object instanceof Character ? this.string.indexOf(((Character)object).charValue()) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            return object instanceof Character ? this.string.lastIndexOf(((Character)object).charValue()) : -1;
        }

        @Override
        public UnmodifiableListIterator<Character> listIterator(int n) {
            int n2 = this.size();
            Preconditions.checkPositionIndex(n, n2);
            return new AbstractIndexedIterator<Character>(n, n2){

                @Override
                protected Character get(int n) {
                    return Character.valueOf(StringAsImmutableList.this.string.charAt(n));
                }
            };
        }

        @Override
        public ImmutableList<Character> subList(int n, int n2) {
            return Lists.charactersOf(this.string.substring(n, n2));
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public Character get(int n) {
            return Character.valueOf(this.string.charAt(n));
        }

        @Override
        public int size() {
            return this.string.length();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            int n = this.string.length();
            if (n != list.size()) {
                return false;
            }
            Iterator iterator = list.iterator();
            for (int i = 0; i < n; ++i) {
                Object e = iterator.next();
                if (e instanceof Character && ((Character)e).charValue() == this.string.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                n = 1;
                for (int i = 0; i < this.string.length(); ++i) {
                    n = n * 31 + this.string.charAt(i);
                }
                this.hash = n;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingRandomAccessList<F, T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        TransformingRandomAccessList(List<F> list, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(list);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public T get(int n) {
            return this.function.apply(this.fromList.get(n));
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        @Override
        public T remove(int n) {
            return this.function.apply(this.fromList.remove(n));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingSequentialList<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        TransformingSequentialList(List<F> list, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(list);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        @Override
        public ListIterator<T> listIterator(int n) {
            final ListIterator<F> listIterator = this.fromList.listIterator(n);
            return new ListIterator<T>(){

                @Override
                public void add(T t) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return listIterator.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return listIterator.hasPrevious();
                }

                @Override
                public T next() {
                    return TransformingSequentialList.this.function.apply(listIterator.next());
                }

                @Override
                public int nextIndex() {
                    return listIterator.nextIndex();
                }

                @Override
                public T previous() {
                    return TransformingSequentialList.this.function.apply(listIterator.previous());
                }

                @Override
                public int previousIndex() {
                    return listIterator.previousIndex();
                }

                @Override
                public void remove() {
                    listIterator.remove();
                }

                @Override
                public void set(T t) {
                    throw new UnsupportedOperationException("not supported");
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TwoPlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E second;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        TwoPlusArrayList(@Nullable E e, @Nullable E e2, E[] EArray) {
            this.first = e;
            this.second = e2;
            this.rest = Preconditions.checkNotNull(EArray);
        }

        @Override
        public int size() {
            return this.rest.length + 2;
        }

        @Override
        public E get(int n) {
            switch (n) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
            }
            Preconditions.checkElementIndex(n, this.size());
            return this.rest[n - 2];
        }
    }
}

