/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.base.Predicate;
import org.python.google.common.base.Predicates;
import org.python.google.common.base.Supplier;
import org.python.google.common.collect.AbstractIterator;
import org.python.google.common.collect.AbstractMapEntry;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.ForwardingMapEntry;
import org.python.google.common.collect.ImmutableEntry;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.Lists;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.StandardTable;
import org.python.google.common.collect.Table;
import org.python.google.common.collect.Tables;
import org.python.google.common.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
class StandardTable<R, C, V>
implements Table<R, C, V>,
Serializable {
    final Map<R, Map<C, V>> backingMap;
    final Supplier<? extends Map<C, V>> factory;
    private transient CellSet cellSet;
    private transient RowKeySet rowKeySet;
    private transient Set<C> columnKeySet;
    private transient Values values;
    private transient RowMap rowMap;
    private transient ColumnMap columnMap;
    private static final long serialVersionUID = 0L;

    StandardTable(Map<R, Map<C, V>> map, Supplier<? extends Map<C, V>> supplier) {
        this.backingMap = map;
        this.factory = supplier;
    }

    @Override
    public boolean contains(@Nullable Object object, @Nullable Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, object);
        return map != null && Maps.safeContainsKey(map, object2);
    }

    @Override
    public boolean containsColumn(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        for (Map<C, V> map : this.backingMap.values()) {
            if (!Maps.safeContainsKey(map, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRow(@Nullable Object object) {
        return object != null && Maps.safeContainsKey(this.backingMap, object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        for (Map<C, V> map : this.backingMap.values()) {
            if (!map.containsValue(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(@Nullable Object object, @Nullable Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, object);
        return map == null ? null : (V)Maps.safeGet(map, object2);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public int size() {
        int n = 0;
        for (Map<C, V> map : this.backingMap.values()) {
            n += map.size();
        }
        return n;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Table) {
            Table table = (Table)object;
            return ((Object)this.cellSet()).equals(table.cellSet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.cellSet()).hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    private Map<C, V> getOrCreate(R r) {
        Map<C, V> map = this.backingMap.get(r);
        if (map == null) {
            map = this.factory.get();
            this.backingMap.put(r, map);
        }
        return map;
    }

    @Override
    public V put(R r, C c, V v) {
        Preconditions.checkNotNull(r);
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(v);
        return this.getOrCreate(r).put(c, v);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell<R, C, V> cell : table.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    @Override
    public V remove(@Nullable Object object, @Nullable Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, object);
        if (map == null) {
            return null;
        }
        V v = map.remove(object2);
        if (map.isEmpty()) {
            this.backingMap.remove(object);
        }
        return v;
    }

    private Map<R, V> removeColumn(Object object) {
        LinkedHashMap<R, V> linkedHashMap = new LinkedHashMap<R, V>();
        Iterator<Map.Entry<R, Map<C, V>>> iterator = this.backingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<R, Map<C, V>> entry = iterator.next();
            V v = entry.getValue().remove(object);
            if (v == null) continue;
            linkedHashMap.put(entry.getKey(), v);
            if (!entry.getValue().isEmpty()) continue;
            iterator.remove();
        }
        return linkedHashMap;
    }

    private boolean containsMapping(Object object, Object object2, Object object3) {
        return object3 != null && object3.equals(this.get(object, object2));
    }

    private boolean removeMapping(Object object, Object object2, Object object3) {
        if (this.containsMapping(object, object2, object3)) {
            this.remove(object, object2);
            return true;
        }
        return false;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        CellSet cellSet = this.cellSet;
        return cellSet == null ? (this.cellSet = new CellSet()) : cellSet;
    }

    @Override
    public Map<C, V> row(R r) {
        return new Row(r);
    }

    @Override
    public Map<R, V> column(C c) {
        return new Column(c);
    }

    @Override
    public Set<R> rowKeySet() {
        RowKeySet rowKeySet = this.rowKeySet;
        return rowKeySet == null ? (this.rowKeySet = new RowKeySet()) : rowKeySet;
    }

    @Override
    public Set<C> columnKeySet() {
        ColumnKeySet columnKeySet = this.columnKeySet;
        return columnKeySet == null ? (this.columnKeySet = new ColumnKeySet()) : columnKeySet;
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        RowMap rowMap = this.rowMap;
        return rowMap == null ? (this.rowMap = new RowMap()) : rowMap;
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap = this.columnMap;
        return columnMap == null ? (this.columnMap = new ColumnMap()) : columnMap;
    }

    static <K, V> Iterator<K> keyIteratorImpl(Map<K, V> map) {
        final Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)iterator.next()).getKey();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    static <K, V> Iterator<V> valueIteratorImpl(Map<K, V> map) {
        final Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)iterator.next()).getValue();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = StandardTable.this.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        @Override
        public Table.Cell<R, C, V> next() {
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Map.Entry entry = this.columnIterator.next();
            return Tables.immutableCell(this.rowEntry.getKey(), entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellSet
    extends TableSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new CellIterator();
        }

        @Override
        public int size() {
            return StandardTable.this.size();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                return StandardTable.this.containsMapping(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                return StandardTable.this.removeMapping(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Column
    extends Maps.ImprovedAbstractMap<R, V> {
        final C columnKey;
        org.python.google.common.collect.StandardTable$Column.Values columnValues;
        org.python.google.common.collect.StandardTable$Column.KeySet keySet;

        Column(C c) {
            this.columnKey = Preconditions.checkNotNull(c);
        }

        @Override
        public V put(R r, V v) {
            return StandardTable.this.put(r, this.columnKey, v);
        }

        @Override
        public V get(Object object) {
            return StandardTable.this.get(object, this.columnKey);
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.contains(object, this.columnKey);
        }

        @Override
        public V remove(Object object) {
            return StandardTable.this.remove(object, this.columnKey);
        }

        @Override
        public Set<Map.Entry<R, V>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        public Collection<V> values() {
            org.python.google.common.collect.StandardTable$Column.Values values = this.columnValues;
            return values == null ? (this.columnValues = new Values()) : values;
        }

        boolean removePredicate(Predicate<? super Map.Entry<R, V>> predicate) {
            boolean bl = false;
            Iterator iterator = StandardTable.this.backingMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map = entry.getValue();
                Object v = map.get(this.columnKey);
                if (v == null || !predicate.apply(new ImmutableEntry(entry.getKey(), v))) continue;
                map.remove(this.columnKey);
                bl = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public Set<R> keySet() {
            org.python.google.common.collect.StandardTable$Column.KeySet keySet = this.keySet;
            return keySet == null ? (this.keySet = new KeySet()) : keySet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntrySet
        extends AbstractSet<Map.Entry<R, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                int n = 0;
                for (Map map : StandardTable.this.backingMap.values()) {
                    if (!map.containsKey(Column.this.columnKey)) continue;
                    ++n;
                }
                return n;
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public void clear() {
                Predicate predicate = Predicates.alwaysTrue();
                Column.this.removePredicate(predicate);
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return StandardTable.this.containsMapping(entry.getKey(), Column.this.columnKey, entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return StandardTable.this.removeMapping(entry.getKey(), Column.this.columnKey, entry.getValue());
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                boolean bl = false;
                for (Object obj : collection) {
                    bl |= this.remove(obj);
                }
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return Column.this.removePredicate(Predicates.not(Predicates.in(collection)));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntrySetIterator
        extends AbstractIterator<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            EntrySetIterator() {
                this.iterator = StandardTable.this.backingMap.entrySet().iterator();
            }

            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    final Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    return new AbstractMapEntry<R, V>(){

                        @Override
                        public R getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)entry.getValue()).get(Column.this.columnKey);
                        }

                        @Override
                        public V setValue(V v) {
                            return ((Map)entry.getValue()).put(Column.this.columnKey, Preconditions.checkNotNull(v));
                        }
                    };
                }
                return (Map.Entry)this.endOfData();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class KeySet
        extends AbstractSet<R> {
            KeySet() {
            }

            @Override
            public Iterator<R> iterator() {
                return StandardTable.keyIteratorImpl(Column.this);
            }

            @Override
            public int size() {
                return Column.this.entrySet().size();
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public boolean contains(Object object) {
                return StandardTable.this.contains(object, Column.this.columnKey);
            }

            @Override
            public boolean remove(Object object) {
                return StandardTable.this.remove(object, Column.this.columnKey) != null;
            }

            @Override
            public void clear() {
                Column.this.entrySet().clear();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                boolean bl = false;
                for (Object obj : collection) {
                    bl |= this.remove(obj);
                }
                return bl;
            }

            @Override
            public boolean retainAll(final Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                Predicate predicate = new Predicate<Map.Entry<R, V>>(){

                    @Override
                    public boolean apply(Map.Entry<R, V> entry) {
                        return !collection.contains(entry.getKey());
                    }
                };
                return Column.this.removePredicate(predicate);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Values
        extends AbstractCollection<V> {
            Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return StandardTable.valueIteratorImpl(Column.this);
            }

            @Override
            public int size() {
                return Column.this.entrySet().size();
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public void clear() {
                Column.this.entrySet().clear();
            }

            @Override
            public boolean remove(Object object) {
                if (object == null) {
                    return false;
                }
                Iterator iterator = StandardTable.this.backingMap.values().iterator();
                while (iterator.hasNext()) {
                    Map map = iterator.next();
                    if (!map.entrySet().remove(new ImmutableEntry(Column.this.columnKey, object))) continue;
                    if (map.isEmpty()) {
                        iterator.remove();
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(final Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                Predicate predicate = new Predicate<Map.Entry<R, V>>(){

                    @Override
                    public boolean apply(Map.Entry<R, V> entry) {
                        return collection.contains(entry.getValue());
                    }
                };
                return Column.this.removePredicate(predicate);
            }

            @Override
            public boolean retainAll(final Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                Predicate predicate = new Predicate<Map.Entry<R, V>>(){

                    @Override
                    public boolean apply(Map.Entry<R, V> entry) {
                        return !collection.contains(entry.getValue());
                    }
                };
                return Column.this.removePredicate(predicate);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnKeyIterator
    extends AbstractIterator<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = StandardTable.this.factory.get();
            this.mapIterator = StandardTable.this.backingMap.values().iterator();
            this.entryIterator = Iterators.emptyIterator();
        }

        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return entry.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return this.endOfData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnKeySet
    extends TableSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return new ColumnKeyIterator();
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            boolean bl = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!map.keySet().remove(object)) continue;
                bl = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            boolean bl = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!Iterators.removeAll(map.keySet().iterator(), collection)) continue;
                bl = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            boolean bl = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!map.keySet().retainAll(collection)) continue;
                bl = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                return false;
            }
            for (Map map : StandardTable.this.backingMap.values()) {
                if (!map.containsKey(object)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnMap
    extends Maps.ImprovedAbstractMap<C, Map<R, V>> {
        org.python.google.common.collect.StandardTable$ColumnMap.ColumnMapValues columnMapValues;

        private ColumnMap() {
        }

        @Override
        public Map<R, V> get(Object object) {
            return StandardTable.this.containsColumn(object) ? StandardTable.this.column(object) : null;
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.containsColumn(object);
        }

        @Override
        public Map<R, V> remove(Object object) {
            return StandardTable.this.containsColumn(object) ? StandardTable.this.removeColumn(object) : null;
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> createEntrySet() {
            return new ColumnMapEntrySet();
        }

        @Override
        public Set<C> keySet() {
            return StandardTable.this.columnKeySet();
        }

        @Override
        public Collection<Map<R, V>> values() {
            org.python.google.common.collect.StandardTable$ColumnMap.ColumnMapValues columnMapValues = this.columnMapValues;
            return columnMapValues == null ? (this.columnMapValues = new ColumnMapValues()) : columnMapValues;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ColumnMapEntrySet
        extends TableSet<Map.Entry<C, Map<R, V>>> {
            ColumnMapEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
                final Iterator iterator = StandardTable.this.columnKeySet().iterator();
                return new UnmodifiableIterator<Map.Entry<C, Map<R, V>>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<C, Map<R, V>> next() {
                        Object e = iterator.next();
                        return new ImmutableEntry(e, StandardTable.this.column(e));
                    }
                };
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }

            @Override
            public boolean contains(Object object) {
                Map.Entry entry;
                if (object instanceof Map.Entry && StandardTable.this.containsColumn((entry = (Map.Entry)object).getKey())) {
                    Object k = entry.getKey();
                    return ColumnMap.this.get(k).equals(entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    Map.Entry entry = (Map.Entry)object;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                boolean bl = false;
                for (Object obj : collection) {
                    bl |= this.remove(obj);
                }
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                boolean bl = false;
                for (Object c : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (collection.contains(new ImmutableEntry(c, StandardTable.this.column(c)))) continue;
                    StandardTable.this.removeColumn(c);
                    bl = true;
                }
                return bl;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ColumnMapValues
        extends TableCollection<Map<R, V>> {
            private ColumnMapValues() {
            }

            @Override
            public Iterator<Map<R, V>> iterator() {
                return StandardTable.valueIteratorImpl(ColumnMap.this);
            }

            @Override
            public boolean remove(Object object) {
                for (Map.Entry entry : ColumnMap.this.entrySet()) {
                    if (!((Object)((Map)entry.getValue())).equals(object)) continue;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl = false;
                for (Object c : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (!collection.contains(StandardTable.this.column(c))) continue;
                    StandardTable.this.removeColumn(c);
                    bl = true;
                }
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl = false;
                for (Object c : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (collection.contains(StandardTable.this.column(c))) continue;
                    StandardTable.this.removeColumn(c);
                    bl = true;
                }
                return bl;
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Row
    extends Maps.ImprovedAbstractMap<C, V> {
        final R rowKey;

        Row(R r) {
            this.rowKey = Preconditions.checkNotNull(r);
        }

        @Override
        protected Set<Map.Entry<C, V>> createEntrySet() {
            return new RowEntrySet();
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.contains(this.rowKey, object);
        }

        @Override
        public V get(Object object) {
            return StandardTable.this.get(this.rowKey, object);
        }

        @Override
        public V put(C c, V v) {
            return StandardTable.this.put(this.rowKey, c, v);
        }

        @Override
        public V remove(Object object) {
            return StandardTable.this.remove(this.rowKey, object);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RowEntrySet
        extends AbstractSet<Map.Entry<C, V>> {
            private RowEntrySet() {
            }

            @Override
            public void clear() {
                StandardTable.this.backingMap.remove(Row.this.rowKey);
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return StandardTable.this.containsMapping(Row.this.rowKey, entry.getKey(), entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return StandardTable.this.removeMapping(Row.this.rowKey, entry.getKey(), entry.getValue());
                }
                return false;
            }

            @Override
            public int size() {
                Map map = StandardTable.this.backingMap.get(Row.this.rowKey);
                return map == null ? 0 : map.size();
            }

            @Override
            public Iterator<Map.Entry<C, V>> iterator() {
                final Map map = StandardTable.this.backingMap.get(Row.this.rowKey);
                if (map == null) {
                    return Iterators.emptyModifiableIterator();
                }
                final Iterator iterator = map.entrySet().iterator();
                return new Iterator<Map.Entry<C, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<C, V> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new ForwardingMapEntry<C, V>(){

                            @Override
                            protected Map.Entry<C, V> delegate() {
                                return entry;
                            }

                            @Override
                            public V setValue(V v) {
                                return super.setValue(Preconditions.checkNotNull(v));
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                        if (map.isEmpty()) {
                            StandardTable.this.backingMap.remove(Row.this.rowKey);
                        }
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RowKeySet
    extends TableSet<R> {
        RowKeySet() {
        }

        @Override
        public Iterator<R> iterator() {
            return StandardTable.keyIteratorImpl(StandardTable.this.rowMap());
        }

        @Override
        public int size() {
            return StandardTable.this.backingMap.size();
        }

        @Override
        public boolean contains(Object object) {
            return StandardTable.this.containsRow(object);
        }

        @Override
        public boolean remove(Object object) {
            return object != null && StandardTable.this.backingMap.remove(object) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RowMap
    extends Maps.ImprovedAbstractMap<R, Map<C, V>> {
        RowMap() {
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.containsRow(object);
        }

        @Override
        public Map<C, V> get(Object object) {
            return StandardTable.this.containsRow(object) ? StandardTable.this.row(object) : null;
        }

        @Override
        public Set<R> keySet() {
            return StandardTable.this.rowKeySet();
        }

        @Override
        public Map<C, V> remove(Object object) {
            return object == null ? null : StandardTable.this.backingMap.remove(object);
        }

        @Override
        protected Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntryIterator
        implements Iterator<Map.Entry<R, Map<C, V>>> {
            final Iterator<R> delegate;

            EntryIterator() {
                this.delegate = StandardTable.this.backingMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Map.Entry<R, Map<C, V>> next() {
                Object r = this.delegate.next();
                return new ImmutableEntry(r, StandardTable.this.row(r));
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntrySet
        extends TableSet<Map.Entry<R, Map<C, V>>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return StandardTable.this.backingMap.size();
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return entry.getKey() != null && entry.getValue() instanceof Map && Collections2.safeContains(StandardTable.this.backingMap.entrySet(), entry);
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return entry.getKey() != null && entry.getValue() instanceof Map && StandardTable.this.backingMap.entrySet().remove(entry);
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TableCollection<T>
    extends AbstractCollection<T> {
        private TableCollection() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TableSet<T>
    extends AbstractSet<T> {
        private TableSet() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends TableCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iterator = StandardTable.this.cellSet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    return ((Table.Cell)iterator.next()).getValue();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return StandardTable.this.size();
        }
    }
}

