/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.io;

import com.google.common.annotations.Beta;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.python.google.common.base.Preconditions;

@Beta
public final class LimitInputStream
extends FilterInputStream {
    private long left;
    private long mark = -1L;

    public LimitInputStream(InputStream inputStream, long l) {
        super(inputStream);
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkArgument(l >= 0L, "limit must be non-negative");
        this.left = l;
    }

    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    public void mark(int n) {
        this.in.mark(n);
        this.mark = this.left;
    }

    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            --this.left;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2 = (int)Math.min((long)n2, this.left));
        if (n3 != -1) {
            this.left -= (long)n3;
        }
        return n3;
    }

    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    public long skip(long l) throws IOException {
        l = Math.min(l, this.left);
        long l2 = this.in.skip(l);
        this.left -= l2;
        return l2;
    }
}

