/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.python.google.common.base.Preconditions;
import org.python.google.common.io.InputSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiReader
extends Reader {
    private final Iterator<? extends InputSupplier<? extends Reader>> it;
    private Reader current;

    MultiReader(Iterator<? extends InputSupplier<? extends Reader>> iterator) throws IOException {
        this.it = iterator;
        this.advance();
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.current = this.it.next().getInput();
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.current == null) {
            return -1;
        }
        int n3 = this.current.read(cArray, n, n2);
        if (n3 == -1) {
            this.advance();
            return this.read(cArray, n, n2);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        Preconditions.checkArgument(l >= 0L, "n is negative");
        if (l > 0L) {
            while (this.current != null) {
                long l2 = this.current.skip(l);
                if (l2 > 0L) {
                    return l2;
                }
                this.advance();
            }
        }
        return 0L;
    }

    @Override
    public boolean ready() throws IOException {
        return this.current != null && this.current.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.current != null) {
            try {
                this.current.close();
            }
            finally {
                this.current = null;
            }
        }
    }
}

