/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.net;

import com.google.common.annotations.Beta;
import java.net.InetAddress;
import java.text.ParseException;
import javax.annotation.Nullable;
import org.python.google.common.net.InetAddresses;
import org.python.google.common.net.InternetDomainName;

@Beta
public final class HostSpecifier {
    private final String canonicalForm;

    private HostSpecifier(String string) {
        this.canonicalForm = string;
    }

    public static HostSpecifier fromValid(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddresses.forString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (inetAddress == null) {
            try {
                inetAddress = InetAddresses.forUriString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (inetAddress != null) {
            return new HostSpecifier(InetAddresses.toUriString(inetAddress));
        }
        InternetDomainName internetDomainName = InternetDomainName.from(string);
        if (internetDomainName.isUnderPublicSuffix()) {
            return new HostSpecifier(internetDomainName.name());
        }
        throw new IllegalArgumentException("Domain name not under a recognized TLD: " + string);
    }

    public static HostSpecifier from(String string) throws ParseException {
        try {
            return HostSpecifier.fromValid(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Invalid host specifier: " + string, 0);
        }
    }

    public static boolean isValid(String string) {
        try {
            HostSpecifier.fromValid(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HostSpecifier) {
            HostSpecifier hostSpecifier = (HostSpecifier)object;
            return this.canonicalForm.equals(hostSpecifier.canonicalForm);
        }
        return false;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public String toString() {
        return this.canonicalForm;
    }
}

