/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Ascii;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Joiner;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;
import org.python.google.common.base.Splitter;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.net.TldPatterns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible(emulated=true)
public final class InternetDomainName {
    private static final CharMatcher DOTS_MATCHER = CharMatcher.anyOf(".\u3002\uff0e\uff61");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');
    private static final int NO_PUBLIC_SUFFIX_FOUND = -1;
    private static final String DOT_REGEX = "\\.";
    private final String name;
    private final ImmutableList<String> parts;
    private final int publicSuffixIndex;
    private static final int MAX_DOMAIN_PART_LENGTH = 63;
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf("-_");
    private static final CharMatcher PART_CHAR_MATCHER = CharMatcher.JAVA_LETTER_OR_DIGIT.or(DASH_MATCHER);

    private InternetDomainName(String string) {
        string = DOTS_MATCHER.replaceFrom((CharSequence)string, '.');
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        this.name = string;
        this.parts = ImmutableList.copyOf(DOT_SPLITTER.split(string));
        Preconditions.checkArgument(InternetDomainName.validateSyntax(this.parts), "Not a valid domain name: '%s'", string);
        this.publicSuffixIndex = this.findPublicSuffix();
    }

    private InternetDomainName(List<String> list) {
        Preconditions.checkArgument(!list.isEmpty());
        this.parts = ImmutableList.copyOf(list);
        this.name = DOT_JOINER.join(list);
        this.publicSuffixIndex = this.findPublicSuffix();
    }

    private int findPublicSuffix() {
        int n = this.parts.size();
        for (int i = 0; i < n; ++i) {
            String string = DOT_JOINER.join(this.parts.subList(i, n));
            if (TldPatterns.EXACT.contains(string)) {
                return i;
            }
            if (TldPatterns.EXCLUDED.contains(string)) {
                return i + 1;
            }
            if (!InternetDomainName.matchesWildcardPublicSuffix(string)) continue;
            return i;
        }
        return -1;
    }

    public static InternetDomainName from(String string) {
        return new InternetDomainName(Ascii.toLowerCase(Preconditions.checkNotNull(string)));
    }

    private static boolean validateSyntax(List<String> list) {
        int n = list.size() - 1;
        if (!InternetDomainName.validatePart(list.get(n), true)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (InternetDomainName.validatePart(string, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean validatePart(String string, boolean bl) {
        if (string.length() < 1 || string.length() > 63) {
            return false;
        }
        if (!CharMatcher.ASCII.matchesAllOf(string)) {
            return true;
        }
        if (!PART_CHAR_MATCHER.matchesAllOf(string)) {
            return false;
        }
        if (DASH_MATCHER.matches(string.charAt(0)) || DASH_MATCHER.matches(string.charAt(string.length() - 1))) {
            return false;
        }
        return !bl || !CharMatcher.DIGIT.matches(string.charAt(0));
    }

    public String name() {
        return this.name;
    }

    public ImmutableList<String> parts() {
        return this.parts;
    }

    public boolean isPublicSuffix() {
        return this.publicSuffixIndex == 0;
    }

    public boolean hasPublicSuffix() {
        return this.publicSuffixIndex != -1;
    }

    public InternetDomainName publicSuffix() {
        return this.hasPublicSuffix() ? this.ancestor(this.publicSuffixIndex) : null;
    }

    public boolean isUnderPublicSuffix() {
        return this.publicSuffixIndex > 0;
    }

    public boolean isTopPrivateDomain() {
        return this.publicSuffixIndex == 1;
    }

    public InternetDomainName topPrivateDomain() {
        if (this.isTopPrivateDomain()) {
            return this;
        }
        Preconditions.checkState(this.isUnderPublicSuffix(), "Not under a public suffix: %s", this.name);
        return this.ancestor(this.publicSuffixIndex - 1);
    }

    public boolean hasParent() {
        return this.parts.size() > 1;
    }

    public InternetDomainName parent() {
        Preconditions.checkState(this.hasParent(), "Domain '%s' has no parent", this.name);
        return this.ancestor(1);
    }

    private InternetDomainName ancestor(int n) {
        return new InternetDomainName(this.parts.subList(n, this.parts.size()));
    }

    public InternetDomainName child(String string) {
        return InternetDomainName.from(Preconditions.checkNotNull(string) + "." + this.name);
    }

    public static boolean isValid(String string) {
        try {
            InternetDomainName.from(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static boolean matchesWildcardPublicSuffix(String string) {
        String[] stringArray = string.split(DOT_REGEX, 2);
        return stringArray.length == 2 && TldPatterns.UNDER.contains(stringArray[1]);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternetDomainName) {
            InternetDomainName internetDomainName = (InternetDomainName)object;
            return this.name.equals(internetDomainName.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

