/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Longs {
    public static final int BYTES = 8;

    private Longs() {
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l > l2 ? 1 : 0);
    }

    public static boolean contains(long[] lArray, long l) {
        for (long l2 : lArray) {
            if (l2 != l) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(long[] lArray, long l) {
        return Longs.indexOf(lArray, l, 0, lArray.length);
    }

    private static int indexOf(long[] lArray, long l, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (lArray[i] != l) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] lArray, long[] lArray2) {
        Preconditions.checkNotNull(lArray, "array");
        Preconditions.checkNotNull(lArray2, "target");
        if (lArray2.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < lArray.length - lArray2.length + 1; ++i) {
            for (int j = 0; j < lArray2.length; ++j) {
                if (lArray[i + j] != lArray2[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] lArray, long l) {
        return Longs.lastIndexOf(lArray, l, 0, lArray.length);
    }

    private static int lastIndexOf(long[] lArray, long l, int n, int n2) {
        for (int i = n2 - 1; i >= n; --i) {
            if (lArray[i] != l) continue;
            return i;
        }
        return -1;
    }

    public static long min(long ... lArray) {
        Preconditions.checkArgument(lArray.length > 0);
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i] >= l) continue;
            l = lArray[i];
        }
        return l;
    }

    public static long max(long ... lArray) {
        Preconditions.checkArgument(lArray.length > 0);
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i] <= l) continue;
            l = lArray[i];
        }
        return l;
    }

    public static long[] concat(long[] ... lArray) {
        int n = 0;
        for (long[] lArray2 : lArray) {
            n += lArray2.length;
        }
        long[] lArray3 = new long[n];
        int n2 = 0;
        for (long[] lArray4 : lArray) {
            System.arraycopy(lArray4, 0, lArray3, n2, lArray4.length);
            n2 += lArray4.length;
        }
        return lArray3;
    }

    @GwtIncompatible(value="doesn't work")
    public static byte[] toByteArray(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    @GwtIncompatible(value="doesn't work")
    public static long fromByteArray(byte[] byArray) {
        Preconditions.checkArgument(byArray.length >= 8, "array too small: %s < %s", byArray.length, 8);
        return Longs.fromBytes(byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]);
    }

    @GwtIncompatible(value="doesn't work")
    public static long fromBytes(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return ((long)by & 0xFFL) << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | (long)by8 & 0xFFL;
    }

    public static long[] ensureCapacity(long[] lArray, int n, int n2) {
        Preconditions.checkArgument(n >= 0, "Invalid minLength: %s", n);
        Preconditions.checkArgument(n2 >= 0, "Invalid padding: %s", n2);
        return lArray.length < n ? Longs.copyOf(lArray, n + n2) : lArray;
    }

    private static long[] copyOf(long[] lArray, int n) {
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, Math.min(lArray.length, n));
        return lArray2;
    }

    public static String join(String string, long ... lArray) {
        Preconditions.checkNotNull(string);
        if (lArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 10);
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            stringBuilder.append(string).append(lArray[i]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static long[] toArray(Collection<Long> collection) {
        if (collection instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection).toLongArray();
        }
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = (Long)objectArray[i];
        }
        return lArray;
    }

    public static List<Long> asList(long ... lArray) {
        if (lArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(lArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] lArray, long[] lArray2) {
            int n = Math.min(lArray.length, lArray2.length);
            for (int i = 0; i < n; ++i) {
                int n2 = Longs.compare(lArray[i], lArray2[i]);
                if (n2 == 0) continue;
                return n2;
            }
            return lArray.length - lArray2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtCompatible
    private static class LongArrayAsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        final long[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        LongArrayAsList(long[] lArray) {
            this(lArray, 0, lArray.length);
        }

        LongArrayAsList(long[] lArray, int n, int n2) {
            this.array = lArray;
            this.start = n;
            this.end = n2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int n) {
            Preconditions.checkElementIndex(n, this.size());
            return this.array[this.start + n];
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Long && Longs.indexOf(this.array, (Long)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n;
            if (object instanceof Long && (n = Longs.indexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n;
            if (object instanceof Long && (n = Longs.lastIndexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int n, Long l) {
            Preconditions.checkElementIndex(n, this.size());
            long l2 = this.array[this.start + n];
            this.array[this.start + n] = l;
            return l2;
        }

        @Override
        public List<Long> subList(int n, int n2) {
            int n3 = this.size();
            Preconditions.checkPositionIndexes(n, n2, n3);
            if (n == n2) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + n, this.start + n2);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList longArrayAsList = (LongArrayAsList)object;
                int n = this.size();
                if (longArrayAsList.size() != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.array[this.start + i] == longArrayAsList.array[longArrayAsList.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n = 1;
            for (int i = this.start; i < this.end; ++i) {
                n = 31 * n + Longs.hashCode(this.array[i]);
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 10);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                stringBuilder.append(", ").append(this.array[i]);
            }
            return stringBuilder.append(']').toString();
        }

        long[] toLongArray() {
            int n = this.size();
            long[] lArray = new long[n];
            System.arraycopy(this.array, this.start, lArray, 0, n);
            return lArray;
        }
    }
}

