/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.primitives;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import org.python.google.common.base.Preconditions;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedBytes {
    private UnsignedBytes() {
    }

    public static int toInt(byte by) {
        return by & 0xFF;
    }

    public static byte checkedCast(long l) {
        Preconditions.checkArgument(l >> 8 == 0L, "out of range: %s", l);
        return (byte)l;
    }

    public static byte saturatedCast(long l) {
        if (l > 255L) {
            return -1;
        }
        if (l < 0L) {
            return 0;
        }
        return (byte)l;
    }

    public static int compare(byte by, byte by2) {
        return UnsignedBytes.toInt(by) - UnsignedBytes.toInt(by2);
    }

    public static byte min(byte ... byArray) {
        Preconditions.checkArgument(byArray.length > 0);
        int n = UnsignedBytes.toInt(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            int n2 = UnsignedBytes.toInt(byArray[i]);
            if (n2 >= n) continue;
            n = n2;
        }
        return (byte)n;
    }

    public static byte max(byte ... byArray) {
        Preconditions.checkArgument(byArray.length > 0);
        int n = UnsignedBytes.toInt(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            int n2 = UnsignedBytes.toInt(byArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return (byte)n;
    }

    public static String join(String string, byte ... byArray) {
        Preconditions.checkNotNull(string);
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 5);
        stringBuilder.append(UnsignedBytes.toInt(byArray[0]));
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(string).append(UnsignedBytes.toInt(byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicalComparatorHolder {
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";

        private LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> clazz = Class.forName(UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)clazz.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable throwable) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                int n = Math.min(byArray.length, byArray2.length);
                for (int i = 0; i < n; ++i) {
                    int n2 = UnsignedBytes.compare(byArray[i], byArray2[i]);
                    if (n2 == 0) continue;
                    return n2;
                }
                return byArray.length - byArray2.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean littleEndian;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            static boolean lessThanUnsigned(long l, long l2) {
                return l + Long.MIN_VALUE < l2 + Long.MIN_VALUE;
            }

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                int n;
                int n2 = Math.min(byArray.length, byArray2.length);
                int n3 = n2 / 8;
                for (n = 0; n < n3 * 8; n += 8) {
                    int n4;
                    long l;
                    long l2 = theUnsafe.getLong(byArray, (long)BYTE_ARRAY_BASE_OFFSET + (long)n);
                    long l3 = l2 ^ (l = theUnsafe.getLong(byArray2, (long)BYTE_ARRAY_BASE_OFFSET + (long)n));
                    if (l3 == 0L) continue;
                    if (!littleEndian) {
                        return UnsafeComparator.lessThanUnsigned(l2, l) ? -1 : 1;
                    }
                    int n5 = 0;
                    int n6 = (int)l3;
                    if (n6 == 0) {
                        n6 = (int)(l3 >>> 32);
                        n5 = 32;
                    }
                    if ((n4 = n6 << 16) == 0) {
                        n5 += 16;
                    } else {
                        n6 = n4;
                    }
                    n4 = n6 << 8;
                    if (n4 == 0) {
                        n5 += 8;
                    }
                    return (int)((l2 >>> n5 & 0xFFL) - (l >>> n5 & 0xFFL));
                }
                for (n = n3 * 8; n < n2; ++n) {
                    int n7 = UnsignedBytes.compare(byArray[n], byArray2[n]);
                    if (n7 == 0) continue;
                    return n7;
                }
                return byArray.length - byArray2.length;
            }

            static {
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
                theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field field = Unsafe.class.getDeclaredField("theUnsafe");
                            field.setAccessible(true);
                            return field.get(null);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            throw new Error();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new Error();
                        }
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }
    }
}

