/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.antlr.AnalyzingParser;
import org.python.antlr.base.mod;
import org.python.antlr.runtime.ANTLRFileStream;
import org.python.antlr.runtime.ANTLRStringStream;
import org.python.antlr.runtime.CharStream;
import org.python.antlr.runtime.RecognitionException;
import org.python.indexer.AstConverter;
import org.python.indexer.Diagnostic;
import org.python.indexer.Indexer;
import org.python.indexer.Util;
import org.python.indexer.ast.NModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstCache {
    public static final String CACHE_DIR = Util.getSystemTempDir() + "jython/ast_cache/";
    private static final Logger LOG = Logger.getLogger(AstCache.class.getCanonicalName());
    private Map<String, NModule> cache = new HashMap<String, NModule>();
    private static AstCache INSTANCE;

    private AstCache() throws Exception {
        File file = new File(CACHE_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static AstCache get() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new AstCache();
        }
        return INSTANCE;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean clearDiskCache() {
        try {
            File file = new File(CACHE_DIR);
            for (File file2 : file.listFiles()) {
                if (!file2.isFile()) continue;
                file2.delete();
            }
            return true;
        }
        catch (Exception exception) {
            this.severe("Failed to clear disk cache: " + exception);
            return false;
        }
    }

    public NModule getAST(String string) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null path");
        }
        return this.fetch(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NModule getAST(String string, String string2) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null path");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null contents");
        }
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        NModule nModule = null;
        try {
            nModule = this.parse(string, string2);
            if (nModule != null) {
                nModule.setFileAndMD5(string, Util.getMD5(string2.getBytes("UTF-8")));
            }
        }
        finally {
            this.cache.put(string, nModule);
        }
        return nModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NModule fetch(String string) throws Exception {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        NModule nModule = this.getSerializedModule(string);
        if (nModule != null) {
            this.fine("reusing " + string);
            this.cache.put(string, nModule);
            return nModule;
        }
        try {
            nModule = this.parse(string);
        }
        finally {
            this.cache.put(string, nModule);
        }
        if (nModule != null) {
            this.serialize(nModule);
        }
        return nModule;
    }

    private NModule parse(String string) throws Exception {
        this.fine("parsing " + string);
        mod mod2 = this.invokeANTLR(string);
        return this.generateAST(mod2, string);
    }

    private NModule parse(String string, String string2) throws Exception {
        this.fine("parsing " + string);
        mod mod2 = this.invokeANTLR(string, string2);
        return this.generateAST(mod2, string);
    }

    private NModule generateAST(mod mod2, String string) throws Exception {
        if (mod2 == null) {
            Indexer.idx.reportFailedAssertion("ANTLR returned NULL for " + string);
            return null;
        }
        Object r = mod2.accept(new AstConverter());
        if (!(r instanceof NModule)) {
            this.warn("\n[warning] converted AST is not a module: " + r);
            return null;
        }
        NModule nModule = (NModule)r;
        if (new File(string).canRead()) {
            nModule.setFile(string);
        }
        return nModule;
    }

    private mod invokeANTLR(String string) {
        ANTLRFileStream aNTLRFileStream = null;
        try {
            aNTLRFileStream = new ANTLRFileStream(string);
        }
        catch (IOException iOException) {
            this.fine(string + ": " + iOException);
            return null;
        }
        return this.invokeANTLR(aNTLRFileStream, string);
    }

    private mod invokeANTLR(String string, String string2) {
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string2);
        return this.invokeANTLR(aNTLRStringStream, string);
    }

    private mod invokeANTLR(CharStream charStream, String string) {
        AnalyzingParser analyzingParser = new AnalyzingParser(charStream, string, null);
        mod mod2 = null;
        try {
            mod2 = analyzingParser.parseModule();
        }
        catch (Exception exception) {
            this.fine("parse for " + string + " failed: " + exception);
        }
        this.recordParseErrors(string, analyzingParser.getRecognitionErrors());
        return mod2;
    }

    private void recordParseErrors(String string, List<RecognitionException> list) {
        if (list.isEmpty()) {
            return;
        }
        List<Diagnostic> list2 = Indexer.idx.getParseErrs(string);
        for (RecognitionException recognitionException : list) {
            String string2 = recognitionException.line + ":" + recognitionException.charPositionInLine + ":" + recognitionException;
            list2.add(new Diagnostic(string, Diagnostic.Type.ERROR, -1, -1, string2));
        }
    }

    public String getCachePath(File file) throws Exception {
        return this.getCachePath(Util.getMD5(file), file.getName());
    }

    public String getCachePath(String string, String string2) {
        return CACHE_DIR + string2 + string + ".ast";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialize(NModule nModule) throws Exception {
        String string = this.getCachePath(nModule.getMD5(), new File(nModule.getFile()).getName());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(nModule);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            } else if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    NModule getSerializedModule(String string) {
        try {
            File file = new File(string);
            if (file == null || !file.canRead()) {
                return null;
            }
            File file2 = new File(this.getCachePath(file));
            if (!file2.canRead()) {
                return null;
            }
            return this.deserialize(file);
        }
        catch (Exception exception) {
            this.severe("Failed to deserialize " + string + ": " + exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NModule deserialize(File file) throws Exception {
        String string = this.getCachePath(file);
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
            NModule nModule = (NModule)objectInputStream.readObject();
            nModule.setFile(file);
            NModule nModule2 = nModule;
            return nModule2;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            } else if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void log(Level level, String string) {
        if (LOG.isLoggable(level)) {
            LOG.log(level, string);
        }
    }

    private void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    private void warn(String string) {
        this.log(Level.WARNING, string);
    }

    private void info(String string) {
        this.log(Level.INFO, string);
    }

    private void fine(String string) {
        this.log(Level.FINE, string);
    }

    private void finer(String string) {
        this.log(Level.FINER, string);
    }
}

