/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class Builtins {
    public static final String LIBRARY_URL = "http://docs.python.org/library/";
    public static final String TUTORIAL_URL = "http://docs.python.org/tutorial/";
    public static final String REFERENCE_URL = "http://docs.python.org/reference/";
    public static final String DATAMODEL_URL = "http://docs.python.org/reference/datamodel#";
    public NModuleType Builtin;
    public NClassType Object;
    public NClassType Type;
    public NClassType None;
    public NClassType BaseNum;
    public NClassType BaseComplex;
    public NClassType BaseBool;
    public NClassType BaseStr;
    public NClassType BaseList;
    public NClassType BaseArray;
    public NClassType BaseDict;
    public NClassType BaseTuple;
    public NClassType BaseModule;
    public NClassType BaseFile;
    public NClassType BaseException;
    public NClassType BaseStruct;
    public NClassType BaseFunction;
    public NClassType BaseClass;
    public NClassType Datetime_datetime;
    public NClassType Datetime_date;
    public NClassType Datetime_time;
    public NClassType Datetime_timedelta;
    public NClassType Datetime_tzinfo;
    public NClassType Time_struct_time;
    Scope globaltable;
    Scope moduleTable;
    String[] builtin_exception_types = new String[]{"ArithmeticError", "AssertionError", "AttributeError", "BaseException", "Exception", "DeprecationWarning", "EOFError", "EnvironmentError", "FloatingPointError", "FutureWarning", "GeneratorExit", "IOError", "ImportError", "ImportWarning", "IndentationError", "IndexError", "KeyError", "KeyboardInterrupt", "LookupError", "MemoryError", "NameError", "NotImplemented", "NotImplementedError", "OSError", "OverflowError", "PendingDeprecationWarning", "ReferenceError", "RuntimeError", "RuntimeWarning", "StandardError", "StopIteration", "SyntaxError", "SyntaxWarning", "SystemError", "SystemExit", "TabError", "TypeError", "UnboundLocalError", "UnicodeDecodeError", "UnicodeEncodeError", "UnicodeError", "UnicodeTranslateError", "UnicodeWarning", "UserWarning", "ValueError", "Warning", "ZeroDivisionError"};
    Set<NType> nativeTypes = new HashSet<NType>();
    private Map<String, NativeModule> modules = new HashMap<String, NativeModule>();

    public static NUrl newLibUrl(String string, String string2) {
        return Builtins.newLibUrl(string + ".html#" + string2);
    }

    public static NUrl newLibUrl(String string) {
        if (!string.endsWith(".html")) {
            string = string + ".html";
        }
        return new NUrl(LIBRARY_URL + string);
    }

    public static NUrl newRefUrl(String string) {
        return new NUrl(REFERENCE_URL + string);
    }

    public static NUrl newDataModelUrl(String string) {
        return new NUrl(DATAMODEL_URL + string);
    }

    public static NUrl newTutUrl(String string) {
        return new NUrl(TUTORIAL_URL + string);
    }

    NClassType newClass(String string, Scope scope) {
        return this.newClass(string, scope, null, new NClassType[0]);
    }

    NClassType newClass(String string, Scope scope, NClassType nClassType, NClassType ... nClassTypeArray) {
        NClassType nClassType2 = new NClassType(string, scope, nClassType);
        for (NClassType nClassType3 : nClassTypeArray) {
            nClassType2.addSuper(nClassType3);
        }
        this.nativeTypes.add(nClassType2);
        return nClassType2;
    }

    NModuleType newModule(String string) {
        NModuleType nModuleType = new NModuleType(string, null, this.globaltable);
        this.nativeTypes.add(nModuleType);
        return nModuleType;
    }

    NUnknownType unknown() {
        NUnknownType nUnknownType = new NUnknownType();
        this.nativeTypes.add(nUnknownType);
        return nUnknownType;
    }

    NClassType newException(String string, Scope scope) {
        return this.newClass(string, scope, this.BaseException, new NClassType[0]);
    }

    NFuncType newFunc() {
        NFuncType nFuncType = new NFuncType();
        this.nativeTypes.add(nFuncType);
        return nFuncType;
    }

    NFuncType newFunc(NType nType) {
        NFuncType nFuncType = new NFuncType(nType);
        this.nativeTypes.add(nFuncType);
        return nFuncType;
    }

    NListType newList() {
        return this.newList(this.unknown());
    }

    NListType newList(NType nType) {
        NListType nListType = new NListType(nType);
        this.nativeTypes.add(nListType);
        return nListType;
    }

    NDictType newDict(NType nType, NType nType2) {
        NDictType nDictType = new NDictType(nType, nType2);
        this.nativeTypes.add(nDictType);
        return nDictType;
    }

    NTupleType newTuple(NType ... nTypeArray) {
        NTupleType nTupleType = new NTupleType(nTypeArray);
        this.nativeTypes.add(nTupleType);
        return nTupleType;
    }

    NUnionType newUnion(NType ... nTypeArray) {
        NUnionType nUnionType = new NUnionType(nTypeArray);
        this.nativeTypes.add(nUnionType);
        return nUnionType;
    }

    String[] list(String ... stringArray) {
        return stringArray;
    }

    public Builtins(Scope scope, Scope scope2) {
        this.globaltable = scope;
        this.moduleTable = scope2;
        this.buildTypes();
    }

    private void buildTypes() {
        new BuiltinsModule();
        Scope scope = this.Builtin.getTable();
        this.Object = this.newClass("object", scope);
        this.None = this.newClass("None", scope);
        this.Type = this.newClass("type", scope, this.Object, new NClassType[0]);
        this.BaseTuple = this.newClass("tuple", scope, this.Object, new NClassType[0]);
        this.BaseList = this.newClass("list", scope, this.Object, new NClassType[0]);
        this.BaseArray = this.newClass("array", scope);
        this.BaseDict = this.newClass("dict", scope, this.Object, new NClassType[0]);
        this.BaseNum = this.newClass("float", scope, this.Object, new NClassType[0]);
        this.BaseComplex = this.newClass("complex", scope, this.Object, new NClassType[0]);
        this.BaseBool = this.newClass("bool", scope, this.BaseNum, new NClassType[0]);
        this.BaseStr = this.newClass("str", scope, this.Object, new NClassType[0]);
        this.BaseModule = this.newClass("module", scope);
        this.BaseFile = this.newClass("file", scope, this.Object, new NClassType[0]);
        this.BaseFunction = this.newClass("function", scope, this.Object, new NClassType[0]);
        this.BaseClass = this.newClass("classobj", scope, this.Object, new NClassType[0]);
    }

    void init() {
        this.buildObjectType();
        this.buildTupleType();
        this.buildArrayType();
        this.buildListType();
        this.buildDictType();
        this.buildNumTypes();
        this.buildStrType();
        this.buildModuleType();
        this.buildFileType();
        this.buildFunctionType();
        this.buildClassType();
        this.modules.get("__builtin__").initBindings();
        new ArrayModule();
        new AudioopModule();
        new BinasciiModule();
        new Bz2Module();
        new CPickleModule();
        new CStringIOModule();
        new CMathModule();
        new CollectionsModule();
        new CryptModule();
        new CTypesModule();
        new DatetimeModule();
        new DbmModule();
        new ErrnoModule();
        new ExceptionsModule();
        new FcntlModule();
        new FpectlModule();
        new GcModule();
        new GdbmModule();
        new GrpModule();
        new ImpModule();
        new ItertoolsModule();
        new MarshalModule();
        new MathModule();
        new Md5Module();
        new MmapModule();
        new NisModule();
        new OperatorModule();
        new OsModule();
        new ParserModule();
        new PosixModule();
        new PwdModule();
        new PyexpatModule();
        new ReadlineModule();
        new ResourceModule();
        new SelectModule();
        new SignalModule();
        new ShaModule();
        new SpwdModule();
        new StropModule();
        new StructModule();
        new SysModule();
        new SyslogModule();
        new TermiosModule();
        new ThreadModule();
        new TimeModule();
        new UnicodedataModule();
        new ZipimportModule();
        new ZlibModule();
    }

    public NModuleType get(String string) {
        if (string.indexOf(".") == -1) {
            return this.getModule(string);
        }
        String[] stringArray = string.split("\\.");
        NType nType = this.getModule(stringArray[0]);
        if (nType == null) {
            return null;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            if ((nType = nType.getTable().lookupType(stringArray[i])) instanceof NModuleType) continue;
            return null;
        }
        return nType;
    }

    private NModuleType getModule(String string) {
        NativeModule nativeModule = this.modules.get(string);
        return nativeModule == null ? null : nativeModule.getModule();
    }

    public boolean isNative(NType nType) {
        return this.nativeTypes.contains(nType);
    }

    void buildObjectType() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"__delattr__", "__format__", "__getattribute__", "__hash__", "__init__", "__new__", "__reduce__", "__reduce_ex__", "__repr__", "__setattr__", "__sizeof__", "__str__", "__subclasshook__"}) {
            this.Object.getTable().update(string, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        this.Object.getTable().update("__doc__", Builtins.newLibUrl("stdtypes"), (NType)this.BaseStr, NBinding.Kind.CLASS);
        this.Object.getTable().update("__class__", Builtins.newLibUrl("stdtypes"), (NType)this.unknown(), NBinding.Kind.CLASS);
    }

    void buildTupleType() {
        Scope scope = this.BaseTuple.getTable();
        String[] stringArray = new String[]{"__add__", "__contains__", "__eq__", "__ge__", "__getnewargs__", "__gt__", "__iter__", "__le__", "__len__", "__lt__", "__mul__", "__ne__", "__new__", "__rmul__", "count", "index"};
        for (String string : stringArray) {
            scope.update(string, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        NBinding nBinding = scope.update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        nBinding.markDeprecated();
        scope.update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        scope.update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
    }

    void buildArrayType() {
        int n;
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"append", "buffer_info", "byteswap", "extend", "fromfile", "fromlist", "fromstring", "fromunicode", "index", "insert", "pop", "read", "remove", "reverse", "tofile", "tolist", "typecode", "write"};
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            String string = stringArray2[n];
            this.BaseArray.getTable().update(string, Builtins.newLibUrl("array"), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        String[] stringArray3 = stringArray2 = new String[]{"count", "itemsize"};
        n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray3[i];
            this.BaseArray.getTable().update(string, Builtins.newLibUrl("array"), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        for (String string : stringArray3 = new String[]{"tostring", "tounicode"}) {
            this.BaseArray.getTable().update(string, Builtins.newLibUrl("array"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
    }

    void buildListType() {
        String[] stringArray;
        this.BaseList.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        this.BaseList.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        this.BaseList.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        String[] stringArray2 = stringArray = new String[]{"append", "extend", "index", "insert", "pop", "remove", "reverse", "sort"};
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            this.BaseList.getTable().update(string, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        for (String string : stringArray2 = new String[]{"count"}) {
            this.BaseList.getTable().update(string, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
    }

    NUrl numUrl() {
        return Builtins.newLibUrl("stdtypes", "typesnumeric");
    }

    void buildNumTypes() {
        String[] stringArray;
        Scope scope = this.BaseNum.getTable();
        String[] stringArray2 = new String[]{"__abs__", "__add__", "__coerce__", "__div__", "__divmod__", "__eq__", "__float__", "__floordiv__", "__format__", "__ge__", "__getformat__", "__gt__", "__int__", "__le__", "__long__", "__lt__", "__mod__", "__mul__", "__ne__", "__neg__", "__new__", "__nonzero__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__setformat__", "__sub__", "__truediv__", "__trunc__", "as_integer_ratio", "fromhex", "is_integer"};
        for (String string : stringArray2) {
            scope.update(string, this.numUrl(), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        scope.update("__getnewargs__", this.numUrl(), (NType)this.newFunc(this.newTuple(this.BaseNum)), NBinding.Kind.METHOD);
        scope.update("hex", this.numUrl(), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        scope.update("conjugate", this.numUrl(), (NType)this.newFunc(this.BaseComplex), NBinding.Kind.METHOD);
        Scope scope2 = this.BaseComplex.getTable();
        String[] stringArray3 = stringArray = new String[]{"__abs__", "__add__", "__div__", "__divmod__", "__float__", "__floordiv__", "__format__", "__getformat__", "__int__", "__long__", "__mod__", "__mul__", "__neg__", "__new__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__sub__", "__truediv__", "conjugate"};
        int n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray3[i];
            scope2.update(string, this.numUrl(), (NType)this.newFunc(this.BaseComplex), NBinding.Kind.METHOD);
        }
        for (String string : stringArray3 = new String[]{"__eq__", "__ge__", "__gt__", "__le__", "__lt__", "__ne__", "__nonzero__", "__coerce__"}) {
            scope2.update(string, this.numUrl(), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        scope2.update("__getnewargs__", this.numUrl(), (NType)this.newFunc(this.newTuple(this.BaseComplex)), NBinding.Kind.METHOD);
        scope2.update("imag", this.numUrl(), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        scope2.update("real", this.numUrl(), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
    }

    void buildStrType() {
        int n;
        String[] stringArray;
        this.BaseStr.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        this.BaseStr.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        this.BaseStr.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        String[] stringArray2 = stringArray = new String[]{"capitalize", "center", "decode", "encode", "expandtabs", "format", "index", "join", "ljust", "lower", "lstrip", "partition", "replace", "rfind", "rindex", "rjust", "rpartition", "rsplit", "rstrip", "strip", "swapcase", "title", "translate", "upper", "zfill"};
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            String string = stringArray2[n];
            this.BaseStr.getTable().update(string, Builtins.newLibUrl("stdtypes.html#str." + string), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
        String[] stringArray3 = stringArray2 = new String[]{"count", "isalnum", "isalpha", "isdigit", "islower", "isspace", "istitle", "isupper", "find", "startswith", "endswith"};
        n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray3[i];
            this.BaseStr.getTable().update(string, Builtins.newLibUrl("stdtypes.html#str." + string), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        for (String string : stringArray3 = new String[]{"split", "splitlines"}) {
            this.BaseStr.getTable().update(string, Builtins.newLibUrl("stdtypes.html#str." + string), (NType)this.newFunc(this.newList(this.BaseStr)), NBinding.Kind.METHOD);
        }
        this.BaseStr.getTable().update("partition", Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.newTuple(this.BaseStr)), NBinding.Kind.METHOD);
    }

    void buildModuleType() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"__doc__", "__file__", "__name__", "__package__"}) {
            this.BaseModule.getTable().update(string, Builtins.newTutUrl("modules.html"), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        this.BaseModule.getTable().update("__dict__", Builtins.newLibUrl("stdtypes", "modules"), (NType)this.newDict(this.BaseStr, this.unknown()), NBinding.Kind.ATTRIBUTE);
    }

    void buildDictType() {
        String[] stringArray;
        String string = "datastructures.html#dictionaries";
        Scope scope = this.BaseDict.getTable();
        scope.update("__getitem__", Builtins.newTutUrl(string), (NType)this.newFunc(), NBinding.Kind.METHOD);
        scope.update("__iter__", Builtins.newTutUrl(string), (NType)this.newFunc(), NBinding.Kind.METHOD);
        scope.update("get", Builtins.newTutUrl(string), (NType)this.newFunc(), NBinding.Kind.METHOD);
        scope.update("items", Builtins.newTutUrl(string), (NType)this.newFunc(this.newList(this.newTuple(this.unknown(), this.unknown()))), NBinding.Kind.METHOD);
        scope.update("keys", Builtins.newTutUrl(string), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        scope.update("values", Builtins.newTutUrl(string), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        String[] stringArray2 = stringArray = new String[]{"clear", "copy", "fromkeys", "get", "iteritems", "iterkeys", "itervalues", "pop", "popitem", "setdefault", "update"};
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i];
            scope.update(string2, Builtins.newTutUrl(string), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        for (String string3 : stringArray2 = new String[]{"has_key"}) {
            scope.update(string3, Builtins.newTutUrl(string), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
    }

    void buildFileType() {
        int n;
        int n2;
        String[] stringArray;
        String string = "stdtypes.html#bltin-file-objects";
        Scope scope = this.BaseFile.getTable();
        String[] stringArray2 = stringArray = new String[]{"__enter__", "__exit__", "__iter__", "flush", "readinto", "truncate"};
        int n3 = stringArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = stringArray2[n2];
            scope.update(string2, Builtins.newLibUrl(string), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        String[] stringArray3 = stringArray2 = new String[]{"next", "read", "readline"};
        n2 = stringArray3.length;
        for (n = 0; n < n2; ++n) {
            String string3 = stringArray3[n];
            scope.update(string3, Builtins.newLibUrl(string), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
        String[] stringArray4 = stringArray3 = new String[]{"fileno", "isatty", "tell"};
        n = stringArray4.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray4[i];
            scope.update(string4, Builtins.newLibUrl(string), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        for (String string5 : stringArray4 = new String[]{"close", "seek", "write", "writelines"}) {
            scope.update(string5, Builtins.newLibUrl(string), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        scope.update("readlines", Builtins.newLibUrl(string), (NType)this.newFunc(this.newList(this.BaseStr)), NBinding.Kind.METHOD);
        scope.update("xreadlines", Builtins.newLibUrl(string), (NType)this.newFunc(this.BaseFile), NBinding.Kind.METHOD);
        scope.update("closed", Builtins.newLibUrl(string), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        scope.update("encoding", Builtins.newLibUrl(string), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        scope.update("errors", Builtins.newLibUrl(string), (NType)this.unknown(), NBinding.Kind.ATTRIBUTE);
        scope.update("mode", Builtins.newLibUrl(string), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        scope.update("name", Builtins.newLibUrl(string), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        scope.update("softspace", Builtins.newLibUrl(string), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        scope.update("newlines", Builtins.newLibUrl(string), (NType)this.newUnion(this.BaseStr, this.newTuple(this.BaseStr)), NBinding.Kind.ATTRIBUTE);
    }

    private NBinding synthetic(Scope scope, String string, NUrl nUrl, NType nType, NBinding.Kind kind) {
        NBinding nBinding = scope.update(string, nUrl, nType, kind);
        nBinding.markSynthetic();
        return nBinding;
    }

    void buildFunctionType() {
        Scope scope = this.BaseFunction.getTable();
        for (String string : this.list("func_doc", "__doc__", "func_name", "__name__", "__module__")) {
            scope.update(string, new NUrl(DATAMODEL_URL), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        NBinding nBinding = this.synthetic(scope, "func_closure", new NUrl(DATAMODEL_URL), this.newTuple(new NType[0]), NBinding.Kind.ATTRIBUTE);
        nBinding.markReadOnly();
        this.synthetic(scope, "func_code", new NUrl(DATAMODEL_URL), this.unknown(), NBinding.Kind.ATTRIBUTE);
        this.synthetic(scope, "func_defaults", new NUrl(DATAMODEL_URL), this.newTuple(new NType[0]), NBinding.Kind.ATTRIBUTE);
        this.synthetic(scope, "func_globals", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, new NUnknownType()), NBinding.Kind.ATTRIBUTE);
        this.synthetic(scope, "func_dict", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, new NUnknownType()), NBinding.Kind.ATTRIBUTE);
        for (String string : this.list("__func__", "im_func")) {
            this.synthetic(scope, string, new NUrl(DATAMODEL_URL), new NFuncType(), NBinding.Kind.METHOD);
        }
    }

    void buildClassType() {
        Scope scope = this.BaseClass.getTable();
        for (String string : this.list("__name__", "__doc__", "__module__")) {
            this.synthetic(scope, string, new NUrl(DATAMODEL_URL), this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        this.synthetic(scope, "__dict__", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, this.unknown()), NBinding.Kind.ATTRIBUTE);
    }

    class ArrayModule
    extends NativeModule {
        public ArrayModule() {
            super("array");
        }

        public void initBindings() {
            this.addClass("array", Builtins.newLibUrl("array", "array"), Builtins.this.BaseArray);
            this.addClass("ArrayType", Builtins.newLibUrl("array", "ArrayType"), Builtins.this.BaseArray);
        }
    }

    class AudioopModule
    extends NativeModule {
        public AudioopModule() {
            super("audioop");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrFuncs("add", "adpcm2lin", "alaw2lin", "bias", "lin2alaw", "lin2lin", "lin2ulaw", "mul", "reverse", "tomono", "ulaw2lin");
            this.addNumFuncs("avg", "avgpp", "cross", "findfactor", "findmax", "getsample", "max", "maxpp", "rms");
            for (String string : Builtins.this.list("adpcm2lin", "findfit", "lin2adpcm", "minmax", "ratecv")) {
                this.addFunction(string, this.liburl(), Builtins.this.newTuple(new NType[0]));
            }
        }
    }

    class BinasciiModule
    extends NativeModule {
        public BinasciiModule() {
            super("binascii");
        }

        public void initBindings() {
            this.addStrFuncs("a2b_uu", "b2a_uu", "a2b_base64", "b2a_base64", "a2b_qp", "b2a_qp", "a2b_hqx", "rledecode_hqx", "rlecode_hqx", "b2a_hqx", "b2a_hex", "hexlify", "a2b_hex", "unhexlify");
            this.addNumFuncs("crc_hqx", "crc32");
            this.addClass("Error", this.liburl(), Builtins.this.newException("Error", this.table));
            this.addClass("Incomplete", this.liburl(), Builtins.this.newException("Incomplete", this.table));
        }
    }

    class BuiltinsModule
    extends NativeModule {
        public BuiltinsModule() {
            super("__builtin__");
            Builtins.this.Builtin = this.module = Builtins.this.newModule(this.name);
            this.table = this.module.getTable();
        }

        public void initBindings() {
            String[] stringArray;
            Builtins.this.moduleTable.put(this.name, this.liburl(), this.module, NBinding.Kind.MODULE);
            this.table.addSuper(Builtins.this.BaseModule.getTable());
            this.addClass("None", Builtins.newLibUrl("constants"), Builtins.this.None);
            this.addClass("bool", Builtins.newLibUrl("functions", "bool"), Builtins.this.BaseBool);
            this.addClass("complex", Builtins.newLibUrl("functions", "complex"), Builtins.this.BaseComplex);
            this.addClass("dict", Builtins.newLibUrl("stdtypes", "typesmapping"), Builtins.this.BaseDict);
            this.addClass("file", Builtins.newLibUrl("functions", "file"), Builtins.this.BaseFile);
            this.addClass("float", Builtins.newLibUrl("functions", "float"), Builtins.this.BaseNum);
            this.addClass("int", Builtins.newLibUrl("functions", "int"), Builtins.this.BaseNum);
            this.addClass("list", Builtins.newLibUrl("functions", "list"), Builtins.this.BaseList);
            this.addClass("long", Builtins.newLibUrl("functions", "long"), Builtins.this.BaseNum);
            this.addClass("object", Builtins.newLibUrl("functions", "object"), Builtins.this.Object);
            this.addClass("str", Builtins.newLibUrl("functions", "str"), Builtins.this.BaseStr);
            this.addClass("tuple", Builtins.newLibUrl("functions", "tuple"), Builtins.this.BaseTuple);
            this.addClass("type", Builtins.newLibUrl("functions", "type"), Builtins.this.Type);
            String[] stringArray2 = stringArray = new String[]{"apply", "basestring", "callable", "classmethod", "coerce", "compile", "copyright", "credits", "delattr", "enumerate", "eval", "execfile", "exit", "filter", "frozenset", "getattr", "help", "input", "int", "intern", "iter", "license", "long", "property", "quit", "raw_input", "reduce", "reload", "reversed", "set", "setattr", "slice", "sorted", "staticmethod", "super", "type", "unichr", "unicode"};
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                this.addFunction(string, Builtins.newLibUrl("functions.html#" + string), Builtins.this.unknown());
            }
            for (String string : stringArray2 = new String[]{"abs", "all", "any", "cmp", "coerce", "divmod", "hasattr", "hash", "id", "isinstance", "issubclass", "len", "max", "min", "ord", "pow", "round", "sum"}) {
                this.addFunction(string, Builtins.newLibUrl("functions.html#" + string), Builtins.this.BaseNum);
            }
            for (String string : Builtins.this.list("hex", "oct", "repr", "chr")) {
                this.addFunction(string, Builtins.newLibUrl("functions.html#" + string), Builtins.this.BaseStr);
            }
            this.addFunction("dir", Builtins.newLibUrl("functions", "dir"), Builtins.this.newList(Builtins.this.BaseStr));
            this.addFunction("map", Builtins.newLibUrl("functions", "map"), Builtins.this.newList(Builtins.this.unknown()));
            this.addFunction("range", Builtins.newLibUrl("functions", "range"), Builtins.this.newList(Builtins.this.BaseNum));
            this.addFunction("xrange", Builtins.newLibUrl("functions", "range"), Builtins.this.newList(Builtins.this.BaseNum));
            this.addFunction("buffer", Builtins.newLibUrl("functions", "buffer"), Builtins.this.newList(Builtins.this.unknown()));
            this.addFunction("zip", Builtins.newLibUrl("functions", "zip"), Builtins.this.newList(Builtins.this.newTuple(Builtins.this.unknown())));
            for (String string : Builtins.this.list("globals", "vars", "locals")) {
                this.addFunction(string, Builtins.newLibUrl("functions.html#" + string), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.unknown()));
            }
            for (String string : Builtins.this.builtin_exception_types) {
                this.addClass(string, Builtins.newDataModelUrl("types"), Builtins.this.newClass(string, Builtins.this.globaltable, Builtins.this.Object, new NClassType[0]));
            }
            Builtins.this.BaseException = (NClassType)this.table.lookup("BaseException").getType();
            for (String string : Builtins.this.list("True", "False", "None", "Ellipsis")) {
                this.addAttr(string, Builtins.newDataModelUrl("types"), Builtins.this.unknown());
            }
            this.addFunction("open", Builtins.newTutUrl("inputoutput.html#reading-and-writing-files"), Builtins.this.BaseFile);
            this.addFunction("__import__", Builtins.newLibUrl("functions"), Builtins.this.newModule("<?>"));
            Builtins.this.globaltable.put("__builtins__", this.liburl(), this.module, NBinding.Kind.ATTRIBUTE);
            Builtins.this.globaltable.merge(this.table);
        }
    }

    class Bz2Module
    extends NativeModule {
        public Bz2Module() {
            super("bz2");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("BZ2File", this.table, Builtins.this.BaseFile, new NClassType[0]);
            this.addClass("BZ2File", this.liburl(), nClassType);
            NClassType nClassType2 = Builtins.this.newClass("BZ2Compressor", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType2.getTable().update("compress", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType2.getTable().update("flush", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            this.addClass("BZ2Compressor", Builtins.newLibUrl("bz2", "sequential-de-compression"), nClassType2);
            NClassType nClassType3 = Builtins.this.newClass("BZ2Decompressor", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType3.getTable().update("decompress", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            this.addClass("BZ2Decompressor", Builtins.newLibUrl("bz2", "sequential-de-compression"), nClassType3);
            this.addFunction("compress", Builtins.newLibUrl("bz2", "one-shot-de-compression"), Builtins.this.BaseStr);
            this.addFunction("decompress", Builtins.newLibUrl("bz2", "one-shot-de-compression"), Builtins.this.BaseStr);
        }
    }

    class CMathModule
    extends NativeModule {
        public CMathModule() {
            super("cmath");
        }

        public void initBindings() {
            this.addFunction("phase", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.BaseNum);
            this.addFunction("polar", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            this.addFunction("rect", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.BaseComplex);
            for (String string : Builtins.this.list("exp", "log", "log10", "sqrt")) {
                this.addFunction(string, this.liburl("power-and-logarithmic-functions"), Builtins.this.BaseNum);
            }
            for (String string : Builtins.this.list("acos", "asin", "atan", "cos", "sin", "tan")) {
                this.addFunction(string, this.liburl("trigonometric-functions"), Builtins.this.BaseNum);
            }
            for (String string : Builtins.this.list("acosh", "asinh", "atanh", "cosh", "sinh", "tanh")) {
                this.addFunction(string, this.liburl("hyperbolic-functions"), Builtins.this.BaseComplex);
            }
            for (String string : Builtins.this.list("isinf", "isnan")) {
                this.addFunction(string, this.liburl("classification-functions"), Builtins.this.BaseBool);
            }
            for (String string : Builtins.this.list("pi", "e")) {
                this.addAttr(string, this.liburl("constants"), Builtins.this.BaseNum);
            }
        }
    }

    class CPickleModule
    extends NativeModule {
        public CPickleModule() {
            super("cPickle");
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl("pickle", "module-cPickle");
        }

        public void initBindings() {
            this.addUnknownFuncs("dump", "load", "dumps", "loads");
            this.addClass("PickleError", this.liburl(), Builtins.this.newException("PickleError", this.table));
            NClassType nClassType = Builtins.this.newException("PicklingError", this.table);
            this.addClass("PicklingError", this.liburl(), nClassType);
            this.update("UnpickleableError", this.liburl(), Builtins.this.newClass("UnpickleableError", this.table, nClassType, new NClassType[0]), NBinding.Kind.CLASS);
            NClassType nClassType2 = Builtins.this.newException("UnpicklingError", this.table);
            this.addClass("UnpicklingError", this.liburl(), nClassType2);
            this.update("BadPickleGet", this.liburl(), Builtins.this.newClass("BadPickleGet", this.table, nClassType2, new NClassType[0]), NBinding.Kind.CLASS);
            NClassType nClassType3 = Builtins.this.newClass("Pickler", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType3.getTable().update("dump", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType3.getTable().update("clear_memo", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Pickler", this.liburl(), nClassType3);
            NClassType nClassType4 = Builtins.this.newClass("Unpickler", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType4.getTable().update("load", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType4.getTable().update("noload", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Unpickler", this.liburl(), nClassType4);
        }
    }

    class CStringIOModule
    extends NativeModule {
        public CStringIOModule() {
            super("cStringIO");
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl("stringio");
        }

        protected NUrl liburl(String string) {
            return Builtins.newLibUrl("stringio", string);
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("StringIO", this.table, Builtins.this.BaseFile, new NClassType[0]);
            this.addFunction("StringIO", this.liburl(), nClassType);
            this.addAttr("InputType", this.liburl(), Builtins.this.Type);
            this.addAttr("OutputType", this.liburl(), Builtins.this.Type);
            this.addAttr("cStringIO_CAPI", this.liburl(), Builtins.this.unknown());
        }
    }

    class CTypesModule
    extends NativeModule {
        public CTypesModule() {
            super("ctypes");
        }

        public void initBindings() {
            String[] stringArray;
            for (String string : stringArray = new String[]{"ARRAY", "ArgumentError", "Array", "BigEndianStructure", "CDLL", "CFUNCTYPE", "DEFAULT_MODE", "DllCanUnloadNow", "DllGetClassObject", "FormatError", "GetLastError", "HRESULT", "LibraryLoader", "LittleEndianStructure", "OleDLL", "POINTER", "PYFUNCTYPE", "PyDLL", "RTLD_GLOBAL", "RTLD_LOCAL", "SetPointerType", "Structure", "Union", "WINFUNCTYPE", "WinDLL", "WinError", "_CFuncPtr", "_FUNCFLAG_CDECL", "_FUNCFLAG_PYTHONAPI", "_FUNCFLAG_STDCALL", "_FUNCFLAG_USE_ERRNO", "_FUNCFLAG_USE_LASTERROR", "_Pointer", "_SimpleCData", "_c_functype_cache", "_calcsize", "_cast", "_cast_addr", "_check_HRESULT", "_check_size", "_ctypes_version", "_dlopen", "_endian", "_memmove_addr", "_memset_addr", "_os", "_pointer_type_cache", "_string_at", "_string_at_addr", "_sys", "_win_functype_cache", "_wstring_at", "_wstring_at_addr", "addressof", "alignment", "byref", "c_bool", "c_buffer", "c_byte", "c_char", "c_char_p", "c_double", "c_float", "c_int", "c_int16", "c_int32", "c_int64", "c_int8", "c_long", "c_longdouble", "c_longlong", "c_short", "c_size_t", "c_ubyte", "c_uint", "c_uint16", "c_uint32", "c_uint64", "c_uint8", "c_ulong", "c_ulonglong", "c_ushort", "c_void_p", "c_voidp", "c_wchar", "c_wchar_p", "cast", "cdll", "create_string_buffer", "create_unicode_buffer", "get_errno", "get_last_error", "memmove", "memset", "oledll", "pointer", "py_object", "pydll", "pythonapi", "resize", "set_conversion_mode", "set_errno", "set_last_error", "sizeof", "string_at", "windll", "wstring_at"}) {
                this.addAttr(string, this.liburl(string), Builtins.this.unknown());
            }
        }
    }

    class CollectionsModule
    extends NativeModule {
        public CollectionsModule() {
            super("collections");
        }

        private NUrl abcUrl() {
            return this.liburl("abcs-abstract-base-classes");
        }

        private NUrl dequeUrl() {
            return this.liburl("deque-objects");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("Callable", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("__call__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Callable", this.abcUrl(), nClassType);
            NClassType nClassType2 = Builtins.this.newClass("Iterable", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType2.getTable().update("__next__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType2.getTable().update("__iter__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Iterable", this.abcUrl(), nClassType2);
            NClassType nClassType3 = Builtins.this.newClass("Hashable", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType3.getTable().update("__hash__", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Hashable", this.abcUrl(), nClassType3);
            NClassType nClassType4 = Builtins.this.newClass("Sized", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType4.getTable().update("__len__", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Sized", this.abcUrl(), nClassType4);
            NClassType nClassType5 = Builtins.this.newClass("Container", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType5.getTable().update("__contains__", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Container", this.abcUrl(), nClassType5);
            NClassType nClassType6 = Builtins.this.newClass("Iterator", this.table, nClassType2, new NClassType[0]);
            this.addClass("Iterator", this.abcUrl(), nClassType6);
            NClassType nClassType7 = Builtins.this.newClass("Sequence", this.table, nClassType4, nClassType2, nClassType5);
            nClassType7.getTable().update("__getitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType7.getTable().update("reversed", this.abcUrl(), (NType)Builtins.this.newFunc(nClassType7), NBinding.Kind.METHOD);
            nClassType7.getTable().update("index", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            nClassType7.getTable().update("count", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Sequence", this.abcUrl(), nClassType7);
            NClassType nClassType8 = Builtins.this.newClass("MutableSequence", this.table, nClassType7, new NClassType[0]);
            nClassType8.getTable().update("__setitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType8.getTable().update("__delitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableSequence", this.abcUrl(), nClassType8);
            NClassType nClassType9 = Builtins.this.newClass("Set", this.table, nClassType4, nClassType2, nClassType5);
            nClassType9.getTable().update("__getitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Set", this.abcUrl(), nClassType9);
            NClassType nClassType10 = Builtins.this.newClass("MutableSet", this.table, nClassType9, new NClassType[0]);
            nClassType10.getTable().update("add", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType10.getTable().update("discard", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableSet", this.abcUrl(), nClassType10);
            NClassType nClassType11 = Builtins.this.newClass("Mapping", this.table, nClassType4, nClassType2, nClassType5);
            nClassType11.getTable().update("__getitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Mapping", this.abcUrl(), nClassType11);
            NClassType nClassType12 = Builtins.this.newClass("MutableMapping", this.table, nClassType11, new NClassType[0]);
            nClassType12.getTable().update("__setitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType12.getTable().update("__delitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableMapping", this.abcUrl(), nClassType12);
            NClassType nClassType13 = Builtins.this.newClass("MappingView", this.table, nClassType4, new NClassType[0]);
            this.addClass("MappingView", this.abcUrl(), nClassType13);
            NClassType nClassType14 = Builtins.this.newClass("KeysView", this.table, nClassType4, new NClassType[0]);
            this.addClass("KeysView", this.abcUrl(), nClassType14);
            NClassType nClassType15 = Builtins.this.newClass("ItemsView", this.table, nClassType4, new NClassType[0]);
            this.addClass("ItemsView", this.abcUrl(), nClassType15);
            NClassType nClassType16 = Builtins.this.newClass("ValuesView", this.table, nClassType4, new NClassType[0]);
            this.addClass("ValuesView", this.abcUrl(), nClassType16);
            NClassType nClassType17 = Builtins.this.newClass("deque", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : Builtins.this.list("append", "appendLeft", "clear", "extend", "extendLeft", "rotate")) {
                nClassType17.getTable().update(string, this.dequeUrl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            }
            for (String string : Builtins.this.list("__getitem__", "__iter__", "pop", "popleft", "remove")) {
                nClassType17.getTable().update(string, this.dequeUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            }
            this.addClass("deque", this.dequeUrl(), nClassType17);
            NClassType nClassType18 = Builtins.this.newClass("defaultdict", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType18.getTable().update("__missing__", this.liburl("defaultdict-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType18.getTable().update("default_factory", this.liburl("defaultdict-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("defaultdict", this.liburl("defaultdict-objects"), nClassType18);
            String string = "namedtuple-factory-function-for-tuples-with-named-fields";
            NClassType nClassType19 = Builtins.this.newClass("(namedtuple)", this.table, Builtins.this.BaseTuple, new NClassType[0]);
            nClassType19.getTable().update("_fields", this.liburl(string), (NType)new NListType(Builtins.this.BaseStr), NBinding.Kind.ATTRIBUTE);
            this.addFunction("namedtuple", this.liburl(string), nClassType19);
        }
    }

    class CryptModule
    extends NativeModule {
        public CryptModule() {
            super("crypt");
        }

        public void initBindings() {
            this.addStrFuncs("crypt");
        }
    }

    class DatetimeModule
    extends NativeModule {
        public DatetimeModule() {
            super("datetime");
        }

        private NUrl dtUrl(String string) {
            return this.liburl("datetime." + string);
        }

        /*
         * WARNING - void declaration
         */
        public void initBindings() {
            void var9_15;
            String string;
            void var9_13;
            this.addNumAttrs("MINYEAR", "MAXYEAR");
            NClassType nClassType = Builtins.this.Datetime_timedelta = Builtins.this.newClass("timedelta", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("timedelta", this.dtUrl("timedelta"), nClassType);
            Scope scope = Builtins.this.Datetime_timedelta.getTable();
            scope.update("min", this.dtUrl("timedelta"), (NType)nClassType, NBinding.Kind.ATTRIBUTE);
            scope.update("max", this.dtUrl("timedelta"), (NType)nClassType, NBinding.Kind.ATTRIBUTE);
            scope.update("resolution", this.dtUrl("timedelta"), (NType)nClassType, NBinding.Kind.ATTRIBUTE);
            scope.update("days", this.dtUrl("timedelta"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope.update("seconds", this.dtUrl("timedelta"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope.update("microseconds", this.dtUrl("timedelta"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            NClassType nClassType2 = Builtins.this.Datetime_tzinfo = Builtins.this.newClass("tzinfo", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("tzinfo", this.dtUrl("tzinfo"), nClassType2);
            Scope scope2 = Builtins.this.Datetime_tzinfo.getTable();
            scope2.update("utcoffset", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            scope2.update("dst", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            scope2.update("tzname", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            scope2.update("fromutc", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(nClassType2), NBinding.Kind.METHOD);
            NClassType nClassType3 = Builtins.this.Datetime_date = Builtins.this.newClass("date", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("date", this.dtUrl("date"), nClassType3);
            Scope scope3 = Builtins.this.Datetime_date.getTable();
            scope3.update("min", this.dtUrl("date"), (NType)nClassType3, NBinding.Kind.ATTRIBUTE);
            scope3.update("max", this.dtUrl("date"), (NType)nClassType3, NBinding.Kind.ATTRIBUTE);
            scope3.update("resolution", this.dtUrl("date"), (NType)nClassType, NBinding.Kind.ATTRIBUTE);
            scope3.update("today", this.dtUrl("date"), (NType)Builtins.this.newFunc(nClassType3), NBinding.Kind.METHOD);
            scope3.update("fromtimestamp", this.dtUrl("date"), (NType)Builtins.this.newFunc(nClassType3), NBinding.Kind.METHOD);
            scope3.update("fromordinal", this.dtUrl("date"), (NType)Builtins.this.newFunc(nClassType3), NBinding.Kind.METHOD);
            scope3.update("year", this.dtUrl("date"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope3.update("month", this.dtUrl("date"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope3.update("day", this.dtUrl("date"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope3.update("replace", this.dtUrl("date"), (NType)Builtins.this.newFunc(nClassType3), NBinding.Kind.METHOD);
            scope3.update("timetuple", this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.Time_struct_time), NBinding.Kind.METHOD);
            String[] object = Builtins.this.list("toordinal", "weekday", "isoweekday");
            int n = object.length;
            boolean bl = false;
            while (var9_13 < n) {
                string = object[var9_13];
                scope3.update(string, this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
                ++var9_13;
            }
            String[] stringArray = Builtins.this.list("ctime", "strftime", "isoformat");
            n = stringArray.length;
            boolean bl2 = false;
            while (var9_15 < n) {
                string = stringArray[var9_15];
                scope3.update(string, this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
                ++var9_15;
            }
            scope3.update("isocalendar", this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum)), NBinding.Kind.METHOD);
            NClassType nClassType4 = Builtins.this.Datetime_time = Builtins.this.newClass("time", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("time", this.dtUrl("time"), nClassType3);
            Scope scope4 = Builtins.this.Datetime_time.getTable();
            scope4.update("min", this.dtUrl("time"), (NType)nClassType4, NBinding.Kind.ATTRIBUTE);
            scope4.update("max", this.dtUrl("time"), (NType)nClassType4, NBinding.Kind.ATTRIBUTE);
            scope4.update("resolution", this.dtUrl("time"), (NType)nClassType, NBinding.Kind.ATTRIBUTE);
            scope4.update("hour", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope4.update("minute", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope4.update("second", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope4.update("microsecond", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            scope4.update("tzinfo", this.dtUrl("time"), (NType)nClassType2, NBinding.Kind.ATTRIBUTE);
            scope4.update("replace", this.dtUrl("time"), (NType)Builtins.this.newFunc(nClassType4), NBinding.Kind.METHOD);
            for (String string2 : Builtins.this.list("isoformat", "strftime", "tzname")) {
                scope4.update(string2, this.dtUrl("time"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            }
            for (String string2 : Builtins.this.list("utcoffset", "dst")) {
                scope4.update(string2, this.dtUrl("time"), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            }
            NClassType nClassType5 = Builtins.this.Datetime_datetime = Builtins.this.newClass("datetime", this.table, nClassType3, nClassType4);
            this.addClass("datetime", this.dtUrl("datetime"), nClassType5);
            Scope scope5 = Builtins.this.Datetime_datetime.getTable();
            for (String string3 : Builtins.this.list("combine", "fromordinal", "fromtimestamp", "now", "strptime", "today", "utcfromtimestamp", "utcnow")) {
                scope5.update(string3, this.dtUrl("datetime"), (NType)Builtins.this.newFunc(nClassType5), NBinding.Kind.METHOD);
            }
            scope5.update("min", this.dtUrl("datetime"), (NType)nClassType5, NBinding.Kind.ATTRIBUTE);
            scope5.update("max", this.dtUrl("datetime"), (NType)nClassType5, NBinding.Kind.ATTRIBUTE);
            scope5.update("resolution", this.dtUrl("datetime"), (NType)nClassType, NBinding.Kind.ATTRIBUTE);
            scope5.update("date", this.dtUrl("datetime"), (NType)Builtins.this.newFunc(nClassType3), NBinding.Kind.METHOD);
            for (String string3 : Builtins.this.list("time", "timetz")) {
                scope5.update(string3, this.dtUrl("datetime"), (NType)Builtins.this.newFunc(nClassType4), NBinding.Kind.METHOD);
            }
            for (String string3 : Builtins.this.list("replace", "astimezone")) {
                scope5.update(string3, this.dtUrl("datetime"), (NType)Builtins.this.newFunc(nClassType5), NBinding.Kind.METHOD);
            }
            scope5.update("utctimetuple", this.dtUrl("datetime"), (NType)Builtins.this.newFunc(Builtins.this.Time_struct_time), NBinding.Kind.METHOD);
        }
    }

    class DbmModule
    extends NativeModule {
        public DbmModule() {
            super("dbm");
        }

        public void initBindings() {
            NClassType nClassType = new NClassType("dbm", this.table, Builtins.this.BaseDict);
            this.addClass("dbm", this.liburl(), nClassType);
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrAttrs("library");
            this.addFunction("open", this.liburl(), nClassType);
        }
    }

    class ErrnoModule
    extends NativeModule {
        public ErrnoModule() {
            super("errno");
        }

        public void initBindings() {
            this.addNumAttrs("E2BIG", "EACCES", "EADDRINUSE", "EADDRNOTAVAIL", "EAFNOSUPPORT", "EAGAIN", "EALREADY", "EBADF", "EBUSY", "ECHILD", "ECONNABORTED", "ECONNREFUSED", "ECONNRESET", "EDEADLK", "EDEADLOCK", "EDESTADDRREQ", "EDOM", "EDQUOT", "EEXIST", "EFAULT", "EFBIG", "EHOSTDOWN", "EHOSTUNREACH", "EILSEQ", "EINPROGRESS", "EINTR", "EINVAL", "EIO", "EISCONN", "EISDIR", "ELOOP", "EMFILE", "EMLINK", "EMSGSIZE", "ENAMETOOLONG", "ENETDOWN", "ENETRESET", "ENETUNREACH", "ENFILE", "ENOBUFS", "ENODEV", "ENOENT", "ENOEXEC", "ENOLCK", "ENOMEM", "ENOPROTOOPT", "ENOSPC", "ENOSYS", "ENOTCONN", "ENOTDIR", "ENOTEMPTY", "ENOTSOCK", "ENOTTY", "ENXIO", "EOPNOTSUPP", "EPERM", "EPFNOSUPPORT", "EPIPE", "EPROTONOSUPPORT", "EPROTOTYPE", "ERANGE", "EREMOTE", "EROFS", "ESHUTDOWN", "ESOCKTNOSUPPORT", "ESPIPE", "ESRCH", "ESTALE", "ETIMEDOUT", "ETOOMANYREFS", "EUSERS", "EWOULDBLOCK", "EXDEV", "WSABASEERR", "WSAEACCES", "WSAEADDRINUSE", "WSAEADDRNOTAVAIL", "WSAEAFNOSUPPORT", "WSAEALREADY", "WSAEBADF", "WSAECONNABORTED", "WSAECONNREFUSED", "WSAECONNRESET", "WSAEDESTADDRREQ", "WSAEDISCON", "WSAEDQUOT", "WSAEFAULT", "WSAEHOSTDOWN", "WSAEHOSTUNREACH", "WSAEINPROGRESS", "WSAEINTR", "WSAEINVAL", "WSAEISCONN", "WSAELOOP", "WSAEMFILE", "WSAEMSGSIZE", "WSAENAMETOOLONG", "WSAENETDOWN", "WSAENETRESET", "WSAENETUNREACH", "WSAENOBUFS", "WSAENOPROTOOPT", "WSAENOTCONN", "WSAENOTEMPTY", "WSAENOTSOCK", "WSAEOPNOTSUPP", "WSAEPFNOSUPPORT", "WSAEPROCLIM", "WSAEPROTONOSUPPORT", "WSAEPROTOTYPE", "WSAEREMOTE", "WSAESHUTDOWN", "WSAESOCKTNOSUPPORT", "WSAESTALE", "WSAETIMEDOUT", "WSAETOOMANYREFS", "WSAEUSERS", "WSAEWOULDBLOCK", "WSANOTINITIALISED", "WSASYSNOTREADY", "WSAVERNOTSUPPORTED");
            this.addAttr("errorcode", this.liburl("errorcode"), Builtins.this.newDict(Builtins.this.BaseNum, Builtins.this.BaseStr));
        }
    }

    class ExceptionsModule
    extends NativeModule {
        public ExceptionsModule() {
            super("exceptions");
        }

        public void initBindings() {
            NModuleType nModuleType = Builtins.this.get("__builtin__");
            for (String string : Builtins.this.builtin_exception_types) {
                NBinding nBinding = nModuleType.getTable().lookup(string);
                this.table.update(nBinding.getName(), nBinding.getSignatureNode(), nBinding.getType(), nBinding.getKind());
            }
        }
    }

    class FcntlModule
    extends NativeModule {
        public FcntlModule() {
            super("fcntl");
        }

        public void initBindings() {
            for (String string : Builtins.this.list("fcntl", "ioctl")) {
                this.addFunction(string, this.liburl(), Builtins.this.newUnion(Builtins.this.BaseNum, Builtins.this.BaseStr));
            }
            this.addNumFuncs("flock");
            this.addUnknownFuncs("lockf");
            this.addNumAttrs("DN_ACCESS", "DN_ATTRIB", "DN_CREATE", "DN_DELETE", "DN_MODIFY", "DN_MULTISHOT", "DN_RENAME", "FASYNC", "FD_CLOEXEC", "F_DUPFD", "F_EXLCK", "F_GETFD", "F_GETFL", "F_GETLEASE", "F_GETLK", "F_GETLK64", "F_GETOWN", "F_GETSIG", "F_NOTIFY", "F_RDLCK", "F_SETFD", "F_SETFL", "F_SETLEASE", "F_SETLK", "F_SETLK64", "F_SETLKW", "F_SETLKW64", "F_SETOWN", "F_SETSIG", "F_SHLCK", "F_UNLCK", "F_WRLCK", "I_ATMARK", "I_CANPUT", "I_CKBAND", "I_FDINSERT", "I_FIND", "I_FLUSH", "I_FLUSHBAND", "I_GETBAND", "I_GETCLTIME", "I_GETSIG", "I_GRDOPT", "I_GWROPT", "I_LINK", "I_LIST", "I_LOOK", "I_NREAD", "I_PEEK", "I_PLINK", "I_POP", "I_PUNLINK", "I_PUSH", "I_RECVFD", "I_SENDFD", "I_SETCLTIME", "I_SETSIG", "I_SRDOPT", "I_STR", "I_SWROPT", "I_UNLINK", "LOCK_EX", "LOCK_MAND", "LOCK_NB", "LOCK_READ", "LOCK_RW", "LOCK_SH", "LOCK_UN", "LOCK_WRITE");
        }
    }

    class FpectlModule
    extends NativeModule {
        public FpectlModule() {
            super("fpectl");
        }

        public void initBindings() {
            this.addNoneFuncs("turnon_sigfpe", "turnoff_sigfpe");
            this.addClass("FloatingPointError", this.liburl(), Builtins.this.newException("FloatingPointError", this.table));
        }
    }

    class GcModule
    extends NativeModule {
        public GcModule() {
            super("gc");
        }

        public void initBindings() {
            this.addNoneFuncs("enable", "disable", "set_debug", "set_threshold");
            this.addNumFuncs("isenabled", "collect", "get_debug", "get_count", "get_threshold");
            for (String string : Builtins.this.list("get_objects", "get_referrers", "get_referents")) {
                this.addFunction(string, this.liburl(), Builtins.this.newList());
            }
            this.addAttr("garbage", this.liburl(), Builtins.this.newList());
            this.addNumAttrs("DEBUG_STATS", "DEBUG_COLLECTABLE", "DEBUG_UNCOLLECTABLE", "DEBUG_INSTANCES", "DEBUG_OBJECTS", "DEBUG_SAVEALL", "DEBUG_LEAK");
        }
    }

    class GdbmModule
    extends NativeModule {
        public GdbmModule() {
            super("gdbm");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            NClassType nClassType = new NClassType("gdbm", this.table, Builtins.this.BaseDict);
            nClassType.getTable().update("firstkey", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType.getTable().update("nextkey", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType.getTable().update("reorganize", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            nClassType.getTable().update("sync", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            this.addFunction("open", this.liburl(), nClassType);
        }
    }

    class GrpModule
    extends NativeModule {
        public GrpModule() {
            super("grp");
        }

        public void initBindings() {
            Builtins.this.get("struct");
            NClassType nClassType = Builtins.this.newClass("struct_group", this.table, Builtins.this.BaseStruct, new NClassType[0]);
            nClassType.getTable().update("gr_name", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            nClassType.getTable().update("gr_passwd", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            nClassType.getTable().update("gr_gid", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            nClassType.getTable().update("gr_mem", this.liburl(), (NType)Builtins.this.newList(Builtins.this.BaseStr), NBinding.Kind.ATTRIBUTE);
            this.addClass("struct_group", this.liburl(), nClassType);
            for (String string : Builtins.this.list("getgrgid", "getgrnam")) {
                this.addFunction(string, this.liburl(), nClassType);
            }
            this.addFunction("getgrall", this.liburl(), new NListType(nClassType));
        }
    }

    class ImpModule
    extends NativeModule {
        public ImpModule() {
            super("imp");
        }

        public void initBindings() {
            this.addStrFuncs("get_magic");
            this.addFunction("get_suffixes", this.liburl(), Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseNum)));
            this.addFunction("find_module", this.liburl(), Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseNum));
            String[] stringArray = new String[]{"load_module", "new_module", "init_builtin", "init_frozen", "load_compiled", "load_dynamic", "load_source"};
            for (String string : stringArray) {
                this.addFunction(string, this.liburl(), Builtins.this.newModule("<?>"));
            }
            this.addUnknownFuncs("acquire_lock", "release_lock");
            this.addNumAttrs("PY_SOURCE", "PY_COMPILED", "C_EXTENSION", "PKG_DIRECTORY", "C_BUILTIN", "PY_FROZEN", "SEARCH_ERROR");
            this.addNumFuncs("lock_held", "is_builtin", "is_frozen");
            NClassType nClassType = Builtins.this.newClass("NullImporter", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("find_module", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.FUNCTION);
            this.addClass("NullImporter", this.liburl(), nClassType);
        }
    }

    class ItertoolsModule
    extends NativeModule {
        public ItertoolsModule() {
            super("itertools");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("iterator", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("from_iterable", this.liburl("itertool-functions"), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            nClassType.getTable().update("next", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            for (String string : Builtins.this.list("chain", "combinations", "count", "cycle", "dropwhile", "groupby", "ifilter", "ifilterfalse", "imap", "islice", "izip", "izip_longest", "permutations", "product", "repeat", "starmap", "takewhile", "tee")) {
                this.addClass(string, this.liburl("itertool-functions"), nClassType);
            }
        }
    }

    class MarshalModule
    extends NativeModule {
        public MarshalModule() {
            super("marshal");
        }

        public void initBindings() {
            this.addNumAttrs("version");
            this.addStrFuncs("dumps");
            this.addUnknownFuncs("dump", "load", "loads");
        }
    }

    class MathModule
    extends NativeModule {
        public MathModule() {
            super("math");
        }

        public void initBindings() {
            this.addNumFuncs("acos", "acosh", "asin", "asinh", "atan", "atan2", "atanh", "ceil", "copysign", "cos", "cosh", "degrees", "exp", "fabs", "factorial", "floor", "fmod", "frexp", "fsum", "hypot", "isinf", "isnan", "ldexp", "log", "log10", "log1p", "modf", "pow", "radians", "sin", "sinh", "sqrt", "tan", "tanh", "trunc");
            this.addNumAttrs("pi", "e");
        }
    }

    class Md5Module
    extends NativeModule {
        public Md5Module() {
            super("md5");
        }

        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            NClassType nClassType = Builtins.this.newClass("md5", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("update", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType.getTable().update("digest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType.getTable().update("hexdigest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType.getTable().update("copy", this.liburl(), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            this.update("new", this.liburl(), Builtins.this.newFunc(nClassType), NBinding.Kind.CONSTRUCTOR);
            this.update("md5", this.liburl(), Builtins.this.newFunc(nClassType), NBinding.Kind.CONSTRUCTOR);
        }
    }

    class MmapModule
    extends NativeModule {
        public MmapModule() {
            super("mmap");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("mmap", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : Builtins.this.list("ACCESS_COPY", "ACCESS_READ", "ACCESS_WRITE", "ALLOCATIONGRANULARITY", "MAP_ANON", "MAP_ANONYMOUS", "MAP_DENYWRITE", "MAP_EXECUTABLE", "MAP_PRIVATE", "MAP_SHARED", "PAGESIZE", "PROT_EXEC", "PROT_READ", "PROT_WRITE")) {
                nClassType.getTable().update(string, this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            for (String string : Builtins.this.list("read", "read_byte", "readline")) {
                nClassType.getTable().update(string, this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            }
            for (String string : Builtins.this.list("find", "rfind", "tell")) {
                nClassType.getTable().update(string, this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            }
            for (String string : Builtins.this.list("close", "flush", "move", "resize", "seek", "write", "write_byte")) {
                nClassType.getTable().update(string, this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            }
            this.addClass("mmap", this.liburl(), nClassType);
        }
    }

    private abstract class NativeModule {
        protected String name;
        protected NModuleType module;
        protected Scope table;

        NativeModule(String string) {
            this.name = string;
            Builtins.this.modules.put(string, this);
        }

        NModuleType getModule() {
            if (this.module == null) {
                this.createModuleType();
                this.initBindings();
            }
            return this.module;
        }

        protected abstract void initBindings();

        protected void createModuleType() {
            if (this.module == null) {
                this.module = Builtins.this.newModule(this.name);
                this.table = this.module.getTable();
                Builtins.this.moduleTable.put(this.name, this.liburl(), this.module, NBinding.Kind.MODULE);
            }
        }

        protected NBinding update(String string, NUrl nUrl, NType nType, NBinding.Kind kind) {
            return this.table.update(string, nUrl, nType, kind);
        }

        protected NBinding addClass(String string, NUrl nUrl, NType nType) {
            return this.table.update(string, nUrl, nType, NBinding.Kind.CLASS);
        }

        protected NBinding addMethod(String string, NUrl nUrl, NType nType) {
            return this.table.update(string, nUrl, nType, NBinding.Kind.METHOD);
        }

        protected NBinding addFunction(String string, NUrl nUrl, NType nType) {
            return this.table.update(string, nUrl, (NType)Builtins.this.newFunc(nType), NBinding.Kind.FUNCTION);
        }

        protected void addFunctions_beCareful(NType nType, String ... stringArray) {
            for (String string : stringArray) {
                this.addFunction(string, this.liburl(), nType);
            }
        }

        protected void addNoneFuncs(String ... stringArray) {
            this.addFunctions_beCareful(Builtins.this.None, stringArray);
        }

        protected void addNumFuncs(String ... stringArray) {
            this.addFunctions_beCareful(Builtins.this.BaseNum, stringArray);
        }

        protected void addStrFuncs(String ... stringArray) {
            this.addFunctions_beCareful(Builtins.this.BaseStr, stringArray);
        }

        protected void addUnknownFuncs(String ... stringArray) {
            for (String string : stringArray) {
                this.addFunction(string, this.liburl(), Builtins.this.unknown());
            }
        }

        protected NBinding addAttr(String string, NUrl nUrl, NType nType) {
            return this.table.update(string, nUrl, nType, NBinding.Kind.ATTRIBUTE);
        }

        protected void addAttributes_beCareful(NType nType, String ... stringArray) {
            for (String string : stringArray) {
                this.addAttr(string, this.liburl(), nType);
            }
        }

        protected void addNumAttrs(String ... stringArray) {
            this.addAttributes_beCareful(Builtins.this.BaseNum, stringArray);
        }

        protected void addStrAttrs(String ... stringArray) {
            this.addAttributes_beCareful(Builtins.this.BaseStr, stringArray);
        }

        protected void addUnknownAttrs(String ... stringArray) {
            for (String string : stringArray) {
                this.addAttr(string, this.liburl(), Builtins.this.unknown());
            }
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl(this.name);
        }

        protected NUrl liburl(String string) {
            return Builtins.newLibUrl(this.name, string);
        }

        public String toString() {
            return this.module == null ? "<Non-loaded builtin module '" + this.name + "'>" : "<NativeModule:" + this.module + ">";
        }
    }

    class NisModule
    extends NativeModule {
        public NisModule() {
            super("nis");
        }

        public void initBindings() {
            this.addStrFuncs("match", "cat", "get_default_domain");
            this.addFunction("maps", this.liburl(), Builtins.this.newList(Builtins.this.BaseStr));
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
        }
    }

    class OperatorModule
    extends NativeModule {
        public OperatorModule() {
            super("operator");
        }

        public void initBindings() {
            this.addNumFuncs("__abs__", "__add__", "__and__", "__concat__", "__contains__", "__div__", "__doc__", "__eq__", "__floordiv__", "__ge__", "__getitem__", "__getslice__", "__gt__", "__iadd__", "__iand__", "__iconcat__", "__idiv__", "__ifloordiv__", "__ilshift__", "__imod__", "__imul__", "__index__", "__inv__", "__invert__", "__ior__", "__ipow__", "__irepeat__", "__irshift__", "__isub__", "__itruediv__", "__ixor__", "__le__", "__lshift__", "__lt__", "__mod__", "__mul__", "__name__", "__ne__", "__neg__", "__not__", "__or__", "__package__", "__pos__", "__pow__", "__repeat__", "__rshift__", "__setitem__", "__setslice__", "__sub__", "__truediv__", "__xor__", "abs", "add", "and_", "concat", "contains", "countOf", "div", "eq", "floordiv", "ge", "getitem", "getslice", "gt", "iadd", "iand", "iconcat", "idiv", "ifloordiv", "ilshift", "imod", "imul", "index", "indexOf", "inv", "invert", "ior", "ipow", "irepeat", "irshift", "isCallable", "isMappingType", "isNumberType", "isSequenceType", "is_", "is_not", "isub", "itruediv", "ixor", "le", "lshift", "lt", "mod", "mul", "ne", "neg", "not_", "or_", "pos", "pow", "repeat", "rshift", "sequenceIncludes", "setitem", "setslice", "sub", "truediv", "truth", "xor");
            this.addUnknownFuncs("attrgetter", "itemgetter", "methodcaller");
            this.addNoneFuncs("__delitem__", "__delslice__", "delitem", "delclice");
        }
    }

    class OsModule
    extends NativeModule {
        public OsModule() {
            super("os");
        }

        public void initBindings() {
            this.addAttr("name", this.liburl(), Builtins.this.BaseStr);
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.initProcBindings();
            this.initProcMgmtBindings();
            this.initFileBindings();
            this.initFileAndDirBindings();
            this.initMiscSystemInfo();
            this.initOsPathModule();
            this.addAttr("errno", this.liburl(), Builtins.this.newModule("errno"));
            this.addFunction("urandom", this.liburl("miscellaneous-functions"), Builtins.this.BaseStr);
            this.addAttr("NGROUPS_MAX", this.liburl(), Builtins.this.BaseNum);
            for (String string : Builtins.this.list("_Environ", "_copy_reg", "_execvpe", "_exists", "_get_exports_list", "_make_stat_result", "_make_statvfs_result", "_pickle_stat_result", "_pickle_statvfs_result", "_spawnvef")) {
                this.addFunction(string, this.liburl(), Builtins.this.unknown());
            }
        }

        private void initProcBindings() {
            String string = "process-parameters";
            this.addAttr("environ", this.liburl(string), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseStr));
            for (String string2 : Builtins.this.list("chdir", "fchdir", "putenv", "setegid", "seteuid", "setgid", "setgroups", "setpgrp", "setpgid", "setreuid", "setregid", "setuid", "unsetenv")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.None);
            }
            for (String string2 : Builtins.this.list("getegid", "getgid", "getpgid", "getpgrp", "getppid", "getuid", "getsid", "umask")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            for (String string2 : Builtins.this.list("getcwd", "ctermid", "getlogin", "getenv", "strerror")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseStr);
            }
            this.addFunction("getgroups", this.liburl(string), Builtins.this.newList(Builtins.this.BaseStr));
            this.addFunction("uname", this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr));
        }

        private void initProcMgmtBindings() {
            String string = "process-management";
            for (String string2 : Builtins.this.list("EX_CANTCREAT", "EX_CONFIG", "EX_DATAERR", "EX_IOERR", "EX_NOHOST", "EX_NOINPUT", "EX_NOPERM", "EX_NOUSER", "EX_OK", "EX_OSERR", "EX_OSFILE", "EX_PROTOCOL", "EX_SOFTWARE", "EX_TEMPFAIL", "EX_UNAVAILABLE", "EX_USAGE", "P_NOWAIT", "P_NOWAITO", "P_WAIT", "P_DETACH", "P_OVERLAY", "WCONTINUED", "WCOREDUMP", "WEXITSTATUS", "WIFCONTINUED", "WIFEXITED", "WIFSIGNALED", "WIFSTOPPED", "WNOHANG", "WSTOPSIG", "WTERMSIG", "WUNTRACED")) {
                this.addAttr(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            for (String string2 : Builtins.this.list("abort", "execl", "execle", "execlp", "execlpe", "execv", "execve", "execvp", "execvpe", "_exit", "kill", "killpg", "plock", "startfile")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.None);
            }
            for (String string2 : Builtins.this.list("nice", "spawnl", "spawnle", "spawnlp", "spawnlpe", "spawnv", "spawnve", "spawnvp", "spawnvpe", "system")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            this.addFunction("fork", this.liburl(string), Builtins.this.newUnion(Builtins.this.BaseFile, Builtins.this.BaseNum));
            this.addFunction("times", this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum));
            for (String string2 : Builtins.this.list("forkpty", "wait", "waitpid")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            }
            for (String string2 : Builtins.this.list("wait3", "wait4")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum));
            }
        }

        private void initFileBindings() {
            String string = "file-object-creation";
            for (String string2 : Builtins.this.list("fdopen", "popen", "tmpfile")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseFile);
            }
            this.addFunction("popen2", this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseFile, Builtins.this.BaseFile));
            this.addFunction("popen3", this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseFile, Builtins.this.BaseFile, Builtins.this.BaseFile));
            this.addFunction("popen4", this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseFile, Builtins.this.BaseFile));
            string = "file-descriptor-operations";
            this.addFunction("open", this.liburl(string), Builtins.this.BaseFile);
            for (String string2 : Builtins.this.list("close", "closerange", "dup2", "fchmod", "fchown", "fdatasync", "fsync", "ftruncate", "lseek", "tcsetpgrp", "write")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.None);
            }
            for (String string2 : Builtins.this.list("dup2", "fpathconf", "fstat", "fstatvfs", "isatty", "tcgetpgrp")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            for (String string2 : Builtins.this.list("read", "ttyname")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseStr);
            }
            for (String string2 : Builtins.this.list("openpty", "pipe", "fstat", "fstatvfs", "isatty")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            }
            for (String string2 : Builtins.this.list("O_APPEND", "O_CREAT", "O_DIRECT", "O_DIRECTORY", "O_DSYNC", "O_EXCL", "O_LARGEFILE", "O_NDELAY", "O_NOCTTY", "O_NOFOLLOW", "O_NONBLOCK", "O_RDONLY", "O_RDWR", "O_RSYNC", "O_SYNC", "O_TRUNC", "O_WRONLY", "SEEK_CUR", "SEEK_END", "SEEK_SET")) {
                this.addAttr(string2, this.liburl(string), Builtins.this.BaseNum);
            }
        }

        private void initFileAndDirBindings() {
            String string = "files-and-directories";
            for (String string2 : Builtins.this.list("F_OK", "R_OK", "W_OK", "X_OK")) {
                this.addAttr(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            for (String string2 : Builtins.this.list("chflags", "chroot", "chmod", "chown", "lchflags", "lchmod", "lchown", "link", "mknod", "mkdir", "mkdirs", "remove", "removedirs", "rename", "renames", "rmdir", "symlink", "unlink", "utime")) {
                this.addAttr(string2, this.liburl(string), Builtins.this.None);
            }
            for (String string2 : Builtins.this.list("access", "lstat", "major", "minor", "makedev", "pathconf", "stat_float_times")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            for (String string2 : Builtins.this.list("getcwdu", "readlink", "tempnam", "tmpnam")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseStr);
            }
            for (String string2 : Builtins.this.list("listdir")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.newList(Builtins.this.BaseStr));
            }
            this.addFunction("mkfifo", this.liburl(string), Builtins.this.BaseFile);
            this.addFunction("stat", this.liburl(string), Builtins.this.newList(Builtins.this.BaseNum));
            this.addFunction("statvfs", this.liburl(string), Builtins.this.newList(Builtins.this.BaseNum));
            this.addAttr("pathconf_names", this.liburl(string), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            this.addAttr("TMP_MAX", this.liburl(string), Builtins.this.BaseNum);
            this.addFunction("walk", this.liburl(string), Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr)));
        }

        private void initMiscSystemInfo() {
            String string = "miscellaneous-system-information";
            this.addAttr("confstr_names", this.liburl(string), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            this.addAttr("sysconf_names", this.liburl(string), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            for (String string2 : Builtins.this.list("curdir", "pardir", "sep", "altsep", "extsep", "pathsep", "defpath", "linesep", "devnull")) {
                this.addAttr(string2, this.liburl(string), Builtins.this.BaseStr);
            }
            for (String string2 : Builtins.this.list("getloadavg", "sysconf")) {
                this.addFunction(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            this.addFunction("confstr", this.liburl(string), Builtins.this.BaseStr);
        }

        private void initOsPathModule() {
            String[] stringArray;
            String[] stringArray2;
            NModuleType nModuleType = Builtins.this.newModule("path");
            Scope scope = nModuleType.getTable();
            scope.setPath("os.path");
            this.update("path", Builtins.newLibUrl("os.path.html#module-os.path"), nModuleType, NBinding.Kind.MODULE);
            for (String string : stringArray2 = new String[]{"_resolve_link", "abspath", "basename", "commonprefix", "dirname", "expanduser", "expandvars", "join", "normcase", "normpath", "realpath", "relpath"}) {
                scope.update(string, Builtins.newLibUrl("os.path", string), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.FUNCTION);
            }
            String[] stringArray3 = new String[]{"exists", "lexists", "getatime", "getctime", "getmtime", "getsize", "isabs", "isdir", "isfile", "islink", "ismount", "samefile", "sameopenfile", "samestat", "supports_unicode_filenames"};
            for (String string : stringArray3) {
                scope.update(string, Builtins.newLibUrl("os.path", string), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.FUNCTION);
            }
            for (String string : Builtins.this.list("split", "splitdrive", "splitext", "splitunc")) {
                scope.update(string, Builtins.newLibUrl("os.path", string), (NType)Builtins.this.newFunc(Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr)), NBinding.Kind.FUNCTION);
            }
            NBinding nBinding = scope.update("walk", Builtins.newLibUrl("os.path"), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.FUNCTION);
            nBinding.markDeprecated();
            for (String string : stringArray = new String[]{"altsep", "curdir", "devnull", "defpath", "pardir", "pathsep", "sep"}) {
                scope.update(string, Builtins.newLibUrl("os.path", string), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            }
            scope.update("os", this.liburl(), (NType)this.module, NBinding.Kind.ATTRIBUTE);
            scope.update("stat", Builtins.newLibUrl("stat"), (NType)Builtins.this.newModule("<stat-fixme>"), NBinding.Kind.ATTRIBUTE);
            scope.update("_varprog", Builtins.newLibUrl("os.path"), (NType)Builtins.this.unknown(), NBinding.Kind.ATTRIBUTE);
        }
    }

    class ParserModule
    extends NativeModule {
        public ParserModule() {
            super("parser");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("st", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("compile", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType.getTable().update("isexpr", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            nClassType.getTable().update("issuite", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            nClassType.getTable().update("tolist", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.newList()), NBinding.Kind.METHOD);
            nClassType.getTable().update("totuple", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(new NType[0])), NBinding.Kind.METHOD);
            this.addAttr("STType", this.liburl("st-objects"), Builtins.this.Type);
            for (String string : Builtins.this.list("expr", "suite", "sequence2st", "tuple2st")) {
                this.addFunction(string, this.liburl("creating-st-objects"), nClassType);
            }
            this.addFunction("st2list", this.liburl("converting-st-objects"), Builtins.this.newList());
            this.addFunction("st2tuple", this.liburl("converting-st-objects"), Builtins.this.newTuple(new NType[0]));
            this.addFunction("compilest", this.liburl("converting-st-objects"), Builtins.this.unknown());
            this.addFunction("isexpr", this.liburl("queries-on-st-objects"), Builtins.this.BaseBool);
            this.addFunction("issuite", this.liburl("queries-on-st-objects"), Builtins.this.BaseBool);
            this.addClass("ParserError", this.liburl("exceptions-and-error-handling"), Builtins.this.newException("ParserError", this.table));
        }
    }

    class PosixModule
    extends NativeModule {
        public PosixModule() {
            super("posix");
        }

        public void initBindings() {
            this.addAttr("environ", this.liburl(), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseStr));
        }
    }

    class PwdModule
    extends NativeModule {
        public PwdModule() {
            super("pwd");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("struct_pwd", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : Builtins.this.list("pw_nam", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell")) {
                nClassType.getTable().update(string, this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_pwd", this.liburl(), nClassType);
            this.addFunction("getpwuid", this.liburl(), nClassType);
            this.addFunction("getpwnam", this.liburl(), nClassType);
            this.addFunction("getpwall", this.liburl(), Builtins.this.newList(nClassType));
        }
    }

    class PyexpatModule
    extends NativeModule {
        public PyexpatModule() {
            super("pyexpat");
        }

        public void initBindings() {
        }
    }

    class ReadlineModule
    extends NativeModule {
        public ReadlineModule() {
            super("readline");
        }

        public void initBindings() {
            this.addNoneFuncs("parse_and_bind", "insert_text", "read_init_file", "read_history_file", "write_history_file", "clear_history", "set_history_length", "remove_history_item", "replace_history_item", "redisplay", "set_startup_hook", "set_pre_input_hook", "set_completer", "set_completer_delims", "set_completion_display_matches_hook", "add_history");
            this.addNumFuncs("get_history_length", "get_current_history_length", "get_begidx", "get_endidx");
            this.addStrFuncs("get_line_buffer", "get_history_item");
            this.addUnknownFuncs("get_completion_type");
            this.addFunction("get_completer", this.liburl(), Builtins.this.newFunc());
            this.addFunction("get_completer_delims", this.liburl(), Builtins.this.newList(Builtins.this.BaseStr));
        }
    }

    class ResourceModule
    extends NativeModule {
        public ResourceModule() {
            super("resource");
        }

        public void initBindings() {
            String[] stringArray;
            this.addFunction("getrlimit", this.liburl(), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            this.addFunction("getrlimit", this.liburl(), Builtins.this.unknown());
            String[] stringArray2 = new String[]{"RLIMIT_CORE", "RLIMIT_CPU", "RLIMIT_FSIZE", "RLIMIT_DATA", "RLIMIT_STACK", "RLIMIT_RSS", "RLIMIT_NPROC", "RLIMIT_NOFILE", "RLIMIT_OFILE", "RLIMIT_MEMLOCK", "RLIMIT_VMEM", "RLIMIT_AS"};
            for (String string : stringArray2) {
                this.addAttr(string, this.liburl("resource-limits"), Builtins.this.BaseNum);
            }
            NClassType nClassType = Builtins.this.newClass("struct_rusage", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : stringArray = new String[]{"ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss", "ru_idrss", "ru_isrss", "ru_minflt", "ru_majflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd", "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw"}) {
                nClassType.getTable().update(string, this.liburl("resource-usage"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addFunction("getrusage", this.liburl("resource-usage"), nClassType);
            this.addFunction("getpagesize", this.liburl("resource-usage"), Builtins.this.BaseNum);
            for (String string : Builtins.this.list("RUSAGE_SELF", "RUSAGE_CHILDREN", "RUSAGE_BOTH")) {
                this.addAttr(string, this.liburl("resource-usage"), Builtins.this.BaseNum);
            }
        }
    }

    class SelectModule
    extends NativeModule {
        public SelectModule() {
            super("select");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addFunction("select", this.liburl(), Builtins.this.newTuple(Builtins.this.newList(), Builtins.this.newList(), Builtins.this.newList()));
            String string = "edge-and-level-trigger-polling-epoll-objects";
            NClassType nClassType = Builtins.this.newClass("epoll", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("close", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            nClassType.getTable().update("fileno", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            nClassType.getTable().update("fromfd", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            for (String string2 : Builtins.this.list("register", "modify", "unregister", "poll")) {
                nClassType.getTable().update(string2, Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            }
            this.addClass("epoll", this.liburl(string), nClassType);
            for (String string2 : Builtins.this.list("EPOLLERR", "EPOLLET", "EPOLLHUP", "EPOLLIN", "EPOLLMSG", "EPOLLONESHOT", "EPOLLOUT", "EPOLLPRI", "EPOLLRDBAND", "EPOLLRDNORM", "EPOLLWRBAND", "EPOLLWRNORM")) {
                this.addAttr(string2, this.liburl(string), Builtins.this.BaseNum);
            }
            string = "polling-objects";
            NClassType nClassType2 = Builtins.this.newClass("poll", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType2.getTable().update("register", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType2.getTable().update("modify", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType2.getTable().update("unregister", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType2.getTable().update("poll", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum))), NBinding.Kind.METHOD);
            this.addClass("poll", this.liburl(string), nClassType2);
            for (String string3 : Builtins.this.list("POLLERR", "POLLHUP", "POLLIN", "POLLMSG", "POLLNVAL", "POLLOUT", "POLLPRI", "POLLRDBAND", "POLLRDNORM", "POLLWRBAND", "POLLWRNORM")) {
                this.addAttr(string3, this.liburl(string), Builtins.this.BaseNum);
            }
            string = "kqueue-objects";
            NClassType nClassType3 = Builtins.this.newClass("kqueue", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType3.getTable().update("close", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            nClassType3.getTable().update("fileno", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            nClassType3.getTable().update("fromfd", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(nClassType3), NBinding.Kind.METHOD);
            nClassType3.getTable().update("control", Builtins.newLibUrl("select", string), (NType)Builtins.this.newFunc(Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum))), NBinding.Kind.METHOD);
            this.addClass("kqueue", this.liburl(string), nClassType3);
            string = "kevent-objects";
            NClassType nClassType4 = Builtins.this.newClass("kevent", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string4 : Builtins.this.list("ident", "filter", "flags", "fflags", "data", "udata")) {
                nClassType4.getTable().update(string4, Builtins.newLibUrl("select", string), (NType)Builtins.this.unknown(), NBinding.Kind.ATTRIBUTE);
            }
            this.addClass("kevent", this.liburl(string), nClassType4);
        }
    }

    class ShaModule
    extends NativeModule {
        public ShaModule() {
            super("sha");
        }

        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            NClassType nClassType = Builtins.this.newClass("sha", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("update", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            nClassType.getTable().update("digest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType.getTable().update("hexdigest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            nClassType.getTable().update("copy", this.liburl(), (NType)Builtins.this.newFunc(nClassType), NBinding.Kind.METHOD);
            this.addClass("sha", this.liburl(), nClassType);
            this.update("new", this.liburl(), Builtins.this.newFunc(nClassType), NBinding.Kind.CONSTRUCTOR);
        }
    }

    class SignalModule
    extends NativeModule {
        public SignalModule() {
            super("signal");
        }

        public void initBindings() {
            this.addNumAttrs("NSIG", "SIGABRT", "SIGALRM", "SIGBUS", "SIGCHLD", "SIGCLD", "SIGCONT", "SIGFPE", "SIGHUP", "SIGILL", "SIGINT", "SIGIO", "SIGIOT", "SIGKILL", "SIGPIPE", "SIGPOLL", "SIGPROF", "SIGPWR", "SIGQUIT", "SIGRTMAX", "SIGRTMIN", "SIGSEGV", "SIGSTOP", "SIGSYS", "SIGTERM", "SIGTRAP", "SIGTSTP", "SIGTTIN", "SIGTTOU", "SIGURG", "SIGUSR1", "SIGUSR2", "SIGVTALRM", "SIGWINCH", "SIGXCPU", "SIGXFSZ", "SIG_DFL", "SIG_IGN");
            this.addUnknownFuncs("default_int_handler", "getsignal", "set_wakeup_fd", "signal");
        }
    }

    class SpwdModule
    extends NativeModule {
        public SpwdModule() {
            super("spwd");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("struct_spwd", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : Builtins.this.list("sp_nam", "sp_pwd", "sp_lstchg", "sp_min", "sp_max", "sp_warn", "sp_inact", "sp_expire", "sp_flag")) {
                nClassType.getTable().update(string, this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_spwd", this.liburl(), nClassType);
            this.addFunction("getspnam", this.liburl(), nClassType);
            this.addFunction("getspall", this.liburl(), Builtins.this.newList(nClassType));
        }
    }

    class StropModule
    extends NativeModule {
        public StropModule() {
            super("strop");
        }

        public void initBindings() {
            this.table.merge(Builtins.this.BaseStr.getTable());
        }
    }

    class StructModule
    extends NativeModule {
        public StructModule() {
            super("struct");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrFuncs("pack");
            this.addUnknownFuncs("pack_into");
            this.addNumFuncs("calcsize");
            this.addFunction("unpack", this.liburl(), Builtins.this.newTuple(new NType[0]));
            this.addFunction("unpack_from", this.liburl(), Builtins.this.newTuple(new NType[0]));
            Builtins.this.BaseStruct = Builtins.this.newClass("Struct", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("Struct", this.liburl("struct-objects"), Builtins.this.BaseStruct);
            Scope scope = Builtins.this.BaseStruct.getTable();
            scope.update("pack", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            scope.update("pack_into", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            scope.update("unpack", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(new NType[0])), NBinding.Kind.METHOD);
            scope.update("unpack_from", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(new NType[0])), NBinding.Kind.METHOD);
            scope.update("format", this.liburl("struct-objects"), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            scope.update("size", this.liburl("struct-objects"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
        }
    }

    class SysModule
    extends NativeModule {
        public SysModule() {
            super("sys");
        }

        public void initBindings() {
            this.addUnknownFuncs("_clear_type_cache", "call_tracing", "callstats", "_current_frames", "_getframe", "displayhook", "dont_write_bytecode", "exitfunc", "exc_clear", "exc_info", "excepthook", "exit", "last_traceback", "last_type", "last_value", "modules", "path_hooks", "path_importer_cache", "getprofile", "gettrace", "setcheckinterval", "setprofile", "setrecursionlimit", "settrace");
            this.addAttr("exc_type", this.liburl(), Builtins.this.None);
            this.addUnknownAttrs("__stderr__", "__stdin__", "__stdout__", "stderr", "stdin", "stdout", "version_info");
            this.addNumAttrs("api_version", "hexversion", "winver", "maxint", "maxsize", "maxunicode", "py3kwarning", "dllhandle");
            this.addStrAttrs("platform", "byteorder", "copyright", "prefix", "version", "exec_prefix", "executable");
            this.addNumFuncs("getrecursionlimit", "getwindowsversion", "getrefcount", "getsizeof", "getcheckinterval");
            this.addStrFuncs("getdefaultencoding", "getfilesystemencoding");
            for (String string : Builtins.this.list("argv", "builtin_module_names", "path", "meta_path", "subversion")) {
                this.addAttr(string, this.liburl(), Builtins.this.newList(Builtins.this.BaseStr));
            }
            for (String string : Builtins.this.list("flags", "warnoptions", "float_info")) {
                this.addAttr(string, this.liburl(), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            }
        }
    }

    class SyslogModule
    extends NativeModule {
        public SyslogModule() {
            super("syslog");
        }

        public void initBindings() {
            this.addNoneFuncs("syslog", "openlog", "closelog", "setlogmask");
            this.addNumAttrs("LOG_ALERT", "LOG_AUTH", "LOG_CONS", "LOG_CRIT", "LOG_CRON", "LOG_DAEMON", "LOG_DEBUG", "LOG_EMERG", "LOG_ERR", "LOG_INFO", "LOG_KERN", "LOG_LOCAL0", "LOG_LOCAL1", "LOG_LOCAL2", "LOG_LOCAL3", "LOG_LOCAL4", "LOG_LOCAL5", "LOG_LOCAL6", "LOG_LOCAL7", "LOG_LPR", "LOG_MAIL", "LOG_MASK", "LOG_NDELAY", "LOG_NEWS", "LOG_NOTICE", "LOG_NOWAIT", "LOG_PERROR", "LOG_PID", "LOG_SYSLOG", "LOG_UPTO", "LOG_USER", "LOG_UUCP", "LOG_WARNING");
        }
    }

    class TermiosModule
    extends NativeModule {
        public TermiosModule() {
            super("termios");
        }

        public void initBindings() {
            this.addFunction("tcgetattr", this.liburl(), Builtins.this.newList());
            this.addUnknownFuncs("tcsetattr", "tcsendbreak", "tcdrain", "tcflush", "tcflow");
        }
    }

    class ThreadModule
    extends NativeModule {
        public ThreadModule() {
            super("thread");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            NClassType nClassType = Builtins.this.newClass("lock", this.table, Builtins.this.Object, new NClassType[0]);
            nClassType.getTable().update("acquire", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.METHOD);
            nClassType.getTable().update("locked", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.METHOD);
            nClassType.getTable().update("release", this.liburl(), (NType)Builtins.this.None, NBinding.Kind.METHOD);
            this.addAttr("LockType", this.liburl(), Builtins.this.Type);
            this.addNoneFuncs("interrupt_main", "exit", "exit_thread");
            this.addNumFuncs("start_new", "start_new_thread", "get_ident", "stack_size");
            this.addFunction("allocate", this.liburl(), nClassType);
            this.addFunction("allocate_lock", this.liburl(), nClassType);
            this.addAttr("_local", this.liburl(), Builtins.this.Type);
        }
    }

    class TimeModule
    extends NativeModule {
        public TimeModule() {
            super("time");
        }

        public void initBindings() {
            String[] stringArray;
            NClassType nClassType = Builtins.this.Time_struct_time = Builtins.this.newClass("datetime", this.table, Builtins.this.Object, new NClassType[0]);
            this.addAttr("struct_time", this.liburl(), nClassType);
            for (String string : stringArray = new String[]{"n_fields", "n_sequence_fields", "n_unnamed_fields", "tm_hour", "tm_isdst", "tm_mday", "tm_min", "tm_mon", "tm_wday", "tm_yday", "tm_year"}) {
                nClassType.getTable().update(string, this.liburl("struct_time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addNumAttrs("accept2dyear", "altzone", "daylight", "timezone");
            this.addAttr("tzname", this.liburl(), Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr));
            this.addNoneFuncs("sleep", "tzset");
            this.addNumFuncs("clock", "mktime", "time", "tzname");
            this.addStrFuncs("asctime", "ctime", "strftime");
            this.addFunctions_beCareful(nClassType, "gmtime", "localtime", "strptime");
        }
    }

    class UnicodedataModule
    extends NativeModule {
        public UnicodedataModule() {
            super("unicodedata");
        }

        public void initBindings() {
            this.addNumFuncs("decimal", "digit", "numeric", "combining", "east_asian_width", "mirrored");
            this.addStrFuncs("lookup", "name", "category", "bidirectional", "decomposition", "normalize");
            this.addNumAttrs("unidata_version");
            this.addUnknownAttrs("ucd_3_2_0");
        }
    }

    class ZipimportModule
    extends NativeModule {
        public ZipimportModule() {
            super("zipimport");
        }

        public void initBindings() {
            this.addClass("ZipImportError", this.liburl(), Builtins.this.newException("ZipImportError", this.table));
            NClassType nClassType = Builtins.this.newClass("zipimporter", this.table, Builtins.this.Object, new NClassType[0]);
            Scope scope = nClassType.getTable();
            scope.update("find_module", this.liburl(), (NType)nClassType, NBinding.Kind.METHOD);
            scope.update("get_code", this.liburl(), (NType)Builtins.this.unknown(), NBinding.Kind.METHOD);
            scope.update("get_data", this.liburl(), (NType)Builtins.this.unknown(), NBinding.Kind.METHOD);
            scope.update("get_source", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.METHOD);
            scope.update("is_package", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.METHOD);
            scope.update("load_module", this.liburl(), (NType)Builtins.this.newModule("<?>"), NBinding.Kind.METHOD);
            scope.update("archive", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            scope.update("prefix", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            this.addClass("zipimporter", this.liburl(), nClassType);
            this.addAttr("_zip_directory_cache", this.liburl(), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.unknown()));
        }
    }

    class ZlibModule
    extends NativeModule {
        public ZlibModule() {
            super("zlib");
        }

        public void initBindings() {
            NClassType nClassType = Builtins.this.newClass("Compress", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : Builtins.this.list("compress", "flush")) {
                nClassType.getTable().update(string, Builtins.newLibUrl("zlib"), (NType)Builtins.this.BaseStr, NBinding.Kind.METHOD);
            }
            nClassType.getTable().update("copy", Builtins.newLibUrl("zlib"), (NType)nClassType, NBinding.Kind.METHOD);
            this.addClass("Compress", this.liburl(), nClassType);
            NClassType nClassType2 = Builtins.this.newClass("Decompress", this.table, Builtins.this.Object, new NClassType[0]);
            for (String string : Builtins.this.list("unused_data", "unconsumed_tail")) {
                nClassType2.getTable().update(string, Builtins.newLibUrl("zlib"), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            }
            for (String string : Builtins.this.list("decompress", "flush")) {
                nClassType2.getTable().update(string, Builtins.newLibUrl("zlib"), (NType)Builtins.this.BaseStr, NBinding.Kind.METHOD);
            }
            nClassType2.getTable().update("copy", Builtins.newLibUrl("zlib"), (NType)nClassType2, NBinding.Kind.METHOD);
            this.addClass("Decompress", this.liburl(), nClassType2);
            this.addFunction("adler32", this.liburl(), Builtins.this.BaseNum);
            this.addFunction("compress", this.liburl(), Builtins.this.BaseStr);
            this.addFunction("compressobj", this.liburl(), nClassType);
            this.addFunction("crc32", this.liburl(), Builtins.this.BaseNum);
            this.addFunction("decompress", this.liburl(), Builtins.this.BaseStr);
            this.addFunction("decompressobj", this.liburl(), nClassType2);
        }
    }
}

