/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.indexer.AstCache;
import org.python.indexer.Builtins;
import org.python.indexer.Diagnostic;
import org.python.indexer.IndexingException;
import org.python.indexer.NBinding;
import org.python.indexer.Outliner;
import org.python.indexer.Ref;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexer {
    public static Indexer idx;
    public Scope moduleTable = new Scope(null, Scope.Type.GLOBAL);
    public Scope globaltable = new Scope(null, Scope.Type.GLOBAL);
    private Map<String, NBinding> allBindings = new HashMap<String, NBinding>();
    private Map<Ref, List<NBinding>> locations = new HashMap<Ref, List<NBinding>>();
    public Map<String, List<Diagnostic>> problems = new HashMap<String, List<Diagnostic>>();
    public Map<String, List<Diagnostic>> parseErrs = new HashMap<String, List<Diagnostic>>();
    public String currentFile = null;
    public String projDir = null;
    public List<String> path = new ArrayList<String>();
    private AstCache astCache;
    public Set<String> failedModules = new HashSet<String>();
    private Map<String, Set<String>> unresolvedModules = new TreeMap<String, Set<String>>();
    public Builtins builtins;
    private boolean aggressiveAssertions;
    private int nloc = 0;
    private int nunbound = 0;
    private int nunknown = 0;
    private int nprob = 0;
    private int nparsing = 0;
    private int loadedFiles = 0;
    private Logger logger = Logger.getLogger(Indexer.class.getCanonicalName());

    public Indexer() {
        idx = this;
        this.builtins = new Builtins(this.globaltable, this.moduleTable);
        this.builtins.init();
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("null logger param");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setProjectDir(String string) throws IOException {
        this.projDir = Util.canonicalize(string);
    }

    public void enableAggressiveAssertions(boolean bl) {
        this.aggressiveAssertions = bl;
    }

    public boolean aggressiveAssertionsEnabled() {
        return this.aggressiveAssertions;
    }

    public void handleException(String string, Throwable throwable) {
        if (throwable instanceof StackOverflowError) {
            this.logger.log(Level.WARNING, string, throwable);
            return;
        }
        if (this.aggressiveAssertionsEnabled()) {
            if (string != null) {
                throw new IndexingException(string, throwable);
            }
            throw new IndexingException(throwable);
        }
        if (string == null) {
            string = "<null msg>";
        }
        if (throwable == null) {
            throwable = new Exception();
        }
        this.logger.log(Level.WARNING, string, throwable);
    }

    public void reportFailedAssertion(String string) {
        if (this.aggressiveAssertionsEnabled()) {
            throw new IndexingException(string, new Exception());
        }
    }

    public void addPaths(List<String> list) throws IOException {
        for (String string : list) {
            this.addPath(string);
        }
    }

    public void addPath(String string) throws IOException {
        this.path.add(Util.canonicalize(string));
    }

    public void setPath(List<String> list) throws IOException {
        this.path = new ArrayList<String>(list.size());
        this.addPaths(list);
    }

    public List<String> getLoadPath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.projDir != null) {
            arrayList.add(this.projDir);
        }
        arrayList.addAll(this.path);
        return arrayList;
    }

    public boolean isLibFile(String string) {
        if (string.startsWith("/")) {
            return true;
        }
        if (this.path != null) {
            for (String string2 : this.path) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, NBinding> getBindings() {
        return this.allBindings;
    }

    public NBinding lookupQname(String string) {
        return this.allBindings.get(string);
    }

    public NType lookupQnameType(String string) {
        NBinding nBinding = this.lookupQname(string);
        if (nBinding != null) {
            return nBinding.followType();
        }
        return null;
    }

    NModuleType getCachedModule(String string) {
        return (NModuleType)this.moduleTable.lookupType(string);
    }

    public NModuleType getModuleForFile(String string) throws Exception {
        if (this.failedModules.contains(string)) {
            return null;
        }
        NModuleType nModuleType = this.getCachedModule(string);
        if (nModuleType != null) {
            return nModuleType;
        }
        return this.loadFile(string);
    }

    public List<Diagnostic> getDiagnosticsForFile(String string) {
        List<Diagnostic> list = this.problems.get(string);
        if (list != null) {
            return list;
        }
        return new ArrayList<Diagnostic>();
    }

    public List<Outliner.Entry> generateOutline(String string) throws Exception {
        return new Outliner().generate(this, string);
    }

    public void putLocation(NNode nNode, NBinding nBinding) {
        if (nNode == null) {
            return;
        }
        this.putLocation(new Ref(nNode), nBinding);
    }

    public void putLocation(Ref ref, NBinding nBinding) {
        if (ref == null) {
            return;
        }
        List<NBinding> list = this.locations.get(ref);
        if (list == null) {
            list = new ArrayList<NBinding>(1);
            this.locations.put(ref, list);
        }
        if (!list.contains(nBinding)) {
            list.add(nBinding);
        }
        nBinding.addRef(ref);
    }

    public void updateLocation(Ref ref, NBinding nBinding) {
        if (ref == null) {
            return;
        }
        List<NBinding> list = this.locations.get(ref);
        if (list == null) {
            list = new ArrayList<NBinding>(1);
            this.locations.put(ref, list);
        } else {
            for (NBinding nBinding2 : list) {
                nBinding2.removeRef(ref);
            }
            list.clear();
        }
        if (!list.contains(nBinding)) {
            list.add(nBinding);
        }
        nBinding.addRef(ref);
    }

    public void removeBinding(NBinding nBinding) {
        this.allBindings.remove(nBinding);
    }

    public NBinding putBinding(NBinding nBinding) {
        if (nBinding == null) {
            throw new IllegalArgumentException("null binding arg");
        }
        String string = nBinding.getQname();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Null/empty qname: " + nBinding);
        }
        NBinding nBinding2 = this.allBindings.get(string);
        if (nBinding2 == nBinding) {
            return nBinding;
        }
        if (nBinding2 != null) {
            this.duplicateBindingFailure(nBinding, nBinding2);
            if (nBinding.getKind() == NBinding.Kind.MODULE) {
                return nBinding;
            }
            return nBinding2;
        }
        this.allBindings.put(string, nBinding);
        return nBinding;
    }

    private void duplicateBindingFailure(NBinding nBinding, NBinding nBinding2) {
    }

    public void putProblem(NNode nNode, String string) {
        String string2;
        if (nNode != null && (string2 = nNode.getFile()) != null) {
            this.addFileErr(string2, nNode.start(), nNode.end(), string);
        }
    }

    public void putProblem(String string, int n, int n2, String string2) {
        if (string != null) {
            this.addFileErr(string, n, n2, string2);
        }
    }

    void addFileErr(String string, int n, int n2, String string2) {
        List<Diagnostic> list = this.getFileErrs(string, this.problems);
        list.add(new Diagnostic(string, Diagnostic.Type.ERROR, n, n2, string2));
    }

    List<Diagnostic> getParseErrs(String string) {
        return this.getFileErrs(string, this.parseErrs);
    }

    List<Diagnostic> getFileErrs(String string, Map<String, List<Diagnostic>> map) {
        List<Diagnostic> list = map.get(string);
        if (list == null) {
            list = new ArrayList<Diagnostic>();
            map.put(string, list);
        }
        return list;
    }

    public NModuleType loadFile(String string) throws Exception {
        return this.loadFile(string, false);
    }

    public NModuleType loadString(String string, String string2) throws Exception {
        NModuleType nModuleType = this.getCachedModule(string);
        if (nModuleType != null) {
            this.finer("\nusing cached module " + string + " [succeeded]");
            return nModuleType;
        }
        return this.parseAndResolve(string, string2);
    }

    public NModuleType loadFile(String string, boolean bl) throws Exception {
        File file = new File(string);
        if (file.isDirectory()) {
            this.finer("\n    loading init file from directory: " + string);
            file = Util.joinPath(string, "__init__.py");
            string = file.getAbsolutePath();
        }
        if (!file.canRead()) {
            this.finer("\nfile not not found or cannot be read: " + string);
            return null;
        }
        NModuleType nModuleType = this.getCachedModule(string);
        if (nModuleType != null) {
            this.finer("\nusing cached module " + string + " [succeeded]");
            return nModuleType;
        }
        if (!bl) {
            this.loadParentPackage(string);
        }
        try {
            return this.parseAndResolve(string);
        }
        catch (StackOverflowError stackOverflowError) {
            this.handleException("Error loading " + string, stackOverflowError);
            return null;
        }
    }

    private void loadParentPackage(String string) throws Exception {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 == null || this.isInLoadPath(file2)) {
            return;
        }
        if (file2 != null && file.isFile() && "__init__.py".equals(file.getName())) {
            file2 = file2.getParentFile();
        }
        if (file2 == null || this.isInLoadPath(file2)) {
            return;
        }
        File file3 = Util.joinPath(file2, "__init__.py");
        if (!file3.isFile() || !file3.canRead()) {
            return;
        }
        this.loadFile(file3.getPath());
    }

    private boolean isInLoadPath(File file) {
        for (String string : this.getLoadPath()) {
            if (!new File(string).equals(file)) continue;
            return true;
        }
        return false;
    }

    private NModuleType parseAndResolve(String string) throws Exception {
        return this.parseAndResolve(string, null);
    }

    private NModuleType parseAndResolve(String string, String string2) throws Exception {
        NModuleType nModuleType = (NModuleType)this.moduleTable.lookupType(string);
        if (nModuleType != null) {
            return nModuleType;
        }
        NModuleType nModuleType2 = new NModuleType(Util.moduleNameFor(string), string, this.globaltable);
        this.moduleTable.put(string, new NUrl("file://" + string), nModuleType2, NBinding.Kind.MODULE);
        try {
            NModule nModule = null;
            nModule = string2 != null ? this.getAstForFile(string, string2) : this.getAstForFile(string);
            if (nModule == null) {
                return null;
            }
            this.finer("resolving: " + string);
            nModule.resolve(this.globaltable);
            this.finer("[success]");
            ++this.loadedFiles;
            return nModuleType2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.astCache != null) {
                this.astCache.clear();
            }
            System.gc();
            return null;
        }
    }

    private AstCache getAstCache() throws Exception {
        if (this.astCache == null) {
            this.astCache = AstCache.get();
        }
        return this.astCache;
    }

    public NModule getAstForFile(String string) throws Exception {
        return this.getAstCache().getAST(string);
    }

    public NModule getAstForFile(String string, String string2) throws Exception {
        return this.getAstCache().getAST(string, string2);
    }

    public NModuleType getBuiltinModule(String string) throws Exception {
        return this.builtins.get(string);
    }

    public NModuleType loadModule(String string) throws Exception {
        if (this.failedModules.contains(string)) {
            return null;
        }
        NModuleType nModuleType = this.getCachedModule(string);
        if (nModuleType != null) {
            this.finer("\nusing cached module " + string);
            return nModuleType;
        }
        NModuleType nModuleType2 = this.getBuiltinModule(string);
        if (nModuleType2 != null) {
            return nModuleType2;
        }
        this.finer("looking for module " + string);
        if (string.endsWith(".py")) {
            string = string.substring(0, string.length() - 3);
        }
        String string2 = string.replace('.', '/');
        string2 = string2.replaceFirst("(/python[23])/([0-9]/)", "$1.$2");
        List<String> list = this.getLoadPath();
        for (String string3 : list) {
            NModuleType nModuleType3;
            String string4;
            String string5 = string3 + string2;
            String string6 = string5 + ".py";
            String string7 = Util.joinPath(string5, "__init__.py").getAbsolutePath();
            if (Util.isReadableFile(string7)) {
                string4 = string7;
            } else {
                if (!Util.isReadableFile(string6)) continue;
                string4 = string6;
            }
            if ((nModuleType3 = this.loadFile(string4 = Util.canonicalize(string4))) == null) continue;
            this.finer("load of module " + string + "[succeeded]");
            return nModuleType3;
        }
        this.finer("failed to find module " + string + " in load path");
        this.failedModules.add(string);
        return null;
    }

    public void loadFileRecursive(String string) throws Exception {
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.loadFileRecursive(file2.getAbsolutePath());
            }
        } else if (file.getAbsolutePath().endsWith(".py")) {
            this.loadFile(file.getAbsolutePath());
        }
    }

    public void ready() {
        Object object;
        this.fine("Checking for undeclared variables");
        for (Map.Entry<Ref, List<NBinding>> iterator2 : this.locations.entrySet()) {
            Ref ref = iterator2.getKey();
            object = iterator2.getValue();
            this.convertCallToNew(ref, (List<NBinding>)object);
            if (this.countDefs((List<NBinding>)object) == 0) continue;
            ++this.nloc;
        }
        this.nprob = this.problems.size();
        this.nparsing = this.parseErrs.size();
        HashSet hashSet = new HashSet();
        for (Map.Entry<String, NBinding> entry : this.allBindings.entrySet()) {
            object = entry.getValue();
            if (!((NBinding)object).isProvisional() && ((NBinding)object).getNumDefs() != 0) continue;
            hashSet.add(entry.getKey());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.allBindings.remove(string);
        }
        this.locations.clear();
    }

    private void convertCallToNew(Ref ref, List<NBinding> list) {
        if (ref.isRef()) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        NBinding nBinding = list.get(0);
        NType nType = nBinding.followType();
        if (nType.isUnionType() && (nType = nType.asUnionType().firstKnownNonNullAlternate()) == null) {
            return;
        }
        NType nType2 = nType.follow();
        if (!nType2.isUnknownType() && !nType2.isFuncType()) {
            ref.markAsNew();
        }
    }

    public void clearAstCache() {
        if (this.astCache != null) {
            this.astCache.clear();
        }
    }

    public void clearModuleTable() {
        this.moduleTable.clear();
        this.moduleTable = new Scope(null, Scope.Type.GLOBAL);
        this.clearAstCache();
    }

    private int countDefs(List<NBinding> list) {
        int n = 0;
        for (NBinding nBinding : list) {
            n += nBinding.getNumDefs();
        }
        return n;
    }

    private String printBindings() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.allBindings.keySet());
        for (String string : treeSet) {
            NBinding nBinding = this.allBindings.get(string);
            stringBuilder.append(nBinding.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public void recordUnresolvedModule(String string, String string2) {
        Set<String> set = this.unresolvedModules.get(string);
        if (set == null) {
            set = new TreeSet<String>();
            this.unresolvedModules.put(string, set);
        }
        set.add(string2);
    }

    public String getStatusReport() {
        int n = this.nloc + this.nunbound + this.nunknown;
        if (n == 0) {
            n = 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Summary: \n").append("- modules loaded: ").append(this.loadedFiles).append("\n- unresolved modules: ").append(this.unresolvedModules.size()).append("\n");
        for (String string : this.unresolvedModules.keySet()) {
            stringBuilder.append(string).append(": ");
            Set<String> set = this.unresolvedModules.get(string);
            if (set.size() > 5) {
                stringBuilder.append(set.iterator().next());
                stringBuilder.append(" and ");
                stringBuilder.append(set.size());
                stringBuilder.append(" more");
            } else {
                String string2 = set.toString();
                stringBuilder.append(string2.substring(1, string2.length() - 1));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("\nsemantics problems: ").append(this.nprob);
        stringBuilder.append("\nparsing problems: ").append(this.nparsing);
        return stringBuilder.toString();
    }

    private String percent(int n, int n2) {
        double d = (double)n * 1.0 / (double)n2;
        d = (double)Math.round(d * 10000.0) / 100.0;
        return n + "/" + n2 + " = " + d + "%";
    }

    public int numFilesLoaded() {
        return this.loadedFiles;
    }

    public List<String> getLoadedFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.moduleTable.keySet()) {
            if (!string.startsWith("/")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void log(Level level, String string) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, string);
        }
    }

    public void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    public void warn(String string) {
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        this.log(Level.INFO, string);
    }

    public void fine(String string) {
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        this.log(Level.FINER, string);
    }

    public void release() {
        this.globaltable = null;
        this.moduleTable = null;
        this.clearAstCache();
        this.astCache = null;
        this.locations = null;
        this.problems.clear();
        this.problems = null;
        this.parseErrs.clear();
        this.parseErrs = null;
        this.path.clear();
        this.path = null;
        this.failedModules.clear();
        this.failedModules = null;
        this.unresolvedModules.clear();
        this.unresolvedModules = null;
        this.builtins = null;
        this.allBindings.clear();
        this.allBindings = null;
        idx = null;
    }

    public String toString() {
        return "<Indexer:locs=" + this.locations.size() + ":unbound=" + this.nunbound + ":probs=" + this.problems.size() + ":files=" + this.loadedFiles + ">";
    }
}

