/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.python.indexer.AstCache;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.TestBase;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NAssert;
import org.python.indexer.ast.NAssign;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NAugAssign;
import org.python.indexer.ast.NBinOp;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NBoolOp;
import org.python.indexer.ast.NBreak;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NClassDef;
import org.python.indexer.ast.NCompare;
import org.python.indexer.ast.NComprehension;
import org.python.indexer.ast.NContinue;
import org.python.indexer.ast.NDelete;
import org.python.indexer.ast.NDict;
import org.python.indexer.ast.NEllipsis;
import org.python.indexer.ast.NExceptHandler;
import org.python.indexer.ast.NExec;
import org.python.indexer.ast.NExprStmt;
import org.python.indexer.ast.NFor;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NGeneratorExp;
import org.python.indexer.ast.NGlobal;
import org.python.indexer.ast.NIf;
import org.python.indexer.ast.NIfExp;
import org.python.indexer.ast.NImport;
import org.python.indexer.ast.NImportFrom;
import org.python.indexer.ast.NIndex;
import org.python.indexer.ast.NKeyword;
import org.python.indexer.ast.NLambda;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NListComp;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNum;
import org.python.indexer.ast.NPass;
import org.python.indexer.ast.NPlaceHolder;
import org.python.indexer.ast.NPrint;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NRaise;
import org.python.indexer.ast.NRepr;
import org.python.indexer.ast.NReturn;
import org.python.indexer.ast.NSlice;
import org.python.indexer.ast.NStr;
import org.python.indexer.ast.NSubscript;
import org.python.indexer.ast.NTryExcept;
import org.python.indexer.ast.NTryFinally;
import org.python.indexer.ast.NTuple;
import org.python.indexer.ast.NUnaryOp;
import org.python.indexer.ast.NUrl;
import org.python.indexer.ast.NWhile;
import org.python.indexer.ast.NWith;
import org.python.indexer.ast.NYield;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;

public class IndexerTest
extends TestBase {
    public void testBuiltinModulePresent() throws Exception {
        NType nType = this.idx.moduleTable.lookupType("__builtin__");
        IndexerTest.assertNotNull((String)"missing __builtin__ module", (Object)nType);
        IndexerTest.assertTrue((String)("wrong type: " + nType.getClass()), (boolean)(nType instanceof NModuleType));
    }

    public void testLazyModuleLoad() throws Exception {
        IndexerTest.assertNull((String)"'array' module should not yet be loaded", (Object)this.idx.moduleTable.lookupType("array"));
        this.assertNoBinding("array");
        IndexerTest.assertNotNull((Object)this.idx.loadModule("array"));
        IndexerTest.assertNotNull((String)"'array' module should have been loaded", (Object)this.idx.moduleTable.lookupType("array"));
        this.assertModuleBinding("array");
    }

    public void testNativeModulesAvailable() throws Exception {
        for (String string : new String[]{"array", "ctypes", "errno", "math", "operator", "os", "signal", "sys", "thread", "time"}) {
            this.assertNoBinding(string);
            IndexerTest.assertNotNull((String)string, (Object)this.idx.loadModule(string));
            this.assertModuleBinding(string);
        }
    }

    public void testBuiltinObject() throws Exception {
        this.assertClassBinding("__builtin__.object");
        this.assertClassBinding("__builtin__.object.__class__");
    }

    public void testBuiltinTuple() throws Exception {
        this.assertClassBinding("__builtin__.tuple");
        this.assertMethodBinding("__builtin__.tuple.__rmul__");
        this.assertMethodBinding("__builtin__.tuple.__iter__");
    }

    public void testBuiltinList() throws Exception {
        this.assertClassBinding("__builtin__.list");
        this.assertMethodBinding("__builtin__.list.append");
        this.assertMethodBinding("__builtin__.list.count");
    }

    public void testBuiltinNum() throws Exception {
        this.assertClassBinding("__builtin__.float");
        NBinding nBinding = this.assertMethodBinding("__builtin__.float.fromhex");
        IndexerTest.assertTrue((boolean)nBinding.isBuiltin());
    }

    public void testBuiltinStr() throws Exception {
        this.assertClassBinding("__builtin__.str");
        this.assertMethodBinding("__builtin__.str.encode");
        this.assertMethodBinding("__builtin__.str.startswith");
        this.assertMethodBinding("__builtin__.str.split");
        this.assertMethodBinding("__builtin__.str.partition");
    }

    public void testBuiltinDict() throws Exception {
        this.assertClassBinding("__builtin__.dict");
        this.assertMethodBinding("__builtin__.dict.__getitem__");
        this.assertMethodBinding("__builtin__.dict.keys");
        this.assertMethodBinding("__builtin__.dict.clear");
    }

    public void testBuiltinFile() throws Exception {
        this.assertClassBinding("__builtin__.file");
        this.assertMethodBinding("__builtin__.file.__enter__");
        this.assertMethodBinding("__builtin__.file.readline");
        this.assertMethodBinding("__builtin__.file.readlines");
        this.assertMethodBinding("__builtin__.file.isatty");
    }

    public void testBuiltinFuncs() throws Exception {
        this.assertFunctionBinding("__builtin__.apply");
        this.assertFunctionBinding("__builtin__.abs");
        this.assertFunctionBinding("__builtin__.hex");
        this.assertFunctionBinding("__builtin__.range");
        this.assertFunctionBinding("__builtin__.globals");
        this.assertFunctionBinding("__builtin__.open");
    }

    public void testBuiltinTypes() throws Exception {
        this.assertClassBinding("__builtin__.ArithmeticError");
        this.assertClassBinding("__builtin__.ZeroDivisionError");
        this.assertAttributeBinding("__builtin__.True");
        this.assertAttributeBinding("__builtin__.False");
        this.assertAttributeBinding("__builtin__.None");
        this.assertAttributeBinding("__builtin__.Ellipsis");
    }

    public void testStrConstructor() throws Exception {
        String string = this.index("newstr.py", "x = str([])");
        this.assertStringType("newstr.x");
    }

    public void testListSubscript() throws Exception {
        String string = this.index("test.py", "x = [1, 2, 3]", "y = x[2]");
        this.assertNumType("test.y");
    }

    public void testBuiltinSys() throws Exception {
        this.idx.loadModule("sys");
        this.assertModuleBinding("sys");
        this.assertAttributeBinding("sys.__stderr__");
        NBinding nBinding = this.assertFunctionBinding("sys.exit");
        IndexerTest.assertTrue((boolean)nBinding.isBuiltin());
        this.assertFunctionBinding("sys.getprofile");
        this.assertFunctionBinding("sys.getdefaultencoding");
        this.assertAttributeBinding("sys.api_version");
        this.assertNumType("sys.api_version");
        this.assertAttributeBinding("sys.argv");
        this.assertBindingType("sys.argv", NListType.class);
        this.assertAttributeBinding("sys.byteorder");
        this.assertStringType("sys.byteorder");
        this.assertAttributeBinding("sys.flags");
        this.assertBindingType("sys.flags", NDictType.class);
    }

    public void testFetchAst() throws Exception {
        NModule nModule = this.idx.getAstForFile(this.abspath("hello.py"));
        IndexerTest.assertNotNull((String)"failed to load file", (Object)nModule);
        IndexerTest.assertEquals((String)"module has wrong name", (String)"hello", (String)nModule.name);
        IndexerTest.assertNotNull((String)"AST has no body", (Object)nModule.body);
        IndexerTest.assertNotNull((String)"AST body has no children", (Object)nModule.body.seq);
        IndexerTest.assertEquals((String)"wrong number of children", (int)1, (int)nModule.body.seq.size());
        NNode nNode = (NNode)nModule.body.seq.get(0);
        IndexerTest.assertTrue((String)("Incorrect AST: " + nNode.getClass()), (boolean)(nNode instanceof NExprStmt));
        nNode = ((NExprStmt)nNode).value;
        IndexerTest.assertTrue((String)("Incorrect AST: " + nNode.getClass()), (boolean)(nNode instanceof NStr));
        IndexerTest.assertEquals((String)"Wrong string content", (String)"Hello", (String)((NStr)nNode).n.toString());
    }

    public void testFileLoad() throws Exception {
        this.idx.loadFile(this.abspath("testfileload.py"), true);
        this.idx.ready();
        IndexerTest.assertEquals((String)"loaded more than 1 file", (int)1, (int)this.idx.numFilesLoaded());
    }

    public void testAstCacheTmpDir() throws Exception {
        AstCache astCache = AstCache.get();
        File file = new File(AstCache.CACHE_DIR);
        IndexerTest.assertTrue((boolean)file.exists());
        IndexerTest.assertTrue((boolean)file.canRead());
        IndexerTest.assertTrue((boolean)file.canWrite());
        IndexerTest.assertTrue((boolean)file.isDirectory());
    }

    public void testAstCacheNames() throws Exception {
        AstCache astCache = AstCache.get();
        String string = this.abspath("hello.py");
        String string2 = astCache.getCachePath(new File(string));
        String string3 = new File(string2).getName();
        IndexerTest.assertTrue((String)("Invalid cache name: " + string3), (boolean)string3.matches("^hello.py[A-Za-z0-9]{32}.ast$"));
    }

    public void testAstCache() throws Exception {
        AstCache astCache = AstCache.get();
        String string = this.abspath("hello.py");
        NModule nModule = astCache.getSerializedModule(string);
        IndexerTest.assertNull((Object)nModule);
        astCache.getAST(string);
        nModule = astCache.getSerializedModule(string);
        IndexerTest.assertNotNull((Object)nModule);
        IndexerTest.assertEquals((String)string, (String)nModule.getFile());
    }

    public void testAstCacheEmptyFile() throws Exception {
        AstCache astCache = AstCache.get();
        NModule nModule = astCache.getAST(this.abspath("empty_file.py"));
        IndexerTest.assertNotNull((Object)nModule);
        NBody nBody = nModule.body;
        IndexerTest.assertNotNull((Object)nBody);
        IndexerTest.assertTrue((boolean)nBody.seq.isEmpty());
    }

    public void testConstructedTypes() throws Exception {
        this.assertNoneType(new NAlias(null, null, null));
        this.assertNoneType(new NAssert(null, null));
        this.assertNoneType(new NAssign(null, null));
        this.assertNoneType(new NAttribute(new NStr(), new NName("")));
        this.assertNoneType(new NAugAssign(null, null, null));
        this.assertNoneType(new NBinOp(null, null, null));
        this.assertNoneType(new NBlock(null));
        this.assertNoneType(new NBody((List<NNode>)null));
        this.assertNoneType(new NBoolOp(null, null));
        this.assertNoneType(new NBreak());
        this.assertNoneType(new NCall(null, null, null, null, null));
        this.assertNoneType(new NClassDef(null, null, null));
        this.assertNoneType(new NCompare(null, null, null));
        this.assertNoneType(new NComprehension(null, null, null));
        this.assertNoneType(new NContinue());
        this.assertNoneType(new NDelete(null));
        this.assertNoneType(new NDict(null, null));
        this.assertNoneType(new NEllipsis());
        this.assertNoneType(new NExceptHandler(null, null, null));
        this.assertNoneType(new NExec(null, null, null));
        this.assertNoneType(new NExprStmt(null));
        this.assertNoneType(new NFor(null, null, null, null));
        this.assertNoneType(new NFunctionDef(null, null, null, null, null, null));
        this.assertNoneType(new NGeneratorExp(null, null));
        this.assertNoneType(new NGlobal(null));
        this.assertNoneType(new NIf(null, null, null));
        this.assertNoneType(new NIfExp(null, null, null));
        this.assertNoneType(new NImport(null));
        this.assertNoneType(new NImportFrom(null, null, null));
        this.assertNoneType(new NIndex(null));
        this.assertNoneType(new NKeyword(null, null));
        this.assertNoneType(new NLambda(null, null, null, null, null));
        this.assertNoneType(new NList(null));
        this.assertNoneType(new NListComp(null, null));
        this.assertNoneType(new NModule(null, 0, 1));
        this.assertNoneType(new NName(""));
        this.assertNoneType(new NNum(-1));
        this.assertNoneType(new NPass());
        this.assertNoneType(new NPlaceHolder());
        this.assertNoneType(new NPrint(null, null));
        this.assertNoneType(new NQname(null, new NName("")));
        this.assertNoneType(new NRaise(null, null, null));
        this.assertNoneType(new NRepr(null));
        this.assertNoneType(new NReturn(null));
        this.assertNoneType(new NSlice(null, null, null));
        this.assertNoneType(new NStr());
        this.assertNoneType(new NSubscript(null, null));
        this.assertNoneType(new NTryExcept(null, null, null));
        this.assertNoneType(new NTryFinally(null, null));
        this.assertNoneType(new NTuple(null));
        this.assertNoneType(new NUnaryOp(null, null));
        this.assertNoneType(new NUrl(""));
        this.assertNoneType(new NWhile(null, null, null));
        this.assertNoneType(new NWith(null, null, null));
        this.assertNoneType(new NYield(null));
    }

    private void assertNoneType(NNode nNode) {
        IndexerTest.assertEquals((Object)nNode.getType(), (Object)Indexer.idx.builtins.None);
    }

    public void testClassTypeBuiltinAttrs() throws Exception {
        String string = "classtype_builtins.py";
        this.buildIndex(string);
        NModuleType nModuleType = (NModuleType)this.idx.moduleTable.lookupType(this.abspath(string));
        Scope scope = nModuleType.getTable();
        IndexerTest.assertTrue((boolean)scope.lookupType("MyClass").isClassType());
        IndexerTest.assertTrue((boolean)scope.lookupType("MyClassNoDoc").isClassType());
        IndexerTest.assertTrue((scope.lookupType("MyClass").getTable().getParent() == scope ? 1 : 0) != 0);
        IndexerTest.assertEquals((Object)((Object)NBinding.Kind.CLASS), (Object)((Object)scope.lookup("MyClass").getKind()));
        Scope scope2 = scope.lookupType("MyClass").getTable();
        IndexerTest.assertTrue((boolean)scope2.lookupType("__bases__").isTupleType());
        IndexerTest.assertTrue((boolean)scope2.lookupType("__dict__").isDictType());
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)scope2.lookupType("__name__"));
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)scope2.lookupType("__module__"));
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)scope2.lookupType("__doc__"));
        scope2 = scope.lookupType("MyClassNoDoc").getTable();
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)scope2.lookupType("__doc__"));
    }

    public void testMethodBuiltinAttrs() throws Exception {
        String string = "classtype_builtins.py";
        this.buildIndex(string);
        Scope scope = this.idx.moduleTable.lookupType(this.abspath(string)).getTable();
        NBinding nBinding = scope.lookupType("MyClass").getTable().lookup("__init__");
        IndexerTest.assertNotNull((Object)nBinding);
        IndexerTest.assertEquals((Object)((Object)NBinding.Kind.CONSTRUCTOR), (Object)((Object)nBinding.getKind()));
        IndexerTest.assertEquals((String)"classtype_builtins.MyClass.__init__", (String)nBinding.getQname());
        NType nType = scope.lookupType("MyClass").getTable().lookupType("__init__");
        IndexerTest.assertTrue((boolean)nType.isFuncType());
        NBinding nBinding2 = scope.lookup("MyClass");
        for (String string2 : new String[]{"im_class", "__class__", "im_self", "__self__"}) {
            NBinding nBinding3 = nType.getTable().lookup(string2);
            IndexerTest.assertNotNull((String)("missing binding for " + string2), (Object)nBinding3);
            IndexerTest.assertEquals((Object)nBinding2.getType(), (Object)nBinding3.getType());
        }
    }

    public void testModulePaths() throws Exception {
        this.idx.loadModule("pkg");
        this.idx.loadModule("pkg.animal");
        this.idx.loadModule("pkg.mineral.stone.lapis");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.animal");
        this.assertModuleBinding("pkg.mineral.stone.lapis");
    }

    public void testCircularImport() throws Exception {
        this.idx.loadModule("pkg.animal.mammal.cat");
        this.idx.ready();
    }

    public void testBasicDefsAndRefs() throws Exception {
        this.idx.loadModule("refs");
        this.idx.ready();
        this.assertScopeBinding("refs.foo");
        String string = this.getSource("refs.py");
        this.assertDefinition("refs.foo", "foo", this.nthIndexOf(string, "foo", 1));
        this.assertNoReference("Definition site should not produce a reference", "refs.foo", this.nthIndexOf(string, "foo", 1), "foo".length());
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 2));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 3));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 4));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 5));
        this.assertNoReference("Should not have been a reference inside a string", "refs.foo", this.nthIndexOf(string, "foo", 6), "foo".length());
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 7));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 8));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 9));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 10));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 11));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 12));
        this.assertNoReference("Function param cannot refer to outer scope", "refs.foo", this.nthIndexOf(string, "foo", 13), "foo".length());
        this.assertNoReference("Function param 'foo' should hide outer foo", "refs.foo", this.nthIndexOf(string, "foo", 14), "foo".length());
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 15));
        this.assertReference("refs.foo", this.nthIndexOf(string, "foo", 16));
    }

    public void testAutoClassBindings() throws Exception {
        this.idx.loadModule("class1");
        this.idx.ready();
        this.assertModuleBinding("class1");
        this.assertClassBinding("class1.A");
        NBinding nBinding = this.assertAttributeBinding("class1.A.__bases__");
        this.assertStaticSynthetic(nBinding);
        IndexerTest.assertTrue((boolean)nBinding.getType().isTupleType());
        IndexerTest.assertTrue((boolean)((NTupleType)nBinding.getType()).getElementTypes().isEmpty());
        nBinding = this.assertAttributeBinding("class1.A.__name__");
        this.assertStaticSynthetic(nBinding);
        IndexerTest.assertEquals((Object)nBinding.getType(), (Object)this.idx.builtins.BaseStr);
        nBinding = this.assertAttributeBinding("class1.A.__module__");
        this.assertStaticSynthetic(nBinding);
        IndexerTest.assertEquals((Object)nBinding.getType(), (Object)this.idx.builtins.BaseStr);
        nBinding = this.assertAttributeBinding("class1.A.__doc__");
        this.assertStaticSynthetic(nBinding);
        IndexerTest.assertEquals((Object)nBinding.getType(), (Object)this.idx.builtins.BaseStr);
        nBinding = this.assertAttributeBinding("class1.A.__dict__");
        this.assertStaticSynthetic(nBinding);
        IndexerTest.assertTrue((boolean)nBinding.getType().isDictType());
        IndexerTest.assertEquals((Object)((NDictType)nBinding.getType()).getKeyType(), (Object)this.idx.builtins.BaseStr);
        IndexerTest.assertTrue((boolean)((NDictType)nBinding.getType()).getValueType().isUnknownType());
    }

    public void testLocalVarRef() throws Exception {
        this.idx.loadModule("class2");
        this.idx.ready();
        this.assertFunctionBinding("class2.hi");
        this.assertParamBinding("class2.hi@msg");
        String string = this.getSource("class2.py");
        this.assertReference("class2.hi@msg", this.nthIndexOf(string, "msg", 2));
    }

    public void testClassMemberBindings() throws Exception {
        this.idx.loadModule("class1");
        this.idx.ready();
        this.assertScopeBinding("class1.A.a");
        this.assertConstructorBinding("class1.A.__init__");
        this.assertMethodBinding("class1.A.hi");
        this.assertParamBinding("class1.A.__init__@self");
        this.assertParamBinding("class1.A.hi@self");
        this.assertParamBinding("class1.A.hi@msg");
        String string = this.getSource("class1.py");
        this.assertReference("class1.A.hi@msg", this.nthIndexOf(string, "msg", 2));
        this.assertReference("class1.A", string.indexOf("A.a"), 1);
        this.assertReference("class1.A.a", string.indexOf("A.a") + 2, 1);
        this.assertScopeBinding("class1.x");
        this.assertScopeBinding("class1.y");
        this.assertScopeBinding("class1.z");
        this.assertReference("class1.A", string.indexOf("= A") + 2, 1);
        this.assertConstructed("class1.A", string.indexOf("A()"), 1);
        this.assertReference("class1.y", string.indexOf("y.b"), 1);
        this.assertInstanceType("class1.y", "class1.A");
        this.assertReference("class1.A.b", string.indexOf("y.b") + 2, 1);
        this.assertScopeBinding("class1.z");
        this.assertNumType("class1.z");
    }

    public void testCallNewRef() throws Exception {
        this.idx.loadModule("callnewref");
        this.idx.ready();
        String string = this.getSource("callnewref.py");
        String string2 = "callnewref.myfunc";
        this.assertFunctionBinding(string2);
        this.assertDefinition(string2, "myfunc", string.indexOf("myfunc"));
        this.assertReference(string2, this.nthIndexOf(string, "myfunc", 2));
        this.assertCall(string2, this.nthIndexOf(string, "myfunc", 3));
        String string3 = "callnewref.MyClass";
        this.assertClassBinding(string3);
        this.assertDefinition(string3, "MyClass", string.indexOf("MyClass"));
        this.assertReference(string3, this.nthIndexOf(string, "MyClass", 2));
        this.assertConstructed(string3, this.nthIndexOf(string, "MyClass", 3));
        String string4 = "callnewref.MyClass.mymethod";
        this.assertMethodBinding(string4);
        this.assertDefinition(string4, "mymethod", string.indexOf("mymethod"));
        this.assertReference(string4, this.nthIndexOf(string, "mymethod", 2));
        this.assertCall(string4, this.nthIndexOf(string, "mymethod", 3));
    }

    public void testPackageLoad() throws Exception {
        this.idx.loadModule("pkgload");
        this.idx.ready();
        this.assertModuleBinding("pkgload");
        this.assertModuleBinding("pkg");
        this.assertScopeBinding("pkg.myvalue");
    }

    public void testUnqualifiedSamePkgImport() throws Exception {
        this.idx.loadModule("pkg.animal.reptile.snake");
        this.idx.ready();
        this.assertModuleBinding("pkg.animal.reptile.snake");
        this.assertModuleBinding("pkg.animal.reptile.croc");
        this.assertClassBinding("pkg.animal.reptile.snake.Snake");
        this.assertClassBinding("pkg.animal.reptile.snake.Python");
        this.assertClassBinding("pkg.animal.reptile.croc.Crocodilian");
        this.assertClassBinding("pkg.animal.reptile.croc.Gavial");
        String string = this.getSource("pkg/animal/reptile/snake.py");
        this.assertReference("pkg.animal.reptile.croc", string.indexOf("croc"));
        this.assertReference("pkg.animal.reptile.croc", this.nthIndexOf(string, "croc", 2));
        this.assertReference("pkg.animal.reptile.croc.Gavial", string.indexOf("Gavial"));
    }

    public void testAbsoluteImport() throws Exception {
        this.idx.loadModule("pkg.mineral.metal.lead");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.plant");
        this.assertModuleBinding("pkg.plant.poison");
        this.assertModuleBinding("pkg.plant.poison.eggplant");
        String string = this.getSource("pkg/mineral/metal/lead.py");
        this.assertReference("pkg", this.nthIndexOf(string, "pkg", 1));
        this.assertReference("pkg", this.nthIndexOf(string, "pkg", 2));
        this.assertReference("pkg.plant", this.nthIndexOf(string, "plant", 1));
        this.assertReference("pkg.plant", this.nthIndexOf(string, ".plant", 2) + 1);
        this.assertReference("pkg.plant.poison", this.nthIndexOf(string, "poison", 1));
        this.assertReference("pkg.plant.poison", this.nthIndexOf(string, ".poison", 2) + 1);
        this.assertReference("pkg.plant.poison.eggplant", this.nthIndexOf(string, "eggplant", 1));
        this.assertReference("pkg.plant.poison.eggplant", this.nthIndexOf(string, ".eggplant", 2) + 1);
    }

    public void testAbsoluteImportAs() throws Exception {
        this.idx.loadModule("pkg.mineral.metal.iron");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.mineral");
        this.assertModuleBinding("pkg.mineral.metal");
        this.assertModuleBinding("pkg.mineral.metal.iron");
        this.assertModuleBinding("pkg.plant");
        this.assertModuleBinding("pkg.plant.poison");
        this.assertModuleBinding("pkg.plant.poison.eggplant");
        String string = "pkg.plant.poison.eggplant.adjectives";
        this.assertScopeBinding(string);
        String string2 = "pkg.mineral.metal.iron.aubergine";
        this.assertScopeBinding(string2);
        this.assertBindingType(string2, "pkg.plant.poison.eggplant");
        String string3 = this.getSource("pkg/mineral/metal/iron.py");
        this.assertReference("pkg", string3.indexOf("pkg"));
        this.assertReference("pkg.plant", string3.indexOf("plant"));
        this.assertReference("pkg.plant.poison", string3.indexOf("poison"));
        this.assertReference("pkg.plant.poison.eggplant", string3.indexOf("eggplant"));
        this.assertReference(string2, this.nthIndexOf(string3, "aubergine", 2));
        this.assertReference(string, string3.indexOf("adjectives"));
    }

    public void testImportFrom() throws Exception {
        this.idx.loadModule("pkg.other.color.white");
        this.idx.ready();
        String string = this.getSource("pkg/other/color/white.py");
        this.assertReference("pkg.other.color.red", string.indexOf("red"));
        this.assertReference("pkg.other.color.green", string.indexOf("green"));
        this.assertReference("pkg.other.color.blue", string.indexOf("blue"));
        this.assertReference("pkg.other.color.red.r", string.indexOf("r as"), 1);
        this.assertReference("pkg.other.color.blue.b", string.indexOf("b as"), 1);
        this.assertReference("pkg.other.color.red.r", string.indexOf("= R") + 2, 1);
        this.assertReference("pkg.other.color.green.g", string.indexOf("g #"), 1);
        this.assertReference("pkg.other.color.blue.b", string.indexOf("= B") + 2, 1);
    }

    public void testImportStar() throws Exception {
        this.idx.loadModule("pkg.other.color.crimson");
        this.idx.ready();
        String string = this.getSource("pkg/other/color/crimson.py");
        this.assertReference("pkg.other.color.red.r", string.indexOf("r,"), 1);
        this.assertReference("pkg.other.color.red.g", string.indexOf("g,"), 1);
        this.assertReference("pkg.other.color.red.b", string.indexOf("b"), 1);
    }

    public void testImportStarAll() throws Exception {
        this.idx.loadModule("pkg.misc.moduleB");
        this.idx.ready();
        String string = this.getSource("pkg/misc/moduleB.py");
        this.assertReference("pkg.misc.moduleA.a", string.indexOf("a #"), 1);
        this.assertReference("pkg.misc.moduleA.b", string.indexOf("b #"), 1);
        this.assertReference("pkg.misc.moduleA.c", string.indexOf("c #"), 1);
        this.assertNoReference("Should not have imported 'd'", "pkg.misc.moduleA.d", string.indexOf("d #"), 1);
    }

    public void testImportFromInitPy() throws Exception {
        this.idx.loadModule("pkg.animal");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.animal");
        this.assertModuleBinding("pkg.animal.animaltest");
        this.assertScopeBinding("pkg.animal.success");
        this.assertScopeBinding("pkg.animal.animaltest.living");
    }

    public void testTempName() throws Exception {
        String string = this.index("tmpname.py", "def purge():", "  cache.clear()", "cache = {}");
        this.assertScopeBinding("tmpname.cache");
        this.assertBindingType("tmpname.cache", NDictType.class);
        this.assertDefinition("tmpname.cache", "cache", string.lastIndexOf("cache"));
        this.assertReference("tmpname.cache", string.indexOf("cache"));
        this.assertNoDefinition("Temp-def should have been replaced", "tmpname.cache", string.indexOf("cache"), "cache".length());
        this.assertCall("__builtin__.dict.clear", string.lastIndexOf("clear"));
    }

    public void testTempAttr() throws Exception {
        String string = this.index("tmpattr.py", "x = app.usage", "app.usage = 'hi'");
        this.assertScopeBinding("tmpattr.x");
        this.assertScopeBinding("tmpattr.app");
        this.assertAttributeBinding("tmpattr.app.usage");
        this.assertStringType("tmpattr.app.usage");
        this.assertStringType("tmpattr.x");
        this.assertDefinition("tmpattr.app.usage", string.lastIndexOf("usage"));
        this.assertReference("tmpattr.app.usage", string.indexOf("usage"));
    }

    public void testTempAttrOnParam() throws Exception {
        String string = this.index("tmpattr_param.py", "def foo(x):", "  x.hello = 'hi'", "def bar(y=None):", "  y.hello = 'hola'");
        this.assertFunctionBinding("tmpattr_param.foo");
        this.assertParamBinding("tmpattr_param.foo@x");
        this.assertAttributeBinding("tmpattr_param.foo@x.hello");
        this.assertStringType("tmpattr_param.foo@x.hello");
        this.assertReference("tmpattr_param.foo@x", string.indexOf("x.hello"), 1);
        this.assertFunctionBinding("tmpattr_param.bar");
        this.assertParamBinding("tmpattr_param.bar@y");
        this.assertAttributeBinding("tmpattr_param.bar@y.hello");
        this.assertStringType("tmpattr_param.bar@y.hello");
        this.assertReference("tmpattr_param.bar@y", string.indexOf("y.hello"), 1);
    }

    public void testParamDefaultLambdaBinding() throws Exception {
        String string = this.index("test.py", "def foo(arg=lambda name: name + '!'):", "  x = arg('hi')");
        this.assertFunctionBinding("test.foo");
        this.assertParamBinding("test.foo@arg");
        this.assertFunctionBinding("test.lambda%1");
        this.assertParamBinding("test.lambda%1@name");
        this.assertReference("test.lambda%1@name", string.lastIndexOf("name"));
        this.assertCall("test.foo@arg", string.lastIndexOf("arg"));
        this.assertStringType("test.foo&x");
    }

    public void testNestedLambdaParam() throws Exception {
        String string = this.index("test.py", "def util(create):", "  return create()", "z = lambda:util(create=lambda: str())", "y = z()()");
        this.assertScopeBinding("test.z");
        this.assertFunctionBinding("test.lambda%1&lambda%1");
    }

    public void testReassignAttrOfUnknown() throws Exception {
        String string = this.index("reassign.py", "app.foo = 'hello'", "app.foo = 2");
        this.assertScopeBinding("reassign.app");
        NBinding nBinding = this.assertAttributeBinding("reassign.app.foo");
        NType nType = nBinding.getType();
        IndexerTest.assertTrue((boolean)nType.isUnionType());
        Set<NType> set = ((NUnionType)nType).getTypes();
        IndexerTest.assertEquals((int)2, (int)set.size());
        IndexerTest.assertTrue((boolean)set.contains(this.idx.builtins.BaseStr));
        IndexerTest.assertTrue((boolean)set.contains(this.idx.builtins.BaseNum));
    }

    public void testRefToProvisionalBinding() throws Exception {
        String string = this.index("provisional.py", "for a in []:", "  a.dump()", "for a in []:", "  a.dump()");
        this.assertModuleBinding("provisional");
        this.assertScopeBinding("provisional.a");
        this.assertNoBinding("provisional.a.dump");
    }

    public void testRefToProvisionalBindingNewType() throws Exception {
        String string = this.index("provisional.py", "for b in []:", "  b.dump()", "for b in ():", "  b.dump()");
        this.assertModuleBinding("provisional");
        this.assertScopeBinding("provisional.b");
        this.assertNoBinding("provisional.b.dump");
    }

    public void testSkipClassScope() throws Exception {
        String string = this.index("skipclass.py", "def aa():", "  xx = 'foo'", "  class bb:", "    xx = 10", "    def cc(self):", "      print bb.xx", "      print xx");
        this.assertReference("skipclass.aa&bb.xx", this.nthIndexOf(string, "xx", 3));
        this.assertReference("skipclass.aa&xx", this.nthIndexOf(string, "xx", 4));
    }

    public void testLambdaArgs() throws Exception {
        String string = this.index("lambda_args.py", "y = lambda x='hi': x.upper()", "y = lambda x='there': x.lower()");
        this.assertScopeBinding("lambda_args.y");
        this.assertFunctionBinding("lambda_args.lambda%1");
        this.assertParamBinding("lambda_args.lambda%1@x");
        this.assertStringType("lambda_args.lambda%1@x");
        this.assertReference("lambda_args.lambda%1@x", this.nthIndexOf(string, "x", 2));
        this.assertCall("__builtin__.str.upper", string.indexOf("upper"));
        this.assertFunctionBinding("lambda_args.lambda%2");
        this.assertParamBinding("lambda_args.lambda%1@x");
        this.assertReference("lambda_args.lambda%2@x", this.nthIndexOf(string, "x", 4));
        this.assertCall("__builtin__.str.lower", string.indexOf("lower"));
    }

    public void testFunArgs() throws Exception {
        String string = this.index("funargs.py", "def foo(x, y='hi'):", "  z = 9", "  return x + y.upper() + z");
        this.assertFunctionBinding("funargs.foo");
        this.assertParamBinding("funargs.foo@x");
        this.assertReference("funargs.foo@x", this.nthIndexOf(string, "x", 2));
        this.assertParamBinding("funargs.foo@y");
        this.assertStringType("funargs.foo@y");
        this.assertReference("funargs.foo@y", this.nthIndexOf(string, "y", 2));
        this.assertCall("__builtin__.str.upper", string.indexOf("upper"));
        this.assertVariableBinding("funargs.foo&z");
        this.assertReference("funargs.foo&z", this.nthIndexOf(string, "z", 2));
    }

    public void testDatetime() throws Exception {
        String string = this.index("date_time.py", "from datetime import datetime as dt", "import datetime", "now = dt.now()", "d = now.date()", "tz = now.tzinfo");
        this.assertModuleBinding("datetime");
        this.assertClassBinding("datetime.datetime");
        this.assertMethodBinding("datetime.datetime.date");
        this.assertReference("datetime", this.nthIndexOf(string, "datetime", 1));
        this.assertReference("datetime.datetime", this.nthIndexOf(string, "datetime", 2));
        this.assertReference("datetime.datetime", this.nthIndexOf(string, "dt", 1), 2);
        this.assertReference("datetime.datetime", this.nthIndexOf(string, "dt", 2), 2);
        this.assertReference("datetime", this.nthIndexOf(string, "datetime", 3));
        this.assertCall("datetime.datetime.now", this.nthIndexOf(string, "now", 2));
        this.assertCall("datetime.datetime.date", this.nthIndexOf(string, "date()", 1));
        this.assertReference("datetime.time.tzinfo", this.nthIndexOf(string, "tzinfo", 1));
        this.assertBindingType("date_time.tz", "datetime.tzinfo");
    }

    public void testUnpackList() throws Exception {
        this.index("unpacklist.py", "a = [1, 2]", "(b, c) = [3, 4]", "[d, e] = ['hi', 'there']");
        this.assertScopeBinding("unpacklist.a");
        this.assertScopeBinding("unpacklist.b");
        this.assertScopeBinding("unpacklist.c");
        this.assertScopeBinding("unpacklist.d");
        this.assertScopeBinding("unpacklist.e");
        this.assertListType("unpacklist.a", "__builtin__.float");
        this.assertNumType("unpacklist.b");
        this.assertNumType("unpacklist.c");
        this.assertStringType("unpacklist.d");
        this.assertStringType("unpacklist.e");
    }

    public void testStringSlice() throws Exception {
        String string = this.index("slicestring.py", "a = 'hello'[2]", "b = 'hello'[2:4]", "test = 'testing'", "test[-3:].lower()");
        this.assertScopeBinding("slicestring.a");
        this.assertScopeBinding("slicestring.b");
        this.assertStringType("slicestring.a");
        this.assertStringType("slicestring.b");
        this.assertCall("__builtin__.str.lower", string.lastIndexOf("lower"));
    }

    public void testUnionStringSliceTempAttr() throws Exception {
        String string = this.index("tmpattr_slice.py", "def foo(filename):", "  module = filename or '<unknown>'", "  module[-3:].lower()");
        this.assertCall("__builtin__.str.lower", string.lastIndexOf("lower"));
    }

    public void testSelfBinding() throws Exception {
        String string = this.index("selfish.py", "class Foo():", "  def hello(self):", "    print self");
        this.assertClassBinding("selfish.Foo");
        this.assertMethodBinding("selfish.Foo.hello");
        this.assertParamBinding("selfish.Foo.hello@self");
        this.assertDefinition("selfish.Foo.hello@self", this.nthIndexOf(string, "self", 1));
        this.assertReference("selfish.Foo.hello@self", this.nthIndexOf(string, "self", 2));
        this.assertBindingType("selfish.Foo.hello@self", "selfish.Foo");
    }

    public void testInstanceAttrs() throws Exception {
        String string = this.index("attr.py", "class Foo():", "  def __init__(self):", "    self.elts = []", "  def add(self, item):", "    self.elts.append(item)");
        this.assertClassBinding("attr.Foo");
        this.assertConstructorBinding("attr.Foo.__init__");
        this.assertParamBinding("attr.Foo.__init__@self");
        this.assertDefinition("attr.Foo.__init__@self", this.nthIndexOf(string, "self", 1));
        this.assertReference("attr.Foo.__init__@self", this.nthIndexOf(string, "self", 2));
        this.assertBindingType("attr.Foo.__init__@self", "attr.Foo");
        this.assertAttributeBinding("attr.Foo.elts");
        this.assertListType("attr.Foo.elts");
        this.assertMethodBinding("attr.Foo.add");
        this.assertParamBinding("attr.Foo.add@self");
        this.assertBindingType("attr.Foo.add@self", "attr.Foo");
        this.assertParamBinding("attr.Foo.add@item");
        this.assertReference("attr.Foo.add@self", this.nthIndexOf(string, "self", 4));
        this.assertReference("attr.Foo.elts", this.nthIndexOf(string, "elts", 2));
        this.assertCall("__builtin__.list.append", string.indexOf("append"));
        this.assertReference("attr.Foo.add@item", string.lastIndexOf("item"));
    }

    public void testInstanceAttrsWithStdLib() throws Exception {
        this.includeStandardLibrary();
        String string = this.index("dice.py", "import random", "class Dice(object):", "  def __init__(self):", "    self.__random = random.Random()", "  def set_seed(self, seed):", "    self.__random.seed(seed)");
        this.assertModuleBinding("random");
        NBinding nBinding = this.assertClassBinding("random.Random");
        IndexerTest.assertFalse((boolean)nBinding.isBuiltin());
        this.assertReference("random", this.nthIndexOf(string, "random", 3));
        this.assertConstructed("random.Random", string.indexOf("Random"));
        this.assertClassBinding("dice.Dice");
        this.assertReference("__builtin__.object", string.indexOf("object"));
        this.assertConstructorBinding("dice.Dice.__init__");
        this.assertParamBinding("dice.Dice.__init__@self");
        this.assertDefinition("dice.Dice.__init__@self", this.nthIndexOf(string, "self", 1));
        this.assertReference("dice.Dice.__init__@self", this.nthIndexOf(string, "self", 2));
        this.assertBindingType("dice.Dice.__init__@self", "dice.Dice");
        this.assertAttributeBinding("dice.Dice.__random");
        this.assertInstanceType("dice.Dice.__random", "random.Random");
        this.assertMethodBinding("dice.Dice.set_seed");
        this.assertParamBinding("dice.Dice.set_seed@self");
        this.assertBindingType("dice.Dice.set_seed@self", "dice.Dice");
        this.assertParamBinding("dice.Dice.set_seed@seed");
        this.assertReference("dice.Dice.set_seed@self", this.nthIndexOf(string, "self", 4));
        this.assertReference("dice.Dice.__random", this.nthIndexOf(string, "__random", 2));
        this.assertCall("random.Random.seed", this.nthIndexOf(string, "seed", 3));
        this.assertReference("dice.Dice.set_seed@seed", string.lastIndexOf("seed"));
    }

    public void testOsPath() throws Exception {
        String string = this.index("test.py", "from os import path", "print path.devnull", "base, ext = path.split('/foo/bar/baz.py')", "print ext.endswith('py')");
        this.assertReference("os.path.devnull", string.indexOf("devnull"));
        this.assertStringType("os.path.devnull");
        this.assertStringType("test.base");
        this.assertStringType("test.ext");
        this.assertCall("os.path.split", string.indexOf("split"));
        this.assertCall("__builtin__.str.endswith", string.indexOf("endswith"));
    }

    public void testImportOsPath() throws Exception {
        String string = this.index("test.py", "import os.path", "print os.path.devnull");
        this.assertReference("os", this.nthIndexOf(string, "os", 1));
        this.assertReference("os", this.nthIndexOf(string, "os", 2));
        this.assertReference("os.path", this.nthIndexOf(string, "path", 1));
        this.assertReference("os.path", this.nthIndexOf(string, "path", 2));
        this.assertReference("os.path.devnull", string.indexOf("devnull"));
    }

    public void testExceptionsModule() throws Exception {
        String string = this.index("test.py", "import exceptions", "raise exceptions.NotImplementedError");
        this.assertModuleBinding("exceptions");
        this.assertClassBinding("exceptions.NotImplementedError");
        this.assertReference("exceptions.NotImplementedError", string.indexOf("Not"));
    }

    public void testDupFunctionDecl() throws Exception {
        String string = this.index("test.py", "if x:", "  def a(args):", "    print args", "elif y:", "  def a(args):", "    print args");
        this.assertFunctionBinding("test.a");
        this.assertParamBinding("test.a@args");
    }

    public void testResolveExportedNames() throws Exception {
        String string = this.index("test.py", "__all__ = ['foo', 'bar' + 'baz', 'one', 'two']", "def foo(x):", "  return x", "bar = 6", "baz = 7", "barbaz = 8", "one = 'hi'", "two = 'there'");
        this.assertReference("test.foo", string.indexOf("'foo"), 5);
        this.assertReference("test.one", string.indexOf("'one"), 5);
        this.assertReference("test.two", string.indexOf("'two"), 5);
        this.assertNoReference("Should not have referenced 'bar'", "test.bar", string.indexOf("bar"), 3);
    }

    public void testImportFromPlusAssign() throws Exception {
        String string = this.index("test.py", "from os import sep", "os = 10", "print os");
        this.assertModuleBinding("os");
        this.assertReference("os", string.indexOf("os"));
        this.assertNoDefinition("Import-from should not introduce a definition", "test.os", string.indexOf("os"), "os".length());
        this.assertDefinition("test.os", this.nthIndexOf(string, "os", 2));
        this.assertNumType("test.os");
        this.assertReference("test.os", string.lastIndexOf("os"));
    }

    public void testCircularTypeFunAndTuple() throws Exception {
        String string = this.index("test.py", "def foo():", "  return (foo,)");
        this.assertFunctionBinding("test.foo");
        NType nType = this.idx.lookupQnameType("test.foo");
        IndexerTest.assertTrue((boolean)(nType instanceof NFuncType));
        NType nType2 = nType.asFuncType().getReturnType();
        IndexerTest.assertTrue((boolean)(nType2 instanceof NTupleType));
        IndexerTest.assertEquals((int)1, (int)nType2.asTupleType().getElementTypes().size());
        IndexerTest.assertEquals((Object)nType, (Object)nType2.asTupleType().getElementTypes().get(0));
        IndexerTest.assertEquals((String)"<FuncType=#1:_:<TupleType:[<#1>]>>", (String)nType.toString());
    }

    public void testCircularTypeXInOwnList() throws Exception {
        String string = this.index("test.py", "x = (2,)", "y = [x]", "x = y");
        NType nType = this.idx.lookupQnameType("test.x");
        IndexerTest.assertTrue((boolean)(nType instanceof NUnionType));
        Set<NType> set = nType.asUnionType().getTypes();
        IndexerTest.assertEquals((int)2, (int)set.size());
        NType[] nTypeArray = set.toArray(new NType[2]);
        boolean bl = nTypeArray[0] instanceof NListType;
        boolean bl2 = nTypeArray[1] instanceof NListType;
        IndexerTest.assertTrue((bl || bl2 ? 1 : 0) != 0);
        int n = bl ? 1 : 0;
        IndexerTest.assertTrue((String)("Expected tuple: " + nTypeArray[n]), (boolean)nTypeArray[n].isTupleType());
        IndexerTest.assertEquals((int)1, (int)nTypeArray[n].asTupleType().getElementTypes().size());
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseNum, (Object)nTypeArray[n].asTupleType().getElementTypes().get(0));
        String string2 = nType.toString();
        int n2 = string2.indexOf("<TupleType=#");
        IndexerTest.assertTrue((n2 != -1 ? 1 : 0) != 0);
        int n3 = n2 + "<TupleType=#".length();
        int n4 = Integer.parseInt(string2.substring(n3, n3 + 1));
        String string3 = "<TupleType=#" + n4 + ":[<ClassType:float>]>";
        String string4 = "<#" + n4 + ">";
        if (bl) {
            IndexerTest.assertEquals((String)("<UnionType:[<ListType:" + string3 + ">," + string4 + "]>"), (String)string2);
        } else {
            IndexerTest.assertEquals((String)("<UnionType:[" + string3 + ",<ListType:" + string4 + ">]>"), (String)string2);
        }
    }

    public void testFunReturn() throws Exception {
        String string = this.index("fret.py", "def foo(x): return x", "a = foo('a')", "b = foo('b')", "c = foo('c')");
        NType nType = this.idx.lookupQnameType("fret.foo");
        IndexerTest.assertEquals((String)"<FuncType:_:<UnknownType:null>>", (String)nType.toString());
        NType nType2 = this.idx.lookupQnameType("fret.c");
        IndexerTest.assertEquals((Object)nType2.follow(), (Object)nType.asFuncType().getReturnType());
    }

    public void testListCompForIn() throws Exception {
        String string = this.index("listforin.py", "[line for line in ['foo']]");
        this.assertStringType("listforin.line");
    }

    public void testNoAddToBuiltin() throws Exception {
        String string = this.index("nob.py", "x = [line.rstrip() + '\\n' for line in ['a ']]");
        this.assertStringType("nob.line");
        this.assertCall("__builtin__.str.rstrip", string.indexOf("rstrip"));
        this.assertNoBinding("__builtin__.list.rstrip");
        this.assertListType("nob.x", "__builtin__.str");
    }

    public void testDecoratorSyntax() throws Exception {
        String string = "@deco1";
        String string2 = "@deco2 ('yargh')";
        String string3 = this.index("deco.py", string, string2, "def foo(): pass");
        this.assertFunctionBinding("deco.foo");
        NModule nModule = this.idx.getAstForFile("deco.py");
        IndexerTest.assertNotNull((Object)nModule);
        NNode nNode = (NNode)nModule.body.seq.get(0);
        IndexerTest.assertTrue((boolean)(nNode instanceof NFunctionDef));
        NFunctionDef nFunctionDef = (NFunctionDef)nNode;
        List<NNode> list = nFunctionDef.getDecoratorList();
        IndexerTest.assertNotNull(list);
        IndexerTest.assertEquals((int)2, (int)list.size());
        IndexerTest.assertTrue((boolean)(list.get(0) instanceof NName));
        NName nName = (NName)list.get(0);
        IndexerTest.assertEquals((int)this.nthIndexOf(string3, "deco1", 1), (int)nName.start());
        IndexerTest.assertEquals((int)"deco1".length(), (int)nName.length());
        IndexerTest.assertEquals((String)"deco1", (String)nName.id);
        IndexerTest.assertTrue((boolean)(list.get(1) instanceof NCall));
        NCall nCall = (NCall)list.get(1);
        IndexerTest.assertTrue((boolean)(nCall.func instanceof NName));
        IndexerTest.assertEquals((String)"deco2", (String)((NName)nCall.func).id);
    }

    public void testBasicDecoratorSyntax() throws Exception {
        String string = this.index("deco.py", "def deco1(func): print 'hello'; return func", "@deco1()", "def foo(): pass");
        this.assertFunctionBinding("deco.deco1");
        this.assertFunctionBinding("deco.foo");
        this.assertCall("deco.deco1", this.nthIndexOf(string, "deco1", 2));
    }
}

