/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Outliner {
    public List<Entry> generate(Indexer indexer, String string) throws Exception {
        NModuleType nModuleType = indexer.getModuleForFile(string);
        if (nModuleType == null) {
            return new ArrayList<Entry>();
        }
        return this.generate(nModuleType.getTable(), string);
    }

    public List<Entry> generate(Scope scope, String string) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        TreeSet<NBinding> treeSet = new TreeSet<NBinding>();
        for (NBinding nBinding : scope.values()) {
            if (nBinding.isSynthetic() || nBinding.isBuiltin() || nBinding.getDefs().isEmpty() || !string.equals(nBinding.getSignatureNode().getFile())) continue;
            treeSet.add(nBinding);
        }
        for (NBinding nBinding : treeSet) {
            Object object;
            Def def = nBinding.getSignatureNode();
            List<Entry> list = null;
            if (nBinding.getKind() == NBinding.Kind.CLASS) {
                object = nBinding.followType();
                if (((NType)object).isUnionType()) {
                    for (NType nType : ((NType)object).asUnionType().getTypes()) {
                        if (!nType.isClassType()) continue;
                        object = nType;
                        break;
                    }
                }
                list = this.generate(((NType)object).getTable(), string);
            }
            object = list != null ? new Branch() : new Leaf();
            ((Entry)object).setOffset(def.start());
            ((Entry)object).setQname(nBinding.getQname());
            ((Entry)object).setKind(nBinding.getKind());
            if (list != null) {
                ((Entry)object).setChildren(list);
            }
            arrayList.add((Entry)object);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Branch
    extends Entry {
        private List<Entry> children = new ArrayList<Entry>();

        public Branch() {
        }

        public Branch(String string, int n, NBinding.Kind kind) {
            super(string, n, kind);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isBranch() {
            return true;
        }

        @Override
        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        @Override
        public List<Entry> getChildren() {
            return this.children;
        }

        @Override
        public void setChildren(List<Entry> list) {
            this.children = list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        protected String qname;
        protected int offset;
        protected NBinding.Kind kind;

        public Entry() {
        }

        public Entry(String string, int n, NBinding.Kind kind) {
            this.qname = string;
            this.offset = n;
            this.kind = kind;
        }

        public abstract boolean isLeaf();

        public Leaf asLeaf() {
            return (Leaf)this;
        }

        public abstract boolean isBranch();

        public Branch asBranch() {
            return (Branch)this;
        }

        public abstract boolean hasChildren();

        public abstract List<Entry> getChildren();

        public abstract void setChildren(List<Entry> var1);

        public String getQname() {
            return this.qname;
        }

        public void setQname(String string) {
            if (string == null) {
                throw new IllegalArgumentException("qname param cannot be null");
            }
            this.qname = string;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public NBinding.Kind getKind() {
            return this.kind;
        }

        public void setKind(NBinding.Kind kind) {
            if (kind == null) {
                throw new IllegalArgumentException("kind param cannot be null");
            }
            this.kind = kind;
        }

        public String getName() {
            String[] stringArray = this.qname.split("[.&@%]");
            return stringArray[stringArray.length - 1];
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder, 0);
            return stringBuilder.toString().trim();
        }

        public void toString(StringBuilder stringBuilder, int n) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("  ");
            }
            stringBuilder.append((Object)this.getKind());
            stringBuilder.append(" ");
            stringBuilder.append(this.getName());
            stringBuilder.append("\n");
            if (this.hasChildren()) {
                for (Entry entry : this.getChildren()) {
                    entry.toString(stringBuilder, n + 1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Leaf
    extends Entry {
        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isBranch() {
            return false;
        }

        public Leaf() {
        }

        public Leaf(String string, int n, NBinding.Kind kind) {
            super(string, n, kind);
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public List<Entry> getChildren() {
            return new ArrayList<Entry>();
        }

        @Override
        public void setChildren(List<Entry> list) {
            throw new UnsupportedOperationException("Leaf nodes cannot have children.");
        }
    }
}

