/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.python.indexer.AstCache;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class TestBase
extends TestCase {
    protected static final String TEST_SOURCE_DIR = System.getProperties().getProperty("python.test.source.dir") + "/org/python/indexer/";
    protected static final String TEST_DATA_DIR = TEST_SOURCE_DIR + "data/";
    protected static final String TEST_LIB_DIR = System.getProperties().getProperty("python.home") + "/Lib/";
    protected Indexer idx;

    protected void setUp() throws Exception {
        this.idx = new Indexer();
        this.idx.enableAggressiveAssertions(true);
        this.idx.setProjectDir(TEST_DATA_DIR);
        AstCache.get().clearDiskCache();
        AstCache.get().clear();
    }

    protected void includeStandardLibrary() throws Exception {
        this.idx.addPath(TEST_LIB_DIR);
    }

    protected String abspath(String string) {
        return this.getTestFilePath(string);
    }

    protected String getTestFilePath(String string) {
        return TEST_DATA_DIR + string;
    }

    protected String getSource(String string) throws Exception {
        String string2;
        String string3 = this.getTestFilePath(string);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string3)));
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    protected String makeModule(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    protected String index(String string, String ... stringArray) throws Exception {
        String string2 = this.makeModule(stringArray);
        this.idx.loadString(string, string2);
        this.idx.ready();
        return string2;
    }

    protected int nthIndexOf(String string, String string2, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if ((n2 = string.indexOf(string2, n2 == -1 ? 0 : n2 + 1)) != -1) continue;
            throw new IllegalArgumentException();
        }
        return n2;
    }

    public void testHandleExceptionLoggingNulls() throws Exception {
        try {
            this.idx.enableAggressiveAssertions(false);
            this.idx.getLogger().setLevel(Level.OFF);
            this.idx.handleException(null, new Exception());
            this.idx.handleException("oops", null);
        }
        catch (Throwable throwable) {
            TestBase.fail((String)("should not have thrown: " + throwable));
        }
    }

    public void testDataFileFindable() throws Exception {
        TestBase.assertTrue((String)"Test file not found", (boolean)new File(TEST_DATA_DIR).exists());
    }

    public void testLoadDataFile() throws Exception {
        String string = this.abspath("test-load.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        TestBase.assertEquals((String)bufferedReader.readLine().trim(), (String)"hello");
        bufferedReader.close();
    }

    public void testGetSource() throws Exception {
        String string = this.getSource("testsrc.txt");
        TestBase.assertEquals((String)"one\ntwo\n\nthree\n", (String)string);
    }

    public void testStringModule() throws Exception {
        this.idx.loadString("test-string-module.py", this.makeModule("def foo():", "  pass"));
        this.idx.ready();
        this.assertFunctionBinding("test-string-module.foo");
    }

    public void testNthIndexOf() throws Exception {
        String string = "ab a b ab a\nb aab";
        TestBase.assertEquals((int)0, (int)this.nthIndexOf(string, "ab", 1));
        TestBase.assertEquals((int)7, (int)this.nthIndexOf(string, "ab", 2));
        TestBase.assertEquals((int)15, (int)this.nthIndexOf(string, "ab", 3));
        try {
            TestBase.assertEquals((int)-1, (int)this.nthIndexOf(string, "ab", 0));
            TestBase.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestBase.assertTrue((boolean)true);
        }
        try {
            TestBase.assertEquals((int)-1, (int)this.nthIndexOf(string, "ab", 4));
            TestBase.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestBase.assertTrue((boolean)true);
        }
    }

    public void testIndexerDefaults() throws Exception {
        this.includeStandardLibrary();
        TestBase.assertEquals((String)"wrong project dir", (String)TEST_DATA_DIR, (String)this.idx.projDir);
        TestBase.assertEquals((String)"unexpected load path entries", (int)1, (int)this.idx.path.size());
        TestBase.assertEquals((String)TEST_LIB_DIR, (String)this.idx.path.get(0));
    }

    public String buildIndex(String ... stringArray) throws Exception {
        for (String string : stringArray) {
            this.idx.loadFile(this.abspath(string));
        }
        this.idx.ready();
        return this.getSource(stringArray[0]);
    }

    public NBinding getBinding(String string) throws Exception {
        NBinding nBinding = this.idx.lookupQname(string);
        TestBase.assertNotNull((String)("no binding found for " + string), (Object)nBinding);
        return nBinding;
    }

    public NBinding assertBinding(String string, NBinding.Kind kind) throws Exception {
        NBinding nBinding = this.getBinding(string);
        TestBase.assertEquals((Object)((Object)kind), (Object)((Object)nBinding.getKind()));
        return nBinding;
    }

    public void assertNoBinding(String string) throws Exception {
        NBinding nBinding = this.idx.lookupQname(string);
        TestBase.assertNull((String)("Should not have found binding for " + string), (Object)nBinding);
    }

    public NBinding assertAttributeBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.ATTRIBUTE);
    }

    public NBinding assertBuiltinBinding(String string) throws Exception {
        NBinding nBinding = this.getBinding(string);
        TestBase.assertTrue((boolean)nBinding.isBuiltin());
        return nBinding;
    }

    public NBinding assertClassBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.CLASS);
    }

    public NBinding assertConstructorBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.CONSTRUCTOR);
    }

    public NBinding assertFunctionBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.FUNCTION);
    }

    public NBinding assertMethodBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.METHOD);
    }

    public NBinding assertModuleBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.MODULE);
    }

    public NBinding assertScopeBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.SCOPE);
    }

    public NBinding assertVariableBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.VARIABLE);
    }

    public NBinding assertParamBinding(String string) throws Exception {
        return this.assertBinding(string, NBinding.Kind.PARAMETER);
    }

    public void assertStaticSynthetic(NBinding nBinding) {
        TestBase.assertTrue((boolean)nBinding.isStatic());
        TestBase.assertTrue((boolean)nBinding.isSynthetic());
    }

    public Def getDefinition(String string, int n, int n2) throws Exception {
        NBinding nBinding = this.getBinding(string);
        TestBase.assertNotNull(nBinding.getDefs());
        for (Def def : nBinding.getDefs()) {
            if (n != def.start() || n2 != def.end() - def.start()) continue;
            return def;
        }
        return null;
    }

    public void assertDefinition(String string, int n, int n2) throws Exception {
        Def def = this.getDefinition(string, n, n2);
        if (def == null) {
            TestBase.fail((String)("No definition for " + string + " at " + n + " of len " + n2));
        }
    }

    public void assertNoDefinition(String string, String string2, int n, int n2) throws Exception {
        Def def = this.getDefinition(string2, n, n2);
        TestBase.assertNull((String)string, (Object)def);
    }

    public void assertDefinition(String string, int n) throws Exception {
        String[] stringArray = string.split("[.&@]");
        this.assertDefinition(string, n, stringArray[stringArray.length - 1].length());
    }

    public void assertDefinition(String string, String string2, int n) throws Exception {
        this.assertDefinition(string, n, string2.length());
    }

    public Ref getRefOrNull(String string, int n, int n2) throws Exception {
        NBinding nBinding = this.getBinding(string);
        TestBase.assertNotNull((String)("Null refs list for " + string), nBinding.getRefs());
        for (Ref ref : nBinding.getRefs()) {
            if (n != ref.start() || n2 != ref.length()) continue;
            return ref;
        }
        return null;
    }

    public Ref getRefOrFail(String string, int n, int n2) throws Exception {
        Ref ref = this.getRefOrNull(string, n, n2);
        TestBase.assertNotNull((String)("No reference to " + string + " at offset " + n + " of length " + n2), (Object)ref);
        return ref;
    }

    public void assertReference(String string, int n, int n2) throws Exception {
        TestBase.assertTrue((boolean)this.getRefOrFail(string, n, n2).isRef());
    }

    public void assertReference(String string, int n, String string2) throws Exception {
        this.assertReference(string, n, string2.length());
    }

    public void assertReference(String string, int n) throws Exception {
        String[] stringArray = string.split("[.&@]");
        this.assertReference(string, n, stringArray[stringArray.length - 1]);
    }

    public void assertNoReference(String string, String string2, int n, int n2) throws Exception {
        TestBase.assertNull((String)string, (Object)this.getRefOrNull(string2, n, n2));
    }

    public void assertCall(String string, int n, int n2) throws Exception {
        TestBase.assertTrue((boolean)this.getRefOrFail(string, n, n2).isCall());
    }

    public void assertCall(String string, int n, String string2) throws Exception {
        this.assertCall(string, n, string2.length());
    }

    public void assertCall(String string, int n) throws Exception {
        String[] stringArray = string.split("[.&@]");
        this.assertCall(string, n, stringArray[stringArray.length - 1]);
    }

    public void assertConstructed(String string, int n, int n2) throws Exception {
        TestBase.assertTrue((boolean)this.getRefOrFail(string, n, n2).isNew());
    }

    public void assertConstructed(String string, int n, String string2) throws Exception {
        this.assertConstructed(string, n, string2.length());
    }

    public void assertConstructed(String string, int n) throws Exception {
        String[] stringArray = string.split("[.&@]");
        this.assertConstructed(string, n, stringArray[stringArray.length - 1]);
    }

    public NType getTypeBinding(String string) throws Exception {
        NType nType = this.idx.lookupQnameType(string);
        TestBase.assertNotNull((String)("No recorded type for " + string), (Object)nType);
        return nType;
    }

    public NBinding assertBindingType(String string, String string2) throws Exception {
        NBinding nBinding = this.getBinding(string);
        NType nType = this.getTypeBinding(string2);
        TestBase.assertEquals((String)"Wrong binding type", (Object)nType, (Object)NUnknownType.follow(nBinding.getType()));
        return nBinding;
    }

    public NBinding assertBindingType(String string, Class clazz) throws Exception {
        NBinding nBinding = this.getBinding(string);
        NType nType = NUnknownType.follow(nBinding.getType());
        TestBase.assertTrue((String)("Wrong type: expected " + clazz + " but was " + nType), (boolean)clazz.isInstance(nType));
        return nBinding;
    }

    public void assertListType(String string) throws Exception {
        this.assertListType(string, null);
    }

    public void assertListType(String string, String string2) throws Exception {
        NBinding nBinding = this.getBinding(string);
        NType nType = nBinding.followType();
        TestBase.assertTrue((boolean)nType.isListType());
        if (string2 != null) {
            NType nType2 = this.getTypeBinding(string2);
            TestBase.assertEquals((Object)nType2, (Object)NUnknownType.follow(nType.asListType().getElementType()));
        }
    }

    public void assertStringType(String string) throws Exception {
        this.assertBindingType(string, "__builtin__.str");
    }

    public void assertNumType(String string) throws Exception {
        this.assertBindingType(string, "__builtin__.float");
    }

    public void assertInstanceType(String string, String string2) throws Exception {
        this.assertBindingType(string, string2);
    }
}

