/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class NAttribute
extends NNode {
    static final long serialVersionUID = -1120979305017812255L;
    public NNode target;
    public NName attr;

    public NAttribute(NNode nNode, NName nName) {
        this(nNode, nName, 0, 1);
    }

    public NAttribute(NNode nNode, NName nName, int n, int n2) {
        super(n, n2);
        this.setTarget(nNode);
        this.setAttr(nName);
        this.addChildren(nNode, nName);
    }

    public String getAttributeName() {
        return this.attr.id;
    }

    public void setAttr(NName nName) {
        if (nName == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.attr = nName;
    }

    public NName getAttr() {
        return this.attr;
    }

    public void setTarget(NNode nNode) {
        if (nNode == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.target = nNode;
    }

    public NNode getTarget() {
        return this.target;
    }

    public void setAttr(Scope scope, NType nType) throws Exception {
        this.setType(new NUnknownType());
        NType nType2 = NAttribute.resolveExpr(this.target, scope);
        if (nType2.isUnionType() && (nType2 = nType2.asUnionType().firstKnownNonNullAlternate()) == null) {
            return;
        }
        if ((nType2 = nType2.follow()) == Indexer.idx.builtins.None) {
            return;
        }
        NBinding nBinding = nType2.getTable().putAttr(this.attr.id, this.attr, nType, NBinding.Kind.ATTRIBUTE);
        if (nBinding != null) {
            this.setType(this.attr.setType(nBinding.followType()));
        }
    }

    public NType resolve(Scope scope) throws Exception {
        this.setType(new NUnknownType());
        NType nType = NAttribute.resolveExpr(this.target, scope);
        if (nType.isUnionType()) {
            NType nType2 = new NUnknownType();
            for (NType nType3 : nType.asUnionType().getTypes()) {
                this.resolveAttributeOnType(nType3);
                nType2 = NUnionType.union(nType2, this.getType());
            }
            this.setType(this.attr.setType(nType2.follow()));
        } else {
            this.resolveAttributeOnType(nType);
        }
        return this.getType();
    }

    private void resolveAttributeOnType(NType nType) {
        NType nType2 = nType.follow();
        NBinding nBinding = nType2.getTable().lookupAttr(this.attr.id);
        if (nBinding == null) {
            nBinding = this.makeProvisionalBinding(nType2);
        }
        if (nBinding != null) {
            Indexer.idx.putLocation(this.attr, nBinding);
            this.setType(this.attr.setType(nBinding.getType()));
        }
    }

    private NBinding makeProvisionalBinding(NType nType) {
        if (nType.isNative()) {
            return null;
        }
        Scope scope = nType.getTable();
        if ("".equals(scope.getPath())) {
            return null;
        }
        NUnknownType nUnknownType = new NUnknownType();
        NBinding nBinding = scope.putAttr(this.attr.id, null, nUnknownType, NBinding.Kind.ATTRIBUTE);
        if (nBinding != null) {
            nBinding.setProvisional(true);
            nUnknownType.getTable().setPath(nBinding.getQname());
        }
        return nBinding;
    }

    public String toString() {
        return "<Attribute:" + this.start() + ":" + this.target + "." + this.getAttributeName() + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.target, nNodeVisitor);
            this.visitNode(this.attr, nNodeVisitor);
        }
    }
}

