/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class NBinOp
extends NNode {
    static final long serialVersionUID = -8961832251782335108L;
    public NNode left;
    public NNode right;
    public String op;

    public NBinOp(NNode nNode, NNode nNode2, String string) {
        this(nNode, nNode2, string, 0, 1);
    }

    public NBinOp(NNode nNode, NNode nNode2, String string, int n, int n2) {
        super(n, n2);
        this.left = nNode;
        this.right = nNode2;
        this.op = string;
        this.addChildren(nNode, nNode2);
    }

    public NType resolve(Scope scope) throws Exception {
        NType nType = null;
        NType nType2 = null;
        if (this.left != null) {
            nType = NBinOp.resolveExpr(this.left, scope).follow();
        }
        if (this.right != null) {
            nType2 = NBinOp.resolveExpr(this.right, scope).follow();
        }
        if (nType == Indexer.idx.builtins.BaseStr || nType2 == Indexer.idx.builtins.BaseStr) {
            return this.setType(Indexer.idx.builtins.BaseStr);
        }
        if (nType == Indexer.idx.builtins.BaseNum || nType2 == Indexer.idx.builtins.BaseNum) {
            return this.setType(Indexer.idx.builtins.BaseNum);
        }
        if (nType == null) {
            return this.setType(nType2 == null ? new NUnknownType() : nType2);
        }
        if (nType2 == null) {
            return this.setType(nType == null ? new NUnknownType() : nType);
        }
        return this.setType(NUnionType.union(nType, nType2));
    }

    public String toString() {
        return "<BinOp:" + this.left + " " + this.op + " " + this.right + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.left, nNodeVisitor);
            this.visitNode(this.right, nNodeVisitor);
        }
    }
}

