/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBoolOp
extends NNode {
    static final long serialVersionUID = -5261954056600388069L;
    OpType op;
    public List<NNode> values;

    public NBoolOp(OpType opType, List<NNode> list) {
        this(opType, list, 0, 1);
    }

    public NBoolOp(OpType opType, List<NNode> list, int n, int n2) {
        super(n, n2);
        this.op = opType;
        this.values = list;
        this.addChildren(list);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        if (this.op == OpType.AND) {
            NType nType = null;
            for (NNode nNode : this.values) {
                nType = NBoolOp.resolveExpr(nNode, scope);
            }
            return this.setType(nType == null ? new NUnknownType() : nType);
        }
        return this.setType(this.resolveListAsUnion(this.values, scope));
    }

    public String toString() {
        return "<BoolOp:" + (Object)((Object)this.op) + ":" + this.values + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNodeList(this.values, nNodeVisitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        AND,
        OR,
        UNDEFINED;

    }
}

