/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NKeyword;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCall
extends NNode {
    static final long serialVersionUID = 5212954751978100639L;
    public NNode func;
    public List<NNode> args;
    public List<NKeyword> keywords;
    public NNode kwargs;
    public NNode starargs;

    public NCall(NNode nNode, List<NNode> list, List<NKeyword> list2, NNode nNode2, NNode nNode3) {
        this(nNode, list, list2, nNode2, nNode3, 0, 1);
    }

    public NCall(NNode nNode, List<NNode> list, List<NKeyword> list2, NNode nNode2, NNode nNode3, int n, int n2) {
        super(n, n2);
        this.func = nNode;
        this.args = list;
        this.keywords = list2;
        this.kwargs = nNode2;
        this.starargs = nNode3;
        this.addChildren(nNode, nNode2, nNode3);
        this.addChildren(list);
        this.addChildren(list2);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        NType nType = NCall.resolveExpr(this.func, scope);
        ArrayList<NType> arrayList = new ArrayList<NType>();
        for (NNode object : this.args) {
            arrayList.add(NCall.resolveExpr(object, scope));
        }
        this.resolveList(this.keywords, scope);
        NCall.resolveExpr(this.starargs, scope);
        NCall.resolveExpr(this.kwargs, scope);
        if (nType.isClassType()) {
            return this.setType(nType);
        }
        if (nType.isFuncType()) {
            return this.setType(nType.asFuncType().getReturnType().follow());
        }
        if (nType.isUnknownType()) {
            NUnknownType nUnknownType = new NUnknownType();
            NFuncType nFuncType = new NFuncType(nUnknownType);
            NUnionType.union(nType, nFuncType);
            return this.setType(nUnknownType);
        }
        this.addWarning("calling non-function " + nType);
        return this.setType(new NUnknownType());
    }

    public String toString() {
        return "<Call:" + this.func + ":" + this.args + ":" + this.start() + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.func, nNodeVisitor);
            this.visitNodeList(this.args, nNodeVisitor);
            this.visitNodeList(this.keywords, nNodeVisitor);
            this.visitNode(this.kwargs, nNodeVisitor);
            this.visitNode(this.starargs, nNodeVisitor);
        }
    }
}

