/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Builtins;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NClassDef
extends NNode {
    static final long serialVersionUID = 7513873538009667540L;
    public NName name;
    public List<NNode> bases;
    public NBody body;

    public NClassDef(NName nName, List<NNode> list, NBlock nBlock) {
        this(nName, list, nBlock, 0, 1);
    }

    public NClassDef(NName nName, List<NNode> list, NBlock nBlock, int n, int n2) {
        super(n, n2);
        this.name = nName;
        this.bases = list;
        this.body = new NBody(nBlock);
        this.addChildren(nName, this.body);
        this.addChildren(list);
    }

    @Override
    public boolean isClassDef() {
        return true;
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope scope) throws Exception {
        Scope scope2 = scope.getScopeSymtab();
        this.setType(new NClassType(this.name.id, scope2));
        NType nType = scope2.lookupType(this.name.id);
        if (nType != null && nType.isClassType()) {
            return;
        }
        NameBinder.make(NBinding.Kind.CLASS).bind(scope2, this.name, this.getType());
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        NClassType nClassType = this.getType().asClassType();
        ArrayList<NType> arrayList = new ArrayList<NType>();
        for (NNode nNode : this.bases) {
            NType nType = NClassDef.resolveExpr(nNode, scope);
            if (nType.isClassType()) {
                nClassType.addSuper(nType);
            }
            arrayList.add(nType);
        }
        Builtins builtins = Indexer.idx.builtins;
        this.addSpecialAttribute("__bases__", new NTupleType(arrayList));
        this.addSpecialAttribute("__name__", builtins.BaseStr);
        this.addSpecialAttribute("__module__", builtins.BaseStr);
        this.addSpecialAttribute("__doc__", builtins.BaseStr);
        this.addSpecialAttribute("__dict__", new NDictType(builtins.BaseStr, new NUnknownType()));
        NClassDef.resolveExpr(this.body, this.getTable());
        return this.getType();
    }

    private void addSpecialAttribute(String string, NType nType) {
        NBinding nBinding = this.getTable().update(string, Builtins.newTutUrl("classes.html"), nType, NBinding.Kind.ATTRIBUTE);
        nBinding.markSynthetic();
        nBinding.markStatic();
        nBinding.markReadOnly();
    }

    public String toString() {
        return "<ClassDef:" + this.name.id + ":" + this.start() + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.name, nNodeVisitor);
            this.visitNodeList(this.bases, nNodeVisitor);
            this.visitNode(this.body, nNodeVisitor);
        }
    }
}

