/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NComprehension
extends NNode {
    static final long serialVersionUID = -598250664243757218L;
    public NNode target;
    public NNode iter;
    public List<NNode> ifs;

    public NComprehension(NNode nNode, NNode nNode2, List<NNode> list) {
        this(nNode, nNode2, list, 0, 1);
    }

    public NComprehension(NNode nNode, NNode nNode2, List<NNode> list, int n, int n2) {
        super(n, n2);
        this.target = nNode;
        this.iter = nNode2;
        this.ifs = list;
        this.addChildren(nNode, nNode2);
        this.addChildren(list);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope scope) throws Exception {
        this.bindNames(scope, this.target, NameBinder.make());
    }

    private void bindNames(Scope scope, NNode nNode, NameBinder nameBinder) throws Exception {
        if (nNode instanceof NName) {
            nameBinder.bind(scope, (NName)nNode, (NType)new NUnknownType());
            return;
        }
        if (nNode instanceof NSequence) {
            for (NNode nNode2 : ((NSequence)nNode).getElements()) {
                this.bindNames(scope, nNode2, nameBinder);
            }
        }
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        NameBinder.make().bindIter(scope, this.target, this.iter);
        this.resolveList(this.ifs, scope);
        return this.setType(this.target.getType());
    }

    public String toString() {
        return "<Comprehension:" + this.start() + ":" + this.target + ":" + this.iter + ":" + this.ifs + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.target, nNodeVisitor);
            this.visitNode(this.iter, nNodeVisitor);
            this.visitNodeList(this.ifs, nNodeVisitor);
        }
    }
}

