/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NExceptHandler
extends NNode {
    static final long serialVersionUID = 6215262228266158119L;
    public NNode name;
    public NNode exceptionType;
    public NBlock body;

    public NExceptHandler(NNode nNode, NNode nNode2, NBlock nBlock) {
        this(nNode, nNode2, nBlock, 0, 1);
    }

    public NExceptHandler(NNode nNode, NNode nNode2, NBlock nBlock, int n, int n2) {
        super(n, n2);
        this.name = nNode;
        this.exceptionType = nNode2;
        this.body = nBlock;
        this.addChildren(nNode, nNode2, nBlock);
    }

    public boolean bindsName() {
        return true;
    }

    protected void bindNames(Scope scope) throws Exception {
        if (this.name != null) {
            NameBinder.make().bind(scope, this.name, (NType)new NUnknownType());
        }
    }

    public NType resolve(Scope scope) throws Exception {
        NType nType = new NUnknownType();
        if (this.exceptionType != null) {
            nType = NExceptHandler.resolveExpr(this.exceptionType, scope);
        }
        if (this.name != null) {
            NameBinder.make().bind(scope, this.name, nType);
        }
        if (this.body != null) {
            return this.setType(NExceptHandler.resolveExpr(this.body, scope));
        }
        return this.setType(new NUnknownType());
    }

    public String toString() {
        return "<ExceptHandler:" + this.start() + ":" + this.name + ":" + this.exceptionType + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.name, nNodeVisitor);
            this.visitNode(this.exceptionType, nNodeVisitor);
            this.visitNode(this.body, nNodeVisitor);
        }
    }
}

