/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Builtins;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFunctionDef
extends NNode {
    static final long serialVersionUID = 5495886181960463846L;
    public NName name;
    public List<NNode> args;
    public List<NNode> defaults;
    public NName varargs;
    public NName kwargs;
    public NNode body;
    private List<NNode> decoratorList;

    public NFunctionDef(NName nName, List<NNode> list, NBlock nBlock, List<NNode> list2, NName nName2, NName nName3) {
        this(nName, list, nBlock, list2, nName3, nName2, 0, 1);
    }

    public NFunctionDef(NName nName, List<NNode> list, NBlock nBlock, List<NNode> list2, NName nName2, NName nName3, int n, int n2) {
        super(n, n2);
        this.name = nName;
        this.args = list;
        this.body = nBlock != null ? new NBody(nBlock) : new NBlock(null);
        this.defaults = list2;
        this.varargs = nName2;
        this.kwargs = nName3;
        this.addChildren(nName);
        this.addChildren(list);
        this.addChildren(list2);
        this.addChildren(nName2, nName3, this.body);
    }

    public void setDecoratorList(List<NNode> list) {
        this.decoratorList = list;
        this.addChildren(list);
    }

    public List<NNode> getDecoratorList() {
        if (this.decoratorList == null) {
            this.decoratorList = new ArrayList<NNode>();
        }
        return this.decoratorList;
    }

    @Override
    public boolean isFunctionDef() {
        return true;
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    protected String getBindingName(Scope scope) {
        return this.name.id;
    }

    @Override
    protected void bindNames(Scope scope) throws Exception {
        Scope scope2 = scope.getScopeSymtab();
        this.setType(new NFuncType());
        Scope scope3 = new Scope(scope.getEnclosingLexicalScope(), Scope.Type.FUNCTION);
        this.getType().setTable(scope3);
        scope3.setPath(scope2.extendPath(this.getBindingName(scope2)));
        NType nType = scope2.lookupType(this.getBindingName(scope2), true);
        if (nType != null && nType.isFuncType()) {
            return;
        }
        this.bindFunctionName(scope2);
        this.bindFunctionParams(scope3);
        this.bindFunctionDefaults(scope);
        this.bindMethodAttrs(scope2);
    }

    protected void bindFunctionName(Scope scope) throws Exception {
        NBinding.Kind kind = NBinding.Kind.FUNCTION;
        if (scope.getScopeType() == Scope.Type.CLASS) {
            kind = "__init__".equals(this.name.id) ? NBinding.Kind.CONSTRUCTOR : NBinding.Kind.METHOD;
        }
        NameBinder.make(kind).bindName(scope, this.name, this.getType());
    }

    protected void bindFunctionParams(Scope scope) throws Exception {
        NameBinder nameBinder = NameBinder.make(NBinding.Kind.PARAMETER);
        for (NNode nNode : this.args) {
            nameBinder.bind(scope, nNode, (NType)new NUnknownType());
        }
        if (this.varargs != null) {
            nameBinder.bind(scope, this.varargs, (NType)new NListType());
        }
        if (this.kwargs != null) {
            nameBinder.bind(scope, this.kwargs, (NType)new NDictType());
        }
    }

    protected void bindFunctionDefaults(Scope scope) throws Exception {
        for (NNode nNode : this.defaults) {
            if (!nNode.bindsName()) continue;
            nNode.bindNames(scope);
        }
    }

    protected void bindMethodAttrs(Scope scope) throws Exception {
        NType nType = Indexer.idx.lookupQnameType(scope.getPath());
        if (nType == null || !nType.isClassType()) {
            return;
        }
        this.addReadOnlyAttr("im_class", nType, NBinding.Kind.CLASS);
        this.addReadOnlyAttr("__class__", nType, NBinding.Kind.CLASS);
        this.addReadOnlyAttr("im_self", nType, NBinding.Kind.ATTRIBUTE);
        this.addReadOnlyAttr("__self__", nType, NBinding.Kind.ATTRIBUTE);
    }

    protected NBinding addSpecialAttr(String string, NType nType, NBinding.Kind kind) {
        NBinding nBinding = this.getTable().update(string, Builtins.newDataModelUrl("the-standard-type-hierarchy"), nType, kind);
        nBinding.markSynthetic();
        nBinding.markStatic();
        return nBinding;
    }

    protected NBinding addReadOnlyAttr(String string, NType nType, NBinding.Kind kind) {
        NBinding nBinding = this.addSpecialAttr(string, nType, kind);
        nBinding.markReadOnly();
        return nBinding;
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        Object object;
        this.resolveList(this.defaults, scope);
        this.resolveList(this.decoratorList, scope);
        Scope scope2 = this.getTable();
        NBinding nBinding = scope2.lookup("__self__");
        if (nBinding != null && !nBinding.getType().isClassType()) {
            nBinding = null;
        }
        if (nBinding != null) {
            if (this.args.size() < 1) {
                this.addWarning(this.name, "method should have at least one argument (self)");
            } else if (!(this.args.get(0) instanceof NName)) {
                this.addError(this.name, "self parameter must be an identifier");
            }
        }
        NTupleType nTupleType = new NTupleType();
        this.bindParamsToDefaults(nBinding, nTupleType);
        if (this.varargs != null && (object = scope2.lookupLocal(this.varargs.id)) != null) {
            nTupleType.add(((NBinding)object).getType());
        }
        if (this.kwargs != null && (object = scope2.lookupLocal(this.kwargs.id)) != null) {
            nTupleType.add(((NBinding)object).getType());
        }
        object = NFunctionDef.resolveExpr(this.body, scope2);
        this.getType().asFuncType().setReturnType((NType)object);
        return this.getType();
    }

    private void bindParamsToDefaults(NBinding nBinding, NTupleType nTupleType) throws Exception {
        NameBinder nameBinder = NameBinder.make(NBinding.Kind.PARAMETER);
        Scope scope = this.getTable();
        for (int i = 0; i < this.args.size(); ++i) {
            NNode nNode = this.args.get(i);
            NType nType = i == 0 && nBinding != null ? nBinding.getType() : NFunctionDef.getArgType(this.args, this.defaults, i);
            nameBinder.bind(scope, nNode, nType);
            nTupleType.add(nType);
        }
    }

    static NType getArgType(List<NNode> list, List<NNode> list2, int n) {
        if (list2 == null) {
            return new NUnknownType();
        }
        int n2 = list.size() - list2.size();
        if (n2 >= 0 && n >= n2) {
            return list2.get(n - n2).getType();
        }
        return new NUnknownType();
    }

    public String toString() {
        return "<Function:" + this.start() + ":" + this.name + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.name, nNodeVisitor);
            this.visitNodeList(this.args, nNodeVisitor);
            this.visitNodeList(this.defaults, nNodeVisitor);
            this.visitNode(this.kwargs, nNodeVisitor);
            this.visitNode(this.varargs, nNodeVisitor);
            this.visitNode(this.body, nNodeVisitor);
        }
    }
}

