/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import java.util.Map;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NImport;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NImportFrom
extends NNode {
    static final long serialVersionUID = 5070549408963950138L;
    public String module;
    public NQname qname;
    public List<NAlias> aliases;

    public NImportFrom(String string, NQname nQname, List<NAlias> list) {
        this(string, nQname, list, 0, 1);
    }

    public NImportFrom(String string, NQname nQname, List<NAlias> list, int n, int n2) {
        super(n, n2);
        this.module = string;
        this.qname = nQname;
        this.aliases = list;
        this.addChildren(nQname);
        this.addChildren(list);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope scope) throws Exception {
        if (this.isImportStar()) {
            return;
        }
        NImport.bindAliases(scope, this.aliases);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        Scope scope2 = scope.getScopeSymtab();
        NImportFrom.resolveExpr(this.qname, scope);
        NType nType = this.qname.getBottom().getType();
        if (!nType.isModuleType()) {
            return this.setType(new NUnknownType());
        }
        NModuleType nModuleType = (NModuleType)nType;
        this.setType(nModuleType);
        NImport.addReferences(scope, this.qname, false);
        if (this.isImportStar()) {
            this.importStar(scope, nModuleType);
            return this.getType();
        }
        for (NAlias nAlias : this.aliases) {
            this.resolveAlias(scope2, nModuleType, nAlias);
        }
        return this.getType();
    }

    public boolean isImportStar() {
        return this.aliases.size() == 1 && "*".equals(this.aliases.get((int)0).name);
    }

    private void resolveAlias(Scope scope, NModuleType nModuleType, NAlias nAlias) throws Exception {
        String string;
        Object object;
        NBinding nBinding = nModuleType.getTable().lookup(nAlias.name);
        if (nBinding == null && (object = Indexer.idx.loadModule(string = this.qname.toQname() + "." + nAlias.qname.toQname())) != null) {
            nBinding = Indexer.idx.lookupQname(((NType)object).getTable().getPath());
        }
        if (nBinding == null) {
            this.addError(nAlias, "name " + nAlias.qname.getName().id + " not found in module " + this.module);
            return;
        }
        string = nAlias.qname.getName().id;
        object = nAlias.aname != null ? nAlias.aname.id : null;
        Indexer.idx.putLocation(nAlias.qname.getName(), nBinding);
        if (object != null) {
            Indexer.idx.putLocation(nAlias.aname, nBinding);
            scope.put((String)object, nBinding);
        } else {
            scope.put(string, nBinding);
        }
    }

    private void importStar(Scope scope, NModuleType nModuleType) throws Exception {
        if (nModuleType == null || nModuleType.getFile() == null) {
            return;
        }
        NModule nModule = Indexer.idx.getAstForFile(nModuleType.getFile());
        if (nModule == null) {
            return;
        }
        List<String> list = nModule.getExportedNames();
        if (!list.isEmpty()) {
            for (String string : list) {
                NBinding nBinding = nModuleType.getTable().lookupLocal(string);
                if (nBinding == null) continue;
                scope.put(string, nBinding);
            }
        } else {
            for (Map.Entry<String, NBinding> entry : nModuleType.getTable().entrySet()) {
                if (entry.getKey().startsWith("_")) continue;
                scope.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String toString() {
        return "<FromImport:" + this.module + ":" + this.aliases + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.qname, nNodeVisitor);
            this.visitNodeList(this.aliases, nNodeVisitor);
        }
    }
}

