/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NList
extends NSequence {
    static final long serialVersionUID = 6623743056841822992L;

    public NList(List<NNode> list) {
        this(list, 0, 1);
    }

    public NList(List<NNode> list, int n, int n2) {
        super(list, n, n2);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        if (this.elts.size() == 0) {
            return this.setType(new NListType());
        }
        NListType nListType = null;
        for (NNode nNode : this.elts) {
            if (nListType == null) {
                nListType = new NListType(NList.resolveExpr(nNode, scope));
                continue;
            }
            nListType.add(NList.resolveExpr(nNode, scope));
        }
        if (nListType != null) {
            this.setType(nListType);
        }
        return this.getType();
    }

    public String toString() {
        return "<List:" + this.start() + ":" + this.elts + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNodeList(this.elts, nNodeVisitor);
        }
    }
}

