/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NAssign;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NStr;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NModule
extends NNode {
    static final long serialVersionUID = -7737089963380450802L;
    public String name;
    public NBody body;
    private String file;
    private String md5;

    public NModule() {
    }

    public NModule(String string) {
        this.name = string;
    }

    public NModule(NBlock nBlock, int n, int n2) {
        super(n, n2);
        this.body = new NBody(nBlock);
        this.addChildren(this.body);
    }

    public void setFile(String string) throws Exception {
        this.file = string;
        this.name = Util.moduleNameFor(string);
        this.md5 = Util.getMD5(new File(string));
    }

    public void setFile(File file) throws Exception {
        this.file = file.getCanonicalPath();
        this.name = Util.moduleNameFor(this.file);
        this.md5 = Util.getMD5(file);
    }

    public void setFileAndMD5(String string, String string2) throws Exception {
        this.file = string;
        this.name = Util.moduleNameFor(this.file);
        this.md5 = string2;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public String getMD5() {
        return this.md5;
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        NBinding nBinding = Indexer.idx.moduleTable.lookupLocal(this.file);
        if (nBinding == null) {
            Indexer.idx.reportFailedAssertion("No module for " + this.name + ": " + this.file);
            this.setType(new NModuleType(this.name, this.file, scope));
        } else {
            this.setType(nBinding.getType());
        }
        NModule.resolveExpr(this.body, this.getTable());
        this.resolveExportedNames();
        return this.getType();
    }

    private void resolveExportedNames() throws Exception {
        NModuleType nModuleType = null;
        NType nType = this.getType();
        if (nType.isModuleType()) {
            nModuleType = nType.asModuleType();
        } else if (nType.isUnionType()) {
            for (NType object : nType.asUnionType().getTypes()) {
                if (!object.isModuleType()) continue;
                nModuleType = object.asModuleType();
                break;
            }
        }
        if (nModuleType == null) {
            Indexer.idx.reportFailedAssertion("Found non-module type for " + this + " in " + this.getFile() + ": " + nType);
            return;
        }
        Scope scope = nModuleType.getTable();
        for (NStr nStr : this.getExportedNameNodes()) {
            String string = nStr.n.toString();
            NBinding nBinding = scope.lookupLocal(string);
            if (nBinding == null) continue;
            Indexer.idx.putLocation(nStr, nBinding);
        }
    }

    public List<String> getExportedNames() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.getType().isModuleType()) {
            return arrayList;
        }
        for (NStr nStr : this.getExportedNameNodes()) {
            arrayList.add(nStr.n.toString());
        }
        return arrayList;
    }

    public List<NStr> getExportedNameNodes() throws Exception {
        ArrayList<NStr> arrayList = new ArrayList<NStr>();
        if (!this.getType().isModuleType()) {
            return arrayList;
        }
        NBinding nBinding = this.getTable().lookupLocal("__all__");
        if (nBinding == null) {
            return arrayList;
        }
        Def def = nBinding.getSignatureNode();
        if (def == null) {
            return arrayList;
        }
        NNode nNode = this.getDeepestNodeAtOffset(def.start());
        if (!(nNode instanceof NName)) {
            return arrayList;
        }
        NNode nNode2 = nNode.getParent();
        if (!(nNode2 instanceof NAssign)) {
            return arrayList;
        }
        NNode nNode3 = ((NAssign)nNode2).rvalue;
        if (!(nNode3 instanceof NList)) {
            return arrayList;
        }
        for (NNode nNode4 : ((NList)nNode3).elts) {
            if (!(nNode4 instanceof NStr)) continue;
            NStr nStr = (NStr)nNode4;
            if (nStr.n == null) continue;
            arrayList.add(nStr);
        }
        return arrayList;
    }

    public String toLongString() {
        return "<Module:" + this.body + ">";
    }

    public String toString() {
        return "<Module:" + this.getFile() + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.body, nNodeVisitor);
        }
    }
}

