/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.File;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NQname
extends NNode {
    static final long serialVersionUID = -5892553606852895686L;
    private NQname next;
    private NName name;

    public NQname(NQname nQname, NName nName) {
        this(nQname, nName, 0, 1);
    }

    public NQname(NQname nQname, NName nName, int n, int n2) {
        super(n, n2);
        if (nName == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = nName;
        this.next = nQname;
        this.addChildren(nName, nQname);
    }

    public NName getName() {
        return this.name;
    }

    public NQname getPrevious() {
        NNode nNode = this.getParent();
        if (nNode instanceof NQname) {
            return (NQname)nNode;
        }
        return null;
    }

    public NQname getNext() {
        return this.next;
    }

    public NQname getBottom() {
        return this.next == null ? this : this.next.getBottom();
    }

    public boolean isTop() {
        return this.getPrevious() == null;
    }

    public boolean isBottom() {
        return this.next == null;
    }

    public boolean isUnqualified() {
        return this.isTop() && this.isBottom();
    }

    public String toQname() {
        return this.isBottom() ? this.name.id : this.name.id + "." + this.next.toQname();
    }

    public String thisQname() {
        NQname nQname = this.getTop();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nQname.name.id);
        while (nQname != this) {
            stringBuilder.append(".");
            nQname = nQname.next;
            stringBuilder.append(nQname.name.id);
        }
        return stringBuilder.toString();
    }

    public NQname getTop() {
        return this.isTop() ? this : this.getPrevious().getTop();
    }

    public boolean isDot() {
        return ".".equals(this.name.id);
    }

    public NType resolve(Scope scope) throws Exception {
        this.setType(this.name.setType(new NUnknownType()));
        if (this.isUnqualified()) {
            NModuleType nModuleType = Indexer.idx.loadModule(this.name.id);
            if (nModuleType != null) {
                return this.setType(this.name.setType(nModuleType));
            }
        } else {
            NModuleType nModuleType = Indexer.idx.getBuiltinModule(this.thisQname());
            if (nModuleType != null) {
                this.setType(this.name.setType(nModuleType));
                NQname.resolveExpr(this.next, scope);
                return nModuleType;
            }
        }
        return this.resolveInFilesystem(scope);
    }

    private NType resolveInFilesystem(Scope scope) throws Exception {
        Object object;
        String string;
        NModuleType nModuleType = this.getStartModule(scope);
        if (nModuleType == null) {
            this.reportUnresolvedModule();
            return this.getType();
        }
        String string2 = nModuleType.getTable().getPath();
        if (this.isDot()) {
            string = Util.getQnameParent(string2);
        } else if (!this.isTop()) {
            string = string2 + "." + this.name.id;
        } else {
            object = this.isInitPy() ? string2 : Util.getQnameParent(string2);
            string = (String)object + "." + this.name.id;
            if (Indexer.idx.loadModule(string) == null) {
                string = this.name.id;
            }
        }
        object = Indexer.idx.loadModule(string);
        if (object == null) {
            this.reportUnresolvedModule();
            return this.getType();
        }
        this.setType(this.name.setType((NType)object));
        if (!this.isTop() && ((NModuleType)object).getFile() != null) {
            Scope scope2 = this.getPrevious().getTable();
            NBinding nBinding = Indexer.idx.moduleTable.lookup(((NModuleType)object).getFile());
            scope2.put(this.name.id, nBinding);
        }
        NQname.resolveExpr(this.next, scope);
        return this.getType();
    }

    private boolean isInitPy() {
        String string = this.getFile();
        if (string == null) {
            return false;
        }
        return new File(string).getName().equals("__init__.py");
    }

    private NModuleType getStartModule(Scope scope) throws Exception {
        if (!this.isTop()) {
            return this.getPrevious().getType().asModuleType();
        }
        NModuleType nModuleType = null;
        Scope scope2 = scope.getSymtabOfType(Scope.Type.MODULE);
        if (scope2 != null && (nModuleType = Indexer.idx.loadModule(scope2.getPath())) != null) {
            return nModuleType;
        }
        String string = new File(this.getFile()).getParent();
        if (string == null) {
            Indexer.idx.warn("Unable to find parent dir for " + this.getFile());
            return null;
        }
        return Indexer.idx.loadModule(string);
    }

    private void reportUnresolvedModule() {
        this.addError("module not found: " + this.name.id);
        Indexer.idx.recordUnresolvedModule(this.thisQname(), this.getFile());
    }

    public String toString() {
        return "<QName:" + this.name + ":" + this.next + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.next, nNodeVisitor);
            this.visitNode(this.name, nNodeVisitor);
        }
    }
}

