/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NIndex;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NSubscript
extends NNode {
    static final long serialVersionUID = -493854491438387425L;
    public NNode value;
    public NNode slice;

    public NSubscript(NNode nNode, NNode nNode2) {
        this(nNode, nNode2, 0, 1);
    }

    public NSubscript(NNode nNode, NNode nNode2, int n, int n2) {
        super(n, n2);
        this.value = nNode;
        this.slice = nNode2;
        this.addChildren(nNode, nNode2);
    }

    public NType resolve(Scope scope) throws Exception {
        NType nType = NSubscript.resolveExpr(this.value, scope);
        NType nType2 = NSubscript.resolveExpr(this.slice, scope);
        if (nType.isUnknownType()) {
            if (nType2.isListType()) {
                return this.setType(nType);
            }
            return this.setType(new NUnknownType());
        }
        if (nType2.isListType()) {
            NType nType3 = nType.getTable().lookupTypeAttr("__getslice__");
            if (nType3 == null) {
                this.addError("The type can't be sliced: " + nType);
                return this.setType(new NUnknownType());
            }
            if (!nType3.isFuncType()) {
                this.addError("The type's __getslice__ method is not a function: " + nType3);
                return this.setType(new NUnknownType());
            }
            return this.setType(nType3.asFuncType().getReturnType().follow());
        }
        if (this.slice instanceof NIndex) {
            if (nType.isListType()) {
                this.warnUnlessNumIndex(nType2);
                return this.setType(nType.asListType().getElementType());
            }
            if (nType.isTupleType()) {
                this.warnUnlessNumIndex(nType2);
                return this.setType(nType.asTupleType().toListType().getElementType());
            }
            if (nType.isStrType()) {
                this.warnUnlessNumIndex(nType2);
                return this.setType(Indexer.idx.builtins.BaseStr);
            }
            if (nType.isDictType()) {
                if (!nType2.follow().equals(nType.asDictType().getKeyType())) {
                    this.addWarning("Possible KeyError (wrong type for subscript)");
                }
                return this.setType(nType.asDictType().getValueType());
            }
        }
        if (nType.isUnionType()) {
            for (NType nType4 : nType.asUnionType().getTypes()) {
                NType nType5 = nType.getTable().lookupTypeAttr("__getitem__");
                if (nType5 == null) continue;
                return this.setType(this.get__getitem__type(nType5, nType5));
            }
        }
        NType nType6 = nType.getTable().lookupTypeAttr("__getitem__");
        return this.setType(this.get__getitem__type(nType6, nType));
    }

    private void warnUnlessNumIndex(NType nType) {
        NType nType2 = nType.follow();
        if (!nType2.isNumType() && !nType2.isUnknownType()) {
            this.addWarning("Possible KeyError: subscript should be a number; found " + nType2);
        }
    }

    private NType get__getitem__type(NType nType, NType nType2) {
        if (nType == null) {
            this.addError("indexing type without __getitem__ method: " + nType2);
            return new NUnknownType();
        }
        if (!nType.isFuncType()) {
            this.addError("The type's __getitem__ method is not a function: " + nType);
            return new NUnknownType();
        }
        return nType.asFuncType().getReturnType().follow();
    }

    public String toString() {
        return "<Subscript:" + this.value + ":" + this.slice + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.value, nNodeVisitor);
            this.visitNode(this.slice, nNodeVisitor);
        }
    }
}

