/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NSubscript;
import org.python.indexer.ast.NTuple;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBinder {
    private static final NameBinder DEFAULT_BINDER = new NameBinder();
    private static final NameBinder ATTRIBUTE_BINDER = new NameBinder(NBinding.Kind.ATTRIBUTE);
    private static final NameBinder CLASS_BINDER = new NameBinder(NBinding.Kind.CLASS);
    private static final NameBinder CONSTRUCTOR_BINDER = new NameBinder(NBinding.Kind.CONSTRUCTOR);
    private static final NameBinder FUNCTION_BINDER = new NameBinder(NBinding.Kind.FUNCTION);
    private static final NameBinder METHOD_BINDER = new NameBinder(NBinding.Kind.METHOD);
    private static final NameBinder MODULE_BINDER = new NameBinder(NBinding.Kind.MODULE);
    private static final NameBinder PARAMETER_BINDER = new NameBinder(NBinding.Kind.PARAMETER);
    private static final NameBinder VARIABLE_BINDER = new NameBinder(NBinding.Kind.VARIABLE);
    private NBinding.Kind kind;

    public static NameBinder make() {
        return DEFAULT_BINDER;
    }

    public static NameBinder make(NBinding.Kind kind) {
        switch (kind) {
            case ATTRIBUTE: {
                return ATTRIBUTE_BINDER;
            }
            case CLASS: {
                return CLASS_BINDER;
            }
            case CONSTRUCTOR: {
                return CONSTRUCTOR_BINDER;
            }
            case FUNCTION: {
                return FUNCTION_BINDER;
            }
            case METHOD: {
                return METHOD_BINDER;
            }
            case MODULE: {
                return MODULE_BINDER;
            }
            case PARAMETER: {
                return PARAMETER_BINDER;
            }
            case VARIABLE: {
                return VARIABLE_BINDER;
            }
        }
        return DEFAULT_BINDER;
    }

    private NameBinder() {
    }

    private NameBinder(NBinding.Kind kind) {
        this.kind = kind;
    }

    public void bind(Scope scope, NNode nNode, NType nType) throws Exception {
        if (nNode instanceof NName) {
            this.bindName(scope, (NName)nNode, nType);
            return;
        }
        if (nNode instanceof NTuple) {
            this.bind(scope, ((NTuple)nNode).elts, nType);
            return;
        }
        if (nNode instanceof NList) {
            this.bind(scope, ((NList)nNode).elts, nType);
            return;
        }
        if (nNode instanceof NAttribute) {
            if (!scope.isNameBindingPhase()) {
                ((NAttribute)nNode).setAttr(scope, nType);
            }
            return;
        }
        if (nNode instanceof NSubscript) {
            if (!scope.isNameBindingPhase()) {
                NNode.resolveExpr(nNode, scope);
            }
            return;
        }
        Indexer.idx.putProblem(nNode, "invalid location for assignment");
    }

    public void bind(Scope scope, List<NNode> list, NType nType) throws Exception {
        if (nType.isTupleType()) {
            List<NType> list2 = nType.asTupleType().getElementTypes();
            if (list.size() != list2.size()) {
                this.reportUnpackMismatch(list, list2.size());
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.bind(scope, list.get(i), list2.get(i));
                }
            }
            return;
        }
        if (nType.isListType()) {
            this.bind(scope, list, (NType)nType.asListType().toTupleType(list.size()));
            return;
        }
        if (nType.isDictType()) {
            this.bind(scope, list, (NType)nType.asDictType().toTupleType(list.size()));
            return;
        }
        if (!nType.isUnknownType()) {
            Indexer.idx.putProblem(list.get(0).getFile(), list.get(0).start(), list.get(list.size() - 1).end(), "unpacking non-iterable: " + nType);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.bind(scope, list.get(i), (NType)new NUnknownType());
        }
    }

    public NBinding bindName(Scope scope, NName nName, NType nType) throws Exception {
        Object object;
        NBinding nBinding;
        if (scope.isGlobalName(nName.id)) {
            nBinding = scope.getGlobalTable().put(nName.id, nName, nType, this.kindOr(NBinding.Kind.SCOPE));
            Indexer.idx.putLocation(nName, nBinding);
        } else {
            object = scope.getScopeSymtab();
            nBinding = ((Scope)object).put(nName.id, nName, nType, this.kindOr(((Scope)object).isFunctionScope() ? NBinding.Kind.VARIABLE : NBinding.Kind.SCOPE));
        }
        nName.setType(nBinding.followType());
        object = nName.getType();
        if (!((NType)object).isModuleType() && !((NType)object).isClassType()) {
            ((NType)object).getTable().setPath(nBinding.getQname());
        }
        return nBinding;
    }

    public void bindIter(Scope scope, NNode nNode, NNode nNode2) throws Exception {
        NType nType = NNode.resolveExpr(nNode2, scope);
        if (nType.isListType()) {
            this.bind(scope, nNode, nType.asListType().getElementType());
        } else if (nType.isTupleType()) {
            this.bind(scope, nNode, nType.asTupleType().toListType().getElementType());
        } else {
            NBinding nBinding = nType.getTable().lookupAttr("__iter__");
            if (nBinding == null || !nBinding.getType().isFuncType()) {
                if (!nType.isUnknownType()) {
                    nNode2.addWarning("not an iterable type: " + nType);
                }
                this.bind(scope, nNode, (NType)new NUnknownType());
            } else {
                this.bind(scope, nNode, nBinding.getType().asFuncType().getReturnType());
            }
        }
    }

    private void reportUnpackMismatch(List<NNode> list, int n) {
        int n2 = list.size();
        int n3 = list.get(0).start();
        int n4 = list.get(list.size() - 1).end();
        int n5 = n2 - n;
        String string = n5 > 0 ? "ValueError: need more than " + n + " values to unpack" : "ValueError: too many values to unpack";
        Indexer.idx.putProblem(list.get(0).getFile(), n3, n4, string);
    }

    private NBinding.Kind kindOr(NBinding.Kind kind) {
        return this.kind != null ? this.kind : kind;
    }
}

