/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.Scope;
import org.python.indexer.StyleRun;
import org.python.indexer.ast.NStr;
import org.python.indexer.demos.Linker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocStringParser {
    private static final int MIN_TYPE_NAME_LENGTH = 4;
    private static final String IDENT = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final Pattern TYPE_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*\\.[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)*\\b|\\b[A-Z][a-zA-Z0-9_]*?[a-z][a-zA-Z0-9_]*\\b|(?<![a-zA-Z0-9_])?__[a-zA-Z][a-zA-Z_]*?__");
    private boolean resolveReferences = true;
    private int docOffset;
    private String docString;
    private NStr docNode;
    private Scope scope;
    private String file;
    private Set<Integer> offsets = new HashSet<Integer>();
    private List<StyleRun> styles = new ArrayList<StyleRun>();
    private Linker linker;

    public DocStringParser(String string, NStr nStr, Linker linker) {
        this.docOffset = nStr.start();
        this.docString = string;
        this.docNode = nStr;
        this.scope = nStr.getEnclosingNamespace();
        this.file = nStr.getFile();
        this.linker = linker;
    }

    public void setResolveReferences(boolean bl) {
        this.resolveReferences = bl;
    }

    public boolean isResolvingReferences() {
        return this.resolveReferences;
    }

    public List<StyleRun> highlight() {
        if (this.resolveReferences) {
            this.scanCommentForTypeNames();
        }
        return this.styles;
    }

    private void scanCommentForTypeNames() {
        Matcher matcher = TYPE_NAME.matcher(this.docString);
        while (matcher.find()) {
            String string = matcher.group();
            int n = matcher.start() + this.docOffset;
            if (this.offsets.contains(n) || string.length() < 4) continue;
            this.checkForReference(n, string);
        }
    }

    private void checkForReference(int n, String string) {
        NBinding nBinding;
        if (string.indexOf(46) == -1) {
            nBinding = this.scope.lookup(string);
            if (nBinding == null) {
                nBinding = Indexer.idx.globaltable.lookup(string);
            }
        } else {
            nBinding = Indexer.idx.lookupQname(string);
        }
        if (nBinding != null) {
            this.linker.processRef(new Ref(this.file, n, string), nBinding);
        }
    }

    private void addStyle(int n, int n2, NBinding nBinding) {
        this.addStyle(n, n2, StyleRun.Type.TYPE_NAME);
        this.offsets.add(n);
    }

    private void addStyle(int n, int n2, StyleRun.Type type) {
        this.styles.add(new StyleRun(type, n, n2));
        this.offsets.add(n);
    }
}

