/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.io.File;
import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.StyleRun;
import org.python.indexer.Util;
import org.python.indexer.demos.HtmlOutline;
import org.python.indexer.demos.Linker;
import org.python.indexer.demos.StyleApplier;
import org.python.indexer.demos.Styler;

public class HtmlDemo {
    private static final File OUTPUT_DIR = new File(new File("./html").getAbsolutePath());
    private static final String CSS = ".builtin {color: #5b4eaf;}\n.comment, .block-comment {color: #005000; font-style: italic;}\n.constant {color: #888888;}\n.decorator {color: #778899;}\n.doc-string {color: #005000;}\n.error {border-bottom: 1px solid red;}\n.field-name {color: #2e8b57;}\n.function {color: #880000;}\n.identifier {color: #8b7765;}\n.info {border-bottom: 1px dotted RoyalBlue;}\n.keyword {color: #0000cd;}\n.lineno {color: #aaaaaa;}\n.number {color: #483d8b;}\n.parameter {color: #2e8b57;}\n.string {color: #4169e1;}\n.type-name {color: #4682b4;}\n.warning {border-bottom: 1px dotted orange;}\n";
    private Indexer indexer;
    private File rootDir;
    private String rootPath;
    private Linker linker;

    private void makeOutputDir() throws Exception {
        if (!OUTPUT_DIR.exists()) {
            OUTPUT_DIR.mkdirs();
            HtmlDemo.info("created directory: " + OUTPUT_DIR.getAbsolutePath());
        }
    }

    private void start(File file, File file2) throws Exception {
        this.rootDir = file2.isFile() ? file2.getParentFile() : file2;
        this.rootPath = this.rootDir.getCanonicalPath();
        this.indexer = new Indexer();
        this.indexer.addPath(file.getCanonicalPath());
        HtmlDemo.info("building index...");
        this.indexer.loadFileRecursive(file2.getCanonicalPath());
        this.indexer.ready();
        HtmlDemo.info(this.indexer.getStatusReport());
        this.generateHtml();
    }

    private void generateHtml() throws Exception {
        HtmlDemo.info("generating html...");
        this.makeOutputDir();
        this.linker = new Linker(this.rootPath, OUTPUT_DIR);
        this.linker.findLinks(this.indexer);
        int n = this.rootPath.length();
        for (String string : this.indexer.getLoadedFiles()) {
            if (!string.startsWith(this.rootPath)) continue;
            File file = Util.joinPath(OUTPUT_DIR, string.substring(n));
            file.getParentFile().mkdirs();
            String string2 = file.getAbsolutePath() + ".html";
            String string3 = this.markup(string);
            Util.writeFile(string2, string3);
        }
        HtmlDemo.info("wrote " + this.indexer.getLoadedFiles().size() + " files to " + OUTPUT_DIR);
    }

    private String markup(String string) throws Exception {
        String string2 = Util.readFile(string);
        List<StyleRun> list = new Styler(this.indexer, this.linker).addStyles(string, string2);
        list.addAll(this.linker.getStyles(string));
        string2 = new StyleApplier(string, string2, list).apply();
        String string3 = new HtmlOutline(this.indexer).generate(string);
        return "<html><head title=\"" + string + "\">" + "<style type='text/css'>\n" + CSS + "</style>\n" + "</head>\n<body>\n" + "<table width=100% border='1px solid gray'><tr><td valign='top'>" + string3 + "</td><td>" + "<pre>" + this.addLineNumbers(string2) + "</pre>" + "</td></tr></table></body></html>";
    }

    private String addLineNumbers(String string) {
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.2));
        int n = 1;
        for (String string2 : string.split("\n")) {
            stringBuilder.append("<span class='lineno'>");
            stringBuilder.append(n++);
            stringBuilder.append("</span> ");
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static void abort(String string) {
        System.err.println(string);
        System.exit(1);
    }

    private static void info(Object object) {
        System.out.println(object);
    }

    private static void usage() {
        HtmlDemo.info("Usage:  java org.python.indexer.HtmlDemo <python-stdlib> <file-or-dir>");
        HtmlDemo.info("  first arg specifies the root of the python standard library");
        HtmlDemo.info("  second arg specifies file or directory for which to generate the index");
        HtmlDemo.info("Example that generates an index for just the email libraries:");
        HtmlDemo.info(" java org.python.indexer.HtmlDemo ./CPythonLib ./CPythonLib/email");
        System.exit(0);
    }

    private static File checkFile(String string) {
        File file = new File(string);
        if (!file.canRead()) {
            HtmlDemo.abort("Path not found or not readable: " + string);
        }
        return file;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            HtmlDemo.usage();
        }
        File file = HtmlDemo.checkFile(stringArray[1]);
        File file2 = HtmlDemo.checkFile(stringArray[0]);
        if (!file2.isDirectory()) {
            HtmlDemo.abort("Not a directory: " + file2);
        }
        new HtmlDemo().start(file2, file);
    }
}

