/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.types;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NInstanceType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public abstract class NType {
    private Scope table;
    protected static final String LIBRARY_URL = "http://docs.python.org/library/";
    protected static final String TUTORIAL_URL = "http://docs.python.org/tutorial/";
    protected static final String REFERENCE_URL = "http://docs.python.org/reference/";
    private static Pattern INSTANCE_TAG = Pattern.compile("(.+?)=#([0-9]+)");

    public void setTable(Scope scope) {
        this.table = scope;
    }

    public Scope getTable() {
        if (this.table == null) {
            this.table = new Scope(null, Scope.Type.SCOPE);
        }
        return this.table;
    }

    public NType follow() {
        return NUnknownType.follow(this);
    }

    public boolean isNative() {
        return Indexer.idx.builtins.isNative(this);
    }

    public boolean isClassType() {
        return this instanceof NClassType;
    }

    public boolean isDictType() {
        return this instanceof NDictType;
    }

    public boolean isFuncType() {
        return this instanceof NFuncType;
    }

    public boolean isInstanceType() {
        return this instanceof NInstanceType;
    }

    public boolean isListType() {
        return this instanceof NListType;
    }

    public boolean isModuleType() {
        return this instanceof NModuleType;
    }

    public boolean isNumType() {
        return this == Indexer.idx.builtins.BaseNum;
    }

    public boolean isStrType() {
        return this == Indexer.idx.builtins.BaseStr;
    }

    public boolean isTupleType() {
        return this instanceof NTupleType;
    }

    public boolean isUnionType() {
        return this instanceof NUnionType;
    }

    public boolean isUnknownType() {
        return this instanceof NUnknownType;
    }

    public NClassType asClassType() {
        return (NClassType)this;
    }

    public NDictType asDictType() {
        return (NDictType)this;
    }

    public NFuncType asFuncType() {
        return (NFuncType)this;
    }

    public NInstanceType asInstanceType() {
        return (NInstanceType)this;
    }

    public NListType asListType() {
        return (NListType)this;
    }

    public NModuleType asModuleType() {
        return (NModuleType)this;
    }

    public NTupleType asTupleType() {
        return (NTupleType)this;
    }

    public NUnionType asUnionType() {
        return (NUnionType)this;
    }

    public NUnknownType asUnknownType() {
        return (NUnknownType)this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(new CyclicTypeRecorder(), stringBuilder);
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length());
        Matcher matcher = INSTANCE_TAG.matcher(stringBuilder.toString());
        int n = -1;
        while (matcher.find()) {
            n = matcher.end();
            int n2 = Integer.parseInt(matcher.group(2));
            if (stringBuilder.indexOf("<#" + n2 + ">") == -1) {
                stringBuilder2.append(matcher.group(1));
                continue;
            }
            stringBuilder2.append(matcher.group());
        }
        if (n != -1) {
            stringBuilder2.append(stringBuilder.substring(n));
        }
        return stringBuilder2.toString();
    }

    protected void print(CyclicTypeRecorder cyclicTypeRecorder, StringBuilder stringBuilder) {
        int n = cyclicTypeRecorder.fetch(this);
        if (n > 0) {
            stringBuilder.append("<#").append(n).append(">");
        } else {
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(".") + 2);
            stringBuilder.append("<").append(string).append("=#").append(-n).append(":");
            this.printKids(cyclicTypeRecorder, stringBuilder);
            stringBuilder.append(">");
        }
    }

    protected abstract void printKids(CyclicTypeRecorder var1, StringBuilder var2);

    protected class CyclicTypeRecorder {
        int count = 0;
        private Map<NType, Integer> elements = new HashMap<NType, Integer>();

        protected CyclicTypeRecorder() {
        }

        public int fetch(NType nType) {
            Integer n = this.elements.get(nType);
            if (n != null) {
                return n;
            }
            n = ++this.count;
            this.elements.put(nType, n);
            return -n.intValue();
        }
    }
}

