/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.types;

import java.util.HashSet;
import java.util.Set;
import org.python.indexer.Indexer;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NUnionType
extends NType {
    private static final int MAX_RECURSION_DEPTH = 15;
    private Set<NType> types = new HashSet<NType>();

    public NUnionType() {
    }

    public NUnionType(NType ... nTypeArray) {
        this();
        for (NType nType : nTypeArray) {
            this.addType(nType);
        }
    }

    public void setTypes(Set<NType> set) {
        this.types = set;
    }

    public Set<NType> getTypes() {
        return this.types;
    }

    public void addType(NType nType) {
        if (nType == null) {
            throw new IllegalArgumentException("null type");
        }
        if (nType.isUnionType()) {
            this.types.addAll(nType.asUnionType().types);
        } else {
            this.types.add(nType);
        }
    }

    public boolean contains(NType nType) {
        return this.types.contains(nType);
    }

    public static NType union(NType nType, NType nType2) {
        NType nType3;
        NType nType4 = NUnknownType.follow(nType);
        if (nType4 == (nType3 = NUnknownType.follow(nType2))) {
            return nType;
        }
        if (nType4 == Indexer.idx.builtins.None) {
            return nType2;
        }
        if (nType3 == Indexer.idx.builtins.None) {
            return nType;
        }
        if (nType4.isUnknownType() && !NUnionType.occurs(nType4, nType3, 0)) {
            NUnknownType.point(nType4, nType3);
            return nType;
        }
        if (nType3.isUnknownType() && !NUnionType.occurs(nType3, nType4, 0)) {
            NUnknownType.point(nType3, nType4);
            return nType2;
        }
        if (nType4.isTupleType() && nType3.isTupleType()) {
            NTupleType nTupleType = (NTupleType)nType4;
            NTupleType nTupleType2 = (NTupleType)nType3;
            if (nTupleType.getElementTypes().size() == nTupleType2.getElementTypes().size()) {
                NTupleType nTupleType3 = new NTupleType();
                for (int i = 0; i < nTupleType.getElementTypes().size(); ++i) {
                    nTupleType3.add(NUnionType.union(nTupleType.getElementTypes().get(i), nTupleType2.getElementTypes().get(i)));
                }
                return nTupleType3;
            }
            return NUnionType.newUnion(nType4, nType3);
        }
        if (nType4.isListType() && nType3.isListType()) {
            return new NListType(NUnionType.union(nType4.asListType().getElementType(), nType3.asListType().getElementType()));
        }
        if (nType4.isDictType() && nType3.isDictType()) {
            NDictType nDictType = (NDictType)nType4;
            NDictType nDictType2 = (NDictType)nType3;
            return new NDictType(NUnionType.union(nDictType.getKeyType(), nDictType2.getKeyType()), NUnionType.union(nDictType.getValueType(), nDictType2.getValueType()));
        }
        if (nType4.isFuncType() && nType3.isFuncType()) {
            return new NFuncType(NUnionType.union(nType4.asFuncType().getReturnType(), nType3.asFuncType().getReturnType()));
        }
        if (nType4.isFuncType() && nType3.isClassType()) {
            NUnknownType.point(nType4.asFuncType().getReturnType(), nType3);
            NUnknownType.point(nType, nType3);
            return nType;
        }
        if (nType4.isClassType() && nType3.isFuncType()) {
            NUnknownType.point(nType3.asFuncType().getReturnType(), nType4);
            NUnknownType.point(nType2, nType4);
            return nType2;
        }
        return NUnionType.newUnion(nType4, nType3);
    }

    private static boolean occurs(NType nType, NType nType2, int n) {
        if (n++ > 15) {
            return true;
        }
        if ((nType = NUnknownType.follow(nType)) == (nType2 = NUnknownType.follow(nType2))) {
            return true;
        }
        if (nType2.isTupleType()) {
            for (NType nType3 : nType2.asTupleType().getElementTypes()) {
                if (!NUnionType.occurs(nType, nType3, n)) continue;
                return true;
            }
            return false;
        }
        if (nType2.isListType()) {
            return NUnionType.occurs(nType, nType2.asListType().getElementType(), n);
        }
        if (nType2.isDictType()) {
            return NUnionType.occurs(nType, nType2.asDictType().getKeyType(), n) || NUnionType.occurs(nType, nType2.asDictType().getValueType(), n);
        }
        if (nType2.isFuncType()) {
            NType nType4 = nType2.asFuncType().getReturnType();
            if (NUnionType.occurs(nType2, nType4, n)) {
                return true;
            }
            return NUnionType.occurs(nType, nType4, n);
        }
        if (nType2.isUnionType()) {
            for (NType nType5 : nType2.asUnionType().types) {
                if (!NUnionType.occurs(nType, nType5, n)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static NUnionType newUnion(NType ... nTypeArray) {
        NUnionType nUnionType = new NUnionType();
        for (NType nType : nTypeArray) {
            nUnionType.addType(nType);
        }
        return nUnionType;
    }

    public NType firstKnownAlternate() {
        for (NType nType : this.types) {
            if (nType.follow().isUnknownType()) continue;
            return nType;
        }
        return null;
    }

    public NType firstKnownNonNullAlternate() {
        for (NType nType : this.types) {
            NType nType2 = nType.follow();
            if (nType2.isUnknownType() || nType2 == Indexer.idx.builtins.None) continue;
            return nType;
        }
        return null;
    }

    @Override
    public void printKids(NType.CyclicTypeRecorder cyclicTypeRecorder, StringBuilder stringBuilder) {
        stringBuilder.append("[");
        for (NType nType : this.types) {
            nType.print(cyclicTypeRecorder, stringBuilder);
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("]");
    }
}

