/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.StringReader;
import java.io.StringWriter;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import junit.framework.TestCase;
import org.python.jsr223.PyScriptEngine;
import org.python.jsr223.PyScriptEngineFactory;

public class ScriptEngineIOTest
extends TestCase {
    ScriptEngineFactory pythonEngineFactory;
    ScriptEngine pythonEngine;

    public void setUp() throws ScriptException {
        this.pythonEngineFactory = new PyScriptEngineFactory();
        this.pythonEngine = new PyScriptEngine(this.pythonEngineFactory);
    }

    public void testEvalString() throws ScriptException {
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("x = 5"));
        ScriptEngineIOTest.assertEquals((Object)5, (Object)this.pythonEngine.eval("x"));
    }

    public void testReadline() throws ScriptException {
        String string = "Shazaam Batman!\n";
        this.pythonEngine.getContext().setReader(new StringReader("Shazaam Batman!\n"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        ScriptEngineIOTest.assertEquals((Object)"Shazaam Batman!\n", (Object)this.pythonEngine.eval("sys.stdin.readline()"));
    }

    public void testReadlines() throws ScriptException {
        String string = "Holy Smokes Batman!\nBIF!\r\n\nKAPOW!!!\rTHE END.";
        this.pythonEngine.getContext().setReader(new StringReader("Holy Smokes Batman!\nBIF!\r\n\nKAPOW!!!\rTHE END."));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        Object object = this.pythonEngine.eval("''.join(sys.stdin.readlines())");
        ScriptEngineIOTest.assertEquals((Object)"Holy Smokes Batman!\nBIF!\n\nKAPOW!!!\nTHE END.\n", (Object)object);
    }

    public void testWriter() throws ScriptException {
        StringWriter stringWriter = new StringWriter();
        this.pythonEngine.getContext().setWriter(stringWriter);
        String string = "It is a wonderful world.";
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("print 'It is a wonderful world.',"));
        ScriptEngineIOTest.assertEquals((String)"It is a wonderful world.", (String)stringWriter.toString());
    }

    public void testErrorWriter() throws ScriptException {
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        this.pythonEngine.getContext().setWriter(stringWriter);
        this.pythonEngine.getContext().setErrorWriter(stringWriter2);
        String string = "It is a wonderful world.";
        String string2 = "Stuff happens!";
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("sys.stdout.write('It is a wonderful world.')"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("sys.stderr.write('Stuff happens!')"));
        ScriptEngineIOTest.assertEquals((String)"It is a wonderful world.", (String)stringWriter.toString());
        ScriptEngineIOTest.assertEquals((String)"Stuff happens!", (String)stringWriter2.toString());
    }
}

