/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedType;

public class _codecs {
    public static void register(PyObject pyObject) {
        codecs.register(pyObject);
    }

    public static PyTuple lookup(String string) {
        return codecs.lookup(string);
    }

    public static PyObject lookup_error(String string) {
        return codecs.lookup_error(string);
    }

    public static void register_error(String string, PyObject pyObject) {
        codecs.register_error(string, pyObject);
    }

    public static PyObject charmap_build(PyUnicode pyUnicode) {
        return EncodingMap.buildEncodingMap(pyUnicode);
    }

    private static PyTuple decode_tuple(String string, int n) {
        return new PyTuple(new PyUnicode(string), Py.newInteger(n));
    }

    private static PyTuple decode_tuple_str(String string, int n) {
        return new PyTuple(new PyString(string), Py.newInteger(n));
    }

    private static PyTuple encode_tuple(String string, int n) {
        return new PyTuple(new PyString(string), Py.newInteger(n));
    }

    public static PyTuple utf_8_decode(String string) {
        return _codecs.utf_8_decode(string, null);
    }

    public static PyTuple utf_8_decode(String string, String string2) {
        return _codecs.utf_8_decode(string, string2, false);
    }

    public static PyTuple utf_8_decode(String string, String string2, boolean bl) {
        int[] nArray = bl ? null : new int[1];
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF8Stateful(string, string2, nArray), bl ? string.length() : nArray[0]);
    }

    public static PyTuple utf_8_encode(String string) {
        return _codecs.utf_8_encode(string, null);
    }

    public static PyTuple utf_8_encode(String string, String string2) {
        int n = string.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF8(string, string2), n);
    }

    public static PyTuple utf_7_decode(String string) {
        return _codecs.utf_7_decode(string, null);
    }

    public static PyTuple utf_7_decode(String string, String string2) {
        int n = string.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF7(string, string2), n);
    }

    public static PyTuple utf_7_encode(String string) {
        return _codecs.utf_7_encode(string, null);
    }

    public static PyTuple utf_7_encode(String string, String string2) {
        int n = string.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF7(string, false, false, string2), n);
    }

    public static PyTuple escape_decode(String string) {
        return _codecs.escape_decode(string, null);
    }

    public static PyTuple escape_decode(String string, String string2) {
        return _codecs.decode_tuple_str(PyString.decode_UnicodeEscape(string, 0, string.length(), string2, true), string.length());
    }

    public static PyTuple escape_encode(String string) {
        return _codecs.escape_encode(string, null);
    }

    public static PyTuple escape_encode(String string, String string2) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(string, false), string.length());
    }

    public static PyTuple charmap_decode(String string, String string2, PyObject pyObject) {
        return _codecs.charmap_decode(string, string2, pyObject, false);
    }

    public static PyTuple charmap_decode(String string, String string2, PyObject pyObject, boolean bl) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                i = codecs.insertReplacementAndGetResume(stringBuilder, string2, "charmap", string, i, i + 1, "ordinal not in range(255)") - 1;
                continue;
            }
            PyInteger pyInteger = Py.newInteger(c);
            PyObject pyObject2 = pyObject.__finditem__(pyInteger);
            if (pyObject2 == null) {
                if (bl) {
                    stringBuilder.append(c);
                    continue;
                }
                i = codecs.insertReplacementAndGetResume(stringBuilder, string2, "charmap", string, i, i + 1, "no mapping found") - 1;
                continue;
            }
            if (pyObject2 instanceof PyInteger) {
                int n2 = ((PyInteger)pyObject2).getValue();
                if (n2 < 0 || n2 > 0x10FFFF) {
                    throw Py.TypeError("character mapping must return integer greater than 0 and less than sys.maxunicode");
                }
                stringBuilder.append((char)n2);
                continue;
            }
            if (pyObject2 == Py.None) {
                i = codecs.insertReplacementAndGetResume(stringBuilder, string2, "charmap", string, i, i + 1, "character maps to <undefined>") - 1;
                continue;
            }
            if (pyObject2 instanceof PyString) {
                stringBuilder.append(pyObject2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.decode_tuple(stringBuilder.toString(), n);
    }

    public static PyObject translateCharmap(PyUnicode pyUnicode, String string, PyObject pyObject) {
        StringBuilder stringBuilder = new StringBuilder(pyUnicode.toString().length());
        Iterator<Integer> iterator = pyUnicode.newSubsequenceIterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            PyObject pyObject2 = pyObject.__finditem__(Py.newInteger(n));
            if (pyObject2 == null) {
                stringBuilder.appendCodePoint(n);
                continue;
            }
            if (pyObject2 == Py.None) continue;
            if (pyObject2 instanceof PyInteger) {
                int n2 = pyObject2.asInt();
                if (n2 < 0 || n2 > 0x10FFFF) {
                    throw Py.TypeError(String.format("character mapping must be in range(0x%x)", 0x110000));
                }
                stringBuilder.appendCodePoint(n2);
                continue;
            }
            if (pyObject2 instanceof PyUnicode) {
                stringBuilder.append(pyObject2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return new PyUnicode(stringBuilder.toString());
    }

    public static PyTuple charmap_encode(String string, String string2, PyObject pyObject) {
        if (pyObject == null) {
            return _codecs.latin_1_encode(string, string2);
        }
        return _codecs.charmap_encode_internal(string, string2, pyObject, new StringBuilder(string.length()), true);
    }

    private static PyTuple charmap_encode_internal(String string, String string2, PyObject pyObject, StringBuilder stringBuilder, boolean bl) {
        EncodingMap encodingMap = pyObject instanceof EncodingMap ? (EncodingMap)pyObject : null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            Object object = encodingMap != null ? ((n2 = encodingMap.lookup(c)) == -1 ? null : Py.newInteger(n2)) : pyObject.__finditem__(Py.newInteger(c));
            if (object == null) {
                if (bl) {
                    i = _codecs.handleBadMapping(string, string2, pyObject, stringBuilder, n, i);
                    continue;
                }
                throw Py.UnicodeEncodeError("charmap", string, i, i + 1, "character maps to <undefined>");
            }
            if (object instanceof PyInteger) {
                n2 = ((PyInteger)object).getValue();
                if (n2 < 0 || n2 > 255) {
                    throw Py.TypeError("character mapping must be in range(256)");
                }
                stringBuilder.append((char)n2);
                continue;
            }
            if (object instanceof PyString && !(object instanceof PyUnicode)) {
                stringBuilder.append(((PyObject)object).toString());
                continue;
            }
            if (object instanceof PyNone) {
                i = _codecs.handleBadMapping(string, string2, pyObject, stringBuilder, n, i);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.encode_tuple(stringBuilder.toString(), n);
    }

    private static int handleBadMapping(String string, String string2, PyObject pyObject, StringBuilder stringBuilder, int n, int n2) {
        if (string2 != null) {
            if (string2.equals("ignore")) {
                return n2;
            }
            if (string2.equals("replace")) {
                _codecs.charmap_encode_internal("?", string2, pyObject, stringBuilder, false);
                return n2;
            }
            if (string2.equals("xmlcharrefreplace")) {
                _codecs.charmap_encode_internal(codecs.xmlcharrefreplace(n2, n2 + 1, string).toString(), string2, pyObject, stringBuilder, false);
                return n2;
            }
            if (string2.equals("backslashreplace")) {
                _codecs.charmap_encode_internal(codecs.backslashreplace(n2, n2 + 1, string).toString(), string2, pyObject, stringBuilder, false);
                return n2;
            }
        }
        PyObject pyObject2 = codecs.encoding_error(string2, "charmap", string, n2, n2 + 1, "character maps to <undefined>");
        String string3 = pyObject2.__getitem__(0).toString();
        _codecs.charmap_encode_internal(string3, string2, pyObject, stringBuilder, false);
        return codecs.calcNewPosition(n, pyObject2) - 1;
    }

    public static PyTuple ascii_decode(String string) {
        return _codecs.ascii_decode(string, null);
    }

    public static PyTuple ascii_decode(String string, String string2) {
        int n = string.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeASCII(string, n, string2), n);
    }

    public static PyTuple ascii_encode(String string) {
        return _codecs.ascii_encode(string, null);
    }

    public static PyTuple ascii_encode(String string, String string2) {
        int n = string.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeASCII(string, n, string2), n);
    }

    public static PyTuple latin_1_decode(String string) {
        return _codecs.latin_1_decode(string, null);
    }

    public static PyTuple latin_1_decode(String string, String string2) {
        int n = string.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeLatin1(string, n, string2), n);
    }

    public static PyTuple latin_1_encode(String string) {
        return _codecs.latin_1_encode(string, null);
    }

    public static PyTuple latin_1_encode(String string, String string2) {
        int n = string.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeLatin1(string, n, string2), n);
    }

    public static PyTuple utf_16_encode(String string) {
        return _codecs.utf_16_encode(string, null);
    }

    public static PyTuple utf_16_encode(String string, String string2) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(string, string2, 0), string.length());
    }

    public static PyTuple utf_16_encode(String string, String string2, int n) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(string, string2, n), string.length());
    }

    public static PyTuple utf_16_le_encode(String string) {
        return _codecs.utf_16_le_encode(string, null);
    }

    public static PyTuple utf_16_le_encode(String string, String string2) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(string, string2, -1), string.length());
    }

    public static PyTuple utf_16_be_encode(String string) {
        return _codecs.utf_16_be_encode(string, null);
    }

    public static PyTuple utf_16_be_encode(String string, String string2) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(string, string2, 1), string.length());
    }

    public static String encode_UTF16(String string, String string2, int n) {
        Charset charset = n == 0 ? Charset.forName("UTF-16") : (n == -1 ? Charset.forName("UTF-16LE") : Charset.forName("UTF-16BE"));
        ByteBuffer byteBuffer = charset.encode(string);
        StringBuilder stringBuilder = new StringBuilder(byteBuffer.limit());
        while (byteBuffer.remaining() > 0) {
            int n2 = byteBuffer.get();
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public static PyTuple utf_16_decode(String string) {
        return _codecs.utf_16_decode(string, null);
    }

    public static PyTuple utf_16_decode(String string, String string2) {
        return _codecs.utf_16_decode(string, string2, false);
    }

    public static PyTuple utf_16_decode(String string, String string2, boolean bl) {
        int[] nArray = new int[]{0};
        int[] nArray2 = bl ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(string, string2, nArray, nArray2), bl ? string.length() : nArray2[0]);
    }

    public static PyTuple utf_16_le_decode(String string) {
        return _codecs.utf_16_le_decode(string, null);
    }

    public static PyTuple utf_16_le_decode(String string, String string2) {
        return _codecs.utf_16_le_decode(string, string2, false);
    }

    public static PyTuple utf_16_le_decode(String string, String string2, boolean bl) {
        int[] nArray = new int[]{-1};
        int[] nArray2 = bl ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(string, string2, nArray, nArray2), bl ? string.length() : nArray2[0]);
    }

    public static PyTuple utf_16_be_decode(String string) {
        return _codecs.utf_16_be_decode(string, null);
    }

    public static PyTuple utf_16_be_decode(String string, String string2) {
        return _codecs.utf_16_be_decode(string, string2, false);
    }

    public static PyTuple utf_16_be_decode(String string, String string2, boolean bl) {
        int[] nArray = new int[]{1};
        int[] nArray2 = bl ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(string, string2, nArray, nArray2), bl ? string.length() : nArray2[0]);
    }

    public static PyTuple utf_16_ex_decode(String string) {
        return _codecs.utf_16_ex_decode(string, null);
    }

    public static PyTuple utf_16_ex_decode(String string, String string2) {
        return _codecs.utf_16_ex_decode(string, string2, 0);
    }

    public static PyTuple utf_16_ex_decode(String string, String string2, int n) {
        return _codecs.utf_16_ex_decode(string, string2, n, false);
    }

    public static PyTuple utf_16_ex_decode(String string, String string2, int n, boolean bl) {
        int[] nArray = new int[]{0};
        int[] nArray2 = bl ? null : new int[1];
        String string3 = _codecs.decode_UTF16(string, string2, nArray, nArray2);
        return new PyTuple(Py.newString(string3), Py.newInteger(bl ? string.length() : nArray2[0]), Py.newInteger(nArray[0]));
    }

    private static String decode_UTF16(String string, String string2, int[] nArray) {
        return _codecs.decode_UTF16(string, string2, nArray, null);
    }

    private static String decode_UTF16(String string, String string2, int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        if (nArray != null) {
            n2 = nArray[0];
        }
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3 / 2);
        for (n = 0; n < n3; n += 2) {
            char c = string.charAt(n);
            if (n + 1 == n3) {
                if (nArray2 != null) break;
                n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-16", string, n, n + 1, "truncated data");
                continue;
            }
            char c2 = string.charAt(n + 1);
            if (c == '\u00fe' && c2 == '\u00ff') {
                n2 = 1;
                continue;
            }
            if (c == '\u00ff' && c2 == '\u00fe') {
                n2 = -1;
                continue;
            }
            int n4 = n2 == -1 ? c2 << 8 | c : c << 8 | c2;
            if (n4 < 55296 || n4 > 57343) {
                stringBuilder.appendCodePoint(n4);
                continue;
            }
            if (n4 >= 55296 && n4 <= 56319 && n < n3 - 1) {
                char c3 = string.charAt(n += 2);
                char c4 = string.charAt(n + 1);
                int n5 = n2 == -1 ? c4 << 8 | c3 : c3 << 8 | c4;
                if (n5 >= 56320 && n5 <= 57343) {
                    int n6 = ((n4 & 0x3FF) << 10 | n5 & 0x3FF) + 65536;
                    stringBuilder.appendCodePoint(n6);
                    continue;
                }
                n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-16", string, n, n + 1, "illegal UTF-16 surrogate");
                continue;
            }
            n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-16", string, n, n + 1, "illegal encoding");
        }
        if (nArray != null) {
            nArray[0] = n2;
        }
        if (nArray2 != null) {
            nArray2[0] = n;
        }
        return stringBuilder.toString();
    }

    public static PyTuple raw_unicode_escape_encode(String string) {
        return _codecs.raw_unicode_escape_encode(string, null);
    }

    public static PyTuple raw_unicode_escape_encode(String string, String string2) {
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeRawUnicodeEscape(string, string2, false), string.length());
    }

    public static PyTuple raw_unicode_escape_decode(String string) {
        return _codecs.raw_unicode_escape_decode(string, null);
    }

    public static PyTuple raw_unicode_escape_decode(String string, String string2) {
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeRawUnicodeEscape(string, string2), string.length());
    }

    public static PyTuple unicode_escape_encode(String string) {
        return _codecs.unicode_escape_encode(string, null);
    }

    public static PyTuple unicode_escape_encode(String string, String string2) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(string, false), string.length());
    }

    public static PyTuple unicode_escape_decode(String string) {
        return _codecs.unicode_escape_decode(string, null);
    }

    public static PyTuple unicode_escape_decode(String string, String string2) {
        int n = string.length();
        return _codecs.decode_tuple(PyString.decode_UnicodeEscape(string, 0, n, string2, true), n);
    }

    public static PyTuple unicode_internal_encode(String string) {
        return _codecs.unicode_internal_encode(string, null);
    }

    public static PyTuple unicode_internal_encode(String string, String string2) {
        return _codecs.encode_tuple(string, string.length());
    }

    public static PyTuple unicode_internal_decode(String string) {
        return _codecs.unicode_internal_decode(string, null);
    }

    public static PyTuple unicode_internal_decode(String string, String string2) {
        return _codecs.decode_tuple(string, string.length());
    }

    @ExposedType(name="EncodingMap", isBaseType=false)
    public static class EncodingMap
    extends PyObject {
        char[] level1;
        char[] level23;
        int count2;
        int count3;

        private EncodingMap(char[] level1, char[] level23, int count2, int count3) {
            this.level1 = level1;
            this.level23 = level23;
            this.count2 = count2;
            this.count3 = count3;
        }

        /*
         * WARNING - void declaration
         */
        public static PyObject buildEncodingMap(PyObject string) {
            void result;
            int length3;
            void i;
            int l22;
            int charAt;
            int decode;
            if (!(string instanceof PyUnicode) || string.__len__() != 256) {
                throw Py.TypeError("bad argument type for built-in operation");
            }
            boolean needDict = false;
            char[] level1 = new char[32];
            char[] level23 = new char[512];
            boolean bl = false;
            int count2 = 0;
            String count3 = string.toString();
            for (decode = 0; decode < level1.length; ++decode) {
                level1[decode] = 255;
            }
            for (decode = 0; decode < level23.length; ++decode) {
                level23[decode] = 255;
            }
            if (count3.charAt(0) != '\u0000') {
                needDict = true;
            }
            for (decode = 1; decode < 256; ++decode) {
                void l1;
                char c = count3.charAt(decode);
                if (c == '\u0000') {
                    needDict = true;
                }
                if (c == '\ufffe') continue;
                int n = c >> 11;
                charAt = l1 >> 7;
                if (level1[l22] == '\u00ff') {
                    level1[l22] = (char)(++i);
                }
                if (level23[charAt] != '\u00ff') continue;
                level23[charAt] = (char)count2++;
            }
            if (i > 255 || count2 > 255) {
                needDict = true;
            }
            if (needDict) {
                PyDictionary l22 = new PyDictionary();
                for (decode = 0; decode < 256; ++decode) {
                    ((PyObject)l22).__setitem__(Py.newInteger(count3.charAt(decode)), (PyObject)Py.newInteger(decode));
                }
                return l22;
            }
            l22 = 16 * i;
            charAt = 128 * count2;
            level23 = new char[length3 + charAt];
            EncodingMap length2 = new EncodingMap(level1, level23, (int)i, count2);
            for (decode = 0; decode < length3; ++decode) {
                level23[decode] = 255;
            }
            for (decode = length3; decode < length3 + result; ++decode) {
                level23[decode] = '\u0000';
            }
            count2 = 0;
            for (decode = 1; decode < 256; ++decode) {
                void o2;
                void o1;
                char c = count3.charAt(decode);
                if (c == '\ufffe') continue;
                int n = c >> 11;
                int n2 = o1 >> 7 & 0xF;
                int i2 = 16 * level1[o2] + n2;
                if (level23[i2] == '\u00ff') {
                    level23[i2] = (char)count2++;
                }
                int n3 = o1 & 0x7F;
                int charAt2 = 128 * level23[i2] + n3;
                level23[length3 + charAt2] = (char)decode;
            }
            return length2;
        }

        public int lookup(char c) {
            int l1 = c >> 11;
            int l2 = c >> 7 & 0xF;
            int l3 = c & 0x7F;
            if (c == '\u0000') {
                return 0;
            }
            char i = this.level1[l1];
            if (i == '\u00ff') {
                return -1;
            }
            if ((i = this.level23[16 * i + l2]) == '\u00ff') {
                return -1;
            }
            if ((i = this.level23[16 * this.count2 + 128 * i + l3]) == '\u0000') {
                return -1;
            }
            return i;
        }

        static {
            PyType.addBuilder(EncodingMap.class, new _codecs$EncodingMap$PyExposer());
        }

        public class _codecs$EncodingMap$PyExposer
        extends BaseTypeBuilder {
            public _codecs$EncodingMap$PyExposer() {
                PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{};
                PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
                super("EncodingMap", EncodingMap.class, Object.class, false, null, pyBuiltinMethodArray, pyDataDescrArray, null);
            }
        }
    }
}

