/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.BaseSet;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBytecode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyFrozenSet;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.modules.PyIOFile;
import org.python.modules.PyIOFileFactory;

public class _marshal
implements ClassDictInit {
    private static final char TYPE_NULL = '0';
    private static final char TYPE_NONE = 'N';
    private static final char TYPE_FALSE = 'F';
    private static final char TYPE_TRUE = 'T';
    private static final char TYPE_STOPITER = 'S';
    private static final char TYPE_ELLIPSIS = '.';
    private static final char TYPE_INT = 'i';
    private static final char TYPE_INT64 = 'I';
    private static final char TYPE_FLOAT = 'f';
    private static final char TYPE_BINARY_FLOAT = 'g';
    private static final char TYPE_COMPLEX = 'x';
    private static final char TYPE_BINARY_COMPLEX = 'y';
    private static final char TYPE_LONG = 'l';
    private static final char TYPE_STRING = 's';
    private static final char TYPE_INTERNED = 't';
    private static final char TYPE_STRINGREF = 'R';
    private static final char TYPE_TUPLE = '(';
    private static final char TYPE_LIST = '[';
    private static final char TYPE_DICT = '{';
    private static final char TYPE_CODE = 'c';
    private static final char TYPE_UNICODE = 'u';
    private static final char TYPE_UNKNOWN = '?';
    private static final char TYPE_SET = '<';
    private static final char TYPE_FROZENSET = '>';
    private static final int MAX_MARSHAL_STACK_DEPTH = 2000;
    private static final int CURRENT_VERSION = 2;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("__name__", (PyObject)Py.newString("_marshal"));
    }

    public static class Marshaller
    extends PyObject {
        private final PyIOFile file;
        private final int version;
        private boolean debug = false;

        public Marshaller(PyObject pyObject) {
            this(pyObject, 2);
        }

        public Marshaller(PyObject pyObject, int n) {
            this.file = PyIOFileFactory.createIOFile(pyObject);
            this.version = n;
        }

        public void _debug() {
            this.debug = true;
        }

        public void dump(PyObject pyObject) {
            this.write_object(pyObject, 0);
        }

        private void write_byte(char c) {
            if (this.debug) {
                System.err.print("[" + c + "]");
            }
            this.file.write(c);
        }

        private void write_string(String string) {
            this.file.write(string);
        }

        private void write_strings(String[] stringArray, int n) {
            PyObject[] pyObjectArray = new PyObject[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                pyObjectArray[i] = Py.newString(stringArray[i]);
            }
            this.write_object(new PyTuple(pyObjectArray), n + 1);
        }

        private void write_short(short s) {
            this.write_byte((char)(s & 0xFF));
            this.write_byte((char)(s >> 8 & 0xFF));
        }

        private void write_int(int n) {
            this.write_byte((char)(n & 0xFF));
            this.write_byte((char)(n >> 8 & 0xFF));
            this.write_byte((char)(n >> 16 & 0xFF));
            this.write_byte((char)(n >> 24 & 0xFF));
        }

        private void write_long64(long l) {
            this.write_int((int)(l & 0xFFFFFFFFFFFFFFFFL));
            this.write_int((int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL));
        }

        private void write_long(BigInteger bigInteger) {
            int n = bigInteger.signum();
            if (n < 0) {
                bigInteger = bigInteger.negate();
            }
            int n2 = bigInteger.bitLength();
            int n3 = n2 / 15 + (n2 % 15 == 0 ? 0 : 1);
            this.write_int(n < 0 ? -n3 : n3);
            BigInteger bigInteger2 = BigInteger.valueOf(32767L);
            for (int i = 0; i < n3; ++i) {
                this.write_short(bigInteger.and(bigInteger2).shortValue());
                bigInteger = bigInteger.shiftRight(15);
            }
        }

        private void write_float(PyFloat pyFloat) {
            this.write_string(pyFloat.__repr__().toString());
        }

        private void write_binary_float(PyFloat pyFloat) {
            this.write_long64(Double.doubleToLongBits(pyFloat.getValue()));
        }

        private void write_object(PyObject pyObject, int n) {
            if (n >= 2000) {
                throw Py.ValueError("Maximum marshal stack depth");
            }
            if (pyObject == null) {
                this.write_byte('0');
            } else if (pyObject == Py.None) {
                this.write_byte('N');
            } else if (pyObject == Py.StopIteration) {
                this.write_byte('S');
            } else if (pyObject == Py.Ellipsis) {
                this.write_byte('.');
            } else if (pyObject == Py.False) {
                this.write_byte('F');
            } else if (pyObject == Py.True) {
                this.write_byte('T');
            } else if (pyObject instanceof PyInteger) {
                this.write_byte('i');
                this.write_int(((PyInteger)pyObject).asInt());
            } else if (pyObject instanceof PyLong) {
                this.write_byte('l');
                this.write_long(((PyLong)pyObject).getValue());
            } else if (pyObject instanceof PyFloat) {
                if (this.version == 2) {
                    this.write_byte('g');
                    this.write_binary_float((PyFloat)pyObject);
                } else {
                    this.write_byte('f');
                    this.write_float((PyFloat)pyObject);
                }
            } else if (pyObject instanceof PyComplex) {
                PyComplex pyComplex = (PyComplex)pyObject;
                if (this.version == 2) {
                    this.write_byte('y');
                    this.write_binary_float(pyComplex.getReal());
                    this.write_binary_float(pyComplex.getImag());
                } else {
                    this.write_byte('x');
                    this.write_float(pyComplex.getReal());
                    this.write_float(pyComplex.getImag());
                }
            } else if (pyObject instanceof PyUnicode) {
                this.write_byte('u');
                String string = ((PyUnicode)pyObject).encode("utf-8").toString();
                this.write_int(string.length());
                this.write_string(string);
            } else if (pyObject instanceof PyString) {
                this.write_byte('s');
                this.write_int(pyObject.__len__());
                this.write_string(pyObject.toString());
            } else if (pyObject instanceof PyTuple) {
                this.write_byte('(');
                PyTuple pyTuple = (PyTuple)pyObject;
                int n2 = pyTuple.__len__();
                this.write_int(n2);
                for (int i = 0; i < n2; ++i) {
                    this.write_object(pyTuple.__getitem__(i), n + 1);
                }
            } else if (pyObject instanceof PyList) {
                this.write_byte('[');
                PyList pyList = (PyList)pyObject;
                int n3 = pyList.__len__();
                this.write_int(n3);
                for (int i = 0; i < n3; ++i) {
                    this.write_object(pyList.__getitem__(i), n + 1);
                }
            } else if (pyObject instanceof PyDictionary) {
                this.write_byte('{');
                PyDictionary pyDictionary = (PyDictionary)pyObject;
                for (PyObject pyObject2 : pyDictionary.iteritems().asIterable()) {
                    PyObject pyObject3 = (PyTuple)pyObject2;
                    this.write_object(pyObject3.__getitem__(0), n + 1);
                    this.write_object(pyObject3.__getitem__(1), n + 1);
                }
                this.write_object(null, n + 1);
            } else if (pyObject instanceof BaseSet) {
                if (pyObject instanceof PySet) {
                    this.write_byte('<');
                } else {
                    this.write_byte('>');
                }
                int n4 = pyObject.__len__();
                this.write_int(n4);
                BaseSet baseSet = (BaseSet)pyObject;
                for (PyObject pyObject3 : baseSet.asIterable()) {
                    this.write_object(pyObject3, n + 1);
                }
            } else if (pyObject instanceof PyBytecode) {
                PyBytecode pyBytecode = (PyBytecode)pyObject;
                this.write_byte('c');
                this.write_int(pyBytecode.co_argcount);
                this.write_int(pyBytecode.co_nlocals);
                this.write_int(pyBytecode.co_stacksize);
                this.write_int(pyBytecode.co_flags.toBits());
                this.write_object(Py.newString(new String(pyBytecode.co_code)), n + 1);
                this.write_object(new PyTuple(pyBytecode.co_consts), n + 1);
                this.write_strings(pyBytecode.co_names, n + 1);
                this.write_strings(pyBytecode.co_varnames, n + 1);
                this.write_strings(pyBytecode.co_freevars, n + 1);
                this.write_strings(pyBytecode.co_cellvars, n + 1);
                this.write_object(Py.newString(pyBytecode.co_name), n + 1);
                this.write_int(pyBytecode.co_firstlineno);
                this.write_object(Py.newString(new String(pyBytecode.co_lnotab)), n + 1);
            } else {
                this.write_byte('?');
            }
            --n;
        }
    }

    public static class Unmarshaller
    extends PyObject {
        private final PyIOFile file;
        private final PyList strings = new PyList();
        private final int version;
        int depth = 0;
        private boolean debug = false;

        public Unmarshaller(PyObject pyObject) {
            this(pyObject, 2);
        }

        public Unmarshaller(PyObject pyObject, int n) {
            this.file = PyIOFileFactory.createIOFile(pyObject);
            this.version = n;
        }

        public void _debug() {
            this.debug = true;
        }

        public PyObject load() {
            try {
                PyObject pyObject = this.read_object(0);
                if (pyObject == null) {
                    throw Py.TypeError("NULL object in marshal data");
                }
                return pyObject;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw Py.EOFError("EOF read where object expected");
            }
        }

        private int read_byte() {
            char c = this.file.read(1).charAt(0);
            if (this.debug) {
                System.err.print("[" + c + "]");
            }
            return c;
        }

        private String read_string(int n) {
            return this.file.read(n);
        }

        private int read_short() {
            int n = this.read_byte();
            return n |= this.read_byte() << 8;
        }

        private int read_int() {
            int n = this.read_byte();
            n |= this.read_byte() << 8;
            n |= this.read_byte() << 16;
            return n |= this.read_byte() << 24;
        }

        private long read_long64() {
            long l = this.read_int();
            long l2 = this.read_int();
            long l3 = l2 << 32 | l & 0xFFFFFFFFL;
            return l3;
        }

        private BigInteger read_long() {
            int n = this.read_int();
            int n2 = 1;
            if (n < 0) {
                n2 = -1;
                n = -n;
            }
            BigInteger bigInteger = BigInteger.ZERO;
            for (int i = 0; i < n; ++i) {
                String string = String.valueOf(this.read_short());
                bigInteger = bigInteger.or(new BigInteger(string).shiftLeft(i * 15));
            }
            if (n2 < 0) {
                bigInteger = bigInteger.negate();
            }
            return bigInteger;
        }

        private double read_float() {
            int n = this.read_byte();
            return Py.newString(this.read_string(n)).atof();
        }

        private double read_binary_float() {
            return Double.longBitsToDouble(this.read_long64());
        }

        private PyObject read_object_notnull(int n) {
            PyObject pyObject = this.read_object(n);
            if (pyObject == null) {
                throw Py.ValueError("bad marshal data");
            }
            return pyObject;
        }

        private String[] read_strings(int n) {
            PyTuple pyTuple = (PyTuple)this.read_object_notnull(n);
            String[] stringArray = new String[pyTuple.__len__()];
            int n2 = 0;
            for (PyObject pyObject : pyTuple.asIterable()) {
                stringArray[n2++] = pyObject.toString().intern();
            }
            return stringArray;
        }

        private PyObject read_object(int n) {
            if (n >= 2000) {
                throw Py.ValueError("Maximum marshal stack depth");
            }
            int n2 = this.read_byte();
            switch (n2) {
                case 48: {
                    return null;
                }
                case 78: {
                    return Py.None;
                }
                case 83: {
                    return Py.StopIteration;
                }
                case 46: {
                    return Py.Ellipsis;
                }
                case 70: {
                    return Py.False;
                }
                case 84: {
                    return Py.True;
                }
                case 105: {
                    return Py.newInteger(this.read_int());
                }
                case 73: {
                    return Py.newInteger(this.read_long64());
                }
                case 108: {
                    return Py.newLong(this.read_long());
                }
                case 102: {
                    return Py.newFloat(this.read_float());
                }
                case 103: {
                    return Py.newFloat(this.read_binary_float());
                }
                case 120: {
                    double d = this.read_float();
                    double d2 = this.read_float();
                    return new PyComplex(d, d2);
                }
                case 121: {
                    double d = this.read_binary_float();
                    double d3 = this.read_binary_float();
                    return new PyComplex(d, d3);
                }
                case 115: 
                case 116: {
                    int n3 = this.read_int();
                    String string = this.read_string(n3);
                    if (n2 == 116) {
                        PyString pyString = PyString.fromInterned(string.intern());
                        this.strings.append(pyString);
                        return pyString;
                    }
                    return Py.newString(string);
                }
                case 82: {
                    int n4 = this.read_int();
                    return this.strings.__getitem__(n4);
                }
                case 117: {
                    int n5 = this.read_int();
                    PyString pyString = Py.newString(this.read_string(n5));
                    return pyString.decode("utf-8");
                }
                case 40: {
                    int n6 = this.read_int();
                    if (n6 < 0) {
                        throw Py.ValueError("bad marshal data");
                    }
                    PyObject[] pyObjectArray = new PyObject[n6];
                    for (int i = 0; i < n6; ++i) {
                        pyObjectArray[i] = this.read_object_notnull(n + 1);
                    }
                    return new PyTuple(pyObjectArray);
                }
                case 91: {
                    int n7 = this.read_int();
                    if (n7 < 0) {
                        throw Py.ValueError("bad marshal data");
                    }
                    PyObject[] pyObjectArray = new PyObject[n7];
                    for (int i = 0; i < n7; ++i) {
                        pyObjectArray[i] = this.read_object_notnull(n + 1);
                    }
                    return new PyList(pyObjectArray);
                }
                case 123: {
                    PyObject pyObject;
                    PyDictionary pyDictionary = new PyDictionary();
                    while ((pyObject = this.read_object(n + 1)) != null) {
                        PyObject pyObject2 = this.read_object(n + 1);
                        if (pyObject2 == null) continue;
                        pyDictionary.__setitem__(pyObject, pyObject2);
                    }
                    return pyDictionary;
                }
                case 60: 
                case 62: {
                    int n8 = this.read_int();
                    PyObject[] pyObjectArray = new PyObject[n8];
                    for (int i = 0; i < n8; ++i) {
                        pyObjectArray[i] = this.read_object(n + 1);
                    }
                    PyTuple pyTuple = new PyTuple(pyObjectArray);
                    if (n2 == 60) {
                        return new PySet(pyTuple);
                    }
                    return new PyFrozenSet(pyTuple);
                }
                case 99: {
                    int n9 = this.read_int();
                    int n10 = this.read_int();
                    int n11 = this.read_int();
                    int n12 = this.read_int();
                    String string = this.read_object_notnull(n + 1).toString();
                    PyObject[] pyObjectArray = ((PyTuple)this.read_object_notnull(n + 1)).getArray();
                    String[] stringArray = this.read_strings(n + 1);
                    String[] stringArray2 = this.read_strings(n + 1);
                    String[] stringArray3 = this.read_strings(n + 1);
                    String[] stringArray4 = this.read_strings(n + 1);
                    String string2 = this.read_object_notnull(n + 1).toString();
                    String string3 = this.read_object_notnull(n + 1).toString();
                    int n13 = this.read_int();
                    String string4 = this.read_object_notnull(n + 1).toString();
                    return new PyBytecode(n9, n10, n11, n12, string, pyObjectArray, stringArray, stringArray2, string2, string3, n13, string4, stringArray4, stringArray3);
                }
            }
            throw Py.ValueError("bad marshal data");
        }
    }
}

