/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.constantine.Constant;
import org.python.constantine.ConstantSet;
import org.python.constantine.platform.Errno;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.imp;
import org.python.posix.util.Platform;

public class errno
implements ClassDictInit {
    public static final PyString __doc__ = Py.newString("This module makes available standard errno system symbols.\n\nThe value of each symbol is the corresponding integer value,\ne.g., on most systems, errno.ENOENT equals the integer 2.\n\nThe dictionary errno.errorcode maps numeric codes to symbol names,\ne.g., errno.errorcode[2] could be the string 'ENOENT'.\n\nSymbols that are not relevant to the underlying system are not defined.\n\nTo map error codes to error messages, use the function os.strerror(),\ne.g. os.strerror(2) could return 'No such file or directory'.");
    public static final PyObject errorcode = new PyDictionary();

    public static void classDictInit(PyObject pyObject) {
        if (Platform.IS_WINDOWS) {
            errno.initWindows(pyObject);
        } else {
            errno.initPosix(pyObject);
        }
        errno.addCode(pyObject, "ESOCKISBLOCKING", 20000, "Socket is in blocking mode");
        errno.addCode(pyObject, "EGETADDRINFOFAILED", 20001, "getaddrinfo failed");
        pyObject.__setitem__("classDictInit", null);
    }

    private static void initWindows(PyObject pyObject) {
        ConstantSet constantSet = ConstantSet.getConstantSet("Errno");
        ConstantSet constantSet2 = ConstantSet.getConstantSet("LastError");
        for (Errno errno2 : Errno.values()) {
            String string = errno2.name();
            Constant constant = constantSet.getConstant(string);
            if (constant == null && (constant = constantSet2.getConstant("WSA" + string)) == null) continue;
            errno.addCode(pyObject, string, constant.value(), constant.toString());
        }
        for (Constant constant : constantSet2) {
            if (!constant.name().startsWith("WSA")) continue;
            errno.addCode(pyObject, constant.name(), constant.value(), constant.toString());
        }
    }

    private static void initPosix(PyObject pyObject) {
        for (Constant constant : ConstantSet.getConstantSet("Errno")) {
            errno.addCode(pyObject, constant.name(), constant.value(), constant.toString());
        }
    }

    private static void addCode(PyObject pyObject, String string, int n, String string2) {
        PyString pyString = Py.newString(string);
        PyInteger pyInteger = Py.newInteger(n);
        pyObject.__setitem__(pyString, (PyObject)pyInteger);
        errorcode.__setitem__(pyInteger, (PyObject)pyString);
    }

    @Deprecated
    public static PyObject strerror(PyObject pyObject) {
        Py.warning(Py.DeprecationWarning, "The errno.strerror function is deprecated, use os.strerror.");
        return imp.load("os").__getattr__("strerror").__call__(pyObject);
    }
}

