/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import org.python.core.Py;
import org.python.modules.jffi.AllocatedDirectMemory;
import org.python.modules.jffi.BoundedNativeMemory;

class AllocatedNativeMemory
extends BoundedNativeMemory
implements AllocatedDirectMemory {
    private volatile boolean released = false;
    private volatile boolean autorelease = true;
    private final long storage;

    static final AllocatedNativeMemory allocate(int n, boolean bl) {
        return AllocatedNativeMemory.allocateAligned(n, 1, bl);
    }

    static final AllocatedNativeMemory allocateAligned(int n, int n2, boolean bl) {
        long l = IO.allocateMemory(n + n2 - 1, bl);
        if (l == 0L) {
            throw Py.RuntimeError("failed to allocate " + n + " bytes");
        }
        return new AllocatedNativeMemory(l, n, n2);
    }

    private AllocatedNativeMemory(long l, int n, int n2) {
        super((l - 1L & (long)(~(n2 - 1))) + (long)n2, n);
        this.storage = l;
    }

    public void free() {
        if (!this.released) {
            IO.freeMemory(this.storage);
            this.released = true;
        }
    }

    public void setAutoRelease(boolean bl) {
        this.autorelease = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.released && this.autorelease) {
                IO.freeMemory(this.storage);
                this.released = true;
            }
        }
        finally {
            super.finalize();
        }
    }
}

