/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinClassMethodNarrow;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyType;
import org.python.core.SequenceIndexDelegate;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.jffi.AllocatedNativeMemory;
import org.python.modules.jffi.CData;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.MemoryOp;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.PointerCData;
import org.python.modules.jffi.Util;

@ExposedType(name="jffi.ArrayCData", base=CData.class)
public class ArrayCData
extends CData
implements Pointer {
    public static final PyType TYPE;
    final CType.Array arrayType;
    final CType componentType;
    final MemoryOp componentMemoryOp;
    protected final SequenceIndexDelegate delegator = new SequenceIndexDelegate(){

        public String getTypeName() {
            return ArrayCData.this.getType().fastGetName();
        }

        public void setItem(int n, PyObject pyObject) {
            ArrayCData.this.componentMemoryOp.put(ArrayCData.this.getReferenceMemory(), n * ArrayCData.this.componentType.size(), pyObject);
        }

        public void setSlice(int n, int n2, int n3, PyObject pyObject) {
            if (!(pyObject instanceof PySequenceList)) {
                throw Py.TypeError("expected list or tuple");
            }
            PySequenceList pySequenceList = (PySequenceList)pyObject;
            for (int i = 0; i < n2 - n; ++i) {
                this.setItem(n + i, pySequenceList.pyget(i));
            }
        }

        public int len() {
            return ArrayCData.this.arrayType.length;
        }

        public void delItem(int n) {
            throw Py.TypeError("Array does not support item deletion");
        }

        public void delItems(int n, int n2) {
            throw Py.TypeError("Array does not support item deletion");
        }

        public PyObject getItem(int n) {
            return ArrayCData.this.componentMemoryOp.get(ArrayCData.this.getReferenceMemory(), n * ArrayCData.this.componentType.size());
        }

        public PyObject getSlice(int n, int n2, int n3) {
            PyObject[] pyObjectArray = new PyObject[n2 - n];
            for (int i = 0; i < pyObjectArray.length; ++i) {
                pyObjectArray[i] = this.getItem(n + i);
            }
            return new PyList(pyObjectArray);
        }
    };

    ArrayCData(PyType subtype, CType.Array arrayType, DirectMemory memory, MemoryOp componentMemoryOp) {
        super(subtype, arrayType, memory);
        this.arrayType = arrayType;
        this.componentType = arrayType.componentType;
        this.componentMemoryOp = componentMemoryOp;
    }

    @ExposedNew
    public static PyObject ArrayCData_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        CType.Array arrayType = ArrayCData.getArrayType(subtype);
        boolean clear = args.length < arrayType.length;
        AllocatedNativeMemory memory = AllocatedNativeMemory.allocateAligned(arrayType.componentType.size() * arrayType.length, arrayType.componentType.alignment(), clear);
        int offset = 0;
        for (PyObject value : args) {
            arrayType.componentMemoryOp.put(memory, offset, value);
            offset += arrayType.componentType.size();
        }
        return new ArrayCData(subtype, arrayType, memory, arrayType.componentMemoryOp);
    }

    static final CType.Array getArrayType(PyType subtype) {
        PyObject jffi_type = subtype.__getattr__("_jffi_type");
        if (!(jffi_type instanceof CType.Array)) {
            throw Py.TypeError("invalid _jffi_type for " + subtype.getName());
        }
        return (CType.Array)jffi_type;
    }

    public static final PyObject from_address(PyType subtype, PyObject address) {
        CType.Array arrayType = ArrayCData.getArrayType(subtype);
        DirectMemory m = Util.getMemoryForAddress(address);
        PointerCData cdata = new PointerCData(subtype, arrayType, m.getMemory(0L), arrayType.componentMemoryOp);
        cdata.setReferenceMemory(m);
        return cdata;
    }

    public final DirectMemory getMemory() {
        return this.getReferenceMemory();
    }

    protected final void initReferenceMemory(Memory m) {
    }

    public PyObject __finditem__(int index) {
        return this.delegator.checkIdxAndFindItem(index);
    }

    public PyObject __getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    public void __setitem__(int index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    public void __setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    public void __delitem__(PyObject key) {
        throw Py.TypeError("Array does not support item deletion");
    }

    public PyObject __iter__() {
        return new ArrayIter();
    }

    static {
        PyType.addBuilder(ArrayCData.class, new ArrayCData$PyExposer());
        TYPE = PyType.fromClass(ArrayCData.class);
    }

    public class ArrayIter
    extends PyIterator {
        private int index = 0;

        public PyObject __iternext__() {
            if (this.index >= ArrayCData.this.arrayType.length) {
                return null;
            }
            return ArrayCData.this.componentMemoryOp.get(ArrayCData.this.getReferenceMemory(), this.index++ * ArrayCData.this.componentType.size());
        }
    }

    public class ArrayCData$from_address_exposer
    extends PyBuiltinClassMethodNarrow {
        public ArrayCData$from_address_exposer(String string) {
            super(string, 2, 2);
            this.doc = "";
        }

        public ArrayCData$from_address_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ArrayCData$from_address_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ArrayCData.from_address((PyType)this.self, pyObject);
        }
    }

    public class ArrayCData$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return ArrayCData.ArrayCData_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class ArrayCData$PyExposer
    extends BaseTypeBuilder {
        public ArrayCData$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new ArrayCData$from_address_exposer("from_address")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("jffi.ArrayCData", ArrayCData.class, CData.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new ArrayCData$exposed___new__());
        }
    }
}

