/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import org.python.core.Py;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.NativeType;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.StringCData;
import org.python.modules.jffi.Util;

class DefaultInvokerFactory {
    public static final DefaultInvokerFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    private DefaultInvokerFactory() {
    }

    final Invoker createInvoker(Function function, PyObject pyObject, PyObject[] pyObjectArray) {
        ParameterMarshaller[] parameterMarshallerArray = new ParameterMarshaller[pyObjectArray.length];
        for (int i = 0; i < parameterMarshallerArray.length; ++i) {
            parameterMarshallerArray[i] = DefaultInvokerFactory.getMarshaller(pyObjectArray[i]);
        }
        return this.createInvoker(function, pyObject, parameterMarshallerArray);
    }

    final Invoker createInvoker(Function function, CType[] cTypeArray, CType cType) {
        ParameterMarshaller[] parameterMarshallerArray = new ParameterMarshaller[cTypeArray.length];
        for (int i = 0; i < parameterMarshallerArray.length; ++i) {
            parameterMarshallerArray[i] = DefaultInvokerFactory.getMarshaller(cTypeArray[i]);
        }
        return this.createInvoker(function, (PyObject)cType, parameterMarshallerArray);
    }

    final Invoker createInvoker(Function function, PyObject pyObject, ParameterMarshaller[] parameterMarshallerArray) {
        CType cType = CType.typeOf(pyObject);
        if (cType instanceof CType.Builtin) {
            switch (cType.getNativeType()) {
                case VOID: {
                    return new VoidInvoker(function, parameterMarshallerArray);
                }
                case BYTE: {
                    return new Signed8Invoker(function, parameterMarshallerArray);
                }
                case UBYTE: {
                    return new Unsigned8Invoker(function, parameterMarshallerArray);
                }
                case SHORT: {
                    return new Signed16Invoker(function, parameterMarshallerArray);
                }
                case USHORT: {
                    return new Unsigned16Invoker(function, parameterMarshallerArray);
                }
                case INT: {
                    return new Signed32Invoker(function, parameterMarshallerArray);
                }
                case UINT: {
                    return new Unsigned32Invoker(function, parameterMarshallerArray);
                }
                case LONGLONG: {
                    return new Signed64Invoker(function, parameterMarshallerArray);
                }
                case ULONGLONG: {
                    return new Unsigned64Invoker(function, parameterMarshallerArray);
                }
                case LONG: {
                    return Platform.getPlatform().longSize() == 32 ? new Signed32Invoker(function, parameterMarshallerArray) : new Signed64Invoker(function, parameterMarshallerArray);
                }
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32 ? new Unsigned32Invoker(function, parameterMarshallerArray) : new Unsigned64Invoker(function, parameterMarshallerArray);
                }
                case FLOAT: {
                    return new FloatInvoker(function, parameterMarshallerArray);
                }
                case DOUBLE: {
                    return new DoubleInvoker(function, parameterMarshallerArray);
                }
                case POINTER: {
                    return new PointerInvoker(function, parameterMarshallerArray);
                }
                case STRING: {
                    return new StringInvoker(function, parameterMarshallerArray);
                }
            }
        }
        throw Py.RuntimeError("Unsupported return type: " + pyObject);
    }

    private static final ParameterMarshaller getMarshaller(NativeType nativeType) {
        switch (nativeType) {
            case BYTE: {
                return Signed8Marshaller.INSTANCE;
            }
            case UBYTE: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case SHORT: {
                return Signed16Marshaller.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case LONGLONG: {
                return Signed64Marshaller.INSTANCE;
            }
            case ULONGLONG: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Unsigned32Marshaller.INSTANCE : Unsigned64Marshaller.INSTANCE;
            }
            case FLOAT: {
                return FloatMarshaller.INSTANCE;
            }
            case DOUBLE: {
                return DoubleMarshaller.INSTANCE;
            }
            case POINTER: {
                return PointerMarshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
        }
        throw Py.RuntimeError("Unsupported parameter type: " + (Object)((Object)nativeType));
    }

    private static final ParameterMarshaller getMarshaller(CType cType) {
        if (cType instanceof CType.Builtin) {
            return DefaultInvokerFactory.getMarshaller(cType.getNativeType());
        }
        if (cType instanceof CType.Pointer) {
            return PointerMarshaller.INSTANCE;
        }
        throw Py.RuntimeError("Unsupported parameter type: " + cType);
    }

    private static final ParameterMarshaller getMarshaller(PyObject pyObject) {
        return DefaultInvokerFactory.getMarshaller(CType.typeOf(pyObject));
    }

    private static abstract class BaseInvoker
    implements Invoker {
        final Function jffiFunction;
        final com.kenai.jffi.Invoker jffiInvoker = com.kenai.jffi.Invoker.getInstance();
        final ParameterMarshaller[] marshallers;
        final int arity;

        public BaseInvoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            this.jffiFunction = function;
            this.marshallers = parameterMarshallerArray;
            this.arity = parameterMarshallerArray.length;
        }

        final HeapInvocationBuffer convertArguments(PyObject[] pyObjectArray) {
            this.checkArity(pyObjectArray);
            HeapInvocationBuffer heapInvocationBuffer = new HeapInvocationBuffer(this.jffiFunction);
            for (int i = 0; i < this.marshallers.length; ++i) {
                this.marshallers[i].marshal(heapInvocationBuffer, pyObjectArray[i]);
            }
            return heapInvocationBuffer;
        }

        public final PyObject invoke() {
            return this.invoke(new PyObject[0]);
        }

        public final PyObject invoke(PyObject pyObject) {
            return this.invoke(new PyObject[]{pyObject});
        }

        public final PyObject invoke(PyObject pyObject, PyObject pyObject2) {
            return this.invoke(new PyObject[]{pyObject, pyObject2});
        }

        public final PyObject invoke(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return this.invoke(new PyObject[]{pyObject, pyObject2, pyObject3});
        }

        final void checkArity(PyObject[] pyObjectArray) {
            this.checkArity(pyObjectArray.length);
        }

        final void checkArity(int n) {
            if (n != this.arity) {
                throw Py.TypeError(String.format("expected %d args; got %d", this.arity, n));
            }
        }
    }

    static abstract class BaseMarshaller
    implements ParameterMarshaller {
        BaseMarshaller() {
        }
    }

    private static final class DoubleInvoker
    extends BaseInvoker {
        public DoubleInvoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Py.newFloat(this.jffiInvoker.invokeDouble(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class DoubleMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new DoubleMarshaller();

        private DoubleMarshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putDouble(pyObject.asDouble());
        }
    }

    private static final class FloatInvoker
    extends BaseInvoker {
        public FloatInvoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Py.newFloat(this.jffiInvoker.invokeFloat(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class FloatMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new FloatMarshaller();

        private FloatMarshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putFloat((float)pyObject.asDouble());
        }
    }

    private static interface ParameterMarshaller {
        public void marshal(HeapInvocationBuffer var1, PyObject var2);
    }

    private static final class PointerInvoker
    extends BaseInvoker {
        public PointerInvoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Py.newLong(this.jffiInvoker.invokeAddress(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class PointerMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new PointerMarshaller();

        private PointerMarshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            if (pyObject instanceof Pointer) {
                heapInvocationBuffer.putAddress(((Pointer)((Object)pyObject)).getMemory().getAddress());
            } else if (pyObject == Py.None) {
                heapInvocationBuffer.putAddress(0L);
            } else {
                throw Py.TypeError("expected pointer argument");
            }
        }
    }

    private static final class Signed16Invoker
    extends BaseInvoker {
        public Signed16Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newSigned16(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Signed16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed16Marshaller();

        private Signed16Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putShort(Util.int16Value(pyObject));
        }
    }

    private static final class Signed32Invoker
    extends BaseInvoker {
        public Signed32Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newSigned32(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Signed32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed32Marshaller();

        private Signed32Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putInt(Util.int32Value(pyObject));
        }
    }

    private static final class Signed64Invoker
    extends BaseInvoker {
        public Signed64Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newSigned64(this.jffiInvoker.invokeLong(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Signed64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed64Marshaller();

        private Signed64Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putLong(Util.int64Value(pyObject));
        }
    }

    private static final class Signed8Invoker
    extends BaseInvoker {
        public Signed8Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newSigned8(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Signed8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed8Marshaller();

        private Signed8Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putByte(Util.int8Value(pyObject));
        }
    }

    private static final class SingletonHolder {
        public static final DefaultInvokerFactory INSTANCE = new DefaultInvokerFactory();

        private SingletonHolder() {
        }
    }

    private static final class StringInvoker
    extends BaseInvoker {
        private static final MemoryIO IO = MemoryIO.getInstance();

        public StringInvoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newString(this.jffiInvoker.invokeAddress(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class StringMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            if (pyObject instanceof StringCData) {
                heapInvocationBuffer.putAddress(((StringCData)pyObject).getMemory().getAddress());
            } else if (pyObject instanceof PyNone) {
                heapInvocationBuffer.putAddress(0L);
            } else {
                byte[] byArray = pyObject.toString().getBytes();
                heapInvocationBuffer.putArray(byArray, 0, byArray.length, 5);
            }
        }
    }

    private static final class Unsigned16Invoker
    extends BaseInvoker {
        public Unsigned16Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newUnsigned16(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Unsigned16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned16Marshaller();

        private Unsigned16Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putShort(Util.uint16Value(pyObject));
        }
    }

    private static final class Unsigned32Invoker
    extends BaseInvoker {
        public Unsigned32Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newUnsigned32(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Unsigned32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned32Marshaller();

        private Unsigned32Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putInt(Util.uint32Value(pyObject));
        }
    }

    private static final class Unsigned64Invoker
    extends BaseInvoker {
        public Unsigned64Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newUnsigned64(this.jffiInvoker.invokeLong(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Unsigned64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned64Marshaller();

        private Unsigned64Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putLong(Util.uint64Value(pyObject));
        }
    }

    private static final class Unsigned8Invoker
    extends BaseInvoker {
        public Unsigned8Invoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            return Util.newUnsigned8(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray)));
        }
    }

    private static class Unsigned8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned8Marshaller();

        private Unsigned8Marshaller() {
        }

        public void marshal(HeapInvocationBuffer heapInvocationBuffer, PyObject pyObject) {
            heapInvocationBuffer.putByte(Util.uint8Value(pyObject));
        }
    }

    private static final class VoidInvoker
    extends BaseInvoker {
        public VoidInvoker(Function function, ParameterMarshaller[] parameterMarshallerArray) {
            super(function, parameterMarshallerArray);
        }

        public final PyObject invoke(PyObject[] pyObjectArray) {
            this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(pyObjectArray));
            return Py.None;
        }
    }
}

