/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Library;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;
import org.python.modules.jffi.BasePointer;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.DynamicLibrary$Symbol$name_descriptor;
import org.python.modules.jffi.DynamicLibrary$name_descriptor;
import org.python.modules.jffi.NativeMemory;

@ExposedType(name="jffi.DynamicLibrary", base=PyObject.class)
public class DynamicLibrary
extends PyObject {
    public static final PyType TYPE;
    public final String name;
    private final Library lib;

    DynamicLibrary(String libname, int mode) {
        this.name = libname;
        this.lib = Library.getCachedInstance(libname, mode);
        if (this.lib == null) {
            throw Py.RuntimeError("Could not open " + libname != null ? libname : "[current process] " + Library.getLastError());
        }
    }

    private long findSymbol(PyObject name) {
        long address = this.lib.getSymbolAddress(name.asString());
        if (address == 0L) {
            throw Py.NameError("Could not locate symbol '" + name.asString() + "' in " + this.name);
        }
        return address;
    }

    public final PyObject find_symbol(PyObject name) {
        long address = this.findSymbol(name);
        return new Symbol(this, name.asString(), new NativeMemory(address));
    }

    public final PyObject find_function(PyObject name) {
        return new TextSymbol(this, name.asString(), this.findSymbol(name));
    }

    public final PyObject find_variable(PyObject name) {
        return new DataSymbol(this, name.asString(), this.findSymbol(name));
    }

    static {
        PyType.addBuilder(DynamicLibrary.class, new DynamicLibrary$PyExposer());
        TYPE = PyType.fromClass(DynamicLibrary.class);
    }

    private static final class SymbolMemory
    extends NativeMemory {
        private final DynamicLibrary library;

        public SymbolMemory(DynamicLibrary dynamicLibrary, long l) {
            super(l);
            this.library = dynamicLibrary;
        }
    }

    public static final class DataSymbol
    extends Symbol
    implements ExposeAsSuperclass {
        public DataSymbol(DynamicLibrary dynamicLibrary, String string, long l) {
            super(dynamicLibrary, string, new SymbolMemory(dynamicLibrary, l));
        }
    }

    public static final class TextSymbol
    extends Symbol
    implements ExposeAsSuperclass {
        public TextSymbol(DynamicLibrary dynamicLibrary, String string, long l) {
            super(dynamicLibrary, string, new SymbolMemory(dynamicLibrary, l));
        }
    }

    @ExposedType(name="jffi.DynamicLibrary.Symbol", base=PyObject.class)
    public static class Symbol
    extends BasePointer {
        public static final PyType TYPE;
        final DynamicLibrary library;
        final DirectMemory memory;
        public final String name;

        public Symbol(DynamicLibrary dynamicLibrary, String string, DirectMemory directMemory) {
            super(TYPE);
            this.library = dynamicLibrary;
            this.name = string;
            this.memory = directMemory;
        }

        public final DirectMemory getMemory() {
            return this.memory;
        }

        static {
            PyType.addBuilder(Symbol.class, new DynamicLibrary$Symbol$PyExposer());
            TYPE = PyType.fromClass(Symbol.class);
        }

        public class DynamicLibrary$Symbol$PyExposer
        extends BaseTypeBuilder {
            public DynamicLibrary$Symbol$PyExposer() {
                PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{};
                PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new DynamicLibrary$Symbol$name_descriptor()};
                super("jffi.DynamicLibrary.Symbol", Symbol.class, PyObject.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, null);
            }
        }
    }

    public class DynamicLibrary$find_symbol_exposer
    extends PyBuiltinMethodNarrow {
        public DynamicLibrary$find_symbol_exposer(String string) {
            super(string, 2, 2);
            this.doc = "";
        }

        public DynamicLibrary$find_symbol_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new DynamicLibrary$find_symbol_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((DynamicLibrary)this.self).find_symbol(pyObject);
        }
    }

    public class DynamicLibrary$find_function_exposer
    extends PyBuiltinMethodNarrow {
        public DynamicLibrary$find_function_exposer(String string) {
            super(string, 2, 2);
            this.doc = "";
        }

        public DynamicLibrary$find_function_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new DynamicLibrary$find_function_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((DynamicLibrary)this.self).find_function(pyObject);
        }
    }

    public class DynamicLibrary$find_variable_exposer
    extends PyBuiltinMethodNarrow {
        public DynamicLibrary$find_variable_exposer(String string) {
            super(string, 2, 2);
            this.doc = "";
        }

        public DynamicLibrary$find_variable_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new DynamicLibrary$find_variable_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((DynamicLibrary)this.self).find_variable(pyObject);
        }
    }

    public class DynamicLibrary$PyExposer
    extends BaseTypeBuilder {
        public DynamicLibrary$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new DynamicLibrary$find_symbol_exposer("find_symbol"), new DynamicLibrary$find_function_exposer("find_function"), new DynamicLibrary$find_variable_exposer("find_variable")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new DynamicLibrary$name_descriptor()};
            super("jffi.DynamicLibrary", DynamicLibrary.class, PyObject.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, null);
        }
    }
}

