/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Type;
import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.Pointer;

final class Util {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    private Util() {
    }

    public static final PyObject newSigned8(int n) {
        return Py.newInteger((n &= 0xFF) < 128 ? n : -128 + (n - 128));
    }

    public static final PyObject newUnsigned8(int n) {
        return Py.newInteger(n < 0 ? ((long)n & 0x7FL) + 128L : (long)n);
    }

    public static final PyObject newSigned16(int n) {
        return Py.newInteger((n &= 0xFFFF) < 32768 ? n : Short.MIN_VALUE + (n - 32768));
    }

    public static final PyObject newUnsigned16(int n) {
        return Py.newInteger(n < 0 ? ((long)n & 0x7FFFL) + 32768L : (long)n);
    }

    public static final PyObject newSigned32(int n) {
        return Py.newInteger(n);
    }

    public static final PyObject newUnsigned32(int n) {
        return Py.newInteger(n < 0 ? ((long)n & Integer.MAX_VALUE) + 0x80000000L : (long)n);
    }

    public static final PyObject newSigned64(long l) {
        return Py.newInteger(l);
    }

    public static final PyObject newUnsigned64(long l) {
        return l < 0L ? Py.newLong(BigInteger.valueOf(l & Long.MAX_VALUE).add(UINT64_BASE)) : Py.newInteger(l);
    }

    public static final PyObject newString(long l) {
        return l != 0L ? Py.newString(new String(IO.getZeroTerminatedByteArray(l))) : Py.None;
    }

    public static final byte int8Value(PyObject pyObject) {
        return (byte)pyObject.asInt();
    }

    public static final byte uint8Value(PyObject pyObject) {
        return (byte)pyObject.asInt();
    }

    public static final short int16Value(PyObject pyObject) {
        return (short)pyObject.asInt();
    }

    public static final short uint16Value(PyObject pyObject) {
        return (short)pyObject.asInt();
    }

    public static final int int32Value(PyObject pyObject) {
        return pyObject.asInt();
    }

    public static final int uint32Value(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return pyObject.asInt();
        }
        if (pyObject instanceof PyLong) {
            return (int)((PyLong)pyObject).asLong(0);
        }
        return (int)Util.__long__value(pyObject);
    }

    public static final long int64Value(PyObject pyObject) {
        return pyObject.asLong();
    }

    public static final long uint64Value(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).getValue().longValue();
        }
        if (pyObject instanceof PyInteger) {
            return pyObject.asInt();
        }
        return Util.__long__value(pyObject);
    }

    public static final float floatValue(PyObject pyObject) {
        return (float)pyObject.asDouble();
    }

    public static final double doubleValue(PyObject pyObject) {
        return pyObject.asDouble();
    }

    private static final long __long__value(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__long__();
        if (pyObject2 instanceof PyLong) {
            return ((PyLong)pyObject2).getValue().longValue();
        }
        if (pyObject2 instanceof PyInteger) {
            return pyObject.asInt();
        }
        throw Py.TypeError("invalid __long__() result");
    }

    public static final void checkBounds(long l, long l2, long l3) {
        if ((l2 | l3 | l2 + l3 | l - (l2 + l3)) < 0L) {
            throw Py.IndexError("Memory access offset=" + l2 + " size=" + l3 + " is out of bounds");
        }
    }

    static final DirectMemory getMemoryForAddress(PyObject pyObject) {
        if (pyObject instanceof Pointer) {
            return ((Pointer)((Object)pyObject)).getMemory();
        }
        if (pyObject instanceof PyInteger) {
            return new NativeMemory(pyObject.asInt());
        }
        if (pyObject instanceof PyLong) {
            return new NativeMemory(((PyLong)pyObject).getValue().longValue());
        }
        throw Py.TypeError("invalid address");
    }

    static final Type jffiType(CType cType) {
        return cType.jffiType();
    }
}

