/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class math
implements ClassDictInit {
    public static PyFloat pi = new PyFloat(Math.PI);
    public static PyFloat e = new PyFloat(Math.E);

    public static void classDictInit(PyObject pyObject) {
    }

    private static double check(double d) {
        if (Double.isNaN(d)) {
            throw Py.ValueError("math domain error");
        }
        if (Double.isInfinite(d)) {
            throw Py.OverflowError("math range error");
        }
        return d;
    }

    public static double acos(double d) {
        return math.check(Math.acos(d));
    }

    public static double asin(double d) {
        return math.check(Math.asin(d));
    }

    public static double atan(double d) {
        return math.check(Math.atan(d));
    }

    public static double atan2(double d, double d2) {
        return math.check(Math.atan2(d, d2));
    }

    public static double ceil(double d) {
        return math.check(Math.ceil(d));
    }

    public static double cos(double d) {
        return math.check(Math.cos(d));
    }

    public static double exp(double d) {
        return math.check(Math.exp(d));
    }

    public static double floor(PyObject pyObject) {
        return math.floor(pyObject.asDouble());
    }

    public static double floor(double d) {
        return math.check(Math.floor(d));
    }

    public static double log(PyObject pyObject) {
        return math.log(pyObject, null);
    }

    public static double log(PyObject pyObject, PyObject pyObject2) {
        double d = pyObject instanceof PyLong ? math.calculateLongLog((PyLong)pyObject) : math.log(pyObject.asDouble());
        if (pyObject2 != null) {
            return math.check(math.applyLoggedBase(d, pyObject2));
        }
        return d;
    }

    private static double calculateLongLog(PyLong pyLong) {
        int[] nArray = new int[1];
        double d = pyLong.scaledDoubleValue(nArray);
        if (d <= 0.0) {
            throw Py.ValueError("math domain error");
        }
        return math.log(d) + (double)nArray[0] * 8.0 * math.log(2.0);
    }

    private static double applyLoggedBase(double d, PyObject pyObject) {
        double d2 = pyObject instanceof PyLong ? math.calculateLongLog((PyLong)pyObject) : math.log(pyObject.asDouble());
        return math.check(d / d2);
    }

    private static double log(double d) {
        return math.check(Math.log(d));
    }

    public static double pow(double d, double d2) {
        return math.check(Math.pow(d, d2));
    }

    public static double sin(PyObject pyObject) {
        return math.sin(pyObject.asDouble());
    }

    public static double sin(double d) {
        return math.check(Math.sin(d));
    }

    public static double sqrt(PyObject pyObject) {
        return math.sqrt(pyObject.asDouble());
    }

    public static double sqrt(double d) {
        return math.check(Math.sqrt(d));
    }

    public static double tan(double d) {
        return math.check(Math.tan(d));
    }

    public static double log10(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            int[] nArray = new int[1];
            double d = ((PyLong)pyObject).scaledDoubleValue(nArray);
            if (d <= 0.0) {
                throw Py.ValueError("math domain error");
            }
            return math.log10(d) + (double)nArray[0] * 8.0 * math.log10(2.0);
        }
        return math.log10(pyObject.asDouble());
    }

    private static double log10(double d) {
        return math.check(Math.log10(d));
    }

    public static double sinh(double d) {
        return math.check(0.5 * (Math.exp(d) - Math.exp(-d)));
    }

    public static double cosh(double d) {
        return math.check(0.5 * (Math.exp(d) + Math.exp(-d)));
    }

    public static double tanh(double d) {
        return math.check(math.sinh(d) / math.cosh(d));
    }

    public static double fabs(double d) {
        return Math.abs(d);
    }

    public static double fmod(double d, double d2) {
        return d % d2;
    }

    public static PyTuple modf(double d) {
        double d2 = d % 1.0;
        return new PyTuple(new PyFloat(d2), new PyFloat(d -= d2));
    }

    public static PyTuple frexp(double d) {
        int n = 0;
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            n = 0;
        } else {
            int n2 = 1;
            if (d < 0.0) {
                d = -d;
                n2 = -1;
            }
            while (d < 0.5) {
                d *= 2.0;
                --n;
            }
            while (d >= 1.0) {
                d *= 0.5;
                ++n;
            }
            d *= (double)n2;
        }
        return new PyTuple(new PyFloat(d), new PyInteger(n));
    }

    public static double ldexp(double d, PyObject pyObject) {
        int n = pyObject.asInt();
        return math.check(d * Math.pow(2.0, n));
    }

    public static double hypot(double d, double d2) {
        return math.check(Math.hypot(d, d2));
    }

    public static double radians(double d) {
        return math.check(Math.toRadians(d));
    }

    public static double degrees(double d) {
        return math.check(Math.toDegrees(d));
    }
}

