/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.posix;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.util.ListIterator;
import java.util.Map;
import org.python.constantine.Constant;
import org.python.constantine.platform.linux.Errno;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.imp;
import org.python.core.io.FileDescriptors;
import org.python.core.io.FileIO;
import org.python.core.io.IOBase;
import org.python.core.io.RawIOBase;
import org.python.core.util.RelativeFile;
import org.python.core.util.StringUtil;
import org.python.modules.posix.Hide;
import org.python.modules.posix.Hider;
import org.python.modules.posix.OS;
import org.python.modules.posix.PosixImpl;
import org.python.modules.posix.PyStatResult;
import org.python.modules.posix.PythonPOSIXHandler;
import org.python.posix.FileStat;
import org.python.posix.POSIX;
import org.python.posix.POSIXFactory;
import org.python.posix.util.Platform;

public class PosixModule
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("This module provides access to operating system functionality that is\nstandardized by the C Standard and the POSIX standard (a thinly\ndisguised Unix interface).  Refer to the library manual and\ncorresponding Unix manual entries for more information on calls.");
    private static OS os = OS.getOS();
    private static POSIX posix = POSIXFactory.getPOSIX(new PythonPOSIXHandler(), true);
    private static int O_RDONLY = 0;
    private static int O_WRONLY = 1;
    private static int O_RDWR = 2;
    private static int O_APPEND = 8;
    private static int O_SYNC = 128;
    private static int O_CREAT = 512;
    private static int O_TRUNC = 1024;
    private static int O_EXCL = 2048;
    private static int F_OK = 0;
    private static int X_OK = 1;
    private static int W_OK = 2;
    private static int R_OK = 4;
    private static PyObject realpath;
    public static PyString __doc___exit;
    public static PyString __doc__access;
    public static PyString __doc__chdir;
    public static PyString __doc__chmod;
    public static PyString __doc__chown;
    public static PyString __doc__close;
    public static PyString __doc__fdopen;
    public static PyString __doc__fdatasync;
    public static PyString __doc__fsync;
    public static PyString __doc__ftruncate;
    public static PyString __doc__getcwd;
    public static PyString __doc__getcwdu;
    public static PyString __doc__getegid;
    public static PyString __doc__geteuid;
    public static PyString __doc__getgid;
    public static PyString __doc__getlogin;
    public static PyString __doc__getppid;
    public static PyString __doc__getuid;
    public static PyString __doc__getpid;
    public static PyString __doc__getpgrp;
    public static PyString __doc__isatty;
    public static PyString __doc__kill;
    public static PyString __doc__lchmod;
    public static PyString __doc__lchown;
    public static PyString __doc__link;
    public static PyString __doc__listdir;
    public static PyString __doc__lseek;
    public static PyString __doc__mkdir;
    public static PyString __doc__open;
    public static PyString __doc__popen;
    public static PyString __doc__putenv;
    public static PyString __doc__read;
    public static PyString __doc__readlink;
    public static PyString __doc__remove;
    public static PyString __doc__rename;
    public static PyString __doc__rmdir;
    public static PyString __doc__setpgrp;
    public static PyString __doc__setsid;
    public static PyString __doc__strerror;
    public static PyString __doc__symlink;
    public static PyString __doc__system;
    public static PyString __doc__umask;
    public static PyString __doc__unlink;
    public static PyString __doc__utime;
    public static PyString __doc__wait;
    public static PyString __doc__waitpid;
    public static PyString __doc__write;
    public static PyString __doc__unsetenv;
    public static PyString __doc__urandom;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("O_RDONLY", (PyObject)Py.newInteger(O_RDONLY));
        pyObject.__setitem__("O_WRONLY", (PyObject)Py.newInteger(O_WRONLY));
        pyObject.__setitem__("O_RDWR", (PyObject)Py.newInteger(O_RDWR));
        pyObject.__setitem__("O_APPEND", (PyObject)Py.newInteger(O_APPEND));
        pyObject.__setitem__("O_SYNC", (PyObject)Py.newInteger(O_SYNC));
        pyObject.__setitem__("O_CREAT", (PyObject)Py.newInteger(O_CREAT));
        pyObject.__setitem__("O_TRUNC", (PyObject)Py.newInteger(O_TRUNC));
        pyObject.__setitem__("O_EXCL", (PyObject)Py.newInteger(O_EXCL));
        pyObject.__setitem__("F_OK", (PyObject)Py.newInteger(F_OK));
        pyObject.__setitem__("X_OK", (PyObject)Py.newInteger(X_OK));
        pyObject.__setitem__("W_OK", (PyObject)Py.newInteger(W_OK));
        pyObject.__setitem__("R_OK", (PyObject)Py.newInteger(R_OK));
        pyObject.__setitem__("EX_OK", (PyObject)Py.Zero);
        boolean bl = posix.isNative();
        pyObject.__setitem__("_native_posix", (PyObject)Py.newBoolean(bl));
        pyObject.__setitem__("_posix_impl", Py.java2py(posix));
        pyObject.__setitem__("environ", PosixModule.getEnviron());
        pyObject.__setitem__("error", Py.OSError);
        pyObject.__setitem__("stat_result", (PyObject)PyStatResult.TYPE);
        pyObject.__setitem__("lstat", (PyObject)new LstatFunction());
        pyObject.__setitem__("stat", (PyObject)new StatFunction());
        Hider.hideFunctions(PosixModule.class, pyObject, os, bl);
        pyObject.__setitem__("classDictInit", null);
        pyObject.__setitem__("__init__", null);
        pyObject.__setitem__("getPOSIX", null);
        pyObject.__setitem__("getOSName", null);
        pyObject.__setitem__("badFD", null);
        PyList pyList = (PyList)pyObject.invoke("keys");
        ListIterator listIterator = pyList.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (!string.startsWith("__doc__")) continue;
            listIterator.remove();
            pyObject.__setitem__(string, null);
        }
        pyObject.__setitem__("__all__", (PyObject)pyList);
        pyObject.__setitem__("__name__", (PyObject)new PyString(os.getModuleName()));
        pyObject.__setitem__("__doc__", (PyObject)__doc__);
    }

    public static void _exit() {
        PosixModule._exit(0);
    }

    public static void _exit(int n) {
        System.exit(n);
    }

    public static boolean access(String string, int n) {
        PosixModule.ensurePath(string);
        boolean bl = true;
        RelativeFile relativeFile = new RelativeFile(string);
        if (!relativeFile.exists()) {
            bl = false;
        }
        if ((n & R_OK) != 0 && !relativeFile.canRead()) {
            bl = false;
        }
        if ((n & W_OK) != 0 && !relativeFile.canWrite()) {
            bl = false;
        }
        if ((n & X_OK) != 0) {
            try {
                bl = posix.stat(relativeFile.getPath()).isExecutable();
            }
            catch (PyException pyException) {
                if (!pyException.match(Py.OSError)) {
                    throw pyException;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static void chdir(PyObject pyObject) {
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError(String.format("coercing to Unicode: need string, '%s' type found", pyObject.getType().fastGetName()));
        }
        String string = pyObject.toString();
        if (!posix.stat(PosixModule.absolutePath(string)).isDirectory()) {
            throw Py.OSError(org.python.constantine.platform.Errno.ENOTDIR, string);
        }
        if (realpath == null) {
            realpath = imp.load("os.path").__getattr__("realpath");
        }
        Py.getSystemState().setCurrentWorkingDir(realpath.__call__(pyObject).toString());
    }

    public static void chmod(String string, int n) {
        if (posix.chmod(PosixModule.absolutePath(string), n) < 0) {
            throw PosixModule.errorFromErrno(string);
        }
    }

    @Hide(value={OS.NT})
    public static void chown(String string, int n, int n2) {
        if (posix.chown(PosixModule.absolutePath(string), n, n2) < 0) {
            throw PosixModule.errorFromErrno(string);
        }
    }

    public static void close(PyObject pyObject) {
        try {
            FileDescriptors.get(pyObject).close();
        }
        catch (PyException pyException) {
            throw PosixModule.badFD();
        }
    }

    public static PyObject fdopen(PyObject pyObject) {
        return PosixModule.fdopen(pyObject, "r");
    }

    public static PyObject fdopen(PyObject pyObject, String string) {
        return PosixModule.fdopen(pyObject, string, -1);
    }

    public static PyObject fdopen(PyObject pyObject, String string, int n) {
        if (string.length() == 0 || !"rwa".contains("" + string.charAt(0))) {
            throw Py.ValueError(String.format("invalid file mode '%s'", string));
        }
        RawIOBase rawIOBase = FileDescriptors.get(pyObject);
        if (rawIOBase.closed()) {
            throw PosixModule.badFD();
        }
        try {
            return new PyFile(rawIOBase, "<fdopen>", string, n);
        }
        catch (PyException pyException) {
            if (!pyException.match(Py.IOError)) {
                throw pyException;
            }
            throw Py.OSError(org.python.constantine.platform.Errno.EINVAL);
        }
    }

    @Hide(value={OS.NT})
    public static void fdatasync(PyObject pyObject) {
        PosixModule.fsync(pyObject, false);
    }

    public static void fsync(PyObject pyObject) {
        PosixModule.fsync(pyObject, true);
    }

    private static void fsync(PyObject pyObject, boolean bl) {
        RawIOBase rawIOBase = FileDescriptors.get(pyObject);
        rawIOBase.checkClosed();
        Channel channel = rawIOBase.getChannel();
        if (!(channel instanceof FileChannel)) {
            throw Py.OSError(org.python.constantine.platform.Errno.EINVAL);
        }
        try {
            ((FileChannel)channel).force(bl);
        }
        catch (ClosedChannelException closedChannelException) {
            throw Py.ValueError("I/O operation on closed file");
        }
        catch (IOException iOException) {
            throw Py.OSError(iOException);
        }
    }

    public static void ftruncate(PyObject pyObject, long l) {
        try {
            FileDescriptors.get(pyObject).truncate(l);
        }
        catch (PyException pyException) {
            throw Py.IOError(org.python.constantine.platform.Errno.EBADF);
        }
    }

    public static PyObject getcwd() {
        return Py.newString(Py.getSystemState().getCurrentWorkingDir());
    }

    public static PyObject getcwdu() {
        return Py.newUnicode(Py.getSystemState().getCurrentWorkingDir());
    }

    @Hide(value={OS.NT})
    public static int getegid() {
        return posix.getegid();
    }

    @Hide(value={OS.NT})
    public static int geteuid() {
        return posix.geteuid();
    }

    @Hide(value={OS.NT})
    public static int getgid() {
        return posix.getgid();
    }

    @Hide(value={OS.NT})
    public static PyObject getlogin() {
        return new PyString(posix.getlogin());
    }

    @Hide(value={OS.NT})
    public static int getppid() {
        return posix.getppid();
    }

    @Hide(value={OS.NT})
    public static int getuid() {
        return posix.getuid();
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static int getpid() {
        return posix.getpid();
    }

    @Hide(value={OS.NT})
    public static int getpgrp() {
        return posix.getpgrp();
    }

    public static boolean isatty(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            FileDescriptor fileDescriptor;
            switch (pyObject.asInt()) {
                case 0: {
                    fileDescriptor = FileDescriptor.in;
                    break;
                }
                case 1: {
                    fileDescriptor = FileDescriptor.out;
                    break;
                }
                case 2: {
                    fileDescriptor = FileDescriptor.err;
                    break;
                }
                default: {
                    throw Py.NotImplementedError("Integer file descriptor compatibility only available for stdin, stdout and stderr (0-2)");
                }
            }
            return posix.isatty(fileDescriptor);
        }
        Object object = pyObject.__tojava__(FileDescriptor.class);
        if (object != Py.NoConversion) {
            return posix.isatty((FileDescriptor)object);
        }
        object = pyObject.__tojava__(IOBase.class);
        if (object == Py.NoConversion) {
            throw Py.TypeError("a file descriptor is required");
        }
        return ((IOBase)object).isatty();
    }

    @Hide(value={OS.NT})
    public static void kill(int n, int n2) {
        if (posix.kill(n, n2) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    @Hide(value={OS.NT})
    public static void lchmod(String string, int n) {
        if (posix.lchmod(PosixModule.absolutePath(string), n) < 0) {
            throw PosixModule.errorFromErrno(string);
        }
    }

    @Hide(value={OS.NT})
    public static void lchown(String string, int n, int n2) {
        if (posix.lchown(PosixModule.absolutePath(string), n, n2) < 0) {
            throw PosixModule.errorFromErrno(string);
        }
    }

    @Hide(value={OS.NT})
    public static void link(String string, String string2) {
        posix.link(PosixModule.absolutePath(string), PosixModule.absolutePath(string2));
    }

    public static PyList listdir(PyObject pyObject) {
        PosixModule.ensurePath(pyObject);
        String string = pyObject.asString();
        PyList pyList = new PyList();
        RelativeFile relativeFile = new RelativeFile(string);
        String[] stringArray = relativeFile.list();
        if (stringArray == null) {
            FileStat fileStat = posix.stat(relativeFile.getPath());
            if (!fileStat.isDirectory()) {
                throw Py.OSError(org.python.constantine.platform.Errno.ENOTDIR, string);
            }
            if (!relativeFile.canRead()) {
                throw Py.OSError(org.python.constantine.platform.Errno.EACCES, string);
            }
            throw Py.OSError("listdir(): an unknown error occured: " + string);
        }
        PyString pyString = (PyString)pyObject;
        for (String string2 : stringArray) {
            pyList.append(pyString.createInstance(string2));
        }
        return pyList;
    }

    public static long lseek(PyObject pyObject, long l, int n) {
        try {
            return FileDescriptors.get(pyObject).seek(l, n);
        }
        catch (PyException pyException) {
            throw PosixModule.badFD();
        }
    }

    public static void mkdir(String string) {
        PosixModule.mkdir(string, 511);
    }

    public static void mkdir(String string, int n) {
        if (posix.mkdir(PosixModule.absolutePath(string), n) < 0) {
            throw PosixModule.errorFromErrno(string);
        }
    }

    public static FileIO open(String string, int n) {
        return PosixModule.open(string, n, 511);
    }

    public static FileIO open(String string, int n, int n2) {
        PosixModule.ensurePath(string);
        boolean bl = (n & O_RDONLY) != 0;
        boolean bl2 = (n & O_WRONLY) != 0;
        boolean bl3 = (n & O_RDWR) != 0;
        boolean bl4 = (n & O_CREAT) != 0;
        boolean bl5 = (n & O_APPEND) != 0;
        boolean bl6 = (n & O_TRUNC) != 0;
        boolean bl7 = (n & O_EXCL) != 0;
        boolean bl8 = (n & O_SYNC) != 0;
        RelativeFile relativeFile = new RelativeFile(string);
        if (bl3 && bl2) {
            throw Py.OSError(org.python.constantine.platform.Errno.EINVAL, string);
        }
        if (!bl4 && !relativeFile.exists()) {
            throw Py.OSError(org.python.constantine.platform.Errno.ENOENT, string);
        }
        if (!bl2) {
            if (bl3) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        if (bl6 && !bl2) {
            new FileIO(string, "w").close();
        }
        if (bl7 && bl4) {
            try {
                if (!relativeFile.createNewFile()) {
                    throw Py.OSError(org.python.constantine.platform.Errno.EEXIST, string);
                }
            }
            catch (IOException iOException) {
                throw Py.OSError(iOException);
            }
        }
        String string2 = (bl ? "r" : "") + (!bl5 && bl2 ? "w" : "") + (bl5 && (bl2 || bl3) ? "a" : "") + (bl3 ? "+" : "");
        if (bl8 && (bl2 || bl3)) {
            try {
                return new FileIO(new RandomAccessFile(relativeFile, "rws").getChannel(), string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw Py.OSError(relativeFile.isDirectory() ? org.python.constantine.platform.Errno.EISDIR : org.python.constantine.platform.Errno.ENOENT, string);
            }
        }
        return new FileIO(string, string2);
    }

    public static PyObject popen(PyObject[] pyObjectArray, String[] stringArray) {
        return imp.load("os").__getattr__("popen").__call__(pyObjectArray, stringArray);
    }

    public static void putenv(String string, String string2) {
        PyObject pyObject = imp.load("os").__getattr__("environ");
        pyObject.__setitem__(string, (PyObject)new PyString(string2));
    }

    public static String read(PyObject pyObject, int n) {
        try {
            return StringUtil.fromBytes(FileDescriptors.get(pyObject).read(n));
        }
        catch (PyException pyException) {
            throw PosixModule.badFD();
        }
    }

    @Hide(value={OS.NT})
    public static String readlink(String string) {
        try {
            return posix.readlink(PosixModule.absolutePath(string));
        }
        catch (IOException iOException) {
            throw Py.OSError(iOException);
        }
    }

    public static void remove(String string) {
        PosixModule.unlink(string);
    }

    public static void rename(String string, String string2) {
        if (!new RelativeFile(string).renameTo(new RelativeFile(string2))) {
            PyTuple pyTuple = new PyTuple(Py.Zero, new PyString("Couldn't rename file"));
            throw new PyException(Py.OSError, pyTuple);
        }
    }

    public static void rmdir(String string) {
        RelativeFile relativeFile = new RelativeFile(string);
        if (!relativeFile.exists()) {
            throw Py.OSError(org.python.constantine.platform.Errno.ENOENT, string);
        }
        if (!relativeFile.isDirectory()) {
            throw Py.OSError(org.python.constantine.platform.Errno.ENOTDIR, string);
        }
        if (!relativeFile.delete()) {
            PyTuple pyTuple = new PyTuple(Py.Zero, new PyString("Couldn't delete directory"), new PyString(string));
            throw new PyException(Py.OSError, pyTuple);
        }
    }

    @Hide(value={OS.NT})
    public static void setpgrp() {
        if (posix.setpgrp(0, 0) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    @Hide(value={OS.NT})
    public static void setsid() {
        if (posix.setsid() < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    public static PyObject strerror(int n) {
        Constant constant = org.python.constantine.platform.Errno.valueOf(n);
        if (constant == org.python.constantine.platform.Errno.__UNKNOWN_CONSTANT__) {
            return new PyString("Unknown error: " + n);
        }
        if (constant.name() == ((Object)constant).toString()) {
            constant = Enum.valueOf(Errno.class, constant.name());
        }
        return new PyString(((Object)constant).toString());
    }

    @Hide(value={OS.NT})
    public static void symlink(String string, String string2) {
        PosixModule.ensurePath(string);
        posix.symlink(string, PosixModule.absolutePath(string2));
    }

    public static PyObject system(PyObject pyObject) {
        return imp.load("subprocess").invoke("call", pyObject, new PyObject[]{Py.True}, new String[]{"shell"});
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static int umask(int n) {
        return posix.umask(n);
    }

    public static void unlink(String string) {
        PosixModule.ensurePath(string);
        RelativeFile relativeFile = new RelativeFile(string);
        if (!relativeFile.delete()) {
            posix.stat(PosixModule.absolutePath(string));
            if (relativeFile.isDirectory()) {
                throw Py.OSError(org.python.constantine.platform.Errno.EISDIR, string);
            }
            if (!relativeFile.canWrite()) {
                throw Py.OSError(org.python.constantine.platform.Errno.EPERM, string);
            }
            throw Py.OSError("unlink(): an unknown error occured: " + string);
        }
    }

    public static void utime(String string, PyObject pyObject) {
        long[] lArray;
        long[] lArray2;
        if (pyObject == Py.None) {
            lArray2 = null;
            lArray = null;
        } else if (pyObject instanceof PyTuple && pyObject.__len__() == 2) {
            lArray = PosixModule.extractTimeval(pyObject.__getitem__(0));
            lArray2 = PosixModule.extractTimeval(pyObject.__getitem__(1));
        } else {
            throw Py.TypeError("utime() arg 2 must be a tuple (atime, mtime)");
        }
        posix.utimes(PosixModule.absolutePath(string), lArray, lArray2);
    }

    private static long[] extractTimeval(PyObject pyObject) {
        long[] lArray = new long[]{Platform.IS_32_BIT ? (long)pyObject.asInt() : pyObject.asLong(), 0L};
        if (pyObject instanceof PyFloat) {
            long l = (long)(pyObject.asDouble() % 1.0 * 1000000.0);
            if (l < 0L) {
                l = 0L;
            }
            lArray[1] = l;
        }
        return lArray;
    }

    @Hide(value={OS.NT})
    public static PyObject wait$() {
        int[] nArray = new int[1];
        int n = posix.wait(nArray);
        if (n < 0) {
            throw PosixModule.errorFromErrno();
        }
        return new PyTuple(Py.newInteger(n), Py.newInteger(nArray[0]));
    }

    public static PyObject waitpid(int n, int n2) {
        int[] nArray = new int[1];
        if ((n = posix.waitpid(n, nArray, n2)) < 0) {
            throw PosixModule.errorFromErrno();
        }
        return new PyTuple(Py.newInteger(n), Py.newInteger(nArray[0]));
    }

    public static int write(PyObject pyObject, String string) {
        try {
            return FileDescriptors.get(pyObject).write(ByteBuffer.wrap(StringUtil.toBytes(string)));
        }
        catch (PyException pyException) {
            throw PosixModule.badFD();
        }
    }

    public static void unsetenv(String string) {
        block2: {
            PyObject pyObject = imp.load("os").__getattr__("environ");
            try {
                pyObject.__delitem__(string);
            }
            catch (PyException pyException) {
                if (pyException.match(Py.KeyError)) break block2;
                throw pyException;
            }
        }
    }

    public static PyObject urandom(int n) {
        byte[] byArray = new byte[n];
        UrandomSource.INSTANCE.nextBytes(byArray);
        return new PyString(StringUtil.fromBytes(byArray));
    }

    public static PyObject _get_shell_commands() {
        String[][] stringArray = os.getShellCommands();
        PyObject[] pyObjectArray = new PyObject[stringArray.length];
        int n = 0;
        for (String[] stringArray2 : stringArray) {
            PyList pyList = new PyList();
            for (String string : stringArray2) {
                pyList.append(new PyString(string));
            }
            pyObjectArray[n++] = pyList;
        }
        return new PyTuple(pyObjectArray);
    }

    private static PyObject getEnviron() {
        Map<String, String> map;
        PyDictionary pyDictionary = new PyDictionary();
        try {
            map = System.getenv();
        }
        catch (SecurityException securityException) {
            return pyDictionary;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ((PyObject)pyDictionary).__setitem__(Py.newString(entry.getKey()), (PyObject)Py.newString(entry.getValue()));
        }
        return pyDictionary;
    }

    private static String absolutePath(String string) {
        PosixModule.ensurePath(string);
        return new RelativeFile(string).getPath();
    }

    private static void ensurePath(PyObject pyObject) {
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError(String.format("coercing to Unicode: need string, %s type found", pyObject.getType().fastGetName()));
        }
    }

    private static void ensurePath(String string) {
        if (string == null) {
            throw Py.TypeError("coercing to Unicode: need string or buffer, NoneType found");
        }
    }

    private static PyException badFD() {
        return Py.OSError(org.python.constantine.platform.Errno.EBADF);
    }

    private static PyException errorFromErrno() {
        return Py.OSError(org.python.constantine.platform.Errno.valueOf(posix.errno()));
    }

    private static PyException errorFromErrno(String string) {
        return Py.OSError(org.python.constantine.platform.Errno.valueOf(posix.errno()), string);
    }

    public static POSIX getPOSIX() {
        return posix;
    }

    public static String getOSName() {
        return os.getModuleName();
    }

    static {
        __doc___exit = new PyString("_exit(status)\n\nExit to the system with specified status, without normal exit processing.");
        __doc__access = new PyString("access(path, mode) -> True if granted, False otherwise\n\nUse the real uid/gid to test for access to a path.  Note that most\noperations will use the effective uid/gid, therefore this routine can\nbe used in a suid/sgid environment to test if the invoking user has the\nspecified access to the path.  The mode argument can be F_OK to test\nexistence, or the inclusive-OR of R_OK, W_OK, and X_OK.");
        __doc__chdir = new PyString("chdir(path)\n\nChange the current working directory to the specified path.");
        __doc__chmod = new PyString("chmod(path, mode)\n\nChange the access permissions of a file.");
        __doc__chown = new PyString("chown(path, uid, gid)\n\nChange the owner and group id of path to the numeric uid and gid.");
        __doc__close = new PyString("close(fd)\n\nClose a file descriptor (for low level IO).");
        __doc__fdopen = new PyString("fdopen(fd [, mode='r' [, bufsize]]) -> file_object\n\nReturn an open file object connected to a file descriptor.");
        __doc__fdatasync = new PyString("fdatasync(fildes)\n\nforce write of file with filedescriptor to disk.\ndoes not force update of metadata.");
        __doc__fsync = new PyString("fsync(fildes)\n\nforce write of file with filedescriptor to disk.");
        __doc__ftruncate = new PyString("ftruncate(fd, length)\n\nTruncate a file to a specified length.");
        __doc__getcwd = new PyString("getcwd() -> path\n\nReturn a string representing the current working directory.");
        __doc__getcwdu = new PyString("getcwd() -> path\n\nReturn a unicode string representing the current working directory.");
        __doc__getegid = new PyString("getegid() -> egid\n\nReturn the current process's effective group id.");
        __doc__geteuid = new PyString("geteuid() -> euid\n\nReturn the current process's effective user id.");
        __doc__getgid = new PyString("getgid() -> gid\n\nReturn the current process's group id.");
        __doc__getlogin = new PyString("getlogin() -> string\n\nReturn the actual login name.");
        __doc__getppid = new PyString("getppid() -> ppid\n\nReturn the parent's process id.");
        __doc__getuid = new PyString("getuid() -> uid\n\nReturn the current process's user id.");
        __doc__getpid = new PyString("getpid() -> pid\n\nReturn the current process id");
        __doc__getpgrp = new PyString("getpgrp() -> pgrp\n\nReturn the current process group id.");
        __doc__isatty = new PyString("isatty(fd) -> bool\n\nReturn True if the file descriptor 'fd' is an open file descriptor\nconnected to the slave end of a terminal.");
        __doc__kill = new PyString("kill(pid, sig)\n\nKill a process with a signal.");
        __doc__lchmod = new PyString("lchmod(path, mode)\n\nChange the access permissions of a file. If path is a symlink, this\naffects the link itself rather than the target.");
        __doc__lchown = new PyString("lchown(path, uid, gid)\n\nChange the owner and group id of path to the numeric uid and gid.\nThis function will not follow symbolic links.");
        __doc__link = new PyString("link(src, dst)\n\nCreate a hard link to a file.");
        __doc__listdir = new PyString("listdir(path) -> list_of_strings\n\nReturn a list containing the names of the entries in the directory.\n\npath: path of directory to list\n\nThe list is in arbitrary order.  It does not include the special\nentries '.' and '..' even if they are present in the directory.");
        __doc__lseek = new PyString("lseek(fd, pos, how) -> newpos\n\nSet the current position of a file descriptor.");
        __doc__mkdir = new PyString("mkdir(path [, mode=0777])\n\nCreate a directory.");
        __doc__open = new PyString("open(filename, flag [, mode=0777]) -> fd\n\nOpen a file (for low level IO).\n\nNote that the mode argument is not currently supported on Jython.");
        __doc__popen = new PyString("popen(command [, mode='r' [, bufsize]]) -> pipe\n\nOpen a pipe to/from a command returning a file object.");
        __doc__putenv = new PyString("putenv(key, value)\n\nChange or add an environment variable.");
        __doc__read = new PyString("read(fd, buffersize) -> string\n\nRead a file descriptor.");
        __doc__readlink = new PyString("readlink(path) -> path\n\nReturn a string representing the path to which the symbolic link points.");
        __doc__remove = new PyString("remove(path)\n\nRemove a file (same as unlink(path)).");
        __doc__rename = new PyString("rename(old, new)\n\nRename a file or directory.");
        __doc__rmdir = new PyString("rmdir(path)\n\nRemove a directory.");
        __doc__setpgrp = new PyString("setpgrp()\n\nMake this process a session leader.");
        __doc__setsid = new PyString("setsid()\n\nCall the system call setsid().");
        __doc__strerror = new PyString("strerror(code) -> string\n\nTranslate an error code to a message string.");
        __doc__symlink = new PyString("symlink(src, dst)\n\nCreate a symbolic link pointing to src named dst.");
        __doc__system = new PyString("system(command) -> exit_status\n\nExecute the command (a string) in a subshell.");
        __doc__umask = new PyString("umask(new_mask) -> old_mask\n\nSet the current numeric umask and return the previous umask.");
        __doc__unlink = new PyString("unlink(path)\n\nRemove a file (same as remove(path)).");
        __doc__utime = new PyString("utime(path, (atime, mtime))\nutime(path, None)\n\nSet the access and modified time of the file to the given values.  If the\nsecond form is used, set the access and modified times to the current time.");
        __doc__wait = new PyString("wait() -> (pid, status)\n\nWait for completion of a child process.");
        __doc__waitpid = new PyString("wait() -> (pid, status)\n\nWait for completion of a child process.");
        __doc__write = new PyString("write(fd, string) -> byteswritten\n\nWrite a string to a file descriptor.");
        __doc__unsetenv = new PyString("unsetenv(key)\n\nDelete an environment variable.");
        __doc__urandom = new PyString("urandom(n) -> str\n\nReturn a string of n random bytes suitable for cryptographic use.");
    }

    static class LstatFunction
    extends PyBuiltinFunction {
        LstatFunction() {
            super("lstat", "lstat(path) -> stat result\n\nLike stat(path), but do not follow symbolic links.");
        }

        public PyObject __call__(ThreadState threadState, PyObject pyObject) {
            if (!(pyObject instanceof PyString)) {
                throw Py.TypeError(String.format("coercing to Unicode: need string or buffer, %s found", pyObject.getType().fastGetName()));
            }
            String string = PosixModule.absolutePath(pyObject.toString());
            return PyStatResult.fromFileStat(posix.lstat(string));
        }
    }

    static class StatFunction
    extends PyBuiltinFunction {
        StatFunction() {
            super("stat", "stat(path) -> stat result\n\nPerform a stat system call on the given path.\n\nNote that some platforms may return only a small subset of the\nstandard fields");
        }

        public PyObject __call__(ThreadState threadState, PyObject pyObject) {
            if (!(pyObject instanceof PyString)) {
                throw Py.TypeError(String.format("coercing to Unicode: need string or buffer, %s found", pyObject.getType().fastGetName()));
            }
            String string = PosixModule.absolutePath(pyObject.toString());
            return PyStatResult.fromFileStat(posix.stat(string));
        }
    }

    private static class UrandomSource {
        static final SecureRandom INSTANCE = new SecureRandom();

        private UrandomSource() {
        }
    }
}

