/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sre;

import org.python.core.PyString;
import org.python.modules.sre.SRE_REPEAT;

public class SRE_STATE {
    public static final int SRE_MAGIC = 20031017;
    public static final int SRE_OP_FAILURE = 0;
    public static final int SRE_OP_SUCCESS = 1;
    public static final int SRE_OP_ANY = 2;
    public static final int SRE_OP_ANY_ALL = 3;
    public static final int SRE_OP_ASSERT = 4;
    public static final int SRE_OP_ASSERT_NOT = 5;
    public static final int SRE_OP_AT = 6;
    public static final int SRE_OP_BRANCH = 7;
    public static final int SRE_OP_CALL = 8;
    public static final int SRE_OP_CATEGORY = 9;
    public static final int SRE_OP_CHARSET = 10;
    public static final int SRE_OP_BIGCHARSET = 11;
    public static final int SRE_OP_GROUPREF = 12;
    public static final int SRE_OP_GROUPREF_EXISTS = 13;
    public static final int SRE_OP_GROUPREF_IGNORE = 14;
    public static final int SRE_OP_IN = 15;
    public static final int SRE_OP_IN_IGNORE = 16;
    public static final int SRE_OP_INFO = 17;
    public static final int SRE_OP_JUMP = 18;
    public static final int SRE_OP_LITERAL = 19;
    public static final int SRE_OP_LITERAL_IGNORE = 20;
    public static final int SRE_OP_MARK = 21;
    public static final int SRE_OP_MAX_UNTIL = 22;
    public static final int SRE_OP_MIN_UNTIL = 23;
    public static final int SRE_OP_NOT_LITERAL = 24;
    public static final int SRE_OP_NOT_LITERAL_IGNORE = 25;
    public static final int SRE_OP_NEGATE = 26;
    public static final int SRE_OP_RANGE = 27;
    public static final int SRE_OP_REPEAT = 28;
    public static final int SRE_OP_REPEAT_ONE = 29;
    public static final int SRE_OP_SUBPATTERN = 30;
    public static final int SRE_OP_MIN_REPEAT_ONE = 31;
    public static final int SRE_AT_BEGINNING = 0;
    public static final int SRE_AT_BEGINNING_LINE = 1;
    public static final int SRE_AT_BEGINNING_STRING = 2;
    public static final int SRE_AT_BOUNDARY = 3;
    public static final int SRE_AT_NON_BOUNDARY = 4;
    public static final int SRE_AT_END = 5;
    public static final int SRE_AT_END_LINE = 6;
    public static final int SRE_AT_END_STRING = 7;
    public static final int SRE_AT_LOC_BOUNDARY = 8;
    public static final int SRE_AT_LOC_NON_BOUNDARY = 9;
    public static final int SRE_AT_UNI_BOUNDARY = 10;
    public static final int SRE_AT_UNI_NON_BOUNDARY = 11;
    public static final int SRE_CATEGORY_DIGIT = 0;
    public static final int SRE_CATEGORY_NOT_DIGIT = 1;
    public static final int SRE_CATEGORY_SPACE = 2;
    public static final int SRE_CATEGORY_NOT_SPACE = 3;
    public static final int SRE_CATEGORY_WORD = 4;
    public static final int SRE_CATEGORY_NOT_WORD = 5;
    public static final int SRE_CATEGORY_LINEBREAK = 6;
    public static final int SRE_CATEGORY_NOT_LINEBREAK = 7;
    public static final int SRE_CATEGORY_LOC_WORD = 8;
    public static final int SRE_CATEGORY_LOC_NOT_WORD = 9;
    public static final int SRE_CATEGORY_UNI_DIGIT = 10;
    public static final int SRE_CATEGORY_UNI_NOT_DIGIT = 11;
    public static final int SRE_CATEGORY_UNI_SPACE = 12;
    public static final int SRE_CATEGORY_UNI_NOT_SPACE = 13;
    public static final int SRE_CATEGORY_UNI_WORD = 14;
    public static final int SRE_CATEGORY_UNI_NOT_WORD = 15;
    public static final int SRE_CATEGORY_UNI_LINEBREAK = 16;
    public static final int SRE_CATEGORY_UNI_NOT_LINEBREAK = 17;
    public static final int SRE_FLAG_TEMPLATE = 1;
    public static final int SRE_FLAG_IGNORECASE = 2;
    public static final int SRE_FLAG_LOCALE = 4;
    public static final int SRE_FLAG_MULTILINE = 8;
    public static final int SRE_FLAG_DOTALL = 16;
    public static final int SRE_FLAG_UNICODE = 32;
    public static final int SRE_FLAG_VERBOSE = 64;
    public static final int SRE_INFO_PREFIX = 1;
    public static final int SRE_INFO_LITERAL = 2;
    public static final int SRE_INFO_CHARSET = 4;
    public static final int USE_RECURSION_LIMIT = 5000;
    public static final int SRE_ERROR_ILLEGAL = -1;
    public static final int SRE_ERROR_STATE = -2;
    public static final int SRE_ERROR_RECURSION_LIMIT = -3;
    static final int SRE_DIGIT_MASK = 1;
    static final int SRE_SPACE_MASK = 2;
    static final int SRE_LINEBREAK_MASK = 4;
    static final int SRE_ALNUM_MASK = 8;
    static final int SRE_WORD_MASK = 16;
    static byte[] sre_char_info = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 6, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 0, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0, 16, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0, 0};
    static byte[] sre_char_lower = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    int ptr;
    int beginning;
    int start;
    int end;
    int[] str;
    int pos;
    int endpos;
    int charsize;
    int lastindex;
    int lastmark;
    int[] mark = new int[200];
    int[] mark_stack;
    int mark_stack_size;
    int mark_stack_base;
    SRE_REPEAT repeat;
    int maxlevel;
    int flags;
    private static final boolean do_trace = false;

    final boolean SRE_IS_DIGIT(int n) {
        return n < 128 ? (sre_char_info[n] & 1) != 0 : false;
    }

    final boolean SRE_IS_SPACE(int n) {
        return n < 128 ? (sre_char_info[n] & 2) != 0 : false;
    }

    final boolean SRE_IS_LINEBREAK(int n) {
        return n == 10;
    }

    final boolean SRE_IS_WORD(int n) {
        return n < 128 ? (sre_char_info[n] & 0x10) != 0 : false;
    }

    final int lower(int n) {
        if ((this.flags & 4) != 0) {
            return n < 256 ? Character.toLowerCase(n) : n;
        }
        if ((this.flags & 0x20) != 0) {
            return Character.toLowerCase(n);
        }
        return n < 128 ? (int)sre_char_lower[n] : n;
    }

    final boolean SRE_LOC_IS_WORD(int n) {
        return Character.isLetterOrDigit(n) || n == 95;
    }

    final boolean SRE_UNI_IS_LINEBREAK(int n) {
        switch (n) {
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 133: 
            case 8232: 
            case 8233: {
                return true;
            }
        }
        return false;
    }

    final boolean sre_category(int n, int n2) {
        switch (n) {
            case 0: {
                return this.SRE_IS_DIGIT(n2);
            }
            case 1: {
                return !this.SRE_IS_DIGIT(n2);
            }
            case 2: {
                return this.SRE_IS_SPACE(n2);
            }
            case 3: {
                return !this.SRE_IS_SPACE(n2);
            }
            case 4: {
                return this.SRE_IS_WORD(n2);
            }
            case 5: {
                return !this.SRE_IS_WORD(n2);
            }
            case 6: {
                return this.SRE_IS_LINEBREAK(n2);
            }
            case 7: {
                return !this.SRE_IS_LINEBREAK(n2);
            }
            case 8: {
                return this.SRE_LOC_IS_WORD(n2);
            }
            case 9: {
                return !this.SRE_LOC_IS_WORD(n2);
            }
            case 10: {
                return Character.isDigit(n2);
            }
            case 11: {
                return !Character.isDigit(n2);
            }
            case 12: {
                return Character.isWhitespace(n2);
            }
            case 13: {
                return !Character.isWhitespace(n2);
            }
            case 14: {
                return Character.isLetterOrDigit(n2) || n2 == 95;
            }
            case 15: {
                return !Character.isLetterOrDigit(n2) && n2 != 95;
            }
            case 16: {
                return this.SRE_UNI_IS_LINEBREAK(n2);
            }
            case 17: {
                return !this.SRE_UNI_IS_LINEBREAK(n2);
            }
        }
        return false;
    }

    private void mark_fini() {
        this.mark_stack = null;
        this.mark_stack_base = 0;
        this.mark_stack_size = 0;
    }

    private int mark_save(int n, int n2) {
        if (n2 <= n) {
            return this.mark_stack_base;
        }
        int n3 = this.mark_stack_size;
        int n4 = n2 - n + 1;
        int n5 = this.mark_stack_base + n4;
        if (n3 < n5) {
            int[] nArray;
            if (n3 == 0) {
                n3 = 512;
                if (n3 < n5) {
                    n3 = n5;
                }
                this.TRACE(0, this.ptr, "allocate stack " + n3);
                nArray = new int[n3];
            } else {
                while (n3 < n5) {
                    n3 += n3;
                }
                this.TRACE(0, this.ptr, "grow stack to " + n3);
                nArray = new int[n3];
                System.arraycopy(this.mark_stack, 0, nArray, 0, this.mark_stack.length);
            }
            this.mark_stack = nArray;
            this.mark_stack_size = n3;
        }
        this.TRACE(0, this.ptr, "copy " + n + ":" + n2 + " to " + this.mark_stack_base + " (" + n4 + ")");
        System.arraycopy(this.mark, n, this.mark_stack, this.mark_stack_base, n4);
        this.mark_stack_base += n4;
        return this.mark_stack_base;
    }

    private void mark_restore(int n, int n2, int n3) {
        if (n2 <= n) {
            return;
        }
        int n4 = n2 - n + 1;
        this.mark_stack_base = n3 - n4;
        this.TRACE(0, this.ptr, "copy " + n + ":" + n2 + " from " + n3);
        System.arraycopy(this.mark_stack, this.mark_stack_base, this.mark, n, n4);
    }

    final boolean SRE_AT(int n, int n2) {
        switch (n2) {
            case 0: 
            case 2: {
                return n == this.beginning;
            }
            case 1: {
                return n == this.beginning || this.SRE_IS_LINEBREAK(this.str[n - 1]);
            }
            case 5: {
                return n + 1 == this.end && this.SRE_IS_LINEBREAK(this.str[n]) || n == this.end;
            }
            case 6: {
                return n == this.end || this.SRE_IS_LINEBREAK(this.str[n]);
            }
            case 7: {
                return n == this.end;
            }
            case 3: {
                if (this.beginning == this.end) {
                    return false;
                }
                boolean bl = n > this.beginning ? this.SRE_IS_WORD(this.str[n - 1]) : false;
                boolean bl2 = n < this.end ? this.SRE_IS_WORD(this.str[n]) : false;
                return bl2 != bl;
            }
            case 4: {
                if (this.beginning == this.end) {
                    return false;
                }
                boolean bl = n > this.beginning ? this.SRE_IS_WORD(this.str[n - 1]) : false;
                boolean bl3 = n < this.end ? this.SRE_IS_WORD(this.str[n]) : false;
                return bl3 == bl;
            }
            case 8: 
            case 10: {
                if (this.beginning == this.end) {
                    return false;
                }
                boolean bl = n > this.beginning ? this.SRE_LOC_IS_WORD(this.str[n - 1]) : false;
                boolean bl4 = n < this.end ? this.SRE_LOC_IS_WORD(this.str[n]) : false;
                return bl4 != bl;
            }
            case 9: 
            case 11: {
                if (this.beginning == this.end) {
                    return false;
                }
                boolean bl = n > this.beginning ? this.SRE_LOC_IS_WORD(this.str[n - 1]) : false;
                boolean bl5 = n < this.end ? this.SRE_LOC_IS_WORD(this.str[n]) : false;
                return bl5 == bl;
            }
        }
        return false;
    }

    final boolean SRE_CHARSET(int[] nArray, int n, int n2) {
        boolean bl = true;
        block9: while (true) {
            switch (nArray[n++]) {
                case 0: {
                    this.TRACE(n, n2, "CHARSET FAILURE");
                    return !bl;
                }
                case 19: {
                    this.TRACE(n, n2, "CHARSET LITERAL " + nArray[n]);
                    if (n2 == nArray[n]) {
                        return bl;
                    }
                    ++n;
                    continue block9;
                }
                case 9: {
                    this.TRACE(n, n2, "CHARSET CHARSET " + nArray[n]);
                    if (this.sre_category(nArray[n], n2)) {
                        return bl;
                    }
                    ++n;
                    continue block9;
                }
                case 10: {
                    this.TRACE(n, n2, "CHARSET CHARSET ");
                    if (n2 < 256 && (nArray[n + (n2 >> 5)] & 1 << (n2 & 0x1F)) != 0) {
                        return bl;
                    }
                    n += 8;
                    continue block9;
                }
                case 27: {
                    this.TRACE(n, n2, "CHARSET RANGE " + nArray[n] + " " + nArray[n + 1]);
                    if (nArray[n] <= n2 && n2 <= nArray[n + 1]) {
                        return bl;
                    }
                    n += 2;
                    continue block9;
                }
                case 26: {
                    this.TRACE(n, n2, "CHARSET NEGATE");
                    bl = !bl;
                    continue block9;
                }
                case 11: {
                    this.TRACE(n, n2, "CHARSET BIGCHARSET ");
                    int n3 = nArray[n++];
                    int n4 = n2 < 65536 ? nArray[n + n2 >> 8] : -1;
                    if (n4 >= 0 && (nArray[(n += 64) + n4 * 8 + ((n2 & 0xFF) >> 5)] & 1 << (n2 & 0x1F)) != 0) {
                        return bl;
                    }
                    n += n3 * 8;
                    continue block9;
                }
            }
            break;
        }
        return false;
    }

    private int SRE_COUNT(int[] nArray, int n, int n2, int n3) {
        int n4 = this.end;
        int n5 = this.ptr;
        if (n2 < n4 - n5 && n2 != 65535) {
            n4 = n5 + n2;
        }
        switch (nArray[n]) {
            case 15: {
                this.TRACE(n, n5, "COUNT IN");
                while (n5 < n4 && this.SRE_CHARSET(nArray, n + 2, this.str[n5])) {
                    ++n5;
                }
                break;
            }
            case 2: {
                this.TRACE(n, n5, "COUNT ANY");
                while (n5 < n4 && !this.SRE_IS_LINEBREAK(this.str[n5])) {
                    ++n5;
                }
                break;
            }
            case 3: {
                this.TRACE(n, n5, "COUNT ANY_ALL");
                n5 = n4;
                break;
            }
            case 19: {
                int n6 = nArray[n + 1];
                this.TRACE(n, n5, "COUNT LITERAL " + n6);
                while (n5 < n4 && this.str[n5] == n6) {
                    ++n5;
                }
                break;
            }
            case 20: {
                int n7 = nArray[n + 1];
                this.TRACE(n, n5, "COUNT LITERAL_IGNORE " + n7);
                while (n5 < n4 && this.lower(this.str[n5]) == n7) {
                    ++n5;
                }
                break;
            }
            case 24: {
                int n8 = nArray[n + 1];
                this.TRACE(n, n5, "COUNT NOT_LITERAL " + n8);
                while (n5 < n4 && this.str[n5] != n8) {
                    ++n5;
                }
                break;
            }
            case 25: {
                int n9 = nArray[n + 1];
                this.TRACE(n, n5, "COUNT NOT_LITERAL_IGNORE " + n9);
                while (n5 < n4 && this.lower(this.str[n5]) != n9) {
                    ++n5;
                }
                break;
            }
            default: {
                this.TRACE(n, n5, "COUNT SUBPATTERN");
                while (this.ptr < n4) {
                    int n10 = this.SRE_MATCH(nArray, n, n3);
                    if (n10 < 0) {
                        return n10;
                    }
                    if (n10 != 0) continue;
                }
                return this.ptr - n5;
            }
        }
        return n5 - this.ptr;
    }

    final int SRE_MATCH(int[] nArray, int n, int n2) {
        int n3 = this.end;
        int n4 = this.ptr;
        int n5 = 0;
        this.TRACE(n, n4, "ENTER " + n2);
        if (n2 > 5000) {
            return -3;
        }
        if (nArray[n] == 17) {
            if (nArray[n + 3] != 0 && n3 - n4 < nArray[n + 3]) {
                return 0;
            }
            n += nArray[n + 1] + 1;
        }
        block27: while (true) {
            switch (nArray[n++]) {
                case 21: {
                    this.TRACE(n, n4, "MARK " + nArray[n]);
                    int n6 = nArray[n];
                    if ((n6 & 1) != 0) {
                        this.lastindex = n6 / 2 + 1;
                    }
                    if (n6 > this.lastmark) {
                        this.lastmark = n6;
                    }
                    this.mark[n6] = n4;
                    ++n;
                    continue block27;
                }
                case 19: {
                    this.TRACE(n, n4, "LITERAL " + nArray[n]);
                    if (n4 >= n3 || this.str[n4] != nArray[n]) {
                        return 0;
                    }
                    ++n;
                    ++n4;
                    continue block27;
                }
                case 24: {
                    this.TRACE(n, n4, "NOT_LITERAL " + nArray[n]);
                    if (n4 >= n3 || this.str[n4] == nArray[n]) {
                        return 0;
                    }
                    ++n;
                    ++n4;
                    continue block27;
                }
                case 1: {
                    this.TRACE(n, n4, "SUCCESS");
                    this.ptr = n4;
                    return 1;
                }
                case 6: {
                    this.TRACE(n, n4, "AT " + nArray[n]);
                    if (!this.SRE_AT(n4, nArray[n])) {
                        return 0;
                    }
                    ++n;
                    continue block27;
                }
                case 9: {
                    this.TRACE(n, n4, "CATEGORY " + nArray[n]);
                    if (n4 >= n3 || !this.sre_category(nArray[n], this.str[n4])) {
                        return 0;
                    }
                    ++n;
                    ++n4;
                    continue block27;
                }
                case 2: {
                    this.TRACE(n, n4, "ANY");
                    if (n4 >= n3 || this.SRE_IS_LINEBREAK(this.str[n4])) {
                        return 0;
                    }
                    ++n4;
                    continue block27;
                }
                case 3: {
                    this.TRACE(n, n4, "ANY_ALL");
                    if (n4 >= n3) {
                        return 0;
                    }
                    ++n4;
                    continue block27;
                }
                case 15: {
                    this.TRACE(n, n4, "IN");
                    if (n4 >= n3 || !this.SRE_CHARSET(nArray, n + 1, this.str[n4])) {
                        return 0;
                    }
                    n += nArray[n];
                    ++n4;
                    continue block27;
                }
                case 20: {
                    this.TRACE(n, n4, "LITERAL_IGNORE " + nArray[n]);
                    if (n4 >= n3 || this.lower(this.str[n4]) != this.lower(nArray[n])) {
                        return 0;
                    }
                    ++n;
                    ++n4;
                    continue block27;
                }
                case 25: {
                    this.TRACE(n, n4, "NOT_LITERAL_IGNORE " + nArray[n]);
                    if (n4 >= n3 || this.lower(this.str[n4]) == this.lower(nArray[n])) {
                        return 0;
                    }
                    ++n;
                    ++n4;
                    continue block27;
                }
                case 16: {
                    this.TRACE(n, n4, "IN_IGNORE");
                    if (n4 >= n3 || !this.SRE_CHARSET(nArray, n + 1, this.lower(this.str[n4]))) {
                        return 0;
                    }
                    n += nArray[n];
                    ++n4;
                    continue block27;
                }
                case 17: 
                case 18: {
                    this.TRACE(n, n4, "JUMP " + nArray[n]);
                    n += nArray[n];
                    continue block27;
                }
                case 7: {
                    int n6;
                    int n7 = this.lastmark;
                    int n8 = this.lastindex;
                    if (this.repeat != null) {
                        n5 = this.mark_save(0, n7);
                    }
                    while (nArray[n] != 0) {
                        if ((nArray[n + 1] != 19 || n4 < n3 && this.str[n4] == nArray[n + 2]) && (nArray[n + 1] != 15 || n4 < n3 && this.SRE_CHARSET(nArray, n + 3, this.str[n4]))) {
                            this.ptr = n4;
                            n6 = this.SRE_MATCH(nArray, n + 1, n2 + 1);
                            if (n6 != 0) {
                                return n6;
                            }
                            if (this.repeat != null) {
                                this.mark_restore(0, n7, n5);
                            }
                            this.LASTMARK_RESTORE(n7, n8);
                        }
                        n += nArray[n];
                    }
                    return 0;
                }
                case 29: {
                    int n6;
                    int n9 = nArray[n + 1];
                    this.TRACE(n, n4, "REPEAT_ONE " + n9 + " " + nArray[n + 2]);
                    if (n4 + n9 > n3) {
                        return 0;
                    }
                    this.ptr = n4;
                    int n10 = this.SRE_COUNT(nArray, n + 3, nArray[n + 2], n2 + 1);
                    if (n10 < 0) {
                        return n10;
                    }
                    n4 += n10;
                    if (n10 < n9) {
                        return 0;
                    }
                    if (nArray[n + nArray[n]] == 1) {
                        this.ptr = n4;
                        return 1;
                    }
                    int n11 = this.lastmark;
                    int n12 = this.lastindex;
                    if (nArray[n + nArray[n]] == 19) {
                        int n13 = nArray[n + nArray[n] + 1];
                        while (true) {
                            if (n10 >= n9 && (n4 >= n3 || this.str[n4] != n13)) {
                                --n4;
                                --n10;
                                continue;
                            }
                            if (n10 >= n9) {
                                this.ptr = n4--;
                                n6 = this.SRE_MATCH(nArray, n + nArray[n], n2 + 1);
                                if (n6 != 0) {
                                    return 1;
                                }
                                --n10;
                                this.LASTMARK_RESTORE(n11, n12);
                                continue;
                            }
                            break;
                        }
                    } else {
                        n11 = this.lastmark;
                        while (n10 >= n9) {
                            this.ptr = n4--;
                            n6 = this.SRE_MATCH(nArray, n + nArray[n], n2 + 1);
                            if (n6 != 0) {
                                return n6;
                            }
                            --n10;
                            this.LASTMARK_RESTORE(n11, n12);
                        }
                    }
                    return 0;
                }
                case 31: {
                    int n14;
                    int n6;
                    this.TRACE(n, n4, "MIN_REPEAT_ONE");
                    if (n4 + nArray[n + 1] > n3) {
                        return 0;
                    }
                    this.ptr = n4;
                    if (nArray[n + 1] == 0) {
                        n14 = 0;
                    } else {
                        n14 = this.SRE_COUNT(nArray, n + 3, nArray[n + 1], n2 + 1);
                        if (n14 < 0) {
                            return n14;
                        }
                        if (n14 < nArray[n + 1]) {
                            return 0;
                        }
                        n4 += n14;
                    }
                    if (nArray[n + nArray[n]] == 1) {
                        this.ptr = n4;
                        return 1;
                    }
                    boolean bl = nArray[n + 2] == 65535;
                    int n15 = this.lastmark;
                    int n16 = this.lastindex;
                    while (bl || n14 <= nArray[n + 2]) {
                        this.ptr = n4;
                        n6 = this.SRE_MATCH(nArray, n + nArray[n], n2 + 1);
                        if (n6 != 0) {
                            return n6;
                        }
                        this.ptr = n4++;
                        int n17 = this.SRE_COUNT(nArray, n + 3, 1, n2 + 1);
                        if (n17 < 0) {
                            return n17;
                        }
                        if (n17 == 0) break;
                        if (n17 != 1) {
                            throw new IllegalStateException("c should be 1!");
                        }
                        ++n14;
                        this.LASTMARK_RESTORE(n15, n16);
                    }
                    return 0;
                }
                case 28: {
                    this.TRACE(n, n4, "REPEAT " + nArray[n + 1] + " " + nArray[n + 2]);
                    SRE_REPEAT sRE_REPEAT = new SRE_REPEAT(this.repeat);
                    sRE_REPEAT.count = -1;
                    sRE_REPEAT.pidx = n;
                    this.repeat = sRE_REPEAT;
                    this.ptr = n4;
                    int n6 = this.SRE_MATCH(nArray, n + nArray[n], n2 + 1);
                    this.repeat = sRE_REPEAT.prev;
                    return n6;
                }
                case 22: {
                    int n6;
                    SRE_REPEAT sRE_REPEAT = this.repeat;
                    if (sRE_REPEAT == null) {
                        return -2;
                    }
                    this.ptr = n4;
                    int n18 = sRE_REPEAT.count + 1;
                    this.TRACE(n, n4, "MAX_UNTIL " + n18);
                    if (n18 < nArray[sRE_REPEAT.pidx + 1]) {
                        sRE_REPEAT.count = n18;
                        n6 = this.SRE_MATCH(nArray, sRE_REPEAT.pidx + 3, n2 + 1);
                        if (n6 != 0) {
                            return n6;
                        }
                        sRE_REPEAT.count = n18 - 1;
                        this.ptr = n4;
                        return 0;
                    }
                    if (n18 < nArray[sRE_REPEAT.pidx + 2] || nArray[sRE_REPEAT.pidx + 2] == 65535) {
                        sRE_REPEAT.count = n18;
                        int n19 = this.lastmark;
                        int n20 = this.lastindex;
                        n5 = this.mark_save(0, n19);
                        n6 = this.SRE_MATCH(nArray, sRE_REPEAT.pidx + 3, n2 + 1);
                        if (n6 != 0) {
                            return n6;
                        }
                        this.mark_restore(0, n19, n5);
                        this.LASTMARK_RESTORE(n19, n20);
                        sRE_REPEAT.count = n18 - 1;
                        this.ptr = n4;
                    }
                    this.repeat = sRE_REPEAT.prev;
                    n6 = this.SRE_MATCH(nArray, n, n2 + 1);
                    if (n6 != 0) {
                        return n6;
                    }
                    this.repeat = sRE_REPEAT;
                    this.ptr = n4;
                    return 0;
                }
                case 23: {
                    int n6;
                    SRE_REPEAT sRE_REPEAT = this.repeat;
                    if (sRE_REPEAT == null) {
                        return -2;
                    }
                    this.ptr = n4;
                    int n21 = sRE_REPEAT.count + 1;
                    this.TRACE(n, n4, "MIN_UNTIL " + n21 + " " + sRE_REPEAT.pidx);
                    if (n21 < nArray[sRE_REPEAT.pidx + 1]) {
                        sRE_REPEAT.count = n21;
                        n6 = this.SRE_MATCH(nArray, sRE_REPEAT.pidx + 3, n2 + 1);
                        if (n6 != 0) {
                            return n6;
                        }
                        sRE_REPEAT.count = n21 - 1;
                        this.ptr = n4;
                        return 0;
                    }
                    int n22 = this.lastmark;
                    int n23 = this.lastindex;
                    this.repeat = sRE_REPEAT.prev;
                    n6 = this.SRE_MATCH(nArray, n, n2 + 1);
                    if (n6 != 0) {
                        return n6;
                    }
                    this.ptr = n4;
                    this.repeat = sRE_REPEAT;
                    if (n21 >= nArray[sRE_REPEAT.pidx + 2] && nArray[sRE_REPEAT.pidx + 2] != 65535) {
                        return 0;
                    }
                    this.LASTMARK_RESTORE(n22, n23);
                    sRE_REPEAT.count = n21;
                    n6 = this.SRE_MATCH(nArray, sRE_REPEAT.pidx + 3, n2 + 1);
                    if (n6 != 0) {
                        return n6;
                    }
                    sRE_REPEAT.count = n21 - 1;
                    this.ptr = n4;
                    return 0;
                }
                case 12: {
                    int n6 = nArray[n];
                    this.TRACE(n, n4, "GROUPREF " + n6);
                    int n24 = this.mark[n6 + n6];
                    int n25 = this.mark[n6 + n6 + 1];
                    if (n24 == -1 || n25 == -1 || n25 < n24) {
                        return 0;
                    }
                    while (n24 < n25) {
                        if (n4 >= n3 || this.str[n4] != this.str[n24]) {
                            return 0;
                        }
                        ++n24;
                        ++n4;
                    }
                    ++n;
                    continue block27;
                }
                case 14: {
                    int n6 = nArray[n];
                    this.TRACE(n, n4, "GROUPREF_IGNORE " + n6);
                    int n24 = this.mark[n6 + n6];
                    int n25 = this.mark[n6 + n6 + 1];
                    if (n24 == -1 || n25 == -1 || n25 < n24) {
                        return 0;
                    }
                    while (n24 < n25) {
                        if (n4 >= n3 || this.lower(this.str[n4]) != this.lower(this.str[n24])) {
                            return 0;
                        }
                        ++n24;
                        ++n4;
                    }
                    ++n;
                    continue block27;
                }
                case 13: {
                    int n6 = nArray[n];
                    this.TRACE(n, n4, "GROUPREF_EXISTS " + n6);
                    int n24 = this.mark[n6 + n6];
                    int n25 = this.mark[n6 + n6 + 1];
                    if (n24 == -1 || n25 == -1 || n25 < n24) {
                        n += nArray[n + 1];
                        continue block27;
                    }
                    n += 2;
                    continue block27;
                }
                case 4: {
                    this.TRACE(n, n4, "ASSERT " + nArray[n + 1]);
                    this.ptr = n4 - nArray[n + 1];
                    if (this.ptr < this.beginning) {
                        return 0;
                    }
                    int n6 = this.SRE_MATCH(nArray, n + 2, n2 + 1);
                    if (n6 <= 0) {
                        return n6;
                    }
                    n += nArray[n];
                    continue block27;
                }
                case 5: {
                    int n6;
                    this.TRACE(n, n4, "ASSERT_NOT " + nArray[n]);
                    this.ptr = n4 - nArray[n + 1];
                    if (this.ptr >= this.beginning) {
                        n6 = this.SRE_MATCH(nArray, n + 2, n2 + 1);
                        if (n6 < 0) {
                            return n6;
                        }
                        if (n6 != 0) {
                            return 0;
                        }
                    }
                    n += nArray[n];
                    continue block27;
                }
                case 0: {
                    this.TRACE(n, n4, "FAILURE");
                    return 0;
                }
            }
            break;
        }
        this.TRACE(n, n4, "UNKNOWN " + nArray[n - 1]);
        return -1;
    }

    private void LASTMARK_RESTORE(int n, int n2) {
        if (this.lastmark > n) {
            while (this.lastmark > n) {
                this.mark[this.lastmark--] = -1;
            }
            this.lastindex = n2;
        }
    }

    int SRE_SEARCH(int[] nArray, int n) {
        int n2 = this.start;
        int n3 = this.end;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (nArray[n] == 17) {
            n10 = nArray[n + 2];
            if (nArray[n + 3] > 1 && (n3 -= nArray[n + 3] - 1) <= n2) {
                n3 = n2;
            }
            if ((n10 & 1) != 0) {
                n5 = nArray[n + 5];
                n6 = nArray[n + 6];
                n7 = n + 7;
                n9 = n7 + n5 - 1;
            } else if ((n10 & 4) != 0) {
                n8 = n + 5;
            }
            n += 1 + nArray[n + 1];
        }
        if (n5 > 1) {
            int n11 = 0;
            n3 = this.end;
            while (n2 < n3) {
                block25: {
                    while (this.str[n2] != nArray[n7 + n11]) {
                        if (n11 != 0) {
                            n11 = nArray[n9 + n11];
                            continue;
                        }
                        break block25;
                    }
                    if (++n11 == n5) {
                        this.TRACE(n, n2, "SEARCH SCAN " + n6 + " " + n5);
                        this.start = n2 + 1 - n5;
                        this.ptr = n2 + 1 - n5 + n6;
                        if ((n10 & 2) != 0) {
                            return 1;
                        }
                        n4 = this.SRE_MATCH(nArray, n + 2 * n6, 1);
                        if (n4 != 0) {
                            return n4;
                        }
                        n11 = nArray[n9 + n11];
                    }
                }
                ++n2;
            }
            return 0;
        }
        if (nArray[n] == 19) {
            int n12 = nArray[n + 1];
            n3 = this.end;
            while (true) {
                if (n2 < n3 && this.str[n2] != n12) {
                    ++n2;
                    continue;
                }
                if (n2 == n3) {
                    return 0;
                }
                this.TRACE(n, n2, "SEARCH LITERAL");
                this.start = n2++;
                this.ptr = n2;
                if ((n10 & 2) != 0) {
                    return 1;
                }
                n4 = this.SRE_MATCH(nArray, n + 2, 1);
                if (n4 != 0) break;
            }
        } else if (n8 != 0) {
            n3 = this.end;
            while (true) {
                if (n2 < n3 && !this.SRE_CHARSET(nArray, n8, this.str[n2])) {
                    ++n2;
                    continue;
                }
                if (n2 == n3) {
                    return 0;
                }
                this.TRACE(n, n2, "SEARCH CHARSET");
                this.start = n2;
                this.ptr = n2++;
                n4 = this.SRE_MATCH(nArray, n, 1);
                if (n4 == 0) {
                    continue;
                }
                break;
            }
        } else {
            while (n2 <= n3) {
                this.TRACE(n, n2, "SEARCH");
                this.ptr = n2++;
                this.start = this.ptr;
                n4 = this.SRE_MATCH(nArray, n, 1);
                if (n4 == 0) continue;
                break;
            }
        }
        return n4;
    }

    public SRE_STATE(PyString pyString, int n, int n2, int n3) {
        this.str = pyString.toCodePoints();
        int n4 = pyString.__len__();
        this.charsize = 1;
        if (n < 0) {
            n = 0;
        } else if (n > n4) {
            n = n4;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n4) {
            n2 = n4;
        }
        this.start = n;
        this.end = n2;
        this.pos = n;
        this.endpos = n2;
        this.state_reset();
        this.flags = n3;
    }

    public static int getlower(int n, int n2) {
        if ((n2 & 4) != 0) {
            return n < 256 ? (int)Character.toLowerCase((char)n) : n;
        }
        if ((n2 & 0x20) != 0) {
            return Character.toLowerCase((char)n);
        }
        return n < 128 ? (int)sre_char_lower[n] : n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getslice(int n, String string, boolean bl) {
        int n2;
        int n3;
        n = (n - 1) * 2;
        if (string == null || this.mark[n] == -1 || this.mark[n + 1] == -1) {
            if (!bl) return null;
            n3 = 0;
            n2 = 0;
            return string.substring(n2, n3);
        } else {
            n2 = this.mark[n];
            n3 = this.mark[n + 1];
        }
        return string.substring(n2, n3);
    }

    void state_reset() {
        this.lastmark = 0;
        for (int i = 0; i < this.mark.length; ++i) {
            this.mark[i] = -1;
        }
        this.lastindex = -1;
        this.repeat = null;
        this.mark_fini();
    }

    private void TRACE(int n, int n2, String string) {
    }
}

