/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.time;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.__builtin__;
import org.python.modules.time.PyTimeTuple;
import org.python.modules.time.TimeFunctions;

public class Time
implements ClassDictInit {
    public static PyString __doc__ = new PyString("This module provides various functions to manipulate time values.\n\nThere are two standard representations of time.  One is the number\nof seconds since the Epoch, in UTC (a.k.a. GMT).  It may be an integer\nor a floating point number (to represent fractions of seconds).\nThe Epoch is system-defined; on Unix, it is generally January 1st, 1970.\nThe actual value can be retrieved by calling gmtime(0).\n\nThe other representation is a tuple of 9 integers giving local time.\nThe tuple items are:\n  year (four digits, e.g. 1998)\n  month (1-12)\n  day (1-31)\n  hours (0-23)\n  minutes (0-59)\n  seconds (0-59)\n  weekday (0-6, Monday is 0)\n  Julian day (day in the year, 1-366)\n  DST (Daylight Savings Time) flag (-1, 0 or 1)\nIf the DST flag is 0, the time is given in the regular time zone;\nif it is 1, the time is given in the DST time zone;\nif it is -1, mktime() should guess based on the date and time.\n\nVariables:\n\ntimezone -- difference in seconds between UTC and local standard time\naltzone -- difference in  seconds between UTC and local DST time\ndaylight -- whether local time should reflect DST\ntzname -- tuple of (standard time zone name, DST time zone name)\n\nFunctions:\n\ntime() -- return current time in seconds since the Epoch as a float\nclock() -- return CPU time since process start as a float\nsleep() -- delay for a number of seconds given as a float\ngmtime() -- convert seconds since Epoch to UTC tuple\nlocaltime() -- convert seconds since Epoch to local time tuple\nasctime() -- convert time tuple to string\nctime() -- convert time in seconds to string\nmktime() -- convert local time tuple to seconds since Epoch\nstrftime() -- convert time tuple to string according to format specification\nstrptime() -- parse string to time tuple according to format specification\n");
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static long initialClock;
    private static volatile boolean clockInitialized;
    protected static Locale currentLocale;
    protected static DateFormatSymbols datesyms;
    protected static String[] shortdays;
    protected static String[] shortmonths;
    private static String[] enshortdays;
    private static String[] enshortmonths;
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;
    private static final String DEFAULT_FORMAT_PY = "%a %b %d %H:%M:%S %Y";
    private static final HashMap<Character, String> py2java;
    private static final List<Character> notSupported;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        pyObject.__setitem__("clock", (PyObject)new TimeFunctions("clock", 1, 0));
        pyObject.__setitem__("struct_time", (PyObject)PyTimeTuple.TYPE);
        pyObject.__setitem__("__name__", (PyObject)Py.newString("time"));
        TimeZone timeZone = TimeZone.getDefault();
        tzname = new PyTuple(new PyString(timeZone.getDisplayName(false, 0)), new PyString(timeZone.getDisplayName(true, 0)));
        daylight = timeZone.useDaylightTime() ? 1 : 0;
        timezone = -timeZone.getRawOffset() / 1000;
        altzone = timezone - timeZone.getDSTSavings() / 1000;
    }

    public static double time() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double clock() {
        if (!clockInitialized) {
            initialClock = System.nanoTime();
            clockInitialized = true;
            return 0.0;
        }
        return (double)(System.nanoTime() - initialClock) / 1.0E9;
    }

    private static void throwValueError(String string) {
        throw new PyException(Py.ValueError, new PyString(string));
    }

    private static int item(PyTuple pyTuple, int n) {
        int n2 = pyTuple.__getitem__(n).asInt();
        boolean bl = true;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                bl = 0 <= n2 && n2 <= 12;
                break;
            }
            case 2: {
                bl = 0 <= n2 && n2 <= 31;
                break;
            }
            case 3: {
                bl = 0 <= n2 && n2 <= 23;
                break;
            }
            case 4: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 5: {
                bl = 0 <= n2 && n2 <= 61;
                break;
            }
            case 6: {
                bl = 0 <= n2 && n2 <= 6;
                break;
            }
            case 7: {
                bl = 0 <= n2 && n2 < 367;
                break;
            }
            case 8: {
                boolean bl2 = bl = -1 <= n2 && n2 <= 1;
            }
        }
        if (!bl) {
            String string;
            switch (n) {
                case 1: {
                    string = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    string = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    string = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    string = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    string = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    string = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    string = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    string = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    string = "ignore";
                }
            }
            Time.throwValueError(string);
        }
        switch (n) {
            case 1: {
                if (n2 <= 0) break;
                --n2;
                break;
            }
            case 2: 
            case 7: {
                if (n2 != 0) break;
                n2 = 1;
            }
        }
        return n2;
    }

    private static GregorianCalendar _tupletocal(PyTuple pyTuple) {
        return new GregorianCalendar(Time.item(pyTuple, 0), Time.item(pyTuple, 1), Time.item(pyTuple, 2), Time.item(pyTuple, 3), Time.item(pyTuple, 4), Time.item(pyTuple, 5));
    }

    public static double mktime(PyTuple pyTuple) {
        GregorianCalendar gregorianCalendar;
        try {
            gregorianCalendar = Time._tupletocal(pyTuple);
        }
        catch (PyException pyException) {
            pyException.type = Py.OverflowError;
            throw pyException;
        }
        int n = Time.item(pyTuple, 8);
        if (n == 0 || n == 1) {
            gregorianCalendar.set(16, n * gregorianCalendar.getTimeZone().getDSTSavings());
        }
        return (double)gregorianCalendar.getTime().getTime() / 1000.0;
    }

    protected static PyTimeTuple _timefields(double d, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        if ((d *= 1000.0) < -9.223372036854776E18 || d > 9.223372036854776E18) {
            throw Py.ValueError("timestamp out of range for platform time_t");
        }
        gregorianCalendar.setTime(new Date((long)d));
        int n = timeZone.inDaylightTime(gregorianCalendar.getTime()) ? 1 : 0;
        return Time.toTimeTuple(gregorianCalendar, n);
    }

    private static PyTimeTuple toTimeTuple(Calendar calendar, int n) {
        int n2 = calendar.get(7) - 2;
        if (n2 < 0) {
            n2 += 7;
        }
        return new PyTimeTuple(new PyInteger(calendar.get(1)), new PyInteger(calendar.get(2) + 1), new PyInteger(calendar.get(5)), new PyInteger(calendar.get(10) + 12 * calendar.get(9)), new PyInteger(calendar.get(12)), new PyInteger(calendar.get(13)), new PyInteger(n2), new PyInteger(calendar.get(6)), new PyInteger(n));
    }

    public static double parseTimeDoubleArg(PyObject pyObject) {
        if (pyObject == Py.None) {
            return Time.time();
        }
        Object object = pyObject.__tojava__(Double.class);
        if (object == Py.NoConversion) {
            throw Py.TypeError("a float is required");
        }
        return (Double)object;
    }

    public static PyTuple localtime() {
        return Time.localtime(Py.None);
    }

    public static PyTuple localtime(PyObject pyObject) {
        return Time._timefields(Time.parseTimeDoubleArg(pyObject), TimeZone.getDefault());
    }

    public static PyTuple gmtime() {
        return Time.gmtime(Py.None);
    }

    public static PyTuple gmtime(PyObject pyObject) {
        return Time._timefields(Time.parseTimeDoubleArg(pyObject), TimeZone.getTimeZone("GMT"));
    }

    public static PyString ctime() {
        return Time.ctime(Py.None);
    }

    public static PyString ctime(PyObject pyObject) {
        return Time.asctime(Time.localtime(pyObject));
    }

    private static synchronized String _shortday(int n) {
        if (shortdays == null) {
            shortdays = new String[7];
            String[] stringArray = datesyms.getShortWeekdays();
            for (int i = 0; i < 6; ++i) {
                Time.shortdays[i] = stringArray[i + 2];
            }
            Time.shortdays[6] = stringArray[1];
        }
        try {
            return shortdays[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PyException(Py.ValueError, new PyString("day of week out of range (0-6)"));
        }
    }

    private static synchronized String _shortmonth(int n) {
        if (shortmonths == null) {
            shortmonths = new String[12];
            String[] stringArray = datesyms.getShortMonths();
            for (int i = 0; i < 12; ++i) {
                Time.shortmonths[i] = stringArray[i];
            }
        }
        try {
            return shortmonths[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PyException(Py.ValueError, new PyString("month out of range (1-12)"));
        }
    }

    private static String _padint(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = string.length();
        if (n2 <= n3) {
            return string;
        }
        if (n2 == n3 + 1) {
            return "0" + string;
        }
        if (n2 == n3 + 2) {
            return "00" + string;
        }
        char[] cArray = new char[n2 - n3];
        Arrays.fill(cArray, '0');
        return new String(cArray) + string;
    }

    private static String _twodigit(int n) {
        return Time._padint(n, 2);
    }

    private static String _truncyear(int n) {
        String string = Time._padint(n, 4);
        return string.substring(string.length() - 2, string.length());
    }

    public static PyString asctime() {
        return Time.asctime(Time.localtime());
    }

    public static PyString asctime(PyTuple pyTuple) {
        StringBuilder stringBuilder = new StringBuilder(25);
        stringBuilder.append(enshortdays[Time.item(pyTuple, 6)]).append(' ');
        stringBuilder.append(enshortmonths[Time.item(pyTuple, 1)]).append(' ');
        int n = Time.item(pyTuple, 2);
        if (n < 10) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n).append(' ');
        stringBuilder.append(Time._twodigit(Time.item(pyTuple, 3))).append(':');
        stringBuilder.append(Time._twodigit(Time.item(pyTuple, 4))).append(':');
        stringBuilder.append(Time._twodigit(Time.item(pyTuple, 5))).append(' ');
        return new PyString(stringBuilder.append(Time.item(pyTuple, 0)).toString());
    }

    public static String locale_asctime(PyTuple pyTuple) {
        Time.checkLocale();
        int n = Time.item(pyTuple, 6);
        int n2 = Time.item(pyTuple, 1);
        return Time._shortday(n) + " " + Time._shortmonth(n2) + " " + Time._twodigit(Time.item(pyTuple, 2)) + " " + Time._twodigit(Time.item(pyTuple, 3)) + ":" + Time._twodigit(Time.item(pyTuple, 4)) + ":" + Time._twodigit(Time.item(pyTuple, 5)) + " " + Time.item(pyTuple, 0);
    }

    public static void sleep(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
        }
    }

    public static PyString strftime(String string) {
        return Time.strftime(string, Time.localtime());
    }

    public static PyString strftime(String string, PyTuple pyTuple) {
        Time.checkLocale();
        int[] nArray = new int[9];
        for (int i = 0; i < 9; ++i) {
            nArray[i] = Time.item(pyTuple, i);
        }
        String string2 = "";
        int n = 0;
        GregorianCalendar gregorianCalendar = null;
        while (n < string.length()) {
            int n2 = string.indexOf("%", n);
            if (n2 < 0) {
                string2 = string2 + string.substring(n);
                break;
            }
            if (n2 == string.length() - 1) {
                string2 = string2 + "%";
                break;
            }
            string2 = string2 + string.substring(n, n2);
            switch (string.charAt(++n2)) {
                case 'a': {
                    int n3 = nArray[6];
                    string2 = string2 + Time._shortday(n3);
                    break;
                }
                case 'A': {
                    String[] stringArray = datesyms.getWeekdays();
                    int n3 = nArray[6];
                    if (0 <= n3 && n3 < 6) {
                        string2 = string2 + stringArray[n3 + 2];
                        break;
                    }
                    if (n3 == 6) {
                        string2 = string2 + stringArray[1];
                        break;
                    }
                    Time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int n3 = nArray[1];
                    string2 = string2 + Time._shortmonth(n3);
                    break;
                }
                case 'B': {
                    String[] stringArray = datesyms.getMonths();
                    int n3 = nArray[1];
                    string2 = string2 + stringArray[n3];
                    break;
                }
                case 'c': {
                    string2 = string2 + Time.locale_asctime(pyTuple);
                    break;
                }
                case 'd': {
                    string2 = string2 + Time._twodigit(nArray[2]);
                    break;
                }
                case 'H': {
                    string2 = string2 + Time._twodigit(nArray[3]);
                    break;
                }
                case 'I': {
                    int n3 = nArray[3] % 12;
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    string2 = string2 + Time._twodigit(n3);
                    break;
                }
                case 'j': {
                    string2 = string2 + Time._padint(nArray[7], 3);
                    break;
                }
                case 'm': {
                    string2 = string2 + Time._twodigit(nArray[1] + 1);
                    break;
                }
                case 'M': {
                    string2 = string2 + Time._twodigit(nArray[4]);
                    break;
                }
                case 'p': {
                    int n3 = nArray[3];
                    String[] stringArray = datesyms.getAmPmStrings();
                    if (0 <= n3 && n3 < 12) {
                        string2 = string2 + stringArray[0];
                        break;
                    }
                    if (12 <= n3 && n3 < 24) {
                        string2 = string2 + stringArray[1];
                        break;
                    }
                    Time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    string2 = string2 + Time._twodigit(nArray[5]);
                    break;
                }
                case 'U': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = Time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(1);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    if (gregorianCalendar.get(2) == 0 && n3 >= 52) {
                        n3 = 0;
                    }
                    string2 = string2 + Time._twodigit(n3);
                    break;
                }
                case 'w': {
                    int n3 = (nArray[6] + 1) % 7;
                    string2 = string2 + n3;
                    break;
                }
                case 'W': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = Time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(2);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    if (gregorianCalendar.get(2) == 0 && n3 >= 52) {
                        n3 = 0;
                    }
                    string2 = string2 + Time._twodigit(n3);
                    break;
                }
                case 'x': {
                    string2 = string2 + Time._twodigit(nArray[1] + 1) + "/" + Time._twodigit(nArray[2]) + "/" + Time._truncyear(nArray[0]);
                    break;
                }
                case 'X': {
                    string2 = string2 + Time._twodigit(nArray[3]) + ":" + Time._twodigit(nArray[4]) + ":" + Time._twodigit(nArray[5]);
                    break;
                }
                case 'Y': {
                    string2 = string2 + Time._padint(nArray[0], 4);
                    break;
                }
                case 'y': {
                    string2 = string2 + Time._truncyear(nArray[0]);
                    break;
                }
                case 'Z': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = Time._tupletocal(pyTuple);
                    }
                    string2 = string2 + gregorianCalendar.getTimeZone().getDisplayName(nArray[8] > 0, 0);
                    break;
                }
                case '%': {
                    string2 = string2 + "%";
                    break;
                }
                default: {
                    string2 = string2 + "%" + string.charAt(n2);
                    ++n2;
                }
            }
            n = n2 + 1;
            ++n2;
        }
        return new PyString(string2);
    }

    private static void checkLocale() {
        if (!Locale.getDefault().equals(currentLocale)) {
            currentLocale = Locale.getDefault();
            datesyms = new DateFormatSymbols(currentLocale);
            shortdays = null;
            shortmonths = null;
        }
    }

    public static PyTuple strptime(String string) {
        return Time.strptime(string, DEFAULT_FORMAT_PY);
    }

    private static PyTuple pystrptime(String string, String string2) {
        return (PyTuple)__builtin__.__import__("_strptime").__getattr__("strptime").__call__(Py.newUnicode(string), (PyObject)Py.newUnicode(string2));
    }

    public static PyTuple strptime(String string, String string2) {
        if (string2 == null || string == null) {
            throw Py.TypeError("expected string of buffer");
        }
        String string3 = Time.py2java_format(string2);
        if (string3 == null) {
            return Time.pystrptime(string, string2);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(string));
        }
        catch (ParseException parseException) {
            Time.throwValueError("time data did not match format:  data=" + string + "  fmt=" + string2);
        }
        int n = -1;
        if (string3.contains("zzz")) {
            n = calendar.getTimeZone().inDaylightTime(calendar.getTime()) ? 1 : 0;
        }
        return Time.toTimeTuple(calendar, n);
    }

    private static String py2java_format(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        if (string.length() == 0) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (c == '%' && !bl) {
                bl = true;
                continue;
            }
            if (!bl) {
                boolean bl3;
                boolean bl4 = bl3 = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
                if (bl3 && !bl2 || !bl3 && bl2) {
                    stringBuilder.append("'");
                    bl2 = bl3;
                }
                stringBuilder.append(c);
                continue;
            }
            if (bl2) {
                stringBuilder.append("'");
                bl2 = false;
            }
            if ((string2 = py2java.get(Character.valueOf(c))) == null && notSupported.contains(Character.valueOf(c))) {
                return null;
            }
            stringBuilder.append(string2 != null ? string2 : Character.valueOf(c));
            bl = false;
        }
        if (bl2) {
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    static {
        currentLocale = null;
        datesyms = new DateFormatSymbols();
        shortdays = null;
        shortmonths = null;
        enshortdays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        enshortmonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        altzone = -1;
        tzname = null;
        py2java = new HashMap<Character, String>(){
            {
                this.put(Character.valueOf('a'), "EEE");
                this.put(Character.valueOf('A'), "EEEE");
                this.put(Character.valueOf('b'), "MMM");
                this.put(Character.valueOf('B'), "MMMM");
                this.put(Character.valueOf('c'), "EEE MMM dd HH:mm:ss yyyy");
                this.put(Character.valueOf('d'), "dd");
                this.put(Character.valueOf('H'), "HH");
                this.put(Character.valueOf('I'), "hh");
                this.put(Character.valueOf('j'), "DDD");
                this.put(Character.valueOf('m'), "MM");
                this.put(Character.valueOf('M'), "mm");
                this.put(Character.valueOf('p'), "a");
                this.put(Character.valueOf('S'), "ss");
                this.put(Character.valueOf('U'), "ww");
                this.put(Character.valueOf('W'), "ww");
                this.put(Character.valueOf('x'), "MM/dd/yy");
                this.put(Character.valueOf('X'), "HH:mm:ss");
                this.put(Character.valueOf('y'), "yy");
                this.put(Character.valueOf('Y'), "yyyy");
                this.put(Character.valueOf('Z'), "zzz");
                this.put(Character.valueOf('%'), "%");
            }
        };
        notSupported = new ArrayList<Character>(){
            {
                this.add(Character.valueOf('w'));
            }
        };
    }
}

