/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.LastError;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.struct.StructUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.python.constantine.platform.Errno;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.DefaultNativeGroup;
import org.python.posix.DefaultNativeTimeval;
import org.python.posix.FileStat;
import org.python.posix.Group;
import org.python.posix.JavaLibCHelper;
import org.python.posix.LibC;
import org.python.posix.LibCProvider;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.Passwd;
import org.python.posix.Timeval;

abstract class BaseNativePOSIX
implements POSIX {
    private final LibC libc;
    protected final String libraryName;
    protected final POSIXHandler handler;
    protected final JavaLibCHelper helper;
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            return object != null ? new DefaultNativeGroup((Pointer)object) : null;
        }
    };
    public static final ToNativeConverter<FileStat, Struct> FileStatConverter = new ToNativeConverter<FileStat, Struct>(){

        @Override
        public Struct toNative(FileStat fileStat, ToNativeContext toNativeContext) {
            if (!(fileStat instanceof Struct)) {
                throw new IllegalArgumentException("FileStat instance is not a struct");
            }
            return (Struct)((Object)fileStat);
        }

        @Override
        public Class<Struct> nativeType() {
            return Struct.class;
        }
    };

    BaseNativePOSIX(String string, LibCProvider libCProvider, POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
        this.libraryName = string;
        this.libc = libCProvider.getLibC();
        this.helper = new JavaLibCHelper(pOSIXHandler);
    }

    public final LibC libc() {
        return this.libc;
    }

    public int chmod(String string, int n) {
        return this.libc().chmod(string, n);
    }

    public int chown(String string, int n, int n2) {
        return this.libc().chown(string, n, n2);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat baseHeapFileStat = this.allocateStat();
        int n = this.helper.getfd(fileDescriptor);
        if (this.libc().fstat(n, baseHeapFileStat) < 0) {
            this.handler.error(Errno.ENOENT, "" + n);
        }
        return baseHeapFileStat;
    }

    public int getegid() {
        return this.libc().getegid();
    }

    public int geteuid() {
        return this.libc().geteuid();
    }

    public int getgid() {
        return this.libc().getgid();
    }

    public String getlogin() {
        return this.libc().getlogin();
    }

    public int getpgid() {
        return this.libc().getpgid();
    }

    public int getpgrp() {
        return this.libc().getpgrp();
    }

    public int getpid() {
        return this.libc().getpid();
    }

    public int getppid() {
        return this.libc().getppid();
    }

    public Passwd getpwent() {
        return this.libc().getpwent();
    }

    public Passwd getpwuid(int n) {
        return this.libc().getpwuid(n);
    }

    public Passwd getpwnam(String string) {
        return this.libc().getpwnam(string);
    }

    public Group getgrent() {
        return this.libc().getgrent();
    }

    public Group getgrgid(int n) {
        return this.libc().getgrgid(n);
    }

    public Group getgrnam(String string) {
        return this.libc().getgrnam(string);
    }

    public int setpwent() {
        return this.libc().setpwent();
    }

    public int endpwent() {
        return this.libc().endpwent();
    }

    public int setgrent() {
        return this.libc().setgrent();
    }

    public int endgrent() {
        return this.libc().endgrent();
    }

    public int getuid() {
        return this.libc().getuid();
    }

    public int setegid(int n) {
        return this.libc().setegid(n);
    }

    public int seteuid(int n) {
        return this.libc().seteuid(n);
    }

    public int setgid(int n) {
        return this.libc().setgid(n);
    }

    public int getfd(FileDescriptor fileDescriptor) {
        return this.helper.getfd(fileDescriptor);
    }

    public int getpgid(int n) {
        return this.libc().getpgid(n);
    }

    public int setpgid(int n, int n2) {
        return this.libc().setpgid(n, n2);
    }

    public int setpgrp(int n, int n2) {
        return this.libc().setpgrp(n, n2);
    }

    public int setsid() {
        return this.libc().setsid();
    }

    public int setuid(int n) {
        return this.libc().setuid(n);
    }

    public int kill(int n, int n2) {
        return this.libc().kill(n, n2);
    }

    public int lchmod(String string, int n) {
        return this.libc().lchmod(string, n);
    }

    public int lchown(String string, int n, int n2) {
        return this.libc().lchown(string, n, n2);
    }

    public int link(String string, String string2) {
        return this.libc().link(string, string2);
    }

    public FileStat lstat(String string) {
        BaseHeapFileStat baseHeapFileStat = this.allocateStat();
        if (this.libc().lstat(string, baseHeapFileStat) < 0) {
            this.handler.error(Errno.ENOENT, string);
        }
        return baseHeapFileStat;
    }

    public int mkdir(String string, int n) {
        int n2 = this.libc().mkdir(string, n);
        if (n2 < 0) {
            int n3 = this.errno();
            this.handler.error(Errno.valueOf(n3), string);
        }
        return n2;
    }

    public FileStat stat(String string) {
        BaseHeapFileStat baseHeapFileStat = this.allocateStat();
        if (this.libc().stat(string, baseHeapFileStat) < 0) {
            this.handler.error(Errno.ENOENT, string);
        }
        return baseHeapFileStat;
    }

    public int symlink(String string, String string2) {
        return this.libc().symlink(string, string2);
    }

    public String readlink(String string) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        int n = this.libc().readlink(string, byteBuffer, byteBuffer.capacity());
        if (n == -1) {
            return null;
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        return Charset.forName("ASCII").decode(byteBuffer).toString();
    }

    public int umask(int n) {
        return this.libc().umask(n);
    }

    public int utimes(String string, long[] lArray, long[] lArray2) {
        Timeval[] timevalArray = null;
        if (lArray != null && lArray2 != null) {
            timevalArray = (Timeval[])StructUtil.newArray(DefaultNativeTimeval.class, (int)2);
            timevalArray[0].setTime(lArray);
            timevalArray[1].setTime(lArray2);
        }
        return this.libc().utimes(string, timevalArray);
    }

    public int fork() {
        return this.libc().fork();
    }

    public int waitpid(int n, int[] nArray, int n2) {
        return this.libc().waitpid(n, nArray, n2);
    }

    public int wait(int[] nArray) {
        return this.libc().wait(nArray);
    }

    public int getpriority(int n, int n2) {
        return this.libc().getpriority(n, n2);
    }

    public int setpriority(int n, int n2, int n3) {
        return this.libc().setpriority(n, n2, n3);
    }

    public boolean isatty(FileDescriptor fileDescriptor) {
        return this.libc().isatty(this.helper.getfd(fileDescriptor)) != 0;
    }

    public int errno() {
        return LastError.getLastError();
    }

    public void errno(int n) {
        LastError.setLastError(n);
    }

    public boolean isNative() {
        return true;
    }

    public abstract BaseHeapFileStat allocateStat();

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

