/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import java.io.File;
import java.io.IOException;
import org.python.posix.FileStat;
import org.python.posix.JavaSecuredFile;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;

public final class JavaFileStat
implements FileStat {
    private final POSIXHandler handler;
    private final POSIX posix;
    short st_mode;
    int st_blksize;
    long st_size;
    int st_ctime;
    int st_mtime;

    public JavaFileStat(POSIX pOSIX, POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
        this.posix = pOSIX;
    }

    public void setup(String string) {
        JavaSecuredFile javaSecuredFile = new JavaSecuredFile(string);
        this.st_blksize = 4096;
        this.st_mode = this.calculateMode(javaSecuredFile, this.st_mode);
        this.st_size = ((File)javaSecuredFile).length();
        this.st_mtime = (int)(((File)javaSecuredFile).lastModified() / 1000L);
        this.st_ctime = ((File)javaSecuredFile).getParentFile() != null ? (int)(((File)javaSecuredFile).getParentFile().lastModified() / 1000L) : this.st_mtime;
    }

    private short calculateMode(File file, short s) {
        if (file.canRead()) {
            s = (short)(s | 0x124);
        }
        if (file.canWrite()) {
            s = (short)(s | 0x92);
        }
        if (file.isDirectory()) {
            s = (short)(s | 0x4000);
        } else if (file.isFile()) {
            s = (short)(s | 0x8000);
        }
        try {
            s = this.calculateSymlink(file, s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    private short calculateSymlink(File file, short s) throws IOException {
        if (file.getAbsoluteFile().getParentFile() == null) {
            return s;
        }
        File file2 = file.getAbsoluteFile().getParentFile();
        File file3 = file2.getCanonicalFile();
        if (file3.getAbsolutePath().equals(file2.getAbsolutePath()) && !file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath())) {
            s = (short)(s | 0xA000);
            return s;
        }
        file = new JavaSecuredFile(file3.getAbsolutePath() + "/" + file.getName());
        if (!file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath())) {
            s = (short)(s | 0xA000);
        }
        return s;
    }

    public long atime() {
        return this.st_mtime;
    }

    public long blocks() {
        this.handler.unimplementedError("stat.st_blocks");
        return -1L;
    }

    public long blockSize() {
        return this.st_blksize;
    }

    public long ctime() {
        return this.st_ctime;
    }

    public long dev() {
        this.handler.unimplementedError("stat.st_dev");
        return -1L;
    }

    public String ftype() {
        if (this.isFile()) {
            return "file";
        }
        if (this.isDirectory()) {
            return "directory";
        }
        return "unknown";
    }

    public int gid() {
        this.handler.unimplementedError("stat.st_gid");
        return -1;
    }

    public boolean groupMember(int n) {
        return this.posix.getgid() == n || this.posix.getegid() == n;
    }

    public long ino() {
        return 0L;
    }

    public boolean isBlockDev() {
        this.handler.unimplementedError("block device detection");
        return false;
    }

    public boolean isCharDev() {
        return false;
    }

    public boolean isDirectory() {
        return (this.mode() & 0x4000) != 0;
    }

    public boolean isEmpty() {
        return this.st_size() == 0L;
    }

    public boolean isExecutable() {
        this.handler.warn(POSIXHandler.WARNING_ID.DUMMY_VALUE_USED, "executable? does not in this environment and will return a dummy value", "executable");
        return true;
    }

    public boolean isExecutableReal() {
        this.handler.warn(POSIXHandler.WARNING_ID.DUMMY_VALUE_USED, "executable_real? does not work in this environmnt and will return a dummy value", "executable_real");
        return true;
    }

    public boolean isFifo() {
        this.handler.unimplementedError("fifo file detection");
        return false;
    }

    public boolean isFile() {
        return (this.mode() & 0x8000) != 0;
    }

    public boolean isGroupOwned() {
        return this.groupMember(this.gid());
    }

    public boolean isIdentical(FileStat fileStat) {
        this.handler.unimplementedError("identical file detection");
        return false;
    }

    public boolean isNamedPipe() {
        this.handler.unimplementedError("piped file detection");
        return false;
    }

    public boolean isOwned() {
        return this.posix.geteuid() == this.uid();
    }

    public boolean isROwned() {
        return this.posix.getuid() == this.uid();
    }

    public boolean isReadable() {
        int n = this.mode();
        if ((n & 0x100) != 0) {
            return true;
        }
        if ((n & 0x20) != 0) {
            return true;
        }
        return (n & 4) != 0;
    }

    public boolean isReadableReal() {
        return this.isReadable();
    }

    public boolean isSymlink() {
        return (this.mode() & 0xA000) == 40960;
    }

    public boolean isWritable() {
        int n = this.mode();
        if ((n & 0x80) != 0) {
            return true;
        }
        if ((n & 0x10) != 0) {
            return true;
        }
        return (n & 2) != 0;
    }

    public boolean isWritableReal() {
        return this.isWritable();
    }

    public boolean isSetgid() {
        this.handler.unimplementedError("setgid detection");
        return false;
    }

    public boolean isSetuid() {
        this.handler.unimplementedError("setuid detection");
        return false;
    }

    public boolean isSocket() {
        this.handler.unimplementedError("socket file type detection");
        return false;
    }

    public boolean isSticky() {
        this.handler.unimplementedError("sticky bit detection");
        return false;
    }

    public int major(long l) {
        this.handler.unimplementedError("major device");
        return -1;
    }

    public int minor(long l) {
        this.handler.unimplementedError("minor device");
        return -1;
    }

    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    public long mtime() {
        return this.st_mtime;
    }

    public int nlink() {
        this.handler.unimplementedError("stat.nlink");
        return -1;
    }

    public long rdev() {
        this.handler.unimplementedError("stat.rdev");
        return -1L;
    }

    public long st_size() {
        return this.st_size;
    }

    public int uid() {
        return -1;
    }
}

