/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.python.constantine.platform.Errno;
import org.python.posix.FileStat;
import org.python.posix.Group;
import org.python.posix.JavaFileStat;
import org.python.posix.JavaLibCHelper;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.Passwd;
import org.python.posix.util.Platform;

final class JavaPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final JavaLibCHelper helper;

    JavaPOSIX(POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
        this.helper = new JavaLibCHelper(pOSIXHandler);
    }

    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    public int chmod(String string, int n) {
        return this.helper.chmod(string, n);
    }

    public int chown(String string, int n, int n2) {
        return this.helper.chown(string, n, n2);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    public int getegid() {
        return LoginInfo.GID;
    }

    public int geteuid() {
        return LoginInfo.UID;
    }

    public int getgid() {
        return LoginInfo.GID;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    public int getpid() {
        return this.helper.getpid();
    }

    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    public Passwd getpwuid(int n) {
        return this.helper.getpwuid(n);
    }

    public Group getgrgid(int n) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    public Passwd getpwnam(String string) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    public Group getgrnam(String string) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    public int getuid() {
        return LoginInfo.UID;
    }

    public int fork() {
        return -1;
    }

    public boolean isatty(FileDescriptor fileDescriptor) {
        return fileDescriptor == FileDescriptor.in || fileDescriptor == FileDescriptor.out || fileDescriptor == FileDescriptor.err;
    }

    public int kill(int n, int n2) {
        return this.unimplementedInt("kill");
    }

    public int lchmod(String string, int n) {
        return this.unimplementedInt("lchmod");
    }

    public int lchown(String string, int n, int n2) {
        return this.unimplementedInt("lchown");
    }

    public int link(String string, String string2) {
        return this.helper.link(string, string2);
    }

    public FileStat lstat(String string) {
        FileStat fileStat = this.allocateStat();
        if (this.helper.lstat(string, fileStat) < 0) {
            this.handler.error(Errno.ENOENT, string);
        }
        return fileStat;
    }

    public int mkdir(String string, int n) {
        return this.helper.mkdir(string, n);
    }

    public String readlink(String string) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(256);
        int n = this.helper.readlink(string, byteBuffer, byteBuffer.capacity());
        if (n == -1) {
            return null;
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        return Charset.forName("ASCII").decode(byteBuffer).toString();
    }

    public FileStat stat(String string) {
        FileStat fileStat = this.allocateStat();
        if (this.helper.stat(string, fileStat) < 0) {
            this.handler.error(Errno.ENOENT, string);
        }
        return fileStat;
    }

    public int symlink(String string, String string2) {
        return this.helper.symlink(string, string2);
    }

    public int setegid(int n) {
        return this.unimplementedInt("setegid");
    }

    public int seteuid(int n) {
        return this.unimplementedInt("seteuid");
    }

    public int setgid(int n) {
        return this.unimplementedInt("setgid");
    }

    public int getpgid(int n) {
        return this.unimplementedInt("getpgid");
    }

    public int setpgid(int n, int n2) {
        return this.unimplementedInt("setpgid");
    }

    public int setpgrp(int n, int n2) {
        return this.unimplementedInt("setpgrp");
    }

    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    public int setuid(int n) {
        return this.unimplementedInt("setuid");
    }

    public int umask(int n) {
        return 0;
    }

    public int utimes(String string, long[] lArray, long[] lArray2) {
        long l;
        if (lArray2 != null) {
            assert (lArray2.length == 2);
            l = lArray2[0] * 1000L + lArray2[1] / 1000L;
        } else {
            l = System.currentTimeMillis();
        }
        new File(string).setLastModified(l);
        return 0;
    }

    public int wait(int[] nArray) {
        return this.unimplementedInt("wait");
    }

    public int waitpid(int n, int[] nArray, int n2) {
        return this.unimplementedInt("waitpid");
    }

    public int getpriority(int n, int n2) {
        return this.unimplementedInt("getpriority");
    }

    public int setpriority(int n, int n2, int n3) {
        return this.unimplementedInt("setpriority");
    }

    public int errno() {
        return 0;
    }

    public void errno(int n) {
    }

    public boolean isNative() {
        return false;
    }

    private int unimplementedInt(String string) {
        this.handler.unimplementedError(string);
        return -1;
    }

    private static final class FakePasswd
    implements Passwd {
        private FakePasswd() {
        }

        public String getLoginName() {
            return LoginInfo.USERNAME;
        }

        public String getPassword() {
            return "";
        }

        public long getUID() {
            return LoginInfo.UID;
        }

        public long getGID() {
            return LoginInfo.GID;
        }

        public int getPasswdChangeTime() {
            return 0;
        }

        public String getAccessClass() {
            return "";
        }

        public String getGECOS() {
            return this.getLoginName();
        }

        public String getHome() {
            return "/";
        }

        public String getShell() {
            return "/bin/sh";
        }

        public int getExpire() {
            return -1;
        }
    }

    private static final class IDHelper {
        private static final String ID_CMD = Platform.IS_SOLARIS ? "/usr/xpg4/bin/id" : "/usr/bin/id";
        private static final int NOBODY = Platform.IS_WINDOWS ? 0 : Short.MAX_VALUE;

        private IDHelper() {
        }

        public static int getInt(String string) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{ID_CMD, string});
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                return Integer.parseInt(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                return NOBODY;
            }
            catch (NumberFormatException numberFormatException) {
                return NOBODY;
            }
            catch (SecurityException securityException) {
                return NOBODY;
            }
        }

        public static String getString(String string) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{ID_CMD, string});
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                return bufferedReader.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    static final class LoginInfo {
        public static final int UID = IDHelper.getInt("-u");
        public static final int GID = IDHelper.getInt("-g");
        public static final String USERNAME = IDHelper.getString("-un");

        LoginInfo() {
        }
    }
}

