/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import java.io.FileDescriptor;
import org.python.constantine.platform.Errno;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.BaseNativePOSIX;
import org.python.posix.FileStat;
import org.python.posix.LibCProvider;
import org.python.posix.Linux64HeapFileStat;
import org.python.posix.LinuxHeapFileStat;
import org.python.posix.LinuxLibC;
import org.python.posix.LinuxPasswd;
import org.python.posix.POSIXHandler;
import org.python.posix.util.Platform;

final class LinuxPOSIX
extends BaseNativePOSIX {
    private volatile boolean use_fxstat64 = true;
    private volatile boolean use_lxstat64 = true;
    private volatile boolean use_xstat64 = true;
    private final int statVersion = Platform.IS_32_BIT ? 3 : 0;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            return object != null ? new LinuxPasswd((Pointer)object) : null;
        }
    };

    LinuxPOSIX(String string, LibCProvider libCProvider, POSIXHandler pOSIXHandler) {
        super(string, libCProvider, pOSIXHandler);
    }

    public BaseHeapFileStat allocateStat() {
        if (Platform.IS_32_BIT) {
            return new LinuxHeapFileStat(this);
        }
        return new Linux64HeapFileStat(this);
    }

    private final FileStat old_fstat(FileDescriptor fileDescriptor) {
        try {
            return super.fstat(fileDescriptor);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.handler.unimplementedError("fstat");
            return null;
        }
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        if (this.use_fxstat64) {
            try {
                BaseHeapFileStat baseHeapFileStat = this.allocateStat();
                int n = this.helper.getfd(fileDescriptor);
                if (((LinuxLibC)this.libc()).__fxstat64(this.statVersion, n, baseHeapFileStat) < 0) {
                    this.handler.error(Errno.ENOENT, "" + n);
                }
                return baseHeapFileStat;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.use_fxstat64 = false;
                return this.old_fstat(fileDescriptor);
            }
        }
        return this.old_fstat(fileDescriptor);
    }

    private final FileStat old_lstat(String string) {
        try {
            return super.lstat(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.handler.unimplementedError("lstat");
            return null;
        }
    }

    public FileStat lstat(String string) {
        if (this.use_lxstat64) {
            try {
                BaseHeapFileStat baseHeapFileStat = this.allocateStat();
                if (((LinuxLibC)this.libc()).__lxstat64(this.statVersion, string, (FileStat)baseHeapFileStat) < 0) {
                    this.handler.error(Errno.ENOENT, string);
                }
                return baseHeapFileStat;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.use_lxstat64 = false;
                return this.old_lstat(string);
            }
        }
        return this.old_lstat(string);
    }

    private final FileStat old_stat(String string) {
        try {
            return super.stat(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.handler.unimplementedError("stat");
            return null;
        }
    }

    public FileStat stat(String string) {
        if (this.use_xstat64) {
            try {
                BaseHeapFileStat baseHeapFileStat = this.allocateStat();
                if (((LinuxLibC)this.libc()).__xstat64(this.statVersion, string, (FileStat)baseHeapFileStat) < 0) {
                    this.handler.error(Errno.ENOENT, string);
                }
                return baseHeapFileStat;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.use_xstat64 = false;
                return this.old_stat(string);
            }
        }
        return this.old_stat(string);
    }
}

