/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.List;
import java.util.Properties;
import org.python.core.Options;
import org.python.util.Generic;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    public boolean runCommand;
    public boolean runModule = false;
    public boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public String[] argv;
    public Properties properties;
    public String command;
    public List<String> warnoptions = Generic.list();
    public String encoding;
    public String division;
    public String moduleName;

    public CommandLineOptions() {
        this.properties = new Properties();
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
        try {
            System.setProperty(string, string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public boolean parse(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string;
            String string2 = stringArray[n];
            if (string2.equals("-h") || string2.equals("-?") || string2.equals("--help")) {
                this.help = true;
                return false;
            }
            if (string2.equals("-V") || string2.equals("--version")) {
                this.version = true;
                return false;
            }
            if (string2.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
                continue;
            }
            if (string2.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
                continue;
            }
            if (string2.equals("-jar")) {
                this.jar = true;
                if (this.fixInteractive) continue;
                this.interactive = false;
                continue;
            }
            if (string2.equals("-u")) {
                Options.unbuffered = true;
                continue;
            }
            if (string2.equals("-v")) {
                ++Options.verbose;
                continue;
            }
            if (string2.equals("-vv")) {
                Options.verbose += 2;
                continue;
            }
            if (string2.equals("-vvv")) {
                Options.verbose += 3;
                continue;
            }
            if (string2.equals("-S")) {
                Options.importSite = false;
                continue;
            }
            if (string2.startsWith("-c")) {
                this.runCommand = true;
                if (string2.length() > 2) {
                    this.command = string2.substring(2);
                } else if (n + 1 < stringArray.length) {
                    this.command = stringArray[++n];
                } else {
                    System.err.println("Argument expected for the -c option");
                    System.err.print("usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\n");
                    System.err.println("Try `jython -h' for more information.");
                    return false;
                }
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                ++n;
                break;
            }
            if (string2.startsWith("-W")) {
                this.warnoptions.add(stringArray[++n]);
                continue;
            }
            if (string2.equals("-C")) {
                this.encoding = stringArray[++n];
                this.setProperty("python.console.encoding", this.encoding);
                continue;
            }
            if (string2.equals("-E")) continue;
            if (string2.startsWith("-D")) {
                string = null;
                String string3 = null;
                int n2 = string2.indexOf("=");
                if (n2 == -1) {
                    String string4 = stringArray[++n];
                    string = string2.substring(2, string2.length());
                    string3 = string4;
                } else {
                    string = string2.substring(2, n2);
                    string3 = string2.substring(n2 + 1, string2.length());
                }
                this.setProperty(string, string3);
                continue;
            }
            if (string2.startsWith("-Q")) {
                if (string2.length() > 2) {
                    this.division = string2.substring(2);
                    continue;
                }
                this.division = stringArray[++n];
                continue;
            }
            if (string2.startsWith("-m")) {
                this.runModule = true;
                if (string2.length() > 2) {
                    this.moduleName = string2.substring(2);
                } else if (n + 1 < stringArray.length) {
                    this.moduleName = stringArray[++n];
                } else {
                    System.err.println("Argument expected for the -m option");
                    System.err.print("usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\n");
                    System.err.println("Try `jython -h' for more information.");
                    return false;
                }
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                int n3 = stringArray.length - ++n + 1;
                this.argv = new String[n3];
                this.argv[0] = this.moduleName;
                int n4 = 1;
                while (n < stringArray.length) {
                    this.argv[n4] = stringArray[n];
                    ++n4;
                    ++n;
                }
                return true;
            }
            string = stringArray[n];
            if (string.startsWith("--")) {
                string = string.substring(2);
            } else if (string.startsWith("-")) {
                string = string.substring(1);
            }
            System.err.println("Unknown option: " + string);
            return false;
        }
        this.notice = this.interactive;
        if (this.filename == null && n < stringArray.length && this.command == null) {
            this.filename = stringArray[n++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n5 = stringArray.length - n + 1;
        this.argv = new String[n5];
        this.argv[0] = this.filename != null ? this.filename : (this.command != null ? "-c" : "");
        int n6 = 1;
        while (n6 < n5) {
            this.argv[n6] = stringArray[n];
            ++n6;
            ++n;
        }
        return true;
    }
}

